/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.impl.ProjectPaneSelectInTarget;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewSettings;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPaneWithAsyncSupport;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.projectView.impl.nodes.ModuleGroupNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewProjectNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.ModuleGrouperKt;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.util.PlatformUtils;
import java.awt.EventQueue;
import java.awt.Font;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ProjectViewPane
extends AbstractProjectViewPaneWithAsyncSupport {
    @NonNls
    public static final String ID = "ProjectPane";

    public ProjectViewPane(Project project2) {
        super(project2);
    }

    @Override
    @NotNull
    public String getTitle() {
        String string2 = IdeBundle.message((String)"title.project", (Object[])new Object[0]);
        if (string2 == null) {
            ProjectViewPane.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon2 = AllIcons.General.ProjectTab;
        if (icon2 == null) {
            ProjectViewPane.$$$reportNull$$$0(1);
        }
        return icon2;
    }

    @Override
    @NotNull
    public SelectInTarget createSelectInTarget() {
        return new ProjectPaneSelectInTarget(this.myProject);
    }

    @Override
    @NotNull
    protected ProjectAbstractTreeStructureBase createStructure() {
        return new ProjectViewPaneTreeStructure();
    }

    @Override
    @NotNull
    protected ProjectViewTree createTree(@NotNull DefaultTreeModel treeModel) {
        if (treeModel == null) {
            ProjectViewPane.$$$reportNull$$$0(2);
        }
        return new ProjectViewTree((TreeModel)treeModel){

            public String toString() {
                return ProjectViewPane.this.getTitle() + " " + super.toString();
            }

            public void setFont(Font font) {
                if (AdvancedSettings.getBoolean((String)"bigger.font.in.project.view")) {
                    font = font.deriveFont((float)font.getSize() + 1.0f);
                }
                super.setFont(font);
            }

            public AccessibleContext getAccessibleContext() {
                if (this.accessibleContext == null) {
                    this.accessibleContext = super.getAccessibleContext();
                    this.accessibleContext.setAccessibleName(IdeBundle.message((String)"project.structure.tree.accessible.name", (Object[])new Object[0]));
                }
                return this.accessibleContext;
            }
        };
    }

    @NotNull
    public String getComponentName() {
        return ID;
    }

    private boolean hasSeveralTopLevelModuleNodes() {
        Object root;
        if (!EventQueue.isDispatchThread()) {
            return true;
        }
        TreeModel treeModel = this.myTree.getModel();
        int count2 = treeModel.getChildCount(root = treeModel.getRoot());
        if (count2 <= 1) {
            return false;
        }
        int moduleNodes = 0;
        for (int i2 = 0; i2 < count2; ++i2) {
            Object node2;
            Object child = treeModel.getChild(root, i2);
            if (!(child instanceof DefaultMutableTreeNode) || !((node2 = ((DefaultMutableTreeNode)child).getUserObject()) instanceof ProjectViewModuleNode || node2 instanceof PsiDirectoryNode ? ++moduleNodes > 1 : node2 instanceof ModuleGroupNode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFileNestingEnabled() {
        return true;
    }

    @Override
    public int getWeight() {
        return 0;
    }

    public static boolean canBeSelectedInProjectView(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            ProjectViewPane.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            ProjectViewPane.$$$reportNull$$$0(4);
        }
        VirtualFile archiveFile = file2.getFileSystem() instanceof ArchiveFileSystem ? ((ArchiveFileSystem)file2.getFileSystem()).getLocalByEntry(file2) : null;
        ProjectFileIndex index2 = ProjectRootManager.getInstance(project2).getFileIndex();
        return archiveFile != null && index2.getContentRootForFile(archiveFile, false) != null || index2.getContentRootForFile(file2, false) != null || index2.isInLibrary(file2) || Comparing.equal(file2.getParent(), project2.getBaseDir()) || ScratchUtil.isScratch(file2) && ProjectView.getInstance(project2).isShowScratchesAndConsoles(ID);
    }

    @Override
    public boolean supportsFlattenModules() {
        return PlatformUtils.isIntelliJ() && ModuleGrouperKt.isQualifiedModuleNamesEnabled(this.myProject) && this.hasSeveralTopLevelModuleNodes();
    }

    @Override
    public boolean supportsShowExcludedFiles() {
        return true;
    }

    @Override
    public boolean supportsShowScratchesAndConsoles() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/ProjectViewPane";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewPane";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createTree";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canBeSelectedInProjectView";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 2, 3, 4 -> new IllegalArgumentException(string2);
        };
    }

    protected class ProjectViewPaneTreeStructure
    extends ProjectTreeStructure
    implements ProjectViewSettings {
        protected ProjectViewPaneTreeStructure() {
            super(ProjectViewPane.this.myProject, ProjectViewPane.this.getId());
        }

        protected AbstractTreeNode<?> createRoot(@NotNull Project project2, @NotNull ViewSettings settings) {
            if (project2 == null) {
                ProjectViewPaneTreeStructure.$$$reportNull$$$0(0);
            }
            if (settings == null) {
                ProjectViewPaneTreeStructure.$$$reportNull$$$0(1);
            }
            return new ProjectViewProjectNode(project2, settings);
        }

        @Override
        public boolean isShowExcludedFiles() {
            return ProjectView.getInstance(this.myProject).isShowExcludedFiles(ProjectViewPane.this.getId());
        }

        @Override
        public boolean isShowLibraryContents() {
            return true;
        }

        @Override
        public boolean isUseFileNestingRules() {
            return ProjectView.getInstance(this.myProject).isUseFileNestingRules(ProjectViewPane.this.getId());
        }

        public boolean isToBuildChildrenInBackground(@NotNull Object element) {
            if (element == null) {
                ProjectViewPaneTreeStructure.$$$reportNull$$$0(2);
            }
            return Registry.is("ide.projectView.ProjectViewPaneTreeStructure.BuildChildrenInBackground");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewPane$ProjectViewPaneTreeStructure";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createRoot";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isToBuildChildrenInBackground";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

