/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ProjectViewImpl;
import com.intellij.ide.util.RunOnceUtil;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public final class ProjectViewToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    public void createToolWindowContent(@NotNull Project project2, @NotNull ToolWindow toolWindow) {
        if (project2 == null) {
            ProjectViewToolWindowFactory.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            ProjectViewToolWindowFactory.$$$reportNull$$$0(1);
        }
        ((ProjectViewImpl)ProjectView.getInstance(project2)).setupImpl(toolWindow);
    }

    @NotNull
    public Icon getIcon() {
        String path2 = ApplicationInfoEx.getInstanceEx().getToolWindowIconUrl();
        if (path2.equals("/toolwindows/toolWindowProject.svg") || path2.equals("toolwindows/toolWindowProject.svg")) {
            Icon icon2 = AllIcons.Toolwindows.ToolWindowProject;
            if (icon2 == null) {
                ProjectViewToolWindowFactory.$$$reportNull$$$0(2);
            }
            return icon2;
        }
        Icon icon3 = Objects.requireNonNull(IconLoader.findIcon(path2, ProjectViewToolWindowFactory.class.getClassLoader()));
        if (icon3 == null) {
            ProjectViewToolWindowFactory.$$$reportNull$$$0(3);
        }
        return icon3;
    }

    public void init(@NotNull ToolWindow window) {
        if (window == null) {
            ProjectViewToolWindowFactory.$$$reportNull$$$0(4);
        }
        if (!(window instanceof ToolWindowEx) || !Registry.is("ide.open.project.view.on.startup", true)) {
            return;
        }
        Project project2 = window.getProject();
        if (Boolean.TRUE.equals(project2.getUserData(FileEditorManagerImpl.NOTHING_WAS_OPENED_ON_START)) && !ProjectUtil.isNotificationSilentMode((Project)project2)) {
            RunOnceUtil.runOnceForProject((Project)project2, (String)"OpenProjectViewOnStart", () -> {
                ToolWindowManager manager = ToolWindowManager.getInstance((Project)project2);
                manager.invokeLater(() -> {
                    if (manager.getActiveToolWindowId() == null) {
                        window.activate(() -> {
                            JTree tree;
                            Module[] modules2 = ModuleManager.getInstance(project2).getModules();
                            if (modules2.length == 1 && "GENERAL_MODULE".equals(modules2[0].getModuleTypeName())) {
                                return;
                            }
                            AbstractProjectViewPane pane = ProjectView.getInstance(project2).getCurrentProjectViewPane();
                            JTree jTree = tree = pane == null ? null : pane.getTree();
                            if (tree != null) {
                                TreeUtil.promiseSelectFirst((JTree)tree).onSuccess(tree::expandPath);
                            }
                        });
                    }
                });
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/ProjectViewToolWindowFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewToolWindowFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createToolWindowContent";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3 -> new IllegalStateException(string2);
        };
    }
}

