/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupNode;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElementNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010 \n\u0002\b\u0004\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001H\u0000\u001a!\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0012\u0010\u0005\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007\u001a\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0007\u001a\"\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0002\u001a+\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0006H\u0007\u00a2\u0006\u0002\u0010\u0016\u001a+\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u00142\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0006H\u0000\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0018"}, d2={"getNodeElement", "", "userObject", "getSelectedLibrary", "Lcom/intellij/openapi/roots/LibraryOrderEntry;", "userObjectsPath", "", "([Ljava/lang/Object;)Lcom/intellij/openapi/roots/LibraryOrderEntry;", "getUnloadedModuleByContentRoot", "Lcom/intellij/openapi/module/UnloadedModuleDescription;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "moduleBySingleContentRoot", "Lcom/intellij/openapi/module/Module;", "moduleContext", "element", "moduleContexts", "", "", "elements", "(Lcom/intellij/openapi/project/Project;[Ljava/lang/Object;)Ljava/util/List;", "unloadedModules", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nprojectViewUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 projectViewUtil.kt\ncom/intellij/ide/projectView/impl/ProjectViewUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
public final class ProjectViewUtilKt {
    @Nullable
    public static final Object getNodeElement(@Nullable Object userObject) {
        Object object = userObject;
        return object instanceof AbstractTreeNode ? ((AbstractTreeNode)userObject).getValue() : (object instanceof NodeDescriptor ? ((NodeDescriptor)userObject).getElement() : null);
    }

    @ApiStatus.Internal
    @NotNull
    public static final List<Module> moduleContexts(@NotNull Project project2, @NotNull Object[] elements) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        ArrayList result2 = new ArrayList();
        for (Object selectedValue : elements) {
            Collection collection = result2;
            Collection<Module> collection2 = ProjectViewUtilKt.moduleContexts(project2, selectedValue);
            if (collection2 == null) continue;
            CollectionsKt.addAll((Collection)collection, (Iterable)collection2);
        }
        return result2;
    }

    private static final Collection<Module> moduleContexts(Project project2, Object element) {
        List list2;
        if (element instanceof ModuleGroup) {
            return ((ModuleGroup)element).modulesInGroup(project2, true);
        }
        Module module2 = ProjectViewUtilKt.moduleContext(project2, element);
        if (module2 != null) {
            Module p0 = module2;
            boolean bl = false;
            list2 = CollectionsKt.listOf((Object)p0);
        } else {
            list2 = null;
        }
        return list2;
    }

    @ApiStatus.Internal
    @Nullable
    public static final Module moduleContext(@NotNull Project project2, @Nullable Object element) {
        Module module2;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Object object = element;
        if (object instanceof Module) {
            module2 = ((Module)element).isDisposed() ? null : (Module)element;
        } else if (object instanceof PsiDirectory) {
            VirtualFile virtualFile2 = ((PsiDirectory)element).getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"element.virtualFile");
            module2 = ProjectViewUtilKt.moduleBySingleContentRoot(project2, virtualFile2);
        } else {
            module2 = object instanceof VirtualFile ? ProjectViewUtilKt.moduleBySingleContentRoot(project2, (VirtualFile)element) : null;
        }
        return module2;
    }

    private static final Module moduleBySingleContentRoot(Project project2, VirtualFile file2) {
        if (!ProjectRootsUtil.isModuleContentRoot(file2, project2)) {
            return null;
        }
        Module module2 = ProjectRootManager.getInstance(project2).getFileIndex().getModuleForFile(file2);
        if (module2 == null || module2.isDisposed() || ModuleRootManager.getInstance(module2).getContentRoots().length != 1) {
            return null;
        }
        return module2;
    }

    @NotNull
    public static final List<UnloadedModuleDescription> unloadedModules(@NotNull Project project2, @NotNull Object[] elements) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        SmartList result2 = new SmartList();
        for (Object element : elements) {
            VirtualFile virtualFile2;
            Object object = element;
            if (object instanceof PsiDirectory) {
                virtualFile2 = ((PsiDirectory)element).getVirtualFile();
            } else {
                if (!(object instanceof VirtualFile)) continue;
                virtualFile2 = (VirtualFile)element;
            }
            Object object2 = virtualFile2;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"when (element) {\n      i\u2026   else -> continue\n    }");
            VirtualFile file2 = object2;
            object2 = result2;
            UnloadedModuleDescription unloadedModuleDescription = ProjectViewUtilKt.getUnloadedModuleByContentRoot(project2, file2);
            if (unloadedModuleDescription == null) continue;
            object2.add(unloadedModuleDescription);
        }
        return result2;
    }

    private static final UnloadedModuleDescription getUnloadedModuleByContentRoot(Project project2, VirtualFile file2) {
        String string2 = ProjectRootsUtil.findUnloadedModuleByContentRoot(file2, project2);
        if (string2 == null) {
            return null;
        }
        String moduleName = string2;
        return ModuleManager.Companion.getInstance(project2).getUnloadedModuleDescription(moduleName);
    }

    @Nullable
    public static final LibraryOrderEntry getSelectedLibrary(@Nullable Object[] userObjectsPath) {
        AbstractTreeNode grandParentObject;
        if (userObjectsPath == null) {
            return null;
        }
        Object parentObject = ArraysKt.getOrNull((Object[])userObjectsPath, (int)(userObjectsPath.length - 2));
        if (!(parentObject instanceof LibraryGroupNode)) {
            return null;
        }
        Object userObject = ArraysKt.last((Object[])userObjectsPath);
        if (userObject instanceof NamedLibraryElementNode) {
            LibraryOrSdkOrderEntry libraryOrSdkOrderEntry = ((NamedLibraryElement)((NamedLibraryElementNode)((Object)userObject)).getValue()).getOrderEntry();
            return libraryOrSdkOrderEntry instanceof LibraryOrderEntry ? (LibraryOrderEntry)libraryOrSdkOrderEntry : null;
        }
        Intrinsics.checkNotNull((Object)userObject, (String)"null cannot be cast to non-null type com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode");
        PsiDirectory directory = (PsiDirectory)((PsiDirectoryNode)userObject).getValue();
        Object object = ArraysKt.getOrNull((Object[])userObjectsPath, (int)(userObjectsPath.length - 3));
        AbstractTreeNode abstractTreeNode = grandParentObject = object instanceof AbstractTreeNode ? (AbstractTreeNode)object : null;
        Intrinsics.checkNotNull((Object)abstractTreeNode);
        Module module2 = (Module)abstractTreeNode.getValue();
        if (module2 == null) {
            return null;
        }
        Module module3 = module2;
        OrderEntry orderEntry2 = ModuleRootManager.getInstance(module3).getFileIndex().getOrderEntryForFile(directory.getVirtualFile());
        return orderEntry2 instanceof LibraryOrderEntry ? (LibraryOrderEntry)orderEntry2 : null;
    }
}

