/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.RenameHandler;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameModuleHandler
implements RenameHandler,
TitledHandler {
    private static final Logger LOG = Logger.getInstance(RenameModuleHandler.class);

    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext2) {
        Module module2;
        if (dataContext2 == null) {
            RenameModuleHandler.$$$reportNull$$$0(0);
        }
        return (module2 = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext2)) != null;
    }

    public void invoke(@NotNull Project project2, Editor editor2, PsiFile file2, DataContext dataContext2) {
        if (project2 == null) {
            RenameModuleHandler.$$$reportNull$$$0(1);
        }
        LOG.assertTrue(false);
    }

    public void invoke(@NotNull Project project2, PsiElement @NotNull [] elements, @NotNull DataContext dataContext2) {
        Module module2;
        if (project2 == null) {
            RenameModuleHandler.$$$reportNull$$$0(2);
        }
        if (dataContext2 == null) {
            RenameModuleHandler.$$$reportNull$$$0(3);
        }
        if (elements == null) {
            RenameModuleHandler.$$$reportNull$$$0(4);
        }
        LOG.assertTrue((module2 = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext2)) != null);
        Messages.showInputDialog((Project)project2, (String)IdeBundle.message((String)"prompt.enter.new.module.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)module2.getName(), (InputValidator)new MyInputValidator(project2, module2));
    }

    @Override
    public String getActionTitle() {
        return RefactoringBundle.message((String)"rename.module.title");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/projectView/impl/RenameModuleHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnDataContext";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyInputValidator
    implements InputValidator {
        private final Project myProject;
        private final Module myModule;

        MyInputValidator(Project project2, Module module2) {
            this.myProject = project2;
            this.myModule = module2;
        }

        @Override
        public boolean checkInput(String inputString) {
            return inputString != null && inputString.length() > 0;
        }

        @Override
        public boolean canClose(String inputString) {
            String oldName = this.myModule.getName();
            ModifiableModuleModel modifiableModel = this.renameModule(inputString);
            if (modifiableModel == null) {
                return false;
            }
            CommandProcessor.getInstance().executeCommand(this.myProject, () -> ApplicationManager.getApplication().runWriteAction(() -> modifiableModel.commit()), IdeBundle.message((String)"command.renaming.module", (Object[])new Object[]{oldName}), null);
            return true;
        }

        @Nullable
        private ModifiableModuleModel renameModule(String inputString) {
            ModifiableModuleModel modifiableModel = ModuleManager.getInstance(this.myProject).getModifiableModel();
            try {
                modifiableModel.renameModule(this.myModule, inputString);
            }
            catch (ModuleWithNameAlreadyExists moduleWithNameAlreadyExists) {
                Messages.showErrorDialog((Project)this.myProject, (String)IdeBundle.message((String)"error.module.already.exists", (Object[])new Object[]{inputString}), (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]));
                return null;
            }
            return modifiableModel;
        }
    }
}

