/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkType;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewSettings;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.CompoundProjectViewNodeDecorator;
import com.intellij.ide.projectView.impl.ProjectViewInplaceCommentProducerImplKt;
import com.intellij.ide.tags.TagManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.InplaceCommentAppender;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.ide.util.treeView.ValidateableNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.StatePreservingNavigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColoredText;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPsiBasedNode<Value>
extends ProjectViewNode<Value>
implements ValidateableNode,
StatePreservingNavigatable {
    private static final Logger LOG = Logger.getInstance(AbstractPsiBasedNode.class.getName());

    protected AbstractPsiBasedNode(Project project2, @NotNull Value value, ViewSettings viewSettings) {
        if (value == null) {
            AbstractPsiBasedNode.$$$reportNull$$$0(0);
        }
        super(project2, value, viewSettings);
    }

    @Nullable
    protected abstract PsiElement extractPsiFromValue();

    @Nullable
    protected abstract Collection<AbstractTreeNode<?>> getChildrenImpl();

    protected abstract void updateImpl(@NotNull PresentationData var1);

    @NotNull
    public final Collection<? extends AbstractTreeNode<?>> getChildren() {
        Collection collection = AstLoadingFilter.disallowTreeLoading(this::doGetChildren);
        if (collection == null) {
            AbstractPsiBasedNode.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    private Collection<? extends AbstractTreeNode<?>> doGetChildren() {
        PsiElement psiElement = this.extractPsiFromValue();
        if (psiElement == null) {
            return new ArrayList();
        }
        if (!psiElement.isValid()) {
            LOG.error(new IllegalStateException("Node contains invalid PSI: \n" + this.getClass() + " [" + this + "]\n" + psiElement.getClass() + " [" + psiElement + "]"));
            List list2 = Collections.emptyList();
            if (list2 == null) {
                AbstractPsiBasedNode.$$$reportNull$$$0(2);
            }
            return list2;
        }
        Collection<AbstractTreeNode<?>> children2 = this.getChildrenImpl();
        Collection<Object> collection = children2 != null ? children2 : Collections.emptyList();
        if (collection == null) {
            AbstractPsiBasedNode.$$$reportNull$$$0(3);
        }
        return collection;
    }

    public boolean isValid() {
        PsiElement psiElement = this.extractPsiFromValue();
        return psiElement != null && psiElement.isValid();
    }

    protected boolean isMarkReadOnly() {
        AbstractTreeNode parent2 = this.getParent();
        if (parent2 == null) {
            return false;
        }
        if (parent2 instanceof AbstractPsiBasedNode) {
            PsiElement psiElement = ((AbstractPsiBasedNode)parent2).extractPsiFromValue();
            return psiElement instanceof PsiDirectory;
        }
        Object parentValue = parent2.getValue();
        return parentValue instanceof PsiDirectory || parentValue instanceof Module;
    }

    public FileStatus getFileStatus() {
        return AbstractPsiBasedNode.computeFileStatus(this.getVirtualFileForValue(), Objects.requireNonNull(this.getProject()));
    }

    protected static FileStatus computeFileStatus(@Nullable VirtualFile virtualFile2, @NotNull Project project2) {
        if (project2 == null) {
            AbstractPsiBasedNode.$$$reportNull$$$0(4);
        }
        if (virtualFile2 == null) {
            return FileStatus.NOT_CHANGED;
        }
        return FileStatusManager.getInstance((Project)project2).getStatus(virtualFile2);
    }

    @Nullable
    private VirtualFile getVirtualFileForValue() {
        Object value = this.getEqualityObject();
        if (value instanceof SmartPsiElementPointer) {
            SmartPsiElementPointer pointer = (SmartPsiElementPointer)value;
            return pointer.getVirtualFile();
        }
        PsiElement psiElement = this.extractPsiFromValue();
        return PsiUtilCore.getVirtualFile(psiElement);
    }

    protected void appendInplaceComments(@NotNull InplaceCommentAppender appender) {
        if (appender == null) {
            AbstractPsiBasedNode.$$$reportNull$$$0(5);
        }
        if (UISettings.getInstance().getShowInplaceComments()) {
            ProjectViewInplaceCommentProducerImplKt.appendInplaceComments(this, appender);
        }
    }

    public void update(@NotNull PresentationData data2) {
        if (data2 == null) {
            AbstractPsiBasedNode.$$$reportNull$$$0(6);
        }
        AstLoadingFilter.disallowTreeLoading(() -> this.doUpdate(data2));
    }

    private void doUpdate(@NotNull PresentationData data2) {
        if (data2 == null) {
            AbstractPsiBasedNode.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            ColoredText tagText;
            Icon tagIcon;
            if (!this.validate()) {
                return;
            }
            PsiElement value = this.extractPsiFromValue();
            LOG.assertTrue(value.isValid());
            int flags = this.getIconableFlags();
            Icon icon2 = null;
            boolean deprecated = false;
            try {
                icon2 = value.getIcon(flags);
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            try {
                deprecated = this.isDeprecated();
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            if (!TagManager.isEnabled()) {
                tagIcon = AbstractPsiBasedNode.getBookmarkIcon(this.myProject, value);
                tagText = null;
            } else {
                Pair<Icon, ColoredText> tagIconAndText = TagManager.getTagIconAndText(value);
                tagIcon = (Icon)tagIconAndText.first;
                tagText = (ColoredText)tagIconAndText.second;
            }
            data2.setIcon(AbstractPsiBasedNode.withIconMarker(icon2, tagIcon));
            data2.setPresentableText(this.myName);
            if (deprecated) {
                data2.setAttributesKey(CodeInsightColors.DEPRECATED_ATTRIBUTES);
            }
            if (tagText != null) {
                List fragments = tagText.fragments();
                for (ColoredText.Fragment fragment : fragments) {
                    data2.getColoredText().add(new PresentableNodeDescriptor.ColoredFragment(fragment.fragmentText(), fragment.fragmentAttributes()));
                }
                if (!fragments.isEmpty()) {
                    data2.getColoredText().add(new PresentableNodeDescriptor.ColoredFragment(this.myName, NodeRenderer.getSimpleTextAttributes((ItemPresentation)data2)));
                }
            }
            this.updateImpl(data2);
            data2.setIcon(AbstractPsiBasedNode.patchIcon(this.myProject, data2.getIcon(true), this.getVirtualFile()));
            CompoundProjectViewNodeDecorator.get(this.myProject).decorate(this, data2);
        });
    }

    @Iconable.IconFlags
    protected int getIconableFlags() {
        int flags = 0;
        ViewSettings settings = this.getSettings();
        if (settings instanceof ProjectViewSettings && ((ProjectViewSettings)settings).isShowVisibilityIcons()) {
            flags |= 1;
        }
        if (this.isMarkReadOnly()) {
            flags |= 2;
        }
        return flags;
    }

    @Nullable
    public static Icon patchIcon(@NotNull Project project2, @Nullable Icon original, @Nullable VirtualFile file2) {
        Icon bookmarkIcon;
        if (project2 == null) {
            AbstractPsiBasedNode.$$$reportNull$$$0(8);
        }
        if (file2 == null || original == null) {
            return original;
        }
        Icon icon2 = original;
        if (file2.is(VFileProperty.SYMLINK)) {
            icon2 = LayeredIcon.create((Icon)icon2, (Icon)PlatformIcons.SYMLINK_ICON);
        }
        if ((bookmarkIcon = AbstractPsiBasedNode.getBookmarkIcon(project2, file2)) != null) {
            icon2 = AbstractPsiBasedNode.withIconMarker(icon2, bookmarkIcon);
        }
        return icon2;
    }

    @Nullable
    private static Icon withIconMarker(@Nullable Icon icon2, @Nullable Icon marker) {
        return Registry.is("ide.project.view.bookmarks.icon.before", false) ? IconUtil.rowIcon((Icon)marker, (Icon)icon2) : IconUtil.rowIcon((Icon)icon2, (Icon)marker);
    }

    @Nullable
    private static Icon getBookmarkIcon(@NotNull Project project2, @Nullable Object context2) {
        if (project2 == null) {
            AbstractPsiBasedNode.$$$reportNull$$$0(9);
        }
        if (Registry.is("ide.project.view.bookmarks.icon.hide", false)) {
            return null;
        }
        BookmarksManager manager = BookmarksManager.getInstance(project2);
        if (manager == null) {
            return null;
        }
        Bookmark bookmark = manager.createBookmark(context2);
        if (bookmark == null) {
            return null;
        }
        BookmarkType type = manager.getType(bookmark);
        if (type == null) {
            return null;
        }
        return type.getIcon();
    }

    protected boolean isDeprecated() {
        return false;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            AbstractPsiBasedNode.$$$reportNull$$$0(10);
        }
        return file2.equals(this.getVirtualFileForValue());
    }

    @Nullable
    public NavigationItem getNavigationItem() {
        PsiElement psiElement = this.extractPsiFromValue();
        return psiElement instanceof NavigationItem ? (NavigationItem)((Object)psiElement) : null;
    }

    @Override
    public void navigate(boolean requestFocus, boolean preserveState) {
        if (this.canNavigate()) {
            if (requestFocus || preserveState) {
                NavigationUtil.openFileWithPsiElement(this.extractPsiFromValue(), requestFocus, requestFocus);
            } else {
                this.getNavigationItem().navigate(false);
            }
        }
    }

    @Override
    public void navigate(boolean requestFocus) {
        this.navigate(requestFocus, false);
    }

    @Override
    public boolean canNavigate() {
        NavigationItem item = this.getNavigationItem();
        return item != null && item.canNavigate();
    }

    @Override
    public boolean canNavigateToSource() {
        NavigationItem item = this.getNavigationItem();
        return item != null && item.canNavigateToSource();
    }

    @Nullable
    protected String calcTooltip() {
        return null;
    }

    @Override
    public boolean validate() {
        PsiElement psiElement = this.extractPsiFromValue();
        if (psiElement == null || !psiElement.isValid()) {
            this.setValue(null);
        }
        return this.getValue() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/nodes/AbstractPsiBasedNode";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appender";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/nodes/AbstractPsiBasedNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeFileStatus";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendInplaceComments";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doUpdate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "patchIcon";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getBookmarkIcon";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 3 -> new IllegalStateException(string2);
        };
    }
}

