/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.NodeSortOrder;
import com.intellij.ide.projectView.NodeSortSettings;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ExternalLibrariesWorkspaceModelNodesProvider;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupNode;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElementNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.SyntheticLibraryElementNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.EntityStorageSnapshot;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

public class ExternalLibrariesNode
extends ProjectViewNode<String> {
    private static final Logger LOG = Logger.getInstance(ExternalLibrariesNode.class);

    public ExternalLibrariesNode(@NotNull Project project2, ViewSettings viewSettings) {
        if (project2 == null) {
            ExternalLibrariesNode.$$$reportNull$$$0(0);
        }
        super(project2, "External Libraries", viewSettings);
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        Project project2;
        ProjectFileIndex index2;
        if (file2 == null) {
            ExternalLibrariesNode.$$$reportNull$$$0(1);
        }
        return (index2 = ProjectFileIndex.getInstance(project2 = Objects.requireNonNull(this.getProject()))).isInLibrary(file2) && this.someChildContainsFile(file2, false);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        Project project2 = Objects.requireNonNull(this.getProject());
        ArrayList<ProjectViewNode> children2 = new ArrayList<ProjectViewNode>();
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance(project2);
        Module[] modules2 = ModuleManager.getInstance(project2).getModules();
        HashMap<String, List> processedLibraries = new HashMap<String, List>();
        HashSet<Sdk> processedSdk = new HashSet<Sdk>();
        for (Module module2 : modules2) {
            OrderEntry[] orderEntries;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module2);
            for (OrderEntry orderEntry2 : orderEntries = moduleRootManager.getOrderEntries()) {
                JdkOrderEntry jdkOrderEntry;
                Sdk jdk;
                if (orderEntry2 instanceof LibraryOrderEntry) {
                    String libraryPresentableName;
                    List librariesWithSameName;
                    LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)orderEntry2;
                    Library library = libraryOrderEntry.getLibrary();
                    if (library == null || ContainerUtil.exists(librariesWithSameName = (List)processedLibraries.getOrDefault(libraryPresentableName = libraryOrderEntry.getPresentableName(), new ArrayList()), processedLibrary -> processedLibrary.hasSameContent(library))) continue;
                    librariesWithSameName.add(library);
                    processedLibraries.put(libraryPresentableName, librariesWithSameName);
                    if (!ExternalLibrariesNode.hasExternalEntries(fileIndex, libraryOrderEntry)) continue;
                    String libraryName = library.getName();
                    if (libraryName == null || libraryName.length() == 0) {
                        ExternalLibrariesNode.addLibraryChildren(libraryOrderEntry, children2, project2, this);
                        continue;
                    }
                    children2.add(new NamedLibraryElementNode(project2, new NamedLibraryElement(null, libraryOrderEntry), this.getSettings()));
                    continue;
                }
                if (!(orderEntry2 instanceof JdkOrderEntry) || (jdk = (jdkOrderEntry = (JdkOrderEntry)orderEntry2).getJdk()) == null || processedSdk.contains(jdk)) continue;
                processedSdk.add(jdk);
                children2.add(new NamedLibraryElementNode(project2, new NamedLibraryElement(null, jdkOrderEntry), this.getSettings()));
            }
        }
        for (AdditionalLibraryRootsProvider additionalLibraryRootsProvider : AdditionalLibraryRootsProvider.EP_NAME.getExtensions()) {
            Collection<SyntheticLibrary> libraries2 = additionalLibraryRootsProvider.getAdditionalProjectLibraries(project2);
            for (SyntheticLibrary library : libraries2) {
                if (!library.isShowInExternalLibrariesNode()) continue;
                if (!(library instanceof ItemPresentation)) {
                    LOG.warn("Synthetic library must implement ItemPresentation to be shown in External Libraries node: " + libraries2.getClass().getSimpleName());
                    continue;
                }
                children2.add(new SyntheticLibraryElementNode(project2, library, (ItemPresentation)((Object)library), this.getSettings()));
            }
        }
        List<ExternalLibrariesWorkspaceModelNodesProvider<?>> extensionList = ExternalLibrariesWorkspaceModelNodesProvider.EP.getExtensionList();
        if (!extensionList.isEmpty()) {
            EntityStorageSnapshot current = WorkspaceModel.getInstance(project2).getCurrentSnapshot();
            for (ExternalLibrariesWorkspaceModelNodesProvider<?> externalLibrariesWorkspaceModelNodesProvider : extensionList) {
                this.handleProvider(externalLibrariesWorkspaceModelNodesProvider, project2, (EntityStorage)current, children2);
            }
        }
        ArrayList<ProjectViewNode> arrayList = children2;
        if (arrayList == null) {
            ExternalLibrariesNode.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private <T extends WorkspaceEntity> void handleProvider(ExternalLibrariesWorkspaceModelNodesProvider<T> provider2, @NotNull Project project2, EntityStorage storage, List<? super AbstractTreeNode<?>> children2) {
        if (project2 == null) {
            ExternalLibrariesNode.$$$reportNull$$$0(3);
        }
        Sequence sequence = storage.entities(provider2.getWorkspaceClass());
        for (WorkspaceEntity entity : SequencesKt.asIterable((Sequence)sequence)) {
            ProgressManager.checkCanceled();
            AbstractTreeNode<?> node2 = provider2.createNode(entity, project2, this.getSettings());
            if (node2 == null) continue;
            children2.add(node2);
        }
    }

    public static void addLibraryChildren(LibraryOrderEntry entry, List<? super AbstractTreeNode<?>> children2, Project project2, ProjectViewNode<?> node2) {
        VirtualFile[] files2;
        PsiManager psiManager = PsiManager.getInstance(project2);
        for (VirtualFile file2 : files2 = entry.getRootFiles(OrderRootType.CLASSES)) {
            PsiDirectory psiDir = psiManager.findDirectory(file2);
            if (psiDir == null) continue;
            children2.add(new PsiDirectoryNode(project2, psiDir, node2.getSettings()));
        }
    }

    private static boolean hasExternalEntries(ProjectFileIndex index2, LibraryOrderEntry orderEntry2) {
        for (VirtualFile file2 : LibraryGroupNode.getLibraryRoots(orderEntry2)) {
            if (index2.isInContent(VfsUtil.getLocalFile(file2))) continue;
            return true;
        }
        return false;
    }

    protected void update(@NotNull PresentationData presentation2) {
        if (presentation2 == null) {
            ExternalLibrariesNode.$$$reportNull$$$0(4);
        }
        presentation2.setPresentableText(IdeBundle.message((String)"node.projectview.external.libraries", (Object[])new Object[0]));
        presentation2.setIcon(PlatformIcons.LIBRARY_ICON);
    }

    @Override
    @NotNull
    public NodeSortOrder getSortOrder(@NotNull NodeSortSettings settings) {
        if (settings == null) {
            ExternalLibrariesNode.$$$reportNull$$$0(5);
        }
        NodeSortOrder nodeSortOrder = NodeSortOrder.LIBRARY_ROOT;
        if (nodeSortOrder == null) {
            ExternalLibrariesNode.$$$reportNull$$$0(6);
        }
        return nodeSortOrder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/nodes/ExternalLibrariesNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/nodes/ExternalLibrariesNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortOrder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleProvider";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSortOrder";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 6 -> new IllegalStateException(string2);
        };
    }
}

