/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.NodeSortOrder;
import com.intellij.ide.projectView.NodeSortSettings;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.actions.MoveModulesToGroupAction;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.nodes.DropTargetNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public abstract class ModuleGroupNode
extends ProjectViewNode<ModuleGroup>
implements DropTargetNode {
    public ModuleGroupNode(Project project2, @NotNull ModuleGroup value, ViewSettings viewSettings) {
        if (value == null) {
            ModuleGroupNode.$$$reportNull$$$0(0);
        }
        super(project2, value, viewSettings);
    }

    @NotNull
    protected abstract AbstractTreeNode createModuleNode(@NotNull Module var1) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException;

    @NotNull
    protected abstract ModuleGroupNode createModuleGroupNode(@NotNull ModuleGroup var1);

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        Collection<ModuleGroup> childGroups = ((ModuleGroup)this.getValue()).childGroups(this.getProject());
        ArrayList result2 = new ArrayList();
        for (ModuleGroup moduleGroup : childGroups) {
            result2.add(this.createModuleGroupNode(moduleGroup));
        }
        Collection<Module> modules2 = ((ModuleGroup)this.getValue()).modulesInGroup(this.getProject());
        try {
            for (Module module2 : modules2) {
                result2.add(this.createModuleNode(module2));
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            LOG.error(reflectiveOperationException);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            ModuleGroupNode.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getRoots() {
        Collection<AbstractTreeNode<?>> children2 = this.getChildren();
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
        for (AbstractTreeNode<?> each : children2) {
            if (!(each instanceof ProjectViewNode)) continue;
            result2.addAll(((ProjectViewNode)each).getRoots());
        }
        HashSet<VirtualFile> hashSet = result2;
        if (hashSet == null) {
            ModuleGroupNode.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        VirtualFile archiveFile;
        List<Module> modules2;
        if (file2 == null) {
            ModuleGroupNode.$$$reportNull$$$0(3);
        }
        if ((modules2 = this.getModulesByFile(file2)).isEmpty() && file2.getFileSystem() instanceof ArchiveFileSystem && (archiveFile = ((ArchiveFileSystem)file2.getFileSystem()).getLocalByEntry(file2)) != null) {
            modules2 = this.getModulesByFile(archiveFile);
        }
        List<String> thisGroupPath = ((ModuleGroup)this.getValue()).getGroupPathList();
        ModuleGrouper grouper = ModuleGrouper.instanceFor(this.getProject());
        for (Module module2 : modules2) {
            if (!ContainerUtil.startsWith(grouper.getGroupPath(module2), thisGroupPath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean validate() {
        return this.getValue() != null;
    }

    @NotNull
    protected abstract List<Module> getModulesByFile(@NotNull VirtualFile var1);

    public void update(@NotNull PresentationData presentation2) {
        if (presentation2 == null) {
            ModuleGroupNode.$$$reportNull$$$0(4);
        }
        presentation2.setPresentableText(this.getPresentableName());
        presentation2.setIcon(PlatformIcons.CLOSED_MODULE_GROUP_ICON);
    }

    @NotNull
    private String getPresentableName() {
        String string2 = StringUtil.join(this.getRelativeGroupPath(), ".");
        if (string2 == null) {
            ModuleGroupNode.$$$reportNull$$$0(5);
        }
        return string2;
    }

    private List<String> getRelativeGroupPath() {
        List<String> parentPath;
        AbstractTreeNode parent2 = this.getParent();
        List<String> thisPath = ((ModuleGroup)this.getValue()).getGroupPathList();
        if (parent2 instanceof ModuleGroupNode && ContainerUtil.startsWith(thisPath, parentPath = ((ModuleGroup)((ModuleGroupNode)parent2).getValue()).getGroupPathList())) {
            return thisPath.subList(parentPath.size(), thisPath.size());
        }
        return thisPath;
    }

    public String getTestPresentation() {
        return "Group: " + this.getPresentableName();
    }

    public String getToolTip() {
        return IdeBundle.message((String)"tooltip.module.group", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public NodeSortOrder getSortOrder(@NotNull NodeSortSettings settings) {
        if (settings == null) {
            ModuleGroupNode.$$$reportNull$$$0(6);
        }
        NodeSortOrder nodeSortOrder = NodeSortOrder.MODULE_GROUP;
        if (nodeSortOrder == null) {
            ModuleGroupNode.$$$reportNull$$$0(7);
        }
        return nodeSortOrder;
    }

    @Override
    public boolean canDrop(TreeNode @NotNull [] sourceNodes) {
        List<Module> modules2;
        if (sourceNodes == null) {
            ModuleGroupNode.$$$reportNull$$$0(8);
        }
        return !(modules2 = ModuleGroupNode.extractModules(sourceNodes)).isEmpty();
    }

    @Override
    public void drop(TreeNode @NotNull [] sourceNodes, @NotNull DataContext dataContext2) {
        if (dataContext2 == null) {
            ModuleGroupNode.$$$reportNull$$$0(9);
        }
        if (sourceNodes == null) {
            ModuleGroupNode.$$$reportNull$$$0(10);
        }
        List<Module> modules2 = ModuleGroupNode.extractModules(sourceNodes);
        MoveModulesToGroupAction.doMove(modules2.toArray(Module.EMPTY_ARRAY), (ModuleGroup)this.getValue(), null);
    }

    @Override
    public void dropExternalFiles(PsiFileSystemItem[] sourceFileArray, DataContext dataContext2) {
    }

    private static List<Module> extractModules(TreeNode[] sourceNodes) {
        ArrayList<Module> modules2 = new ArrayList<Module>();
        for (TreeNode sourceNode : sourceNodes) {
            Object userObject;
            if (!(sourceNode instanceof DefaultMutableTreeNode) || !((userObject = AbstractProjectViewPane.extractValueFromNode(sourceNode)) instanceof Module)) continue;
            modules2.add((Module)userObject);
        }
        return modules2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/nodes/ModuleGroupNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceNodes";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/nodes/ModuleGroupNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortOrder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSortOrder";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canDrop";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "drop";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 5, 7 -> new IllegalStateException(string2);
        };
    }
}

