/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.ProjectViewSettings;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileSystemItemFilter;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.FontUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;

public class ProjectViewDirectoryHelper {
    protected static final Logger LOG = Logger.getInstance(ProjectViewDirectoryHelper.class);
    private final Project myProject;
    private final ProjectFileIndex myFileIndex;

    public static ProjectViewDirectoryHelper getInstance(@NotNull Project project2) {
        if (project2 == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(0);
        }
        return project2.getService(ProjectViewDirectoryHelper.class);
    }

    public ProjectViewDirectoryHelper(Project project2) {
        this.myProject = project2;
        this.myFileIndex = ProjectFileIndex.getInstance(project2);
    }

    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    public String getLocationString(@NotNull PsiDirectory psiDirectory) {
        if (psiDirectory == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(1);
        }
        boolean includeUrl = ProjectRootsUtil.isModuleContentRoot(psiDirectory);
        return this.getLocationString(psiDirectory, includeUrl, false);
    }

    @Nullable
    public String getLocationString(@NotNull PsiDirectory psiDirectory, boolean includeUrl, boolean includeRootType) {
        ModuleSourceRootEditHandler<?> handler2;
        SourceFolder sourceRoot;
        if (psiDirectory == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(2);
        }
        StringBuilder result2 = new StringBuilder();
        VirtualFile directory = psiDirectory.getVirtualFile();
        if (ProjectRootsUtil.isLibraryRoot(directory, psiDirectory.getProject())) {
            result2.append(ProjectBundle.message((String)"module.paths.root.node", (Object[])new Object[]{"library"}).toLowerCase(Locale.getDefault()));
        } else if (includeRootType && (sourceRoot = ProjectRootsUtil.getModuleSourceRoot(psiDirectory.getVirtualFile(), psiDirectory.getProject())) != null && (handler2 = ModuleSourceRootEditHandler.getEditHandler(sourceRoot.getRootType())) != null) {
            JavaSourceRootProperties properties = (JavaSourceRootProperties)sourceRoot.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES);
            if (properties != null && properties.isForGeneratedSources()) {
                result2.append("generated ");
            }
            result2.append(handler2.getFullRootTypeName().toLowerCase(Locale.getDefault()));
        }
        if (includeUrl) {
            if (result2.length() > 0) {
                result2.append(",").append(FontUtil.spaceAndThinSpace());
            }
            result2.append(FileUtil.getLocationRelativeToUserHome(directory.getPresentableUrl()));
        }
        return result2.length() == 0 ? null : result2.toString();
    }

    public boolean isShowFQName(ViewSettings settings, Object parentValue, PsiDirectory value) {
        return false;
    }

    public boolean shouldHideProjectConfigurationFilesDirectory() {
        return true;
    }

    @Nullable
    public String getNodeName(ViewSettings settings, Object parentValue, PsiDirectory directory) {
        return directory.getName();
    }

    public boolean skipDirectory(PsiDirectory directory) {
        return true;
    }

    public boolean isEmptyMiddleDirectory(PsiDirectory directory, boolean strictlyEmpty) {
        return this.isEmptyMiddleDirectory(directory, strictlyEmpty, null);
    }

    public boolean isEmptyMiddleDirectory(PsiDirectory directory, boolean strictlyEmpty, @Nullable PsiFileSystemItemFilter filter2) {
        return false;
    }

    public boolean supportsFlattenPackages() {
        return false;
    }

    public boolean supportsHideEmptyMiddlePackages() {
        return false;
    }

    public boolean canRepresent(Object element, PsiDirectory directory) {
        if (element instanceof VirtualFile) {
            VirtualFile vFile = (VirtualFile)element;
            return Comparing.equal(directory.getVirtualFile(), vFile);
        }
        return false;
    }

    public boolean canRepresent(@NotNull VirtualFile element, @NotNull PsiDirectory directory, @NotNull PsiDirectory owner, ViewSettings settings) {
        if (element == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(3);
        }
        if (directory == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(4);
        }
        if (owner == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(5);
        }
        if (this.canRepresent(element, directory)) {
            return true;
        }
        if (settings == null) {
            return false;
        }
        if (settings.isFlattenPackages() || !settings.isHideEmptyMiddlePackages()) {
            return false;
        }
        return !ProjectViewDirectoryHelper.processParents(directory, owner, dir -> !element.equals(dir.getVirtualFile()));
    }

    boolean isValidDirectory(PsiDirectory directory, Object owner, ViewSettings settings, PsiFileSystemItemFilter filter2) {
        if (directory == null || !directory.isValid()) {
            return false;
        }
        if (settings == null) {
            return true;
        }
        if (!(owner instanceof PsiDirectory)) {
            return true;
        }
        if (!settings.isFlattenPackages() && settings.isHideEmptyMiddlePackages()) {
            PsiDirectory parent2 = directory.getParent();
            if (parent2 == null || this.skipDirectory(parent2)) {
                return true;
            }
            if (ProjectRootsUtil.isSourceRoot(directory)) {
                return true;
            }
            if (this.isEmptyMiddleDirectory(directory, true, filter2)) {
                return false;
            }
            return ProjectViewDirectoryHelper.processParents(directory, (PsiDirectory)owner, dir -> {
                if (!dir.isValid()) {
                    return false;
                }
                PsiDirectory dirParent = dir.getParent();
                if (dirParent == null || this.skipDirectory(dirParent)) {
                    return false;
                }
                return this.isEmptyMiddleDirectory((PsiDirectory)dir, true, filter2);
            });
        }
        return true;
    }

    private static boolean processParents(@NotNull PsiDirectory directory, @NotNull PsiDirectory owner, @NotNull Processor<? super PsiDirectory> processor) {
        if (directory == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(6);
        }
        if (owner == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(8);
        }
        for (directory = directory.getParentDirectory(); directory != null && !directory.equals(owner); directory = directory.getParentDirectory()) {
            if (processor.process(directory)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getDirectoryChildren(PsiDirectory psiDirectory, ViewSettings settings, boolean withSubDirectories) {
        Collection<AbstractTreeNode<?>> collection = this.getDirectoryChildren(psiDirectory, settings, withSubDirectories, null);
        if (collection == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getDirectoryChildren(PsiDirectory psiDirectory, ViewSettings settings, boolean withSubDirectories, @Nullable PsiFileSystemItemFilter filter2) {
        Collection collection = (Collection)AbstractTreeUi.calculateYieldingToWriteAction(() -> this.doGetDirectoryChildren(psiDirectory, settings, withSubDirectories, filter2));
        if (collection == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @NotNull
    private Collection<AbstractTreeNode<?>> doGetDirectoryChildren(PsiDirectory psiDirectory, ViewSettings settings, boolean withSubDirectories, @Nullable PsiFileSystemItemFilter filter2) {
        ModuleFileIndex moduleFileIndex;
        ArrayList children2 = new ArrayList();
        if (!psiDirectory.isValid()) {
            ArrayList arrayList = children2;
            if (arrayList == null) {
                ProjectViewDirectoryHelper.$$$reportNull$$$0(11);
            }
            return arrayList;
        }
        Project project2 = psiDirectory.getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(project2).getFileIndex();
        Module module2 = fileIndex.getModuleForFile(psiDirectory.getVirtualFile());
        ModuleFileIndex moduleFileIndex2 = moduleFileIndex = module2 == null ? null : ModuleRootManager.getInstance(module2).getFileIndex();
        if (!settings.isFlattenPackages() || this.skipDirectory(psiDirectory)) {
            this.processPsiDirectoryChildren(psiDirectory, this.directoryChildrenInProject(psiDirectory, settings), children2, fileIndex, null, settings, withSubDirectories, filter2);
        } else {
            PsiDirectory parentDir = psiDirectory.getParentDirectory();
            if (parentDir == null || this.skipDirectory(parentDir) && withSubDirectories) {
                this.addAllSubpackages(children2, psiDirectory, moduleFileIndex, settings, filter2);
            }
            if (withSubDirectories) {
                PsiDirectory[] subdirs;
                for (PsiDirectory subdir : subdirs = psiDirectory.getSubdirectories()) {
                    if (!this.skipDirectory(subdir) || filter2 != null && !filter2.shouldShow(subdir)) continue;
                    VirtualFile directoryFile = subdir.getVirtualFile();
                    if (Registry.is("ide.hide.excluded.files") ? fileIndex.isExcluded(directoryFile) : FileTypeRegistry.getInstance().isFileIgnored(directoryFile)) continue;
                    children2.add(new PsiDirectoryNode(project2, subdir, settings, filter2));
                }
            }
            this.processPsiDirectoryChildren(psiDirectory, psiDirectory.getFiles(), children2, fileIndex, moduleFileIndex, settings, withSubDirectories, filter2);
        }
        ArrayList arrayList = children2;
        if (arrayList == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    public List<VirtualFile> getTopLevelRoots() {
        ArrayList<VirtualFile> topLevelContentRoots = new ArrayList<VirtualFile>();
        ProjectRootManager prm = ProjectRootManager.getInstance(this.myProject);
        for (VirtualFile root : prm.getContentRoots()) {
            VirtualFile parent2 = root.getParent();
            if (this.isFileUnderContentRoot(parent2)) continue;
            topLevelContentRoots.add(root);
        }
        Collection<UnloadedModuleDescription> descriptions = ModuleManager.getInstance(this.myProject).getUnloadedModuleDescriptions();
        for (UnloadedModuleDescription description : descriptions) {
            for (VirtualFilePointer pointer : description.getContentRoots()) {
                VirtualFile parent3;
                VirtualFile root = pointer.getFile();
                if (root == null || this.isFileUnderContentRoot(parent3 = root.getParent())) continue;
                topLevelContentRoots.add(root);
            }
        }
        ArrayList<VirtualFile> arrayList = topLevelContentRoots;
        if (arrayList == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    List<VirtualFile> getTopLevelModuleRoots(Module module2, ViewSettings settings) {
        List<VirtualFile> list2 = ContainerUtil.filter(ModuleRootManager.getInstance(module2).getContentRoots(), root -> {
            if (!this.shouldBeShown((VirtualFile)root, settings)) {
                return false;
            }
            VirtualFile parent2 = root.getParent();
            if (parent2 == null) {
                return true;
            }
            if (!module2.equals(this.myFileIndex.getModuleForFile(parent2, false))) {
                return true;
            }
            return this.myFileIndex.isExcluded(parent2) && !ProjectViewDirectoryHelper.shouldShowExcludedFiles(settings);
        });
        if (list2 == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(14);
        }
        return list2;
    }

    @NotNull
    List<VirtualFile> getTopLevelUnloadedModuleRoots(UnloadedModuleDescription module2, ViewSettings settings) {
        List<VirtualFile> list2 = module2.getContentRoots().stream().map(VirtualFilePointer::getFile).filter(root -> root != null && this.shouldBeShown((VirtualFile)root, settings)).collect(Collectors.toList());
        if (list2 == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(15);
        }
        return list2;
    }

    private boolean isFileUnderContentRoot(@Nullable VirtualFile file2) {
        return file2 != null && file2.isValid() && this.myFileIndex.getContentRootForFile(file2, false) != null;
    }

    private PsiElement @NotNull [] directoryChildrenInProject(PsiDirectory psiDirectory, final ViewSettings settings) {
        VirtualFile dir = psiDirectory.getVirtualFile();
        if (this.shouldBeShown(dir, settings)) {
            final ArrayList children2 = new ArrayList();
            psiDirectory.processChildren((PsiElementProcessor<? super PsiFileSystemItem>)new PsiElementProcessor<PsiFileSystemItem>(){

                @Override
                public boolean execute(@NotNull PsiFileSystemItem element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (ProjectViewDirectoryHelper.this.shouldBeShown(element.getVirtualFile(), settings)) {
                        children2.add(element);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/projectView/impl/nodes/ProjectViewDirectoryHelper$1", "execute"));
                }
            });
            PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(children2);
            if (psiElementArray == null) {
                ProjectViewDirectoryHelper.$$$reportNull$$$0(16);
            }
            return psiElementArray;
        }
        PsiManager manager = psiDirectory.getManager();
        HashSet<PsiDirectory> directoriesOnTheWayToContentRoots = new HashSet<PsiDirectory>();
        Iterator<VirtualFile> iterator2 = this.getTopLevelRoots().iterator();
        while (iterator2.hasNext()) {
            VirtualFile root;
            VirtualFile current = root = iterator2.next();
            while (current != null) {
                PsiDirectory psi;
                VirtualFile parent2 = current.getParent();
                if (Comparing.equal(parent2, dir) && (psi = manager.findDirectory(current)) != null) {
                    directoriesOnTheWayToContentRoots.add(psi);
                }
                current = parent2;
            }
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(directoriesOnTheWayToContentRoots);
        if (psiElementArray == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(17);
        }
        return psiElementArray;
    }

    private boolean shouldBeShown(@NotNull VirtualFile dir, ViewSettings settings) {
        if (dir == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(18);
        }
        if (!dir.isValid()) {
            return false;
        }
        return ProjectViewDirectoryHelper.shouldShowExcludedFiles(settings) ? this.myFileIndex.isInProjectOrExcluded(dir) : this.myFileIndex.isInProject(dir) && !ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)dir);
    }

    private static boolean shouldShowExcludedFiles(ViewSettings settings) {
        return !Registry.is("ide.hide.excluded.files") && settings instanceof ProjectViewSettings && ((ProjectViewSettings)settings).isShowExcludedFiles();
    }

    private void processPsiDirectoryChildren(PsiDirectory psiDir, PsiElement[] children2, List<? super AbstractTreeNode<?>> container, ProjectFileIndex projectFileIndex, @Nullable ModuleFileIndex moduleFileIndex, ViewSettings viewSettings, boolean withSubDirectories, @Nullable PsiFileSystemItemFilter filter2) {
        for (PsiElement child : children2) {
            LOG.assertTrue(child.isValid());
            if (!(child instanceof PsiFileSystemItem)) {
                LOG.error("Either PsiFile or PsiDirectory expected as a child of " + child.getParent() + ", but was " + child);
                continue;
            }
            VirtualFile vFile = ((PsiFileSystemItem)child).getVirtualFile();
            if (vFile == null || moduleFileIndex != null && !moduleFileIndex.isInContent(vFile) || filter2 != null && !filter2.shouldShow((PsiFileSystemItem)child)) continue;
            if (child instanceof PsiFile) {
                container.add(new PsiFileNode(child.getProject(), (PsiFile)child, viewSettings));
                continue;
            }
            if (!(child instanceof PsiDirectory) || !withSubDirectories) continue;
            PsiDirectory dir = (PsiDirectory)child;
            if (!vFile.equals(projectFileIndex.getSourceRootForFile(vFile)) && viewSettings.isHideEmptyMiddlePackages() && !this.skipDirectory(psiDir) && this.isEmptyMiddleDirectory(dir, true, filter2)) {
                this.processPsiDirectoryChildren(dir, this.directoryChildrenInProject(dir, viewSettings), container, projectFileIndex, moduleFileIndex, viewSettings, true, filter2);
                continue;
            }
            container.add(new PsiDirectoryNode(child.getProject(), (PsiDirectory)child, viewSettings, filter2));
        }
    }

    private void addAllSubpackages(List<? super AbstractTreeNode<?>> container, PsiDirectory dir, @Nullable ModuleFileIndex moduleFileIndex, ViewSettings viewSettings, @Nullable PsiFileSystemItemFilter filter2) {
        PsiDirectory[] subdirs;
        Project project2 = dir.getProject();
        for (PsiDirectory subdir : subdirs = dir.getSubdirectories()) {
            if (this.skipDirectory(subdir) || filter2 != null && !filter2.shouldShow(subdir)) continue;
            if (moduleFileIndex != null && !moduleFileIndex.isInContent(subdir.getVirtualFile())) {
                container.add(new PsiDirectoryNode(project2, subdir, viewSettings, filter2));
                continue;
            }
            if (viewSettings.isHideEmptyMiddlePackages()) {
                if (!this.isEmptyMiddleDirectory(subdir, false, filter2)) {
                    container.add(new PsiDirectoryNode(project2, subdir, viewSettings, filter2));
                }
            } else {
                container.add(new PsiDirectoryNode(project2, subdir, viewSettings, filter2));
            }
            this.addAllSubpackages(container, subdir, moduleFileIndex, viewSettings, filter2);
        }
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> createFileAndDirectoryNodes(@NotNull List<? extends VirtualFile> files2, ViewSettings viewSettings) {
        if (files2 == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(19);
        }
        ArrayList children2 = new ArrayList(files2.size());
        PsiManager psiManager = PsiManager.getInstance(this.myProject);
        for (VirtualFile virtualFile2 : files2) {
            ContainerUtil.addIfNotNull(children2, this.doCreateNode(virtualFile2, psiManager, viewSettings));
        }
        ArrayList arrayList = children2;
        if (arrayList == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    @Nullable
    protected AbstractTreeNode<?> doCreateNode(@NotNull VirtualFile virtualFile2, @NotNull PsiManager psiManager, @Nullable ViewSettings viewSettings) {
        if (virtualFile2 == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(21);
        }
        if (psiManager == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(22);
        }
        if (virtualFile2.isDirectory()) {
            PsiDirectory directory = psiManager.findDirectory(virtualFile2);
            if (directory != null) {
                return new PsiDirectoryNode(this.myProject, directory, viewSettings);
            }
        } else {
            PsiFile file2 = psiManager.findFile(virtualFile2);
            if (file2 != null) {
                return new PsiFileNode(this.myProject, file2, viewSettings);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 11, 12, 13, 14, 15, 16, 17, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDirectory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/nodes/ProjectViewDirectoryHelper";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/nodes/ProjectViewDirectoryHelper";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoryChildren";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetDirectoryChildren";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelRoots";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelModuleRoots";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelUnloadedModuleRoots";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "directoryChildrenInProject";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileAndDirectoryNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLocationString";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canRepresent";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processParents";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "shouldBeShown";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createFileAndDirectoryNodes";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "doCreateNode";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 9, 10, 11, 12, 13, 14, 15, 16, 17, 20 -> new IllegalStateException(string2);
        };
    }
}

