/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.nodes.AbstractProjectNode;
import com.intellij.ide.projectView.impl.nodes.ExternalLibrariesNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleGroupNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewUnloadedModuleNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.module.impl.LoadedModuleDescriptionImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProjectViewProjectNode
extends AbstractProjectNode {
    public ProjectViewProjectNode(@NotNull Project project2, ViewSettings viewSettings) {
        if (project2 == null) {
            ProjectViewProjectNode.$$$reportNull$$$0(0);
        }
        super(project2, project2, viewSettings);
    }

    public boolean canRepresent(Object element) {
        Project project2 = (Project)this.getValue();
        return project2 == element || project2 != null && element instanceof VirtualFile && element.equals(project2.getBaseDir());
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        VirtualFile baseDir;
        Project project2 = this.myProject;
        if (project2 == null || project2.isDisposed() || project2.isDefault()) {
            List<AbstractTreeNode<?>> list2 = Collections.emptyList();
            if (list2 == null) {
                ProjectViewProjectNode.$$$reportNull$$$0(1);
            }
            return list2;
        }
        List<VirtualFile> topLevelContentRoots = ProjectViewDirectoryHelper.getInstance(project2).getTopLevelRoots();
        LinkedHashSet<LoadedModuleDescriptionImpl> modules2 = new LinkedHashSet<LoadedModuleDescriptionImpl>(topLevelContentRoots.size());
        for (VirtualFile root : topLevelContentRoots) {
            Module module2 = ModuleUtilCore.findModuleForFile(root, project2);
            if (module2 != null) {
                modules2.add(new LoadedModuleDescriptionImpl(module2));
                continue;
            }
            String unloadedModuleName = ProjectRootsUtil.findUnloadedModuleByContentRoot(root, project2);
            if (unloadedModuleName == null) continue;
            ContainerUtil.addIfNotNull(modules2, ModuleManager.getInstance(project2).getUnloadedModuleDescription(unloadedModuleName));
        }
        ArrayList nodes2 = new ArrayList(this.modulesAndGroups(modules2));
        String baseDirPath = project2.getBasePath();
        VirtualFile virtualFile2 = baseDir = baseDirPath == null ? null : LocalFileSystem.getInstance().findFileByPath(baseDirPath);
        if (baseDir != null) {
            PsiManager psiManager = PsiManager.getInstance(project2);
            VirtualFile[] files2 = baseDir.getChildren();
            ProjectFileIndex projectFileIndex = null;
            for (VirtualFile file2 : files2) {
                PsiFile psiFile;
                if (file2.isDirectory()) continue;
                if (projectFileIndex == null) {
                    projectFileIndex = ProjectFileIndex.getInstance(this.getProject());
                }
                if (projectFileIndex.getModuleForFile(file2, false) != null || (psiFile = psiManager.findFile(file2)) == null) continue;
                nodes2.add(new PsiFileNode(this.getProject(), psiFile, this.getSettings()));
            }
        }
        if (this.getSettings().isShowLibraryContents()) {
            nodes2.add(new ExternalLibrariesNode(project2, this.getSettings()));
        }
        ArrayList arrayList = nodes2;
        if (arrayList == null) {
            ProjectViewProjectNode.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected AbstractTreeNode<?> createModuleGroup(@NotNull Module module2) {
        PsiDirectory psi;
        List<VirtualFile> roots2;
        if (module2 == null) {
            ProjectViewProjectNode.$$$reportNull$$$0(3);
        }
        if ((roots2 = ProjectViewDirectoryHelper.getInstance(this.myProject).getTopLevelModuleRoots(module2, this.getSettings())).size() == 1 && (psi = PsiManager.getInstance(this.myProject).findDirectory(roots2.get(0))) != null) {
            return new PsiDirectoryNode(this.myProject, psi, this.getSettings());
        }
        return new ProjectViewModuleNode(this.getProject(), module2, this.getSettings());
    }

    @Override
    protected AbstractTreeNode<?> createUnloadedModuleNode(@NotNull UnloadedModuleDescription moduleDescription) {
        PsiDirectory psi;
        List<VirtualFile> roots2;
        if (moduleDescription == null) {
            ProjectViewProjectNode.$$$reportNull$$$0(4);
        }
        if ((roots2 = ProjectViewDirectoryHelper.getInstance(this.myProject).getTopLevelUnloadedModuleRoots(moduleDescription, this.getSettings())).size() == 1 && (psi = PsiManager.getInstance(this.myProject).findDirectory(roots2.get(0))) != null) {
            return new PsiDirectoryNode(this.myProject, psi, this.getSettings());
        }
        return new ProjectViewUnloadedModuleNode(this.getProject(), moduleDescription, this.getSettings());
    }

    @NotNull
    protected AbstractTreeNode createModuleGroupNode(@NotNull ModuleGroup moduleGroup) {
        if (moduleGroup == null) {
            ProjectViewProjectNode.$$$reportNull$$$0(5);
        }
        return new ProjectViewModuleGroupNode(this.getProject(), moduleGroup, this.getSettings());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/nodes/ProjectViewProjectNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDescription";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/nodes/ProjectViewProjectNode";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createModuleGroup";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createUnloadedModuleNode";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createModuleGroupNode";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2 -> new IllegalStateException(string2);
        };
    }
}

