/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class ProjectViewUnloadedModuleNode
extends ProjectViewNode<UnloadedModuleDescription> {
    public ProjectViewUnloadedModuleNode(Project project2, @NotNull UnloadedModuleDescription value, ViewSettings viewSettings) {
        if (value == null) {
            ProjectViewUnloadedModuleNode.$$$reportNull$$$0(0);
        }
        super(project2, value, viewSettings);
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        UnloadedModuleDescription module2 = (UnloadedModuleDescription)this.getValue();
        if (module2 == null) {
            List<AbstractTreeNode<?>> list2 = Collections.emptyList();
            if (list2 == null) {
                ProjectViewUnloadedModuleNode.$$$reportNull$$$0(1);
            }
            return list2;
        }
        List<VirtualFile> contentRoots = ProjectViewDirectoryHelper.getInstance(this.myProject).getTopLevelUnloadedModuleRoots(module2, this.getSettings());
        Collection<AbstractTreeNode<?>> collection = ProjectViewDirectoryHelper.getInstance(this.myProject).createFileAndDirectoryNodes(contentRoots, this.getSettings());
        if (collection == null) {
            ProjectViewUnloadedModuleNode.$$$reportNull$$$0(2);
        }
        return collection;
    }

    public int getWeight() {
        return 10;
    }

    @Override
    public int getTypeSortWeight(boolean sortByType) {
        return 2;
    }

    public void update(@NotNull PresentationData presentation2) {
        UnloadedModuleDescription module2;
        if (presentation2 == null) {
            ProjectViewUnloadedModuleNode.$$$reportNull$$$0(3);
        }
        if ((module2 = (UnloadedModuleDescription)this.getValue()) == null) {
            this.setValue(null);
            return;
        }
        presentation2.setPresentableText(module2.getName());
        presentation2.addText(module2.getName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        presentation2.setIcon(AllIcons.Modules.UnloadedModule);
        presentation2.setTooltip(LangBundle.message("unloaded.module.tooltip", new Object[0]));
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getRoots() {
        UnloadedModuleDescription module2 = (UnloadedModuleDescription)this.getValue();
        Collection<VirtualFile> collection = module2 != null ? (Collection)module2.getContentRoots().stream().map(VirtualFilePointer::getFile).filter(Objects::nonNull).collect(Collectors.toList()) : Collections.emptyList();
        if (collection == null) {
            ProjectViewUnloadedModuleNode.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        UnloadedModuleDescription module2;
        if (file2 == null) {
            ProjectViewUnloadedModuleNode.$$$reportNull$$$0(5);
        }
        return (module2 = (UnloadedModuleDescription)this.getValue()) != null && module2.getContentRoots().stream().map(VirtualFilePointer::getFile).anyMatch(root -> root != null && VfsUtilCore.isAncestor(root, file2, false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/nodes/ProjectViewUnloadedModuleNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/nodes/ProjectViewUnloadedModuleNode";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 4 -> new IllegalStateException(string2);
        };
    }
}

