/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scopeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyPasteUtil;
import com.intellij.ide.bookmark.BookmarksListener;
import com.intellij.ide.bookmark.FileBookmarksListener;
import com.intellij.ide.projectView.NodeSortOrder;
import com.intellij.ide.projectView.NodeSortSettings;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewNodeDecorator;
import com.intellij.ide.projectView.ProjectViewSettings;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.CompoundIconProvider;
import com.intellij.ide.projectView.impl.nodes.AbstractPsiBasedNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.scopeView.NamedScopeFilter;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.impl.OpenFilesScope;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.pom.NavigatableWithText;
import com.intellij.problems.ProblemListener;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.search.scope.ProjectFilesScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.DeferredIcon;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.icons.CompositeIcon;
import com.intellij.ui.stripe.ErrorStripe;
import com.intellij.ui.tree.AbstractTreeWalker;
import com.intellij.ui.tree.BaseTreeModel;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.tree.project.ProjectFileNode;
import com.intellij.ui.tree.project.ProjectFileNodeUpdater;
import com.intellij.ui.tree.project.ProjectFileTreeModel;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import javax.swing.Icon;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ScopeViewTreeModel
extends BaseTreeModel<AbstractTreeNode<?>>
implements InvokerSupplier {
    private static final Logger LOG = Logger.getInstance(ScopeViewTreeModel.class);
    private volatile Comparator<? super NodeDescriptor<?>> comparator;
    private final ProjectFileTreeModel model;
    private final ProjectNode root;

    ScopeViewTreeModel(@NotNull Project project2, @NotNull ViewSettings settings) {
        if (project2 == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(1);
        }
        this.model = new ProjectFileTreeModel(project2);
        this.model.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

            @Override
            protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (type == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (type == TreeModelAdapter.EventType.StructureChanged) {
                    TreePath path2 = event.getTreePath();
                    if (path2 == null || null == path2.getParentPath()) {
                        ScopeViewTreeModel.this.invalidate(null);
                    } else {
                        Object component2 = path2.getLastPathComponent();
                        if (component2 instanceof ProjectFileNode) {
                            ProjectFileNode node2 = (ProjectFileNode)component2;
                            ScopeViewTreeModel.this.notifyStructureChanged(node2.getVirtualFile());
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        Disposer.register((Disposable)((Object)this), (Disposable)this.model);
        this.root = new ProjectNode(project2, settings);
        MessageBusConnection connection = project2.getMessageBus().connect((Disposable)((Object)this));
        connection.subscribe(BookmarksListener.TOPIC, new FileBookmarksListener(file2 -> this.notifyPresentationChanged((VirtualFile)file2)));
        connection.subscribe(ProblemListener.TOPIC, new ProblemListener(){

            @Override
            public void problemsAppeared(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.problemsDisappeared(file2);
            }

            @Override
            public void problemsDisappeared(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                ScopeViewTreeModel.this.notifyPresentationChanged(file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "file";
                objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "problemsAppeared";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "problemsDisappeared";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, new FileEditorManagerListener(){

            @Override
            public void fileOpened(@NotNull FileEditorManager manager, @NotNull VirtualFile file2) {
                if (manager == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                this.fileClosed(manager, file2);
            }

            @Override
            public void fileClosed(@NotNull FileEditorManager manager, @NotNull VirtualFile file2) {
                if (manager == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (file2 == null) {
                    3.$$$reportNull$$$0(3);
                }
                ScopeViewTreeModel.this.updateScopeIf(OpenFilesScope.class);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "manager";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileOpened";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        FileStatusManager.getInstance((Project)project2).addFileStatusListener(new FileStatusListener(){

            public void fileStatusChanged(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                ScopeViewTreeModel.this.notifyPresentationChanged(file2);
            }

            public void fileStatusesChanged() {
                ScopeViewTreeModel.this.invalidate(null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scopeView/ScopeViewTreeModel$4", "fileStatusChanged"));
            }
        }, (Disposable)((Object)this));
        CopyPasteUtil.addDefaultListener((Disposable)((Object)this), element -> {
            VirtualFile file2 = PsiUtilCore.getVirtualFile(element);
            if (file2 != null) {
                this.notifyPresentationChanged(file2);
            }
        });
    }

    void setStructureProvider(TreeStructureProvider provider2) {
        this.model.onValidThread(() -> {
            if (this.root.provider == null && provider2 == null) {
                return;
            }
            this.root.provider = provider2;
            this.treeStructureChanged(null, null, null);
        });
    }

    void setNodeDecorator(ProjectViewNodeDecorator decorator) {
        this.model.onValidThread(() -> {
            if (this.root.decorator == null && decorator == null) {
                return;
            }
            this.root.decorator = decorator;
            this.treeStructureChanged(null, null, null);
        });
    }

    void setComparator(@NotNull Comparator<? super NodeDescriptor<?>> comparator) {
        if (comparator == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(2);
        }
        this.model.onValidThread(() -> {
            if (this.comparator == comparator) {
                return;
            }
            this.comparator = comparator;
            this.treeStructureChanged(null, null, null);
        });
    }

    public void setFilter(@Nullable NamedScopeFilter filter2) {
        this.root.filter = filter2;
        LOG.debug("set filter", filter2);
        this.model.setFilter((VirtualFileFilter)(filter2 != null && filter2.getScope() instanceof ProjectFilesScope ? null : filter2));
    }

    public NamedScopeFilter getFilter() {
        return this.root.filter;
    }

    @Nullable
    public Object getContent(Object object) {
        Node node2;
        if (object instanceof GroupNode) {
            node2 = (GroupNode)((Object)object);
            object = ((GroupNode)node2).getSingleRoot();
        }
        if (object instanceof FileNode) {
            node2 = (FileNode)((Object)object);
            PsiFileSystemItem element = node2.findFileSystemItem(((FileNode)node2).getVirtualFile());
            if (element == null || ((FileNode)node2).compacted == null) {
                return element;
            }
            if (ScopeViewTreeModel.isPackage(node2.getIcon()) && node2.getSettings().isFlattenPackages()) {
                return element;
            }
            ArrayDeque<PsiFileSystemItem> deque = new ArrayDeque<PsiFileSystemItem>();
            ((FileNode)node2).compacted.forEach(arg_0 -> ScopeViewTreeModel.lambda$getContent$5((FileNode)node2, deque, arg_0));
            if (deque.isEmpty()) {
                return element;
            }
            deque.addFirst(element);
            return deque.toArray();
        }
        if (object instanceof NodeDescriptor) {
            object = ((NodeDescriptor)object).getElement();
        }
        if (object instanceof AbstractTreeNode) {
            object = ((AbstractTreeNode)object).getValue();
        }
        return object;
    }

    @NotNull
    public ProjectFileNodeUpdater getUpdater() {
        ProjectFileNodeUpdater projectFileNodeUpdater = this.model.getUpdater();
        if (projectFileNodeUpdater == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(3);
        }
        return projectFileNodeUpdater;
    }

    @NotNull
    public Invoker getInvoker() {
        Invoker invoker = this.model.getInvoker();
        if (invoker == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(4);
        }
        return invoker;
    }

    public void invalidate(@Nullable Runnable onDone) {
        this.model.onValidThread(() -> {
            this.root.childrenValid = false;
            LOG.debug("whole structure changed");
            ViewSettings settings = this.root.getSettings();
            boolean isShowExcludedFiles = false;
            if (settings instanceof ProjectViewSettings && ((ProjectViewSettings)settings).isShowExcludedFiles()) {
                NamedScopeFilter filter2 = this.getFilter();
                Class<?> type = filter2 == null ? null : filter2.getScope().getClass();
                isShowExcludedFiles = !NamedScope.class.equals(type);
            }
            this.model.setSettings(isShowExcludedFiles, PlatformUtils.isIntelliJ() && settings.isShowModules());
            this.treeStructureChanged(null, null, null);
            if (onDone != null) {
                onDone.run();
            }
        });
    }

    private void update(@NotNull AbstractTreeNode<?> node2, boolean structure) {
        if (node2 == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(5);
        }
        this.model.onValidThread(() -> {
            boolean changed2;
            boolean updated = node2.update();
            boolean bl = changed2 = structure || !(node2 instanceof Node);
            if (!updated && !changed2) {
                return;
            }
            TreePath path2 = TreePathUtil.pathToCustomNode((Object)node2, AbstractTreeNode::getParent);
            if (path2 == null || this.root != path2.getPathComponent(0)) {
                return;
            }
            if (changed2) {
                LOG.debug("structure changed: ", node2);
                this.treeStructureChanged(path2, null, null);
            } else {
                LOG.debug("node updated: ", node2);
                this.treeNodesChanged(path2, null, null);
            }
        });
    }

    private void notifyStructureChanged(@NotNull VirtualFile file2) {
        boolean flattenPackages;
        if (file2 == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(6);
        }
        if (flattenPackages = this.root.getSettings().isFlattenPackages()) {
            VirtualFile ancestor;
            ProjectFileIndex index2 = ScopeViewTreeModel.getProjectFileIndex(this.root.getProject());
            VirtualFile virtualFile2 = ancestor = index2 == null ? null : index2.getSourceRootForFile(file2);
            if (ancestor != null && VfsUtilCore.isAncestor(ancestor, file2, true)) {
                file2 = ancestor;
            } else {
                flattenPackages = false;
            }
        }
        boolean resolveCompactedFolder = !flattenPackages && file2.isDirectory() && this.root.getSettings().isCompactDirectories();
        this.find(file2, null, found2 -> {
            if (found2 instanceof Node) {
                AbstractTreeNode parent2;
                Node node2 = (Node)((Object)((Object)found2));
                if (resolveCompactedFolder && (parent2 = node2.getParent()) instanceof Node) {
                    node2 = (Node)parent2;
                }
                if (node2.childrenValid) {
                    node2.childrenValid = false;
                    this.update(node2, true);
                }
            } else if (found2 instanceof AbstractTreeNode) {
                this.update((AbstractTreeNode)found2, true);
            }
        });
    }

    private void notifyPresentationChanged(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(7);
        }
        while (!file2.isValid()) {
            if ((file2 = file2.getParent()) != null) continue;
            return;
        }
        SmartList list2 = new SmartList();
        this.find(file2, list2, found2 -> {
            list2.forEach(node2 -> this.update((AbstractTreeNode<?>)node2, false));
            if (found2 instanceof AbstractTreeNode) {
                this.update((AbstractTreeNode)found2, false);
            }
        });
    }

    private void find(@NotNull VirtualFile file2, final @Nullable List<? super Node> list2, @NotNull Consumer<Object> consumer2) {
        if (file2 == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(8);
        }
        if (consumer2 == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(9);
        }
        this.model.onValidThread(() -> {
            final AreaInstance area = ProjectFileNode.findArea((VirtualFile)file2, (Project)this.root.getProject());
            if (area != null) {
                TreeVisitor.ByComponent<VirtualFile, AbstractTreeNode> visitor2 = new TreeVisitor.ByComponent<VirtualFile, AbstractTreeNode>(file2, AbstractTreeNode.class){

                    protected boolean matches(@NotNull AbstractTreeNode pathComponent, @NotNull VirtualFile thisComponent) {
                        if (pathComponent == null) {
                            5.$$$reportNull$$$0(0);
                        }
                        if (thisComponent == null) {
                            5.$$$reportNull$$$0(1);
                        }
                        if (pathComponent.canRepresent((Object)thisComponent)) {
                            return true;
                        }
                        if (pathComponent instanceof Node) {
                            return false;
                        }
                        ProjectViewNode node2 = pathComponent instanceof ProjectViewNode ? (ProjectViewNode)pathComponent : null;
                        return node2 != null && node2.contains(thisComponent);
                    }

                    protected boolean contains(@NotNull AbstractTreeNode pathComponent, @NotNull VirtualFile thisComponent) {
                        Node node2;
                        if (pathComponent == null) {
                            5.$$$reportNull$$$0(2);
                        }
                        if (thisComponent == null) {
                            5.$$$reportNull$$$0(3);
                        }
                        Node node3 = node2 = pathComponent instanceof Node ? (Node)pathComponent : null;
                        if (node2 == null || !node2.contains(thisComponent, area)) {
                            return false;
                        }
                        if (list2 != null) {
                            list2.add(node2);
                        }
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "pathComponent";
                                break;
                            }
                            case 1: 
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "thisComponent";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel$5";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "matches";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "contains";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                AbstractTreeWalker walker = new AbstractTreeWalker<AbstractTreeNode<?>>((TreeVisitor)visitor2){

                    protected Collection<AbstractTreeNode<?>> getChildren(@NotNull AbstractTreeNode pathComponent) {
                        if (pathComponent == null) {
                            6.$$$reportNull$$$0(0);
                        }
                        Node node2 = pathComponent instanceof Node ? (Node)pathComponent : null;
                        return node2 != null && node2.childrenValid ? node2.children : Collections.emptyList();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathComponent", "com/intellij/ide/scopeView/ScopeViewTreeModel$6", "getChildren"));
                    }
                };
                walker.start((Object)this.root);
                walker.promise().onProcessed(path2 -> consumer2.consume(path2 == null ? null : path2.getLastPathComponent()));
            }
        });
    }

    public Object getRoot() {
        if (!this.model.isValidThread()) {
            return null;
        }
        this.root.update();
        return this.root;
    }

    public boolean isLeaf(Object object) {
        return this.root != object && super.isLeaf(object);
    }

    public int getChildCount(Object object) {
        if (object instanceof AbstractTreeNode && this.model.isValidThread()) {
            return ((AbstractTreeNode)object).getChildren().size();
        }
        return 0;
    }

    @NotNull
    public List<AbstractTreeNode<?>> getChildren(Object object) {
        if (object instanceof AbstractTreeNode) {
            Collection children2;
            AbstractTreeNode parent2 = (AbstractTreeNode)object;
            if (this.model.isValidThread() && !(children2 = parent2.getChildren()).isEmpty()) {
                SmartList result2 = new SmartList();
                children2.forEach(child -> {
                    if (child instanceof AbstractTreeNode) {
                        AbstractTreeNode node2 = (AbstractTreeNode)child;
                        node2.setParent(parent2);
                        node2.update();
                        result2.add(node2);
                    }
                });
                Comparator<? super NodeDescriptor<?>> comparator = this.comparator;
                if (comparator != null) {
                    result2.sort(comparator);
                }
                SmartList smartList = result2;
                if (smartList == null) {
                    ScopeViewTreeModel.$$$reportNull$$$0(10);
                }
                return smartList;
            }
        }
        List<AbstractTreeNode<?>> list2 = Collections.emptyList();
        if (list2 == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @Nullable
    ErrorStripe getStripe(Object object, boolean expanded) {
        if (expanded && object instanceof Node) {
            return null;
        }
        if (object instanceof PresentableNodeDescriptor) {
            Color color;
            PresentableNodeDescriptor node2 = (PresentableNodeDescriptor)object;
            TextAttributesKey key = node2.getPresentation().getTextAttributesKey();
            TextAttributes attributes = key == null ? null : EditorColorsManager.getInstance().getSchemeForCurrentUITheme().getAttributes(key);
            Color color2 = color = attributes == null ? null : attributes.getErrorStripeColor();
            if (color != null) {
                return ErrorStripe.create((Color)color, (int)1);
            }
        }
        return null;
    }

    private boolean updateScopeIf(@NotNull Class<? extends NamedScope> type) {
        NamedScopeFilter filter2;
        if (type == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(12);
        }
        if ((filter2 = this.getFilter()) == null || !type.isInstance(filter2.getScope())) {
            return false;
        }
        LOG.debug("update filter", filter2);
        this.model.setFilter((VirtualFileFilter)filter2);
        return true;
    }

    @Nullable
    private static WolfTheProblemSolver getWolfTheProblemSolver(@Nullable Project project2) {
        return project2 == null || project2.isDisposed() ? null : WolfTheProblemSolver.getInstance(project2);
    }

    @Nullable
    private static FileStatusManager getFileStatusManager(@Nullable Project project2) {
        return project2 == null || project2.isDisposed() ? null : FileStatusManager.getInstance((Project)project2);
    }

    @Nullable
    private static ModuleManager getModuleManager(@Nullable Project project2) {
        return project2 == null || project2.isDisposed() ? null : ModuleManager.getInstance(project2);
    }

    @Nullable
    private static ProjectFileIndex getProjectFileIndex(@Nullable Project project2) {
        return project2 == null || project2.isDisposed() ? null : ProjectFileIndex.getInstance(project2);
    }

    @Nullable
    private static ModuleRootManager getModuleRootManager(@Nullable Module module2) {
        return module2 == null || module2.isDisposed() ? null : ModuleRootManager.getInstance(module2);
    }

    @Nullable
    private static ProjectSettingsService getProjectSettingsService(@Nullable Project project2) {
        return project2 == null || project2.isDisposed() ? null : ProjectSettingsService.getInstance(project2);
    }

    @Nullable
    private static Module getModule(@NotNull VirtualFile file2, @Nullable Project project2) {
        ProjectFileIndex index2;
        if (file2 == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(13);
        }
        return (index2 = ScopeViewTreeModel.getProjectFileIndex(project2)) == null ? null : index2.getModuleForFile(file2);
    }

    private static boolean hasModuleGroups(@Nullable Project project2) {
        if (Registry.is("project.qualified.module.names")) {
            return true;
        }
        ModuleManager manager = ScopeViewTreeModel.getModuleManager(project2);
        return manager != null && manager.hasModuleGroups();
    }

    @NotNull
    private static List<String> getModuleNameAsList(@NotNull Module module2, boolean split2) {
        if (module2 == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(14);
        }
        String name = module2.getName();
        Project project2 = module2.isDisposed() ? null : module2.getProject();
        ModuleManager manager = ScopeViewTreeModel.getModuleManager(project2);
        if (manager != null) {
            if (manager.hasModuleGroups()) {
                String[] path2 = manager.getModuleGroupPath(module2);
                if (path2 != null && path2.length != 0) {
                    SmartList<String> list2 = new SmartList<String>(path2);
                    list2.add(name);
                    SmartList<String> smartList = list2;
                    if (smartList == null) {
                        ScopeViewTreeModel.$$$reportNull$$$0(15);
                    }
                    return smartList;
                }
            } else if (split2) {
                List<String> list3 = StringUtil.split(name, ".");
                if (list3 == null) {
                    ScopeViewTreeModel.$$$reportNull$$$0(16);
                }
                return list3;
            }
        }
        return new SmartList<String>(name);
    }

    @Nullable
    private static List<VirtualFile> getCompactedFolders(@Nullable VirtualFile ancestor, @NotNull VirtualFile file2) {
        if (file2 == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(17);
        }
        if (ancestor == null || !VfsUtilCore.isAncestor(ancestor, file2, true)) {
            return null;
        }
        ArrayDeque<VirtualFile> deque = new ArrayDeque<VirtualFile>();
        while ((file2 = file2.getParent()) != null && VfsUtilCore.isAncestor(ancestor, file2, true)) {
            deque.addFirst(file2);
        }
        return deque.isEmpty() ? null : new SmartList(deque);
    }

    private static boolean isFolder(@Nullable Icon icon2) {
        return ScopeViewTreeModel.is(icon2, AllIcons.Nodes.Folder);
    }

    private static boolean isPackage(@Nullable Icon icon2) {
        return ScopeViewTreeModel.is(icon2, AllIcons.Nodes.Package);
    }

    private static boolean is(@Nullable Icon icon2, @NotNull Icon expected) {
        if (expected == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(18);
        }
        if (expected.equals(icon2)) {
            return true;
        }
        if (icon2 instanceof CompositeIcon) {
            CompositeIcon composite2 = (CompositeIcon)icon2;
            for (int i2 = 0; i2 < composite2.getIconCount(); ++i2) {
                if (!ScopeViewTreeModel.is(composite2.getIcon(i2), expected)) continue;
                return true;
            }
        }
        if (icon2 instanceof DeferredIcon) {
            return false;
        }
        if (icon2 instanceof RetrievableIcon) {
            RetrievableIcon retrievable = (RetrievableIcon)icon2;
            if (retrievable.isComplex()) {
                return false;
            }
            if (ScopeViewTreeModel.is(retrievable.retrieveIcon(), expected)) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void lambda$getContent$5(FileNode node2, ArrayDeque deque, VirtualFile file2) {
        PsiFileSystemItem item = node2.findFileSystemItem(file2);
        if (item != null) {
            deque.addFirst(item);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 10, 11, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scopeView/ScopeViewTreeModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdater";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvoker";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleNameAsList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setComparator";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "notifyStructureChanged";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "notifyPresentationChanged";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateScopeIf";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getModule";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getModuleNameAsList";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCompactedFolders";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "is";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4, 10, 11, 15, 16 -> new IllegalStateException(string2);
        };
    }

    private final class ProjectNode
    extends Node {
        private volatile Map<Object, RootNode> roots;
        volatile TreeStructureProvider provider;
        volatile ProjectViewNodeDecorator decorator;

        ProjectNode(@NotNull Project project2, ViewSettings settings) {
            if (project2 == null) {
                ProjectNode.$$$reportNull$$$0(0);
            }
            if (settings == null) {
                ProjectNode.$$$reportNull$$$0(1);
            }
            super(project2, project2, settings);
            this.roots = new HashMap<Object, RootNode>();
        }

        protected void update(@NotNull PresentationData presentation2) {
            if (presentation2 == null) {
                ProjectNode.$$$reportNull$$$0(2);
            }
            presentation2.setIcon(AllIcons.Nodes.Project);
            presentation2.setPresentableText(this.toString());
            this.decorate(presentation2);
        }

        @Override
        @Nullable
        @NlsSafe
        String getLocation() {
            Project project2 = this.getProject();
            return project2 == null || project2.isDisposed() ? null : FileUtil.getLocationRelativeToUserHome(project2.getPresentableUrl());
        }

        @Override
        @NotNull
        Collection<AbstractTreeNode<?>> createChildren(@NotNull Collection<? extends AbstractTreeNode<?>> old) {
            if (old == null) {
                ProjectNode.$$$reportNull$$$0(3);
            }
            Map<Object, RootNode> oldRoots = this.roots;
            HashMap<Object, RootNode> newRoots = new HashMap<Object, RootNode>();
            Mapper<RootNode, ProjectFileNode> mapper = new Mapper<RootNode, ProjectFileNode>(RootNode::new, oldRoots);
            ScopeViewTreeModel.this.model.getChildren(ScopeViewTreeModel.this.model.getRoot()).forEach(child -> newRoots.put(child, (RootNode)((Object)((Object)mapper.apply(this, (ProjectFileNode)child)))));
            this.roots = newRoots;
            if (newRoots.isEmpty()) {
                List<AbstractTreeNode<?>> list2 = Collections.emptyList();
                if (list2 == null) {
                    ProjectNode.$$$reportNull$$$0(4);
                }
                return list2;
            }
            Collection<AbstractTreeNode<?>> collection = new Group(newRoots.values(), this.getSettings().isFlattenModules() || !ScopeViewTreeModel.hasModuleGroups(this.getProject())).createChildren(this, old);
            if (collection == null) {
                ProjectNode.$$$reportNull$$$0(5);
            }
            return collection;
        }

        @NotNull
        Collection<AbstractTreeNode<?>> createChildren(@NotNull Node parent2, @NotNull Collection<? extends AbstractTreeNode<?>> old) {
            if (parent2 == null) {
                ProjectNode.$$$reportNull$$$0(6);
            }
            if (old == null) {
                ProjectNode.$$$reportNull$$$0(7);
            }
            boolean flattenPackages = this.getSettings().isFlattenPackages();
            boolean hideEmptyMiddlePackages = this.getSettings().isHideEmptyMiddlePackages();
            boolean compactDirectories = this.getSettings().isCompactDirectories();
            Mapper<FileNode, ProjectFileNode> mapper = new Mapper<FileNode, ProjectFileNode>(FileNode::new, FileNode.class, old);
            SmartList children2 = new SmartList();
            SmartList files2 = new SmartList();
            TreeStructureProvider provider2 = this.provider;
            ScopeViewTreeModel.this.model.getChildren(parent2.getValue()).forEach(child -> {
                PsiFileSystemItem element = this.findFileSystemItem(child.getVirtualFile());
                if (element instanceof PsiDirectory) {
                    Icon icon2 = ProjectNode.getFolderIcon(element);
                    if (!ScopeViewTreeModel.isPackage(icon2) || !flattenPackages) {
                        ProjectFileNode childNext2;
                        ProjectFileNode projectFileNode = childNext2 = !compactDirectories ? null : this.getSingleDirectory((ProjectFileNode)child);
                        while (childNext2 != null) {
                            Icon iconNext = ProjectNode.getFolderIcon(this.findFileSystemItem(childNext2.getVirtualFile()));
                            if (icon2.equals(iconNext)) {
                                child = childNext2;
                                childNext2 = this.getSingleDirectory((ProjectFileNode)child);
                                continue;
                            }
                            if (ScopeViewTreeModel.isFolder(icon2) && !ScopeViewTreeModel.isPackage(iconNext)) {
                                icon2 = iconNext;
                                child = childNext2;
                                childNext2 = null;
                                continue;
                            }
                            childNext2 = null;
                        }
                        children2.add((AbstractTreeNode<?>)mapper.apply(parent2, (ProjectFileNode)child, icon2));
                    } else if (!ScopeViewTreeModel.isPackage(parent2.getIcon())) {
                        this.visitPackages((ProjectFileNode)child, hideEmptyMiddlePackages, childNext -> children2.add((AbstractTreeNode<?>)mapper.apply(parent2, (ProjectFileNode)childNext, AllIcons.Nodes.Package)));
                    }
                } else if (element instanceof PsiFile) {
                    if (provider2 == null) {
                        children2.add((AbstractTreeNode<?>)mapper.apply(parent2, (ProjectFileNode)child));
                    } else {
                        files2.add((PsiFile)element);
                    }
                }
            });
            if (provider2 == null) {
                SmartList smartList = children2;
                if (smartList == null) {
                    ProjectNode.$$$reportNull$$$0(8);
                }
                return smartList;
            }
            List<AbstractTreeNode> nodes2 = ContainerUtil.map(files2, file2 -> new PsiFileNode(this.getProject(), (PsiFile)file2, this.getSettings()));
            children2.addAll(provider2.modify((AbstractTreeNode)parent2, nodes2, this.getSettings()));
            SmartList smartList = children2;
            if (smartList == null) {
                ProjectNode.$$$reportNull$$$0(9);
            }
            return smartList;
        }

        private void visitPackages(@NotNull ProjectFileNode parent2, boolean hideEmptyMiddle, @NotNull Consumer<? super ProjectFileNode> consumer2) {
            if (parent2 == null) {
                ProjectNode.$$$reportNull$$$0(10);
            }
            if (consumer2 == null) {
                ProjectNode.$$$reportNull$$$0(11);
            }
            AtomicBoolean empty2 = new AtomicBoolean(hideEmptyMiddle);
            AtomicBoolean middle = new AtomicBoolean();
            ScopeViewTreeModel.this.model.getChildren((Object)parent2).forEach(child -> {
                PsiFileSystemItem element = this.findFileSystemItem(child.getVirtualFile());
                if (element instanceof PsiDirectory) {
                    Icon icon2 = ProjectNode.getFolderIcon(element);
                    if (ScopeViewTreeModel.isPackage(icon2)) {
                        if (hideEmptyMiddle) {
                            middle.set(true);
                        }
                        this.visitPackages((ProjectFileNode)child, hideEmptyMiddle, consumer2);
                    } else if (hideEmptyMiddle) {
                        empty2.set(false);
                    }
                } else if (element instanceof PsiFile && hideEmptyMiddle) {
                    empty2.set(false);
                }
            });
            if (!empty2.get() || !middle.get()) {
                consumer2.consume((ProjectFileNode)parent2);
            }
        }

        @Nullable
        private ProjectFileNode getSingleDirectory(ProjectFileNode parent2) {
            List children2 = ScopeViewTreeModel.this.model.getChildren((Object)parent2);
            ProjectFileNode child = children2.size() != 1 ? null : (ProjectFileNode)children2.get(0);
            return child != null && child.getVirtualFile().isDirectory() ? child : null;
        }

        @Override
        boolean contains(@NotNull VirtualFile file2, @NotNull AreaInstance area) {
            if (file2 == null) {
                ProjectNode.$$$reportNull$$$0(12);
            }
            if (area == null) {
                ProjectNode.$$$reportNull$$$0(13);
            }
            return ContainerUtil.exists(this.roots.values(), root -> root.canRepresentOrContain(file2, area));
        }

        @Override
        @NotNull
        public NodeSortOrder getSortOrder(@NotNull NodeSortSettings settings) {
            if (settings == null) {
                ProjectNode.$$$reportNull$$$0(14);
            }
            NodeSortOrder nodeSortOrder = NodeSortOrder.PROJECT_ROOT;
            if (nodeSortOrder == null) {
                ProjectNode.$$$reportNull$$$0(15);
            }
            return nodeSortOrder;
        }

        @NotNull
        public String toString() {
            Project project2 = this.getProject();
            String string2 = project2 == null || project2.isDisposed() ? "DISPOSED PROJECT" : project2.getName();
            if (string2 == null) {
                ProjectNode.$$$reportNull$$$0(16);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 8, 9, 15, 16 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "old";
                    break;
                }
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 15: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scopeView/ScopeViewTreeModel$ProjectNode";
                    break;
                }
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "area";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel$ProjectNode";
                    break;
                }
                case 4: 
                case 5: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createChildren";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSortOrder";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createChildren";
                    break;
                }
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 15: 
                case 16: {
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPackages";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "getSortOrder";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 4, 5, 8, 9, 15, 16 -> new IllegalStateException(string2);
            };
        }
    }

    private static final class GroupNode
    extends Node
    implements NavigatableWithText {
        @NlsSafe
        private final String prefix;
        @NlsSafe
        private final String name;
        private Group group;

        GroupNode(@NotNull Node parent2, @NotNull Object value) {
            if (parent2 == null) {
                GroupNode.$$$reportNull$$$0(0);
            }
            if (value == null) {
                GroupNode.$$$reportNull$$$0(1);
            }
            super(parent2, value);
            if (value instanceof Module) {
                List<String> list2 = ScopeViewTreeModel.getModuleNameAsList((Module)value, false);
                int index2 = list2.size() - 1;
                if (index2 > 0) {
                    StringBuilder sb = new StringBuilder();
                    for (int i2 = 0; i2 < index2; ++i2) {
                        sb.append(list2.get(i2)).append('/');
                    }
                    this.prefix = sb.toString();
                    this.name = list2.get(index2);
                } else {
                    this.prefix = null;
                    this.name = index2 < 0 ? "UNEXPECTED" : list2.get(index2);
                }
            } else {
                this.prefix = null;
                this.name = value.toString();
            }
        }

        void setGroup(@NotNull Group group2) {
            if (group2 == null) {
                GroupNode.$$$reportNull$$$0(2);
            }
            this.group = group2;
            this.childrenValid = false;
            this.setIcon(group2.getIcon());
        }

        @Nullable
        RootNode getSingleRoot() {
            Group group2 = this.group;
            return group2 == null ? null : group2.getSingleRoot();
        }

        @Override
        @Nullable
        public VirtualFile getVirtualFile() {
            RootNode node2 = this.getSingleRoot();
            return node2 == null ? null : node2.getVirtualFile();
        }

        protected void update(@NotNull PresentationData presentation2) {
            if (presentation2 == null) {
                GroupNode.$$$reportNull$$$0(3);
            }
            presentation2.setIcon(this.getIcon());
            if (this.prefix != null) {
                presentation2.addText(this.prefix, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            presentation2.addText(this.name, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            this.decorate(presentation2);
        }

        @Override
        @Nullable
        @NlsSafe
        String getLocation() {
            RootNode node2 = this.getSingleRoot();
            return node2 == null ? null : node2.getTitle();
        }

        @Override
        @NotNull
        Collection<AbstractTreeNode<?>> createChildren(@NotNull Collection<? extends AbstractTreeNode<?>> old) {
            Group group2;
            if (old == null) {
                GroupNode.$$$reportNull$$$0(4);
            }
            if ((group2 = this.group) == null) {
                List<AbstractTreeNode<?>> list2 = Collections.emptyList();
                if (list2 == null) {
                    GroupNode.$$$reportNull$$$0(5);
                }
                return list2;
            }
            RootNode node2 = group2.getSingleRoot();
            if (node2 == null) {
                Collection<AbstractTreeNode<?>> collection = group2.createChildren(this, old);
                if (collection == null) {
                    GroupNode.$$$reportNull$$$0(6);
                }
                return collection;
            }
            node2.setParent(this);
            Collection<AbstractTreeNode<?>> collection = node2.getChildren();
            if (collection == null) {
                GroupNode.$$$reportNull$$$0(7);
            }
            return collection;
        }

        @Override
        boolean contains(@NotNull VirtualFile file2, @NotNull AreaInstance area) {
            Group group2;
            if (file2 == null) {
                GroupNode.$$$reportNull$$$0(8);
            }
            if (area == null) {
                GroupNode.$$$reportNull$$$0(9);
            }
            return (group2 = this.group) != null && group2.contains(file2, area);
        }

        public boolean canNavigate() {
            Group group2 = this.group;
            RootNode node2 = group2 == null ? null : group2.getFirstRoot();
            return node2 != null && node2.canNavigate();
        }

        public void navigate(boolean requestFocus) {
            RootNode node2;
            Group group2 = this.group;
            RootNode rootNode = node2 = group2 == null ? null : group2.getFirstRoot();
            if (node2 != null) {
                node2.navigate(requestFocus);
            }
        }

        public String getNavigateActionText(boolean focusEditor) {
            return ActionsBundle.message((String)"action.ModuleSettings.navigate", (Object[])new Object[0]);
        }

        @Override
        @NotNull
        public NodeSortOrder getSortOrder(@NotNull NodeSortSettings settings) {
            if (settings == null) {
                GroupNode.$$$reportNull$$$0(10);
            }
            Group group2 = settings.isSortByType() ? this.group : null;
            NodeSortOrder nodeSortOrder = group2 == null || null == group2.getCommonRootID() ? NodeSortOrder.MODULE_GROUP : NodeSortOrder.MODULE_ROOT;
            if (nodeSortOrder == null) {
                GroupNode.$$$reportNull$$$0(11);
            }
            return nodeSortOrder;
        }

        public boolean equals(Object object) {
            return this == object;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }

        @NotNull
        public String toString() {
            Object object = this.prefix != null ? this.prefix + this.name : this.name;
            if (object == null) {
                GroupNode.$$$reportNull$$$0(12);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 7, 11, 12 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "old";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scopeView/ScopeViewTreeModel$GroupNode";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "area";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel$GroupNode";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createChildren";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSortOrder";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setGroup";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createChildren";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 11: 
                case 12: {
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getSortOrder";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 5, 6, 7, 11, 12 -> new IllegalStateException(string2);
            };
        }
    }

    private static final class RootNode
    extends FileNode
    implements NavigatableWithText {
        RootNode(@NotNull Node parent2, @NotNull ProjectFileNode node2) {
            if (parent2 == null) {
                RootNode.$$$reportNull$$$0(0);
            }
            if (node2 == null) {
                RootNode.$$$reportNull$$$0(1);
            }
            super(parent2, node2);
        }

        boolean canRepresentOrContain(@NotNull VirtualFile file2, @NotNull AreaInstance area) {
            if (file2 == null) {
                RootNode.$$$reportNull$$$0(2);
            }
            if (area == null) {
                RootNode.$$$reportNull$$$0(3);
            }
            return this.node.contains(file2, area, false);
        }

        @Override
        @NotNull
        public NodeSortOrder getSortOrder(@NotNull NodeSortSettings settings) {
            if (settings == null) {
                RootNode.$$$reportNull$$$0(4);
            }
            boolean scratch = null != ScratchFileService.getInstance().getRootType(this.getVirtualFile());
            NodeSortOrder nodeSortOrder = scratch ? NodeSortOrder.SCRATCH_ROOT : super.getSortOrder(settings);
            if (nodeSortOrder == null) {
                RootNode.$$$reportNull$$$0(5);
            }
            return nodeSortOrder;
        }

        @Override
        @NotNull
        public String getTitle() {
            return this.getLocation(false);
        }

        @Override
        @NotNull
        protected String getNodeName() {
            return this.getLocation(true);
        }

        @NotNull
        @NlsSafe
        private String getLocation(boolean allowEmpty) {
            String location2;
            VirtualFile dir = ProjectFileNode.findBaseDir((Project)this.getProject());
            String string2 = location2 = dir == null ? null : VfsUtilCore.getRelativePath(this.getVirtualFile(), dir);
            if (location2 != null && (allowEmpty || !location2.isEmpty())) {
                String string3 = location2;
                if (string3 == null) {
                    RootNode.$$$reportNull$$$0(6);
                }
                return string3;
            }
            String string4 = FileUtil.getLocationRelativeToUserHome(this.getVirtualFile().getPresentableUrl());
            if (string4 == null) {
                RootNode.$$$reportNull$$$0(7);
            }
            return string4;
        }

        public boolean canNavigate() {
            return null != ScopeViewTreeModel.getProjectSettingsService(this.getProject());
        }

        public void navigate(boolean requestFocus) {
            ProjectSettingsService service2 = ScopeViewTreeModel.getProjectSettingsService(this.getProject());
            if (service2 != null) {
                Module module2 = ScopeViewTreeModel.getModule(this.getVirtualFile(), this.getProject());
                if (module2 != null && service2.canOpenModuleSettings()) {
                    service2.openModuleSettings(module2);
                } else {
                    service2.openProjectSettings();
                }
            }
        }

        public String getNavigateActionText(boolean focusEditor) {
            return ActionsBundle.message((String)"action.ModuleSettings.navigate", (Object[])new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "area";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scopeView/ScopeViewTreeModel$RootNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel$RootNode";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSortOrder";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLocation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "canRepresentOrContain";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getSortOrder";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 5, 6, 7 -> new IllegalStateException(string2);
            };
        }
    }

    private static class FileNode
    extends Node {
        final List<VirtualFile> compacted;
        final ProjectFileNode node;

        FileNode(@NotNull Node parent2, @NotNull ProjectFileNode node2) {
            if (parent2 == null) {
                FileNode.$$$reportNull$$$0(0);
            }
            if (node2 == null) {
                FileNode.$$$reportNull$$$0(1);
            }
            super(parent2, node2);
            this.node = node2;
            this.compacted = ScopeViewTreeModel.getCompactedFolders(parent2.getVirtualFile(), node2.getVirtualFile());
            this.myName = node2.getVirtualFile().getName();
        }

        protected void update(@NotNull PresentationData presentation2) {
            ProjectFileIndex index2;
            if (presentation2 == null) {
                FileNode.$$$reportNull$$$0(2);
            }
            this.myName = this.getNodeName();
            Project project2 = this.getProject();
            VirtualFile file2 = this.getVirtualFile();
            String title = this.getTitle();
            SimpleTextAttributes attributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            if (this.node.getRootID() instanceof VirtualFile && (index2 = ScopeViewTreeModel.getProjectFileIndex(project2)) != null && file2.equals(index2.getContentRootForFile(file2))) {
                attributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            }
            String text2 = title != null ? title : this.toString();
            presentation2.setPresentableText(text2);
            presentation2.addText(text2, attributes);
            Icon icon2 = CompoundIconProvider.findIcon(this.findFileSystemItem(file2), 0);
            presentation2.setIcon(icon2 == null || project2 == null ? icon2 : AbstractPsiBasedNode.patchIcon(project2, icon2, file2));
            this.decorate(presentation2);
        }

        protected boolean valueIsCut() {
            return CopyPasteManager.getInstance().isCutElement((Object)this.findFileSystemItem(this.getVirtualFile()));
        }

        @Override
        @NotNull
        Collection<AbstractTreeNode<?>> createChildren(@NotNull Collection<? extends AbstractTreeNode<?>> old) {
            ProjectNode parent2;
            if (old == null) {
                FileNode.$$$reportNull$$$0(3);
            }
            if ((parent2 = this.findParent(ProjectNode.class)) == null) {
                List<AbstractTreeNode<?>> list2 = Collections.emptyList();
                if (list2 == null) {
                    FileNode.$$$reportNull$$$0(4);
                }
                return list2;
            }
            Collection<AbstractTreeNode<?>> collection = parent2.createChildren(this, old);
            if (collection == null) {
                FileNode.$$$reportNull$$$0(5);
            }
            return collection;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        boolean canRepresent(@NotNull VirtualFile file2) {
            if (file2 == null) {
                FileNode.$$$reportNull$$$0(6);
            }
            if (super.canRepresent(file2)) return true;
            if (this.compacted == null) return false;
            if (!ContainerUtil.exists(this.compacted, file2::equals)) return false;
            return true;
        }

        @Override
        boolean contains(@NotNull VirtualFile file2, @NotNull AreaInstance area) {
            if (file2 == null) {
                FileNode.$$$reportNull$$$0(7);
            }
            if (area == null) {
                FileNode.$$$reportNull$$$0(8);
            }
            return this.node.contains(file2, area, true);
        }

        public FileStatus getFileStatus() {
            FileStatusManager manager = ScopeViewTreeModel.getFileStatusManager(this.getProject());
            return manager == null ? FileStatus.NOT_CHANGED : manager.getRecursiveStatus(this.getVirtualFile());
        }

        @Override
        @NotNull
        public VirtualFile getVirtualFile() {
            VirtualFile virtualFile2 = this.node.getVirtualFile();
            if (virtualFile2 == null) {
                FileNode.$$$reportNull$$$0(9);
            }
            return virtualFile2;
        }

        @Override
        @NotNull
        public NodeSortOrder getSortOrder(@NotNull NodeSortSettings settings) {
            if (settings == null) {
                FileNode.$$$reportNull$$$0(10);
            }
            if (this.getVirtualFile().isDirectory()) {
                if (settings.isSortByType() && ScopeViewTreeModel.isPackage(this.getIcon())) {
                    NodeSortOrder nodeSortOrder = NodeSortOrder.PACKAGE;
                    if (nodeSortOrder == null) {
                        FileNode.$$$reportNull$$$0(11);
                    }
                    return nodeSortOrder;
                }
                if (settings.isSortByType() || settings.isFoldersAlwaysOnTop()) {
                    NodeSortOrder nodeSortOrder = NodeSortOrder.FOLDER;
                    if (nodeSortOrder == null) {
                        FileNode.$$$reportNull$$$0(12);
                    }
                    return nodeSortOrder;
                }
            }
            NodeSortOrder nodeSortOrder = super.getSortOrder(settings);
            if (nodeSortOrder == null) {
                FileNode.$$$reportNull$$$0(13);
            }
            return nodeSortOrder;
        }

        @Override
        @Nullable
        public Comparable<PsiFileNode.ExtensionSortKey> getTypeSortKey() {
            String extension2 = this.getVirtualFile().getExtension();
            return extension2 == null ? null : new PsiFileNode.ExtensionSortKey(extension2);
        }

        public int getWeight() {
            return 20;
        }

        @NotNull
        protected String getNodeName() {
            return this.getNodeName(this.getPackageName());
        }

        @NotNull
        private String getNodeName(@Nullable String name) {
            if (name != null) {
                String prefix;
                AbstractTreeNode parent2 = this.getParent();
                FileNode node2 = parent2 instanceof FileNode ? (FileNode)parent2 : null;
                String string2 = prefix = node2 == null ? null : node2.getPackageName();
                if (prefix == null) {
                    String string3 = name;
                    if (string3 == null) {
                        FileNode.$$$reportNull$$$0(14);
                    }
                    return string3;
                }
                int length = prefix.length();
                if (length > 0 && name.startsWith(prefix)) {
                    if (length < name.length() && '.' == name.charAt(length)) {
                        ++length;
                    }
                    if (length < name.length()) {
                        String string4 = name.substring(length);
                        if (string4 == null) {
                            FileNode.$$$reportNull$$$0(15);
                        }
                        return string4;
                    }
                }
                LOG.info("unexpected prefix: " + prefix + " for package: " + name);
            }
            if (this.compacted != null) {
                StringBuilder sb = new StringBuilder();
                char separator = ScopeViewTreeModel.isPackage(this.getIcon()) ? (char)'.' : '/';
                this.compacted.forEach(file2 -> sb.append(file2.getName()).append(separator));
                String string5 = sb.append(this.getVirtualFile().getName()).toString();
                if (string5 == null) {
                    FileNode.$$$reportNull$$$0(16);
                }
                return string5;
            }
            String string6 = this.getVirtualFile().getName();
            if (string6 == null) {
                FileNode.$$$reportNull$$$0(17);
            }
            return string6;
        }

        @Nullable
        private String getPackageName() {
            String name;
            PsiDirectoryFactory factory2;
            PsiFileSystemItem element;
            PsiFileSystemItem psiFileSystemItem = element = !ScopeViewTreeModel.isPackage(this.getIcon()) ? null : this.findFileSystemItem(this.getVirtualFile());
            if (element instanceof PsiDirectory && element.isValid() && (factory2 = PsiDirectoryFactory.getInstance(element.getProject())) != null && factory2.isPackage((PsiDirectory)element) && factory2.isValidPackageName(name = factory2.getQualifiedName((PsiDirectory)element, false))) {
                return name;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 9, 11, 12, 13, 14, 15, 16, 17 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "old";
                    break;
                }
                case 4: 
                case 5: 
                case 9: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scopeView/ScopeViewTreeModel$FileNode";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "area";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel$FileNode";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createChildren";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVirtualFile";
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSortOrder";
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodeName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createChildren";
                    break;
                }
                case 4: 
                case 5: 
                case 9: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "canRepresent";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getSortOrder";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 4, 5, 9, 11, 12, 13, 14, 15, 16, 17 -> new IllegalStateException(string2);
            };
        }
    }

    private static abstract class Node
    extends ProjectViewNode<Object> {
        volatile NamedScopeFilter filter;
        volatile Collection<AbstractTreeNode<?>> children;
        volatile boolean childrenValid;

        Node(@NotNull Project project2, @NotNull Object value, @NotNull ViewSettings settings) {
            if (project2 == null) {
                Node.$$$reportNull$$$0(0);
            }
            if (value == null) {
                Node.$$$reportNull$$$0(1);
            }
            if (settings == null) {
                Node.$$$reportNull$$$0(2);
            }
            super(project2, value, settings);
            this.children = Collections.emptyList();
        }

        Node(@NotNull Node parent2, @NotNull Object value) {
            if (parent2 == null) {
                Node.$$$reportNull$$$0(3);
            }
            if (value == null) {
                Node.$$$reportNull$$$0(4);
            }
            super(parent2.getProject(), value, parent2.getSettings());
            this.children = Collections.emptyList();
            this.setParent(parent2);
        }

        public final boolean canRepresent(Object element) {
            if (element instanceof PsiFileSystemItem) {
                PsiFileSystemItem item = (PsiFileSystemItem)element;
                element = item.getVirtualFile();
            }
            return element instanceof VirtualFile && this.canRepresent((VirtualFile)element);
        }

        boolean canRepresent(@NotNull VirtualFile file2) {
            if (file2 == null) {
                Node.$$$reportNull$$$0(5);
            }
            return file2.equals(this.getVirtualFile());
        }

        @Override
        public final boolean contains(@NotNull VirtualFile file2) {
            AreaInstance area;
            if (file2 == null) {
                Node.$$$reportNull$$$0(6);
            }
            return (area = ProjectFileNode.findArea((VirtualFile)file2, (Project)this.getProject())) != null && this.contains(file2, area);
        }

        @Override
        protected boolean hasProblemFileBeneath() {
            WolfTheProblemSolver solver = ScopeViewTreeModel.getWolfTheProblemSolver(this.getProject());
            return solver == null || solver.hasProblemFilesBeneath(this::contains);
        }

        abstract boolean contains(@NotNull VirtualFile var1, @NotNull AreaInstance var2);

        public Color getFileStatusColor(@NotNull FileStatus status) {
            if (status == null) {
                Node.$$$reportNull$$$0(7);
            }
            return status.getColor();
        }

        @NotNull
        abstract Collection<AbstractTreeNode<?>> createChildren(@NotNull Collection<? extends AbstractTreeNode<?>> var1);

        @NotNull
        public final Collection<AbstractTreeNode<?>> getChildren() {
            if (this.childrenValid) {
                Collection<AbstractTreeNode<?>> collection = this.children;
                if (collection == null) {
                    Node.$$$reportNull$$$0(8);
                }
                return collection;
            }
            Collection<AbstractTreeNode<?>> oldChildren = this.children;
            Collection<AbstractTreeNode<?>> newChildren = this.createChildren(oldChildren);
            oldChildren.forEach(node2 -> node2.setParent(null));
            newChildren.forEach(node2 -> node2.setParent((AbstractTreeNode)this));
            this.children = newChildren;
            this.childrenValid = true;
            Collection<AbstractTreeNode<?>> collection = newChildren;
            if (collection == null) {
                Node.$$$reportNull$$$0(9);
            }
            return collection;
        }

        @Nullable
        @NlsSafe
        String getLocation() {
            return null;
        }

        final void decorate(@NotNull PresentationData presentation2) {
            ProjectNode parent2;
            ProjectViewNodeDecorator decorator;
            String location2;
            if (presentation2 == null) {
                Node.$$$reportNull$$$0(10);
            }
            if ((location2 = this.getLocation()) != null) {
                if (this.getSettings().isShowURL()) {
                    presentation2.setLocationString(location2);
                } else {
                    presentation2.setTooltip(location2);
                }
            }
            ProjectViewNodeDecorator projectViewNodeDecorator = decorator = (parent2 = this.findParent(ProjectNode.class)) == null ? null : parent2.decorator;
            if (decorator != null) {
                decorator.decorate(this, presentation2);
            }
        }

        @NotNull
        static Icon getFolderIcon(@Nullable PsiElement element) {
            Icon icon2 = CompoundIconProvider.findIcon(element, 0);
            Icon icon3 = icon2 != null ? icon2 : AllIcons.Nodes.Folder;
            if (icon3 == null) {
                Node.$$$reportNull$$$0(11);
            }
            return icon3;
        }

        @Nullable
        final PsiFileSystemItem findFileSystemItem(@NotNull VirtualFile file2) {
            if (file2 == null) {
                Node.$$$reportNull$$$0(12);
            }
            return PsiUtilCore.findFileSystemItem(this.getProject(), file2);
        }

        final <N> N findParent(Class<N> type) {
            for (Node node2 = this; node2 != null; node2 = node2.getParent()) {
                if (!type.isInstance((Object)node2)) continue;
                return type.cast((Object)node2);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8, 9, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 5: 
                case 6: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "status";
                    break;
                }
                case 8: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scopeView/ScopeViewTreeModel$Node";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel$Node";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFolderIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "canRepresent";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getFileStatusColor";
                    break;
                }
                case 8: 
                case 9: 
                case 11: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "decorate";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "findFileSystemItem";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 8, 9, 11 -> new IllegalStateException(string2);
            };
        }
    }

    private static final class Mapper<N extends Node, V> {
        private final Map<Object, N> map;
        private final BiFunction<? super Node, ? super V, ? extends N> creator;

        Mapper(@NotNull BiFunction<? super Node, ? super V, ? extends N> creator, @NotNull Map<Object, N> map2) {
            if (creator == null) {
                Mapper.$$$reportNull$$$0(0);
            }
            if (map2 == null) {
                Mapper.$$$reportNull$$$0(1);
            }
            this.creator = creator;
            this.map = map2;
        }

        Mapper(@NotNull BiFunction<? super Node, ? super V, ? extends N> creator, @NotNull Class<? extends N> type, @NotNull Collection<? extends AbstractTreeNode<?>> list2) {
            if (creator == null) {
                Mapper.$$$reportNull$$$0(2);
            }
            if (type == null) {
                Mapper.$$$reportNull$$$0(3);
            }
            if (list2 == null) {
                Mapper.$$$reportNull$$$0(4);
            }
            this(creator, new HashMap());
            list2.forEach(node2 -> {
                Object id = node2.getValue();
                if (id != null && type.isInstance(node2)) {
                    this.map.put(id, (N)((Object)((Node)((Object)((Object)type.cast(node2))))));
                }
            });
        }

        @NotNull
        N apply(@NotNull Node parent2, @NotNull V value) {
            if (parent2 == null) {
                Mapper.$$$reportNull$$$0(5);
            }
            if (value == null) {
                Mapper.$$$reportNull$$$0(6);
            }
            N n = this.apply(parent2, value, null);
            if (n == null) {
                Mapper.$$$reportNull$$$0(7);
            }
            return n;
        }

        @NotNull
        N apply(@NotNull Node parent2, @NotNull V value, @Nullable Icon icon2) {
            Node node2;
            if (parent2 == null) {
                Mapper.$$$reportNull$$$0(8);
            }
            if (value == null) {
                Mapper.$$$reportNull$$$0(9);
            }
            Node node3 = node2 = this.map.isEmpty() ? null : (Node)((Object)this.map.get(value));
            if (node2 == null) {
                node2 = (Node)((Object)this.creator.apply(parent2, value));
            }
            node2.setIcon(icon2);
            node2.childrenValid = false;
            Node node4 = node2;
            if (node4 == null) {
                Mapper.$$$reportNull$$$0(10);
            }
            return (N)((Object)node4);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "creator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scopeView/ScopeViewTreeModel$Mapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel$Mapper";
                    break;
                }
                case 7: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "apply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 7: 
                case 10: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 7, 10 -> new IllegalStateException(string2);
            };
        }
    }

    private static final class Group {
        private final Object id;
        private final HashMap<Object, Group> groups;
        private final List<RootNode> roots;

        private Group(@NotNull String name) {
            if (name == null) {
                Group.$$$reportNull$$$0(0);
            }
            this.groups = new HashMap();
            this.roots = new SmartList<RootNode>();
            this.id = name;
        }

        private Group(@NotNull Module module2) {
            if (module2 == null) {
                Group.$$$reportNull$$$0(1);
            }
            this.groups = new HashMap();
            this.roots = new SmartList<RootNode>();
            this.id = module2;
        }

        Group(@NotNull Collection<RootNode> nodes2, boolean flatten) {
            if (nodes2 == null) {
                Group.$$$reportNull$$$0(2);
            }
            this.groups = new HashMap();
            this.roots = new SmartList<RootNode>();
            this.id = null;
            if (!nodes2.isEmpty()) {
                HashMap<Module, Group> map2 = new HashMap<Module, Group>();
                nodes2.forEach(node2 -> {
                    Object id = node2.node.getRootID();
                    if (id instanceof Module) {
                        Module module2 = (Module)id;
                        Group group2 = (Group)map2.get(module2);
                        if (group2 == null) {
                            group2 = new Group(module2);
                            map2.put(module2, group2);
                        }
                        group2.roots.add((RootNode)((Object)node2));
                    } else {
                        this.roots.add((RootNode)((Object)node2));
                    }
                });
                if (flatten) {
                    this.groups.putAll(map2);
                } else {
                    map2.forEach((module2, group2) -> {
                        List<String> path2 = ScopeViewTreeModel.getModuleNameAsList(module2, Registry.is("project.qualified.module.names"));
                        group2.roots.forEach(node2 -> this.add((RootNode)((Object)((Object)node2)), path2, 0));
                    });
                }
            }
        }

        private void add(RootNode node2, List<String> path2, int index2) {
            if (index2 < path2.size()) {
                String name = path2.get(index2);
                Group group2 = this.groups.get(name);
                if (group2 == null) {
                    group2 = new Group(name);
                    this.groups.put(name, group2);
                }
                group2.add(node2, path2, index2 + 1);
            } else {
                this.roots.add(node2);
            }
        }

        @Nullable
        Object getCommonRootID() {
            if (!this.groups.isEmpty() || this.roots.isEmpty()) {
                return null;
            }
            Object id = this.roots.get((int)0).node.getRootID();
            return ContainerUtil.and(this.roots, root -> root.node.getRootID().equals(id)) ? id : null;
        }

        @NotNull
        Icon getIcon() {
            Object id = this.getCommonRootID();
            if (id == null) {
                Icon icon2 = AllIcons.Nodes.ModuleGroup;
                if (icon2 == null) {
                    Group.$$$reportNull$$$0(3);
                }
                return icon2;
            }
            if (id instanceof Module) {
                Icon icon3 = ModuleType.get((Module)((Module)id)).getIcon();
                if (icon3 == null) {
                    Group.$$$reportNull$$$0(4);
                }
                return icon3;
            }
            Icon icon4 = AllIcons.Nodes.Module;
            if (icon4 == null) {
                Group.$$$reportNull$$$0(5);
            }
            return icon4;
        }

        @Nullable
        RootNode getFirstRoot() {
            if (!this.roots.isEmpty()) {
                return this.roots.get(0);
            }
            for (Group group2 : this.groups.values()) {
                RootNode root = group2.getFirstRoot();
                if (root == null) continue;
                return root;
            }
            return null;
        }

        @Nullable
        RootNode getSingleRoot() {
            if (!this.groups.isEmpty() || this.roots.size() != 1) {
                return null;
            }
            RootNode node2 = this.roots.get(0);
            ModuleRootManager manager = ScopeViewTreeModel.getModuleRootManager(ScopeViewTreeModel.getModule(node2.getVirtualFile(), node2.getProject()));
            if (manager == null) {
                return null;
            }
            for (VirtualFile file2 : manager.getSourceRoots()) {
                if (VfsUtilCore.isAncestor(node2.getVirtualFile(), file2, true)) continue;
                return null;
            }
            return node2;
        }

        @Nullable
        private Group getSingleGroup() {
            if (!this.roots.isEmpty() || this.groups.size() != 1) {
                return null;
            }
            return this.groups.values().stream().findFirst().orElse(null);
        }

        @NotNull
        Collection<AbstractTreeNode<?>> createChildren(@NotNull Node parent2, @NotNull Collection<? extends AbstractTreeNode<?>> old) {
            if (parent2 == null) {
                Group.$$$reportNull$$$0(6);
            }
            if (old == null) {
                Group.$$$reportNull$$$0(7);
            }
            Mapper<GroupNode, Object> mapper = new Mapper<GroupNode, Object>(GroupNode::new, GroupNode.class, old);
            ModuleManager manager = ScopeViewTreeModel.getModuleManager(parent2.getProject());
            char separator = manager != null && manager.hasModuleGroups() ? (char)'/' : '.';
            boolean compactDirectories = parent2.getSettings().isCompactDirectories();
            SmartList children2 = new SmartList();
            for (Group group2 : this.groups.values()) {
                Group single2;
                Object id = group2.id;
                Group group3 = single2 = !compactDirectories ? null : group2.getSingleGroup();
                if (single2 != null) {
                    StringBuilder sb = new StringBuilder(id.toString());
                    do {
                        group2 = single2;
                        sb.append(separator).append(group2.id);
                    } while ((single2 = single2.getSingleGroup()) != null);
                    id = sb.toString();
                }
                GroupNode node2 = mapper.apply(parent2, id);
                node2.setGroup(group2);
                children2.add(node2);
            }
            children2.addAll(this.roots);
            SmartList smartList = children2;
            if (smartList == null) {
                Group.$$$reportNull$$$0(8);
            }
            return smartList;
        }

        boolean contains(@NotNull VirtualFile file2, @NotNull AreaInstance area) {
            if (file2 == null) {
                Group.$$$reportNull$$$0(9);
            }
            if (area == null) {
                Group.$$$reportNull$$$0(10);
            }
            return ContainerUtil.exists(this.roots, root -> root.canRepresentOrContain(file2, area)) || ContainerUtil.exists(this.groups.values(), group2 -> group2.contains(file2, area));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scopeView/ScopeViewTreeModel$Group";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "old";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "area";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel$Group";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createChildren";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3, 4, 5, 8 -> new IllegalStateException(string2);
            };
        }
    }
}

