/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RootType {
    public static final ExtensionPointName<RootType> ROOT_EP = new ExtensionPointName("com.intellij.scratch.rootType");
    private final String myId;
    @Nls
    private final String myDisplayName;

    @NotNull
    public static List<RootType> getAllRootTypes() {
        List<RootType> list2 = ROOT_EP.getExtensionList();
        if (list2 == null) {
            RootType.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @NotNull
    public static RootType findById(@NotNull String id) {
        if (id == null) {
            RootType.$$$reportNull$$$0(1);
        }
        for (RootType type : RootType.getAllRootTypes()) {
            if (!id.equals(type.getId())) continue;
            RootType rootType = type;
            if (rootType == null) {
                RootType.$$$reportNull$$$0(2);
            }
            return rootType;
        }
        throw new AssertionError((Object)id);
    }

    @NotNull
    public static <T extends RootType> T findByClass(@NotNull Class<T> aClass) {
        if (aClass == null) {
            RootType.$$$reportNull$$$0(3);
        }
        RootType rootType = (RootType)ROOT_EP.findExtensionOrFail(aClass);
        if (rootType == null) {
            RootType.$$$reportNull$$$0(4);
        }
        return (T)rootType;
    }

    @Nullable
    public static RootType forFile(@Nullable VirtualFile file2) {
        return ScratchFileService.findRootType(file2);
    }

    protected RootType(@NonNls @NotNull String id, @Nullable @Nls(capitalization=Nls.Capitalization.Title) String displayName) {
        if (id == null) {
            RootType.$$$reportNull$$$0(5);
        }
        this.myId = id;
        this.myDisplayName = displayName;
    }

    @NotNull
    public final String getId() {
        String string2 = this.myId;
        if (string2 == null) {
            RootType.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @Nullable
    @Nls(capitalization=Nls.Capitalization.Title)
    public final String getDisplayName() {
        return this.myDisplayName;
    }

    public boolean isHidden() {
        return StringUtil.isEmpty(this.myDisplayName);
    }

    public boolean containsFile(@Nullable VirtualFile file2) {
        return ScratchFileService.findRootType(file2) == this;
    }

    @Nullable
    public Language substituteLanguage(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            RootType.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            RootType.$$$reportNull$$$0(8);
        }
        return null;
    }

    @Nullable
    public Icon substituteIcon(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            RootType.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            RootType.$$$reportNull$$$0(10);
        }
        if (file2.isDirectory()) {
            return null;
        }
        Language language = this.substituteLanguage(project2, file2);
        FileType fileType = LanguageUtil.getLanguageFileType(language);
        if (fileType == null) {
            String extension2 = file2.getExtension();
            fileType = extension2 == null ? null : FileTypeRegistry.getInstance().getFileTypeByFileName(file2.getNameSequence());
        }
        return fileType != null && fileType != UnknownFileType.INSTANCE ? fileType.getIcon() : null;
    }

    @Nullable
    @NlsSafe
    public String substituteName(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            RootType.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            RootType.$$$reportNull$$$0(12);
        }
        return null;
    }

    public VirtualFile findFile(@Nullable Project project2, @NotNull String pathName, ScratchFileService.Option option) throws IOException {
        if (pathName == null) {
            RootType.$$$reportNull$$$0(13);
        }
        return ScratchFileService.getInstance().findFile(this, pathName, option);
    }

    public void fileOpened(@NotNull VirtualFile file2, @NotNull FileEditorManager source) {
        if (file2 == null) {
            RootType.$$$reportNull$$$0(14);
        }
        if (source == null) {
            RootType.$$$reportNull$$$0(15);
        }
    }

    public boolean isIgnored(@NotNull Project project2, @NotNull VirtualFile element) {
        if (project2 == null) {
            RootType.$$$reportNull$$$0(16);
        }
        if (element == null) {
            RootType.$$$reportNull$$$0(17);
        }
        return false;
    }

    public void registerTreeUpdater(@NotNull Project project2, @NotNull Disposable disposable, @NotNull Runnable onUpdate) {
        if (project2 == null) {
            RootType.$$$reportNull$$$0(18);
        }
        if (disposable == null) {
            RootType.$$$reportNull$$$0(19);
        }
        if (onUpdate == null) {
            RootType.$$$reportNull$$$0(20);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scratch/RootType";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onUpdate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRootTypes";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scratch/RootType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findById";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findByClass";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findById";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findByClass";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "substituteLanguage";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "substituteIcon";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "substituteName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fileOpened";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "registerTreeUpdater";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 3, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20 -> new IllegalArgumentException(string2);
        };
    }
}

