/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.scratch.RootType;
import com.intellij.lang.Language;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CachedSingletonsRegistry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ScratchFileService {
    private static final Supplier<ScratchFileService> ourInstance = CachedSingletonsRegistry.lazy(() -> ApplicationManager.getApplication().getService(ScratchFileService.class));

    public static ScratchFileService getInstance() {
        return ourInstance.get();
    }

    @NotNull
    public abstract String getRootPath(@NotNull RootType var1);

    @Nullable
    public abstract RootType getRootType(@Nullable VirtualFile var1);

    public abstract VirtualFile findFile(@NotNull RootType var1, @NotNull String var2, @NotNull Option var3) throws IOException;

    @NotNull
    public abstract PerFileMappings<Language> getScratchesMapping();

    @Nullable
    public static RootType findRootType(@Nullable VirtualFile file2) {
        if (file2 == null || !file2.isInLocalFileSystem()) {
            return null;
        }
        VirtualFile parent2 = file2.isDirectory() ? file2 : file2.getParent();
        return ScratchFileService.getInstance().getRootType(parent2);
    }

    @NotNull
    public static Set<VirtualFile> getAllRootPaths() {
        ScratchFileService instance2 = ScratchFileService.getInstance();
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        Set<VirtualFile> result2 = CollectionFactory.createSmallMemoryFootprintSet();
        for (RootType rootType : RootType.getAllRootTypes()) {
            if (rootType.isHidden()) continue;
            ContainerUtil.addIfNotNull(result2, fileSystem.findFileByPath(instance2.getRootPath(rootType)));
        }
        Set<VirtualFile> set2 = result2;
        if (set2 == null) {
            ScratchFileService.$$$reportNull$$$0(0);
        }
        return set2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchFileService", "getAllRootPaths"));
    }

    public static enum Option {
        existing_only,
        create_if_missing,
        create_new_always;

    }
}

