/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.icons.AllIcons;
import com.intellij.ide.scratch.LRUPopupBuilder;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.WildcardFileNameMatcher;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.terminal.TerminalUtils;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.awt.Component;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ScratchImplUtil {
    private ScratchImplUtil() {
    }

    public static void updateFileExtension(@NotNull Project project2, @Nullable VirtualFile file2, @NotNull LanguageItem item) throws IOException {
        FileType currType;
        if (project2 == null) {
            ScratchImplUtil.$$$reportNull$$$0(0);
        }
        if (item == null) {
            ScratchImplUtil.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (CommandProcessor.getInstance().getCurrentCommand() == null) {
            throw new AssertionError((Object)"command required");
        }
        if (file2 == null) {
            return;
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        FileType prevType = ScratchImplUtil.getFileTypeFromName(file2.getName(), fileTypeManager);
        Language currLanguage = LanguageUtil.getLanguageForPsi(project2, file2, item.fileType);
        FileType fileType = currType = currLanguage == null ? item.fileType : ObjectUtils.notNull(currLanguage.getAssociatedFileType(), item.fileType);
        if (prevType == currType) {
            return;
        }
        String nameWithoutExtension = ScratchImplUtil.getNameWithoutExtension(file2, fileTypeManager);
        VirtualFile parent2 = file2.getParent();
        String newName2 = parent2 != null ? VfsUtil.getNextAvailableName(parent2, nameWithoutExtension, item.fileExtension) : PathUtil.makeFileName(nameWithoutExtension, item.fileExtension);
        file2.rename(ScratchImplUtil.class, newName2);
    }

    @NotNull
    private static String getNameWithoutExtension(@NotNull VirtualFile file2, @NotNull FileTypeManager fileTypeManager) {
        if (file2 == null) {
            ScratchImplUtil.$$$reportNull$$$0(2);
        }
        if (fileTypeManager == null) {
            ScratchImplUtil.$$$reportNull$$$0(3);
        }
        return ScratchImplUtil.getNameWithoutExtension(file2.getName(), file2.isCaseSensitive(), fileTypeManager);
    }

    @NotNull
    private static String getNameWithoutExtension(@NotNull String fileName, boolean caseSensitive, @NotNull FileTypeManager fileTypeManager) {
        String extension2;
        if (fileName == null) {
            ScratchImplUtil.$$$reportNull$$$0(4);
        }
        if (fileTypeManager == null) {
            ScratchImplUtil.$$$reportNull$$$0(5);
        }
        if ((extension2 = StringUtil.notNullize(PathUtilRt.getFileExtension(fileName))).isEmpty()) {
            String string2 = fileName;
            if (string2 == null) {
                ScratchImplUtil.$$$reportNull$$$0(6);
            }
            return string2;
        }
        FileType fileType = fileTypeManager.getFileTypeByFileName(fileName);
        if (fileType != FileTypes.UNKNOWN) {
            extension2 = ScratchImplUtil.getFileTypeExtensions(fileType, false, fileTypeManager).reduce(extension2, (val, o) -> val.length() < o.length() && ScratchImplUtil.hasExtension(fileName, o, caseSensitive) ? o : val);
        }
        String string3 = fileName.substring(0, fileName.length() - extension2.length() - 1);
        if (string3 == null) {
            ScratchImplUtil.$$$reportNull$$$0(7);
        }
        return string3;
    }

    public static boolean hasMatchingExtension(@NotNull Project project2, @NotNull VirtualFile file2) {
        LanguageFileType actual;
        String fileName;
        if (project2 == null) {
            ScratchImplUtil.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            ScratchImplUtil.$$$reportNull$$$0(9);
        }
        if (PathUtilRt.getFileExtension(fileName = file2.getName()) == null) {
            return false;
        }
        boolean caseSensitive = file2.isCaseSensitive();
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        FileType expected = ScratchImplUtil.getFileTypeFromName(fileName, fileTypeManager);
        Language language = LanguageUtil.getLanguageForPsi(project2, file2);
        LanguageFileType languageFileType = actual = language == null ? null : language.getAssociatedFileType();
        if (actual == null) {
            return expected != null;
        }
        if (expected == actual) {
            return true;
        }
        return ScratchImplUtil.getFileTypeExtensions(actual, false, fileTypeManager).filter(o -> ScratchImplUtil.hasExtension(fileName, o, caseSensitive)).isNotEmpty();
    }

    private static boolean hasExtension(@NotNull String fileName, @NotNull String extension2, boolean caseSensitive) {
        if (fileName == null) {
            ScratchImplUtil.$$$reportNull$$$0(10);
        }
        if (extension2 == null) {
            ScratchImplUtil.$$$reportNull$$$0(11);
        }
        if (fileName.length() < extension2.length() + 1) {
            return false;
        }
        if (fileName.charAt(fileName.length() - extension2.length() - 1) != '.') {
            return false;
        }
        return StringUtilRt.equal(fileName.subSequence(fileName.length() - extension2.length(), fileName.length()), extension2, caseSensitive);
    }

    @Nullable
    static FileType getFileTypeFromName(@NotNull String fileName, @NotNull FileTypeManager fileTypeManager) {
        if (fileName == null) {
            ScratchImplUtil.$$$reportNull$$$0(12);
        }
        if (fileTypeManager == null) {
            ScratchImplUtil.$$$reportNull$$$0(13);
        }
        if (PathUtilRt.getFileExtension(fileName) == null) {
            return null;
        }
        FileType result2 = fileTypeManager.getFileTypeByFileName(fileName);
        if (result2 == UnknownFileType.INSTANCE || ScratchImplUtil.getFileTypeExtensions(result2, false, fileTypeManager).isEmpty()) {
            return null;
        }
        return result2;
    }

    @NotNull
    static JBIterable<String> getFileTypeExtensions(@NotNull FileType fileType, boolean sort2, @NotNull FileTypeManager fileTypeManager) {
        if (fileType == null) {
            ScratchImplUtil.$$$reportNull$$$0(14);
        }
        if (fileTypeManager == null) {
            ScratchImplUtil.$$$reportNull$$$0(15);
        }
        JBIterable<String> result2 = JBIterable.from(fileTypeManager.getAssociations(fileType)).filterMap(o -> {
            String pattern;
            if (o instanceof ExtensionFileNameMatcher) {
                return StringUtil.nullize(((ExtensionFileNameMatcher)o).getExtension());
            }
            if (o instanceof WildcardFileNameMatcher && (pattern = ((WildcardFileNameMatcher)o).getPattern()).startsWith("*.") && pattern.indexOf(42, 1) < 0 && pattern.indexOf(63, 1) < 0) {
                return StringUtil.nullize(pattern.substring(2));
            }
            return null;
        });
        if (sort2) {
            String def = fileType.getDefaultExtension();
            JBIterable<String> jBIterable = result2.sort((o1, o2) -> o1.equals(o2) ? 0 : (o1.equals(def) ? -1 : (o2.equals(def) ? 1 : Integer.compare(o1.length(), o2.length()))));
            if (jBIterable == null) {
                ScratchImplUtil.$$$reportNull$$$0(16);
            }
            return jBIterable;
        }
        JBIterable<String> jBIterable = result2;
        if (jBIterable == null) {
            ScratchImplUtil.$$$reportNull$$$0(17);
        }
        return jBIterable;
    }

    @Nullable
    static VirtualFile findFileIgnoreExtension(@NotNull VirtualFile dir, @NotNull String fileNameAndExt) {
        if (dir == null) {
            ScratchImplUtil.$$$reportNull$$$0(18);
        }
        if (fileNameAndExt == null) {
            ScratchImplUtil.$$$reportNull$$$0(19);
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        String fileName = ScratchImplUtil.getNameWithoutExtension(fileNameAndExt, dir.isCaseSensitive(), fileTypeManager);
        for (VirtualFile child : dir.getChildren()) {
            String childName;
            if (child.isDirectory() || !StringUtil.equalsIgnoreCase(childName = ScratchImplUtil.getNameWithoutExtension(child, fileTypeManager), fileName)) continue;
            return child;
        }
        return null;
    }

    @NotNull
    static String getNextAvailableName(@NotNull VirtualFile dir, @NotNull String fileNameAndExt) {
        if (dir == null) {
            ScratchImplUtil.$$$reportNull$$$0(20);
        }
        if (fileNameAndExt == null) {
            ScratchImplUtil.$$$reportNull$$$0(21);
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        IntOpenHashSet existing = new IntOpenHashSet();
        String fileName = ScratchImplUtil.getNameWithoutExtension(fileNameAndExt, dir.isCaseSensitive(), fileTypeManager);
        int fileNameLen = fileName.length();
        String fileExt = fileNameAndExt.length() > fileNameLen + 1 ? fileNameAndExt.substring(fileNameLen + 1) : "";
        for (VirtualFile child : dir.getChildren()) {
            int val;
            String childName;
            if (child.isDirectory() || !StringUtil.startsWithIgnoreCase(childName = ScratchImplUtil.getNameWithoutExtension(child, fileTypeManager), fileName)) continue;
            if (childName.length() == fileNameLen) {
                existing.add(0);
                continue;
            }
            if (childName.length() <= fileNameLen + 1 || childName.charAt(fileNameLen) != '_' || (val = StringUtil.parseInt(childName.substring(fileNameLen + 1), -1)) <= -1) continue;
            existing.add(val);
        }
        int num = 0;
        while (existing.contains(num)) {
            ++num;
        }
        String string2 = PathUtil.makeFileName((String)(num == 0 ? fileName : fileName + "_" + num), fileExt);
        if (string2 == null) {
            ScratchImplUtil.$$$reportNull$$$0(22);
        }
        return string2;
    }

    static void changeLanguageWithUndo(@NotNull Project project2, final @NotNull LanguageItem item, final VirtualFile @NotNull [] sortedFiles, final @NotNull PerFileMappings<Language> mappings) throws UnexpectedUndoException {
        ReadonlyStatusHandler.OperationStatus status;
        if (project2 == null) {
            ScratchImplUtil.$$$reportNull$$$0(23);
        }
        if (item == null) {
            ScratchImplUtil.$$$reportNull$$$0(24);
        }
        if (mappings == null) {
            ScratchImplUtil.$$$reportNull$$$0(25);
        }
        if (sortedFiles == null) {
            ScratchImplUtil.$$$reportNull$$$0(26);
        }
        if ((status = ReadonlyStatusHandler.getInstance(project2).ensureFilesWritable(Arrays.asList(sortedFiles))).hasReadonlyFiles()) {
            return;
        }
        LinkedHashSet<VirtualFile> matchedExtensions = new LinkedHashSet<VirtualFile>();
        final HashMap<VirtualFile, Language> oldMapping = new HashMap<VirtualFile, Language>();
        for (VirtualFile file2 : sortedFiles) {
            oldMapping.put(file2, mappings.getMapping(file2));
            if (!ScratchImplUtil.hasMatchingExtension(project2, file2)) continue;
            matchedExtensions.add(file2);
        }
        BasicUndoableAction action2 = new BasicUndoableAction(sortedFiles){

            @Override
            public void undo() {
                for (VirtualFile file2 : sortedFiles) {
                    mappings.setMapping(file2, (Language)oldMapping.get(file2));
                }
            }

            @Override
            public void redo() {
                for (VirtualFile file2 : sortedFiles) {
                    mappings.setMapping(file2, item.language);
                }
            }
        };
        action2.redo();
        UndoManager.getInstance(project2).undoableActionPerformed(action2);
        for (VirtualFile file3 : matchedExtensions) {
            try {
                ScratchImplUtil.updateFileExtension(project2, file3, item);
            }
            catch (IOException iOException) {}
        }
    }

    static LRUPopupBuilder<LanguageItem> buildLanguagesPopup(@NotNull Project project2, @NotNull @NlsContexts.PopupTitle String title) {
        if (project2 == null) {
            ScratchImplUtil.$$$reportNull$$$0(27);
        }
        if (title == null) {
            ScratchImplUtil.$$$reportNull$$$0(28);
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        List<LanguageItem> items2 = JBIterable.from(LanguageUtil.getFileLanguages()).map(LanguageItem::fromLanguage).append((LanguageItem)((Object)JBIterable.of(fileTypeManager.getRegisteredFileTypes()).filter(AbstractFileType.class).map(o -> LanguageItem.fromAbstractFileType(o, ScratchImplUtil.getFileTypeExtensions((FileType)o, true, fileTypeManager).first())))).filter(Objects::nonNull).toList();
        Comparator comparator = (o1, o2) -> StringUtil.naturalCompare(o1.getDisplayName(), o2.getDisplayName());
        return new LRUPopupBuilder<LanguageItem>(project2, title){

            @Override
            public String getDisplayName(LanguageItem o) {
                return o.getDisplayName();
            }

            @Override
            public Icon getIcon(LanguageItem o) {
                return ObjectUtils.notNull(o.fileType.getIcon(), AllIcons.FileTypes.Any_type);
            }

            @Override
            public String getStorageId(LanguageItem o) {
                return o.language != null ? o.language.getID() : o.fileType.getName();
            }
        }.forValues(items2).withComparator(comparator).withExtraSpeedSearchNamer(o -> o.fileExtension).withSelection(null);
    }

    @Nullable
    static TextExtractor getTextExtractor(@Nullable Component component2) {
        return component2 instanceof JTextComponent ? new TextComponentExtractor((JTextComponent)component2) : (component2 instanceof JList ? new ListExtractor((JList)component2) : (component2 instanceof JTree ? new TreeExtractor((JTree)component2) : (component2 instanceof JTable ? new TableExtractor((JTable)component2) : (TerminalUtils.isTerminalComponent((Component)component2) ? new TerminalExtractor(component2) : null))));
    }

    private static void append(StringBuilder sb, Object value, Component renderer) {
        int length = sb.length();
        if (renderer instanceof JPanel) {
            for (Component c2 : UIUtil.uiTraverser(renderer)) {
                if (!ScratchImplUtil.appendSimple(sb, c2)) continue;
                sb.append(" ");
            }
            if (sb.length() == length) {
                sb.append(TreeUtil.getUserObject((Object)value));
            }
        } else if (!ScratchImplUtil.appendSimple(sb, renderer)) {
            sb.append(TreeUtil.getUserObject((Object)value));
        }
        int len = sb.length();
        for (int i2 = length; i2 < len; ++i2) {
            char c3 = sb.charAt(i2);
            if (c3 < '\u2000' || c3 > '\u2009') continue;
            sb.setCharAt(i2, ' ');
        }
    }

    private static boolean appendSimple(@NotNull StringBuilder sb, @Nullable Component renderer) {
        if (sb == null) {
            ScratchImplUtil.$$$reportNull$$$0(29);
        }
        if (renderer instanceof JLabel) {
            sb.append(((JLabel)renderer).getText());
        } else if (renderer instanceof JTextComponent) {
            sb.append(((JTextComponent)renderer).getText());
        } else if (renderer instanceof SimpleColoredComponent) {
            sb.append(((SimpleColoredComponent)renderer).getCharSequence(false));
        } else {
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 16, 17, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeManager";
                break;
            }
            case 4: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 6: 
            case 7: 
            case 16: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scratch/ScratchImplUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameAndExt";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortedFiles";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scratch/ScratchImplUtil";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameWithoutExtension";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeExtensions";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextAvailableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateFileExtension";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNameWithoutExtension";
                break;
            }
            case 6: 
            case 7: 
            case 16: 
            case 17: 
            case 22: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasMatchingExtension";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasExtension";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeFromName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeExtensions";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findFileIgnoreExtension";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getNextAvailableName";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "changeLanguageWithUndo";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "buildLanguagesPopup";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "appendSimple";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6, 7, 16, 17, 22 -> new IllegalStateException(string2);
        };
    }

    record LanguageItem(@Nullable Language language, @NotNull FileType fileType, @NotNull String fileExtension) {
        @NotNull
        private final FileType fileType;
        @NotNull
        private final String fileExtension;

        LanguageItem(@Nullable Language language, @NotNull FileType fileType, @NotNull String fileExtension) {
            if (fileType == null) {
                LanguageItem.$$$reportNull$$$0(0);
            }
            if (fileExtension == null) {
                LanguageItem.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        @NlsSafe
        String getDisplayName() {
            Object object = this.language != null ? this.language.getDisplayName() : this.fileType.getDescription() + " (*." + this.fileExtension + ")";
            if (object == null) {
                LanguageItem.$$$reportNull$$$0(2);
            }
            return object;
        }

        @Nullable
        static LanguageItem fromLanguage(@NotNull Language language) {
            LanguageFileType fileType;
            String defaultExtension;
            if (language == null) {
                LanguageItem.$$$reportNull$$$0(3);
            }
            String string2 = defaultExtension = (fileType = language.getAssociatedFileType()) == null ? null : fileType.getDefaultExtension();
            if (StringUtil.isEmpty(defaultExtension)) {
                return null;
            }
            return new LanguageItem(language, fileType, defaultExtension);
        }

        @Nullable
        static LanguageItem fromAbstractFileType(@NotNull AbstractFileType fileType, @Nullable String fileExtension) {
            if (fileType == null) {
                LanguageItem.$$$reportNull$$$0(4);
            }
            if (fileExtension == null) {
                return null;
            }
            return new LanguageItem(null, (FileType)fileType, fileExtension);
        }

        @NotNull
        public FileType fileType() {
            FileType fileType = this.fileType;
            if (fileType == null) {
                LanguageItem.$$$reportNull$$$0(5);
            }
            return fileType;
        }

        @NotNull
        public String fileExtension() {
            String string2 = this.fileExtension;
            if (string2 == null) {
                LanguageItem.$$$reportNull$$$0(6);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileExtension";
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scratch/ScratchImplUtil$LanguageItem";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scratch/ScratchImplUtil$LanguageItem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fileType";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fileExtension";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "fromLanguage";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "fromAbstractFileType";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 5, 6 -> new IllegalStateException(string2);
            };
        }
    }

    private static class TextComponentExtractor
    implements TextExtractor {
        final JTextComponent comp;

        TextComponentExtractor(@NotNull JTextComponent component2) {
            if (component2 == null) {
                TextComponentExtractor.$$$reportNull$$$0(0);
            }
            this.comp = component2;
        }

        @Override
        public boolean hasSelection() {
            return this.comp.getSelectionStart() != this.comp.getSelectionEnd();
        }

        @Override
        public String extractText() {
            String text2 = this.comp.getSelectedText();
            return StringUtil.isEmpty(text2) ? this.comp.getText() : text2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ide/scratch/ScratchImplUtil$TextComponentExtractor", "<init>"));
        }
    }

    private static class ListExtractor
    implements TextExtractor {
        final JList<Object> comp;

        ListExtractor(@NotNull JList<?> component2) {
            if (component2 == null) {
                ListExtractor.$$$reportNull$$$0(0);
            }
            this.comp = component2;
        }

        @Override
        public boolean hasSelection() {
            return this.comp.getSelectionModel().getSelectedItemsCount() > 1;
        }

        @Override
        public String extractText() {
            JBIterable<Object> values2;
            List<Object> selection = this.comp.getSelectedValuesList();
            if (selection.size() > 1) {
                JBIterable<Object> values22 = JBIterable.from(selection);
            } else {
                ListModel<Object> model2 = this.comp.getModel();
                values2 = JBIterable.generate(0, o -> o + 1).take(model2.getSize()).map(o -> model2.getElementAt((int)o));
            }
            ListCellRenderer<Object> renderer = this.comp.getCellRenderer();
            StringBuilder sb = new StringBuilder();
            for (Object t : values2) {
                ScratchImplUtil.append(sb, t, renderer.getListCellRendererComponent(this.comp, t, -1, false, false));
                sb.append("\n");
            }
            return sb.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ide/scratch/ScratchImplUtil$ListExtractor", "<init>"));
        }
    }

    private static class TreeExtractor
    implements TextExtractor {
        final JTree comp;

        TreeExtractor(@NotNull JTree component2) {
            if (component2 == null) {
                TreeExtractor.$$$reportNull$$$0(0);
            }
            this.comp = component2;
        }

        @Override
        public boolean hasSelection() {
            return this.comp.getSelectionModel().getSelectionCount() > 1;
        }

        @Override
        public String extractText() {
            int initialDepth;
            JBIterable paths2;
            TreePath[] selection = this.comp.getSelectionPaths();
            JBTreeTraverser traverser = (JBTreeTraverser)TreeUtil.treePathTraverser((JTree)this.comp).expand(this.comp::isExpanded);
            if (selection != null && selection.length > 1) {
                paths2 = ((JBTreeTraverser)((JBTreeTraverser)traverser.withRoots(selection)).unique()).traverse();
                initialDepth = Integer.MAX_VALUE;
                for (TreePath path2 : selection) {
                    initialDepth = Math.min(initialDepth, path2.getPathCount() - 1);
                }
            } else {
                initialDepth = this.comp.isRootVisible() ? 0 : 1;
                paths2 = traverser.traverse().skip(initialDepth);
            }
            TreeCellRenderer renderer = this.comp.getCellRenderer();
            StringBuilder sb = new StringBuilder();
            for (TreePath path2 : paths2) {
                Object value = path2.getLastPathComponent();
                int depth = path2.getPathCount() - initialDepth - 1;
                for (int i2 = 0; i2 < depth; ++i2) {
                    sb.append("  ");
                }
                ScratchImplUtil.append(sb, value, renderer.getTreeCellRendererComponent(this.comp, value, false, false, false, -1, false));
                sb.append("\n");
            }
            return sb.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ide/scratch/ScratchImplUtil$TreeExtractor", "<init>"));
        }
    }

    private static class TableExtractor
    implements TextExtractor {
        final JTable comp;

        TableExtractor(@NotNull JTable component2) {
            if (component2 == null) {
                TableExtractor.$$$reportNull$$$0(0);
            }
            this.comp = component2;
        }

        @Override
        public boolean hasSelection() {
            return this.comp.getSelectionModel().getSelectedItemsCount() > 1;
        }

        @Override
        public String extractText() {
            int[] rows = this.comp.getSelectedRows();
            int[] cols = this.comp.getColumnSelectionAllowed() ? this.comp.getSelectedColumns() : IntStream.range(0, this.comp.getColumnCount()).toArray();
            StringBuilder sb = new StringBuilder();
            int lastCol = cols.length == 0 ? -1 : cols[cols.length - 1];
            for (int row : rows) {
                for (int col : cols) {
                    Object value = this.comp.getModel().getValueAt(this.comp.convertRowIndexToModel(row), this.comp.convertColumnIndexToModel(col));
                    TableCellRenderer renderer = this.comp.getCellRenderer(row, col);
                    ScratchImplUtil.append(sb, value, renderer.getTableCellRendererComponent(this.comp, value, false, false, row, col));
                    if (col == lastCol) continue;
                    sb.append("    ");
                }
                sb.append("\n");
            }
            return sb.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ide/scratch/ScratchImplUtil$TableExtractor", "<init>"));
        }
    }

    private static class TerminalExtractor
    implements TextExtractor {
        final Component component;

        TerminalExtractor(@Nullable Component dataContext2) {
            this.component = dataContext2;
        }

        @Override
        public boolean hasSelection() {
            return TerminalUtils.hasSelectionInTerminal((Component)this.component);
        }

        @Override
        public String extractText() {
            if (TerminalUtils.hasSelectionInTerminal((Component)this.component)) {
                return TerminalUtils.getSelectedTextInTerminal((Component)this.component);
            }
            String text2 = TerminalUtils.getTextInTerminal((Component)this.component);
            return StringUtil.isEmptyOrSpaces(text2) ? null : text2;
        }
    }

    static interface TextExtractor {
        public boolean hasSelection();

        @Nullable
        public String extractText();
    }
}

