/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.icons.AllIcons;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchFileTypeIcon;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.UIBundle;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScratchRootType
extends RootType {
    @NotNull
    public static ScratchRootType getInstance() {
        ScratchRootType scratchRootType = ScratchRootType.findByClass(ScratchRootType.class);
        if (scratchRootType == null) {
            ScratchRootType.$$$reportNull$$$0(0);
        }
        return scratchRootType;
    }

    ScratchRootType() {
        super("scratches", LangBundle.message("root.type.scratches", new Object[0]));
    }

    @Override
    public Language substituteLanguage(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            ScratchRootType.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            ScratchRootType.$$$reportNull$$$0(2);
        }
        return ScratchFileService.getInstance().getScratchesMapping().getMapping(file2);
    }

    @Override
    @Nullable
    public Icon substituteIcon(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            ScratchRootType.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            ScratchRootType.$$$reportNull$$$0(4);
        }
        if (file2.isDirectory()) {
            return null;
        }
        Icon icon2 = ObjectUtils.notNull(super.substituteIcon(project2, file2), AllIcons.FileTypes.Text);
        return new ScratchFileTypeIcon(icon2);
    }

    @Nullable
    public VirtualFile createScratchFile(@Nullable Project project2, @NotNull String fileName, @Nullable Language language, @NotNull String text2) {
        if (fileName == null) {
            ScratchRootType.$$$reportNull$$$0(5);
        }
        if (text2 == null) {
            ScratchRootType.$$$reportNull$$$0(6);
        }
        return this.createScratchFile(project2, fileName, language, text2, ScratchFileService.Option.create_new_always);
    }

    @Nullable
    public VirtualFile createScratchFile(@Nullable Project project2, @NotNull String fileName, @Nullable Language language, @NotNull String text2, @NotNull ScratchFileService.Option option) {
        if (fileName == null) {
            ScratchRootType.$$$reportNull$$$0(7);
        }
        if (text2 == null) {
            ScratchRootType.$$$reportNull$$$0(8);
        }
        if (option == null) {
            ScratchRootType.$$$reportNull$$$0(9);
        }
        try {
            return WriteCommandAction.writeCommandAction(project2).withName(UIBundle.message((String)"file.chooser.create.new.scratch.file.command.name", (Object[])new Object[0])).withGlobalUndo().shouldRecordActionForActiveDocument(false).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).compute(() -> {
                ScratchFileService fileService = ScratchFileService.getInstance();
                VirtualFile file2 = fileService.findFile(this, fileName, option);
                VfsUtil.saveText(file2, text2);
                if (language != null) {
                    Language fileLanguage = LanguageUtil.getFileLanguage(file2);
                    fileService.getScratchesMapping().setMapping(file2, fileLanguage == null || language == fileLanguage ? null : language);
                }
                return file2;
            });
        }
        catch (IOException e) {
            Messages.showMessageDialog((String)UIBundle.message((String)"create.new.file.could.not.create.file.error.message", (Object[])new Object[]{fileName}), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scratch/ScratchRootType";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scratch/ScratchRootType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "substituteLanguage";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "substituteIcon";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createScratchFile";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string2);
        };
    }
}

