/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.NodeSortOrder;
import com.intellij.ide.projectView.NodeSortSettings;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.nodes.ProjectViewProjectNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileSystemItemFilter;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.scratch.ScratchesNamedScope;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScratchTreeStructureProvider
implements TreeStructureProvider,
DumbAware {
    public ScratchTreeStructureProvider(final Project project2) {
        ScratchTreeStructureProvider.registerUpdaters(project2, project2, new Runnable(){
            AbstractProjectViewPane updateTarget;

            @Override
            public void run() {
                if (project2.isDisposed()) {
                    return;
                }
                if (this.updateTarget == null) {
                    this.updateTarget = ProjectView.getInstance(project2).getProjectViewPaneById("ProjectPane");
                }
                if (this.updateTarget != null) {
                    this.updateTarget.updateFromRoot(true);
                }
            }
        });
    }

    private static void registerUpdaters(final @NotNull Project project2, final @NotNull Disposable disposable, final @NotNull Runnable onUpdate) {
        if (project2 == null) {
            ScratchTreeStructureProvider.$$$reportNull$$$0(0);
        }
        if (disposable == null) {
            ScratchTreeStructureProvider.$$$reportNull$$$0(1);
        }
        if (onUpdate == null) {
            ScratchTreeStructureProvider.$$$reportNull$$$0(2);
        }
        VirtualFileManager.getInstance().addAsyncFileListener(events -> {
            ScratchFileService scratchFileService = ScratchFileService.getInstance();
            boolean update2 = JBIterable.from(events).find(e -> {
                ProgressManager.checkCanceled();
                VirtualFile parent2 = ScratchTreeStructureProvider.getNewParent(e);
                if (parent2 == null) {
                    return false;
                }
                if (ScratchUtil.isScratch(parent2)) {
                    return true;
                }
                if (!ScratchTreeStructureProvider.isDirectory(e)) {
                    return false;
                }
                for (RootType rootType : RootType.getAllRootTypes()) {
                    if (!scratchFileService.getRootPath(rootType).startsWith(parent2.getPath())) continue;
                    return true;
                }
                return false;
            }) != null;
            return !update2 ? null : new AsyncFileListener.ChangeApplier(){

                @Override
                public void afterVfsChange() {
                    onUpdate.run();
                }
            };
        }, disposable);
        final ConcurrentMap<RootType, Disposable> disposables = ConcurrentFactoryMap.createMap(o -> Disposer.newDisposable(o.getDisplayName()));
        for (RootType rootType : RootType.getAllRootTypes()) {
            ScratchTreeStructureProvider.registerRootTypeUpdater(project2, rootType, onUpdate, disposable, disposables);
        }
        RootType.ROOT_EP.addExtensionPointListener(new ExtensionPointListener<RootType>(){

            @Override
            public void extensionAdded(@NotNull RootType rootType, @NotNull PluginDescriptor pluginDescriptor) {
                if (rootType == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(1);
                }
                ScratchTreeStructureProvider.registerRootTypeUpdater(project2, rootType, onUpdate, disposable, disposables);
            }

            @Override
            public void extensionRemoved(@NotNull RootType rootType, @NotNull PluginDescriptor pluginDescriptor) {
                Disposable rootDisposable;
                if (rootType == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(3);
                }
                if ((rootDisposable = (Disposable)disposables.remove(rootType)) != null) {
                    Disposer.dispose(rootDisposable);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rootType";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/scratch/ScratchTreeStructureProvider$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, project2);
        RootType.ROOT_EP.addChangeListener(onUpdate, project2);
    }

    private static void registerRootTypeUpdater(@NotNull Project project2, @NotNull RootType rootType, @NotNull Runnable onUpdate, @NotNull Disposable parentDisposable, @NotNull Map<RootType, Disposable> disposables) {
        if (project2 == null) {
            ScratchTreeStructureProvider.$$$reportNull$$$0(3);
        }
        if (rootType == null) {
            ScratchTreeStructureProvider.$$$reportNull$$$0(4);
        }
        if (onUpdate == null) {
            ScratchTreeStructureProvider.$$$reportNull$$$0(5);
        }
        if (parentDisposable == null) {
            ScratchTreeStructureProvider.$$$reportNull$$$0(6);
        }
        if (disposables == null) {
            ScratchTreeStructureProvider.$$$reportNull$$$0(7);
        }
        if (rootType.isHidden()) {
            return;
        }
        Disposable rootDisposable = disposables.get(rootType);
        Disposer.register(parentDisposable, rootDisposable);
        ReadAction.nonBlocking(() -> rootType.registerTreeUpdater(project2, parentDisposable, onUpdate)).expireWith(parentDisposable).submit((Executor)NonUrgentExecutor.getInstance());
    }

    private static VirtualFile getNewParent(@NotNull VFileEvent e) {
        if (e == null) {
            ScratchTreeStructureProvider.$$$reportNull$$$0(8);
        }
        if (e instanceof VFileMoveEvent) {
            return ((VFileMoveEvent)e).getNewParent();
        }
        if (e instanceof VFileCopyEvent) {
            return ((VFileCopyEvent)e).getNewParent();
        }
        if (e instanceof VFileCreateEvent) {
            return ((VFileCreateEvent)e).getParent();
        }
        return Objects.requireNonNull(e.getFile()).getParent();
    }

    private static boolean isDirectory(@NotNull VFileEvent e) {
        if (e == null) {
            ScratchTreeStructureProvider.$$$reportNull$$$0(9);
        }
        if (e instanceof VFileCreateEvent) {
            return ((VFileCreateEvent)e).isDirectory();
        }
        return Objects.requireNonNull(e.getFile()).isDirectory();
    }

    @Nullable
    private static PsiDirectory getDirectory(@NotNull Project project2, @NotNull RootType rootType) {
        VirtualFile virtualFile2;
        if (project2 == null) {
            ScratchTreeStructureProvider.$$$reportNull$$$0(10);
        }
        if (rootType == null) {
            ScratchTreeStructureProvider.$$$reportNull$$$0(11);
        }
        return (virtualFile2 = ScratchTreeStructureProvider.getVirtualFile(rootType)) == null ? null : PsiManager.getInstance(project2).findDirectory(virtualFile2);
    }

    @Nullable
    public static VirtualFile getVirtualFile(@NotNull RootType rootType) {
        if (rootType == null) {
            ScratchTreeStructureProvider.$$$reportNull$$$0(12);
        }
        String path2 = ScratchFileService.getInstance().getRootPath(rootType);
        return LocalFileSystem.getInstance().findFileByPath(path2);
    }

    @Nullable
    private static AbstractTreeNode<?> createRootTypeNode(@NotNull Project project2, @NotNull RootType rootType, @NotNull ViewSettings settings) {
        if (project2 == null) {
            ScratchTreeStructureProvider.$$$reportNull$$$0(13);
        }
        if (rootType == null) {
            ScratchTreeStructureProvider.$$$reportNull$$$0(14);
        }
        if (settings == null) {
            ScratchTreeStructureProvider.$$$reportNull$$$0(15);
        }
        if (rootType.isHidden()) {
            return null;
        }
        MyRootNode node2 = new MyRootNode(project2, rootType, settings);
        return node2.isEmpty() ? null : node2;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> modify(@NotNull AbstractTreeNode<?> parent2, @NotNull Collection<AbstractTreeNode<?>> children2, ViewSettings settings) {
        Project project2;
        if (parent2 == null) {
            ScratchTreeStructureProvider.$$$reportNull$$$0(16);
        }
        if (children2 == null) {
            ScratchTreeStructureProvider.$$$reportNull$$$0(17);
        }
        if (!settings.isShowScratchesAndConsoles()) {
            Collection<AbstractTreeNode<?>> collection = children2;
            if (collection == null) {
                ScratchTreeStructureProvider.$$$reportNull$$$0(18);
            }
            return collection;
        }
        Project project3 = project2 = parent2 instanceof ProjectViewProjectNode ? parent2.getProject() : null;
        if (project2 == null) {
            Collection<AbstractTreeNode<?>> collection = children2;
            if (collection == null) {
                ScratchTreeStructureProvider.$$$reportNull$$$0(19);
            }
            return collection;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Collection<AbstractTreeNode<?>> collection = children2;
            if (collection == null) {
                ScratchTreeStructureProvider.$$$reportNull$$$0(20);
            }
            return collection;
        }
        if (children2.isEmpty() && JBIterable.from(RootType.getAllRootTypes()).filterMap(o -> ScratchTreeStructureProvider.createRootTypeNode(project2, o, settings)).isEmpty()) {
            Collection<AbstractTreeNode<?>> collection = children2;
            if (collection == null) {
                ScratchTreeStructureProvider.$$$reportNull$$$0(21);
            }
            return collection;
        }
        ArrayList list2 = new ArrayList(children2.size() + 1);
        list2.addAll(children2);
        list2.add(new MyProjectNode(project2, settings));
        ArrayList arrayList = list2;
        if (arrayList == null) {
            ScratchTreeStructureProvider.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    @Deprecated(forRemoval=true)
    public static AbstractTreeNode<?> createRootNode(@NotNull Project project2, ViewSettings settings) {
        if (project2 == null) {
            ScratchTreeStructureProvider.$$$reportNull$$$0(23);
        }
        return new MyProjectNode(project2, settings);
    }

    public Object getData(@NotNull Collection<? extends AbstractTreeNode<?>> selected, @NotNull String dataId) {
        if (selected == null) {
            ScratchTreeStructureProvider.$$$reportNull$$$0(24);
        }
        if (dataId == null) {
            ScratchTreeStructureProvider.$$$reportNull$$$0(25);
        }
        if (PlatformCoreDataKeys.BGT_DATA_PROVIDER.is(dataId)) {
            return slowId -> ScratchTreeStructureProvider.getSlowData(slowId, selected);
        }
        return null;
    }

    @Nullable
    private static Object getSlowData(@NotNull String dataId, @NotNull Collection<? extends AbstractTreeNode<?>> selected) {
        AbstractTreeNode<?> single2;
        if (dataId == null) {
            ScratchTreeStructureProvider.$$$reportNull$$$0(26);
        }
        if (selected == null) {
            ScratchTreeStructureProvider.$$$reportNull$$$0(27);
        }
        if (LangDataKeys.PASTE_TARGET_PSI_ELEMENT.is(dataId) && (single2 = JBIterable.from(selected).single()) instanceof MyRootNode) {
            VirtualFile file2 = ((MyRootNode)single2).getVirtualFile();
            Project project2 = single2.getProject();
            return file2 == null || project2 == null ? null : PsiManager.getInstance(project2).findDirectory(file2);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18, 19, 20, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onUpdate";
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposables";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scratch/ScratchTreeStructureProvider";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scratch/ScratchTreeStructureProvider";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "modify";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerUpdaters";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerRootTypeUpdater";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNewParent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isDirectory";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDirectory";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createRootTypeNode";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createRootNode";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getSlowData";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 18, 19, 20, 21, 22 -> new IllegalStateException(string2);
        };
    }

    private static class MyRootNode
    extends ProjectViewNode<RootType>
    implements PsiFileSystemItemFilter {
        MyRootNode(Project project2, @NotNull RootType type, ViewSettings settings) {
            if (type == null) {
                MyRootNode.$$$reportNull$$$0(0);
            }
            super(project2, type, settings);
        }

        @NotNull
        public RootType getRootType() {
            RootType rootType = Objects.requireNonNull((RootType)this.getValue());
            if (rootType == null) {
                MyRootNode.$$$reportNull$$$0(1);
            }
            return rootType;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyRootNode.$$$reportNull$$$0(2);
            }
            return ((RootType)this.getValue()).containsFile(file2);
        }

        @Override
        @Nullable
        public VirtualFile getVirtualFile() {
            return ScratchTreeStructureProvider.getVirtualFile(this.getRootType());
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getRoots() {
            Collection<VirtualFile> collection = MyRootNode.getDefaultRootsFor(this.getVirtualFile());
            if (collection == null) {
                MyRootNode.$$$reportNull$$$0(3);
            }
            return collection;
        }

        @NotNull
        public Collection<? extends AbstractTreeNode<?>> getChildren() {
            return MyRootNode.getDirectoryChildrenImpl(this.getProject(), this.getDirectory(), this.getSettings(), this);
        }

        PsiDirectory getDirectory() {
            return ScratchTreeStructureProvider.getDirectory(this.getProject(), (RootType)this.getValue());
        }

        protected void update(@NotNull PresentationData presentation2) {
            if (presentation2 == null) {
                MyRootNode.$$$reportNull$$$0(4);
            }
            presentation2.setIcon(AllIcons.Nodes.Folder);
            presentation2.setPresentableText(this.getRootType().getDisplayName());
        }

        public boolean canRepresent(Object element) {
            return Comparing.equal(this.getDirectory(), element);
        }

        public boolean isEmpty() {
            VirtualFile root = this.getVirtualFile();
            if (root == null) {
                return true;
            }
            RootType rootType = this.getRootType();
            Project project2 = Objects.requireNonNull(this.getProject());
            for (VirtualFile f : root.getChildren()) {
                if (rootType.isIgnored(project2, f)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean shouldShow(@NotNull PsiFileSystemItem item) {
            if (item == null) {
                MyRootNode.$$$reportNull$$$0(5);
            }
            return !this.getRootType().isIgnored(this.getProject(), item.getVirtualFile());
        }

        @NotNull
        static Collection<AbstractTreeNode<?>> getDirectoryChildrenImpl(final @NotNull Project project2, @Nullable PsiDirectory directory, final @NotNull ViewSettings settings, final @NotNull PsiFileSystemItemFilter filter2) {
            if (project2 == null) {
                MyRootNode.$$$reportNull$$$0(6);
            }
            if (settings == null) {
                MyRootNode.$$$reportNull$$$0(7);
            }
            if (filter2 == null) {
                MyRootNode.$$$reportNull$$$0(8);
            }
            final ArrayList result2 = new ArrayList();
            PsiElementProcessor<PsiFileSystemItem> processor = new PsiElementProcessor<PsiFileSystemItem>(){

                @Override
                public boolean execute(@NotNull PsiFileSystemItem element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (filter2.shouldShow(element)) {
                        if (element instanceof PsiDirectory) {
                            result2.add(new PsiDirectoryNode(project2, (PsiDirectory)element, settings, filter2){

                                @Override
                                public Collection<AbstractTreeNode<?>> getChildrenImpl() {
                                    return MyRootNode.getDirectoryChildrenImpl(this.getProject(), (PsiDirectory)this.getValue(), this.getSettings(), this.getFilter());
                                }
                            });
                        } else if (element instanceof PsiFile) {
                            result2.add(new PsiFileNode(project2, (PsiFile)element, settings){

                                @Override
                                public Comparable<PsiFileNode.ExtensionSortKey> getTypeSortKey() {
                                    PsiFile value = (PsiFile)this.getValue();
                                    Language language = value == null ? null : value.getLanguage();
                                    LanguageFileType fileType = language == null ? null : language.getAssociatedFileType();
                                    return fileType == null ? null : new PsiFileNode.ExtensionSortKey(fileType.getDefaultExtension());
                                }
                            });
                        }
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/scratch/ScratchTreeStructureProvider$MyRootNode$1", "execute"));
                }
            };
            Collection collection = (Collection)AbstractTreeUi.calculateYieldingToWriteAction(() -> {
                if (directory == null || !directory.isValid()) {
                    return Collections.emptyList();
                }
                directory.processChildren(processor);
                return result2;
            });
            if (collection == null) {
                MyRootNode.$$$reportNull$$$0(9);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scratch/ScratchTreeStructureProvider$MyRootNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scratch/ScratchTreeStructureProvider$MyRootNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRoots";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDirectoryChildrenImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "shouldShow";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getDirectoryChildrenImpl";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1, 3, 9 -> new IllegalStateException(string2);
            };
        }
    }

    private static final class MyProjectNode
    extends ProjectViewNode<String> {
        MyProjectNode(Project project2, ViewSettings settings) {
            super(project2, ScratchesNamedScope.scratchesAndConsoles(), settings);
        }

        @Override
        @NotNull
        public NodeSortOrder getSortOrder(@NotNull NodeSortSettings settings) {
            if (settings == null) {
                MyProjectNode.$$$reportNull$$$0(0);
            }
            NodeSortOrder nodeSortOrder = NodeSortOrder.SCRATCH_ROOT;
            if (nodeSortOrder == null) {
                MyProjectNode.$$$reportNull$$$0(1);
            }
            return nodeSortOrder;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyProjectNode.$$$reportNull$$$0(2);
            }
            return ScratchUtil.isScratch(file2);
        }

        @NotNull
        public Collection<? extends AbstractTreeNode<?>> getChildren() {
            ArrayList list2 = new ArrayList();
            Project project2 = Objects.requireNonNull(this.getProject());
            for (RootType rootType : RootType.getAllRootTypes()) {
                ContainerUtil.addIfNotNull(list2, ScratchTreeStructureProvider.createRootTypeNode(project2, rootType, this.getSettings()));
            }
            ArrayList arrayList = list2;
            if (arrayList == null) {
                MyProjectNode.$$$reportNull$$$0(3);
            }
            return arrayList;
        }

        protected void update(@NotNull PresentationData presentation2) {
            if (presentation2 == null) {
                MyProjectNode.$$$reportNull$$$0(4);
            }
            presentation2.setPresentableText((String)this.getValue());
            presentation2.setIcon(AllIcons.Scope.Scratches);
        }

        public boolean canRepresent(Object element) {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scratch/ScratchTreeStructureProvider$MyProjectNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scratch/ScratchTreeStructureProvider$MyProjectNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSortOrder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSortOrder";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1, 3 -> new IllegalStateException(string2);
            };
        }
    }
}

