/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.script;

import com.intellij.ide.extensionResources.ExtensionsRootType;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.script.IdeConsoleScriptBindings;
import com.intellij.ide.script.IdeScriptEngine;
import com.intellij.ide.script.IdeScriptEngineManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.Formats;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class IdeStartupScripts
implements StartupActivity.DumbAware {
    private static final Logger LOG = Logger.getInstance(IdeStartupScripts.class);
    private static final String SCRIPT_DIR = "startup";
    private final AtomicBoolean isActive = new AtomicBoolean(true);

    IdeStartupScripts() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw ExtensionNotApplicableException.create();
        }
    }

    @Override
    public void runActivity(@NotNull Project project2) {
        if (project2 == null) {
            IdeStartupScripts.$$$reportNull$$$0(0);
        }
        if (!this.isActive.compareAndSet(true, false)) {
            return;
        }
        List<Path> scripts = IdeStartupScripts.getScripts();
        LOG.info(scripts.size() + " startup script(s) found");
        if (!scripts.isEmpty()) {
            IdeStartupScripts.runAllScriptsImpl(project2, IdeStartupScripts.prepareScriptsAndEngines(scripts), LOG);
        }
    }

    @NotNull
    static List<Pair<Path, IdeScriptEngine>> prepareScriptsAndEngines(List<? extends Path> scripts) {
        IdeScriptEngineManager scriptEngineManager = IdeScriptEngineManager.getInstance();
        ArrayList<Pair<Path, IdeScriptEngine>> result2 = new ArrayList<Pair<Path, IdeScriptEngine>>();
        for (Path path2 : scripts) {
            IdeScriptEngine engine;
            String extension2 = FileUtilRt.getExtension(path2.getFileName().toString());
            IdeScriptEngine ideScriptEngine = engine = extension2.isEmpty() ? null : scriptEngineManager.getEngineByFileExtension(extension2, null);
            if (engine == null) {
                LOG.warn(path2 + " not supported (no script engine)");
                continue;
            }
            result2.add(new Pair<Path, IdeScriptEngine>(path2, engine));
        }
        ArrayList<Pair<Path, IdeScriptEngine>> arrayList = result2;
        if (arrayList == null) {
            IdeStartupScripts.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static List<Path> getScripts() {
        List<Path> list2;
        Stream<Path> stream;
        block11: {
            Path directory = ExtensionsRootType.getInstance().findResourceDirectory(PluginManagerCore.CORE_ID, SCRIPT_DIR, false);
            stream = Files.list(directory);
            list2 = stream.filter(ExtensionsRootType.regularFileFilter()).sorted((f1, f2) -> {
                String f1Name = f1 == null ? null : f1.getFileName().toString();
                String f2Name = f2 == null ? null : f2.getFileName().toString();
                return StringUtil.compare(f1Name, f2Name, false);
            }).collect(Collectors.toList());
            if (stream == null) break block11;
            stream.close();
        }
        List<Path> list3 = list2;
        if (list3 == null) {
            IdeStartupScripts.$$$reportNull$$$0(2);
        }
        return list3;
        {
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException directory) {
                }
                catch (IOException e) {
                    LOG.error(e);
                }
            }
        }
        List<Path> list4 = Collections.emptyList();
        if (list4 == null) {
            IdeStartupScripts.$$$reportNull$$$0(3);
        }
        return list4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runAllScriptsImpl(@Nullable Project project2, @NotNull List<? extends Pair<Path, IdeScriptEngine>> result2, @NotNull Logger logger) {
        if (result2 == null) {
            IdeStartupScripts.$$$reportNull$$$0(4);
        }
        if (logger == null) {
            IdeStartupScripts.$$$reportNull$$$0(5);
        }
        for (Pair<Path, IdeScriptEngine> pair : result2) {
            try {
                logger.info(((Path)pair.first).toString());
                String scriptText = Files.readString((Path)pair.first);
                IdeConsoleScriptBindings.ensureIdeIsBound(project2, (IdeScriptEngine)pair.second);
                long start = System.currentTimeMillis();
                try {
                    ((IdeScriptEngine)pair.second).eval(scriptText);
                }
                catch (ProcessCanceledException e) {
                    logger.warn("... cancelled");
                }
                finally {
                    logger.info("... completed in " + Formats.formatDuration(System.currentTimeMillis() - start));
                }
            }
            catch (Exception e) {
                logger.warn(e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/script/IdeStartupScripts";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/script/IdeStartupScripts";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareScriptsAndEngines";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getScripts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runAllScriptsImpl";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 3 -> new IllegalStateException(string2);
        };
    }
}

