/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.script;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.script.IdeConsoleRootType;
import com.intellij.ide.script.IdeConsoleScriptBindings;
import com.intellij.ide.script.IdeScriptEngine;
import com.intellij.ide.script.IdeScriptEngineManager;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.content.Content;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RunIdeConsoleAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(RunIdeConsoleAction.class);
    private static final String DEFAULT_FILE_NAME = "ide-scripting";
    private static final Key<IdeScriptEngineManager.EngineInfo> SELECTED_ENGINE_INFO_KEY = Key.create("SELECTED_ENGINE_INFO_KEY");
    private static final Key<Trinity<IdeScriptEngine, IdeScriptEngineManager.EngineInfo, VirtualFile>> SCRIPT_ENGINE_KEY = Key.create("SCRIPT_ENGINE_KEY");

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabledAndVisible(e.getProject() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(2);
        }
        if ((project2 = e.getProject()) == null) {
            return;
        }
        List infos = IdeScriptEngineManager.getInstance().getEngineInfos();
        RunIdeConsoleAction.chooseScriptEngineAndRun(e, infos, engineInfo -> RunIdeConsoleAction.runConsole(project2, engineInfo));
    }

    static void chooseScriptEngineAndRun(@NotNull AnActionEvent e, @NotNull List<? extends IdeScriptEngineManager.EngineInfo> infos, final @NotNull Consumer<? super IdeScriptEngineManager.EngineInfo> onChosen2) {
        if (e == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(3);
        }
        if (infos == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(4);
        }
        if (onChosen2 == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(5);
        }
        if (infos.size() == 1) {
            onChosen2.consume((IdeScriptEngineManager.EngineInfo)infos.iterator().next());
            return;
        }
        List<1> actions = JBIterable.from(infos).map(engineInfo -> {
            String lang = engineInfo.languageName;
            String eng = engineInfo.engineName;
            if (StringUtil.toLowerCase(lang).equals(lang)) {
                lang = StringUtil.capitalize(lang);
            }
            if (StringUtil.toLowerCase(eng).equals(eng)) {
                eng = StringUtil.capitalize(eng);
            }
            String name = lang + " (" + eng + ")";
            PluginDescriptor plugin = engineInfo.plugin;
            String description = LangBundle.message("action.engine.description", lang, eng, plugin == null ? "" : LangBundle.message("action.plugin.description", new Object[0]) + plugin.getName());
            return new DumbAwareAction(name, description, null, (IdeScriptEngineManager.EngineInfo)engineInfo){
                final /* synthetic */ IdeScriptEngineManager.EngineInfo val$engineInfo;
                {
                    this.val$engineInfo = engineInfo;
                    super(arg0, arg1, arg2);
                }

                public void actionPerformed(@NotNull AnActionEvent e1) {
                    if (e1 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    onChosen2.consume(this.val$engineInfo);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e1", "com/intellij/ide/script/RunIdeConsoleAction$1", "actionPerformed"));
                }
            };
        }).sort(Comparator.comparing(o -> o.getTemplatePresentation().getText())).toList();
        DefaultActionGroup actionGroup2 = new DefaultActionGroup(actions);
        JBPopupFactory.getInstance().createActionGroupPopup(ExecutionBundle.message((String)"popup.title.script.engine", (Object[])new Object[0]), (ActionGroup)actionGroup2, e.getDataContext(), JBPopupFactory.ActionSelectionAid.NUMBERING, false).showInBestPositionFor(e.getDataContext());
    }

    private static void runConsole(@NotNull Project project2, @NotNull IdeScriptEngineManager.EngineInfo info2) {
        if (project2 == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(6);
        }
        if (info2 == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(7);
        }
        List extensions2 = info2.fileExtensions;
        try {
            String pathName = PathUtil.makeFileName(DEFAULT_FILE_NAME, (String)ContainerUtil.getFirstItem(extensions2));
            VirtualFile virtualFile2 = IdeConsoleRootType.getInstance().findFile(project2, pathName, ScratchFileService.Option.create_if_missing);
            if (virtualFile2 != null) {
                virtualFile2.putUserData(SELECTED_ENGINE_INFO_KEY, info2);
                FileEditorManager.getInstance(project2).openFile(virtualFile2, true);
            }
        }
        catch (IOException ex) {
            LOG.error(ex);
        }
    }

    public static void configureConsole(@NotNull VirtualFile file2, @NotNull FileEditorManager source) {
        if (file2 == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(8);
        }
        if (source == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(9);
        }
        MyRunAction runAction = new MyRunAction();
        for (FileEditor fileEditor : source.getEditors(file2)) {
            if (!(fileEditor instanceof TextEditor)) continue;
            Editor editor2 = ((TextEditor)fileEditor).getEditor();
            runAction.registerCustomShortcutSet(CommonShortcuts.CTRL_ENTER, editor2.getComponent());
        }
    }

    private static void executeQuery(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull Editor editor2, @NotNull IdeScriptEngineManager.EngineInfo engineInfo) {
        IdeScriptEngine engine;
        String command2;
        if (project2 == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(11);
        }
        if (editor2 == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(12);
        }
        if (engineInfo == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(13);
        }
        if (StringUtil.isEmptyOrSpaces(command2 = RunIdeConsoleAction.getCommandText(project2, editor2))) {
            return;
        }
        String profile = RunIdeConsoleAction.getProfileText(file2);
        RunContentDescriptor descriptor2 = RunIdeConsoleAction.getConsoleView(project2, file2, engineInfo);
        Content content2 = descriptor2.getAttachedContent();
        if (content2 == null) {
            LOG.error("Attached content expected");
            return;
        }
        Trinity data2 = (Trinity)content2.getUserData(SCRIPT_ENGINE_KEY);
        if (data2 != null) {
            engine = (IdeScriptEngine)data2.first;
        } else {
            engine = IdeScriptEngineManager.getInstance().getEngine(engineInfo, null);
            if (engine == null) {
                LOG.error("Script engine not found for: " + file2.getName());
                return;
            }
            content2.putUserData(SCRIPT_ENGINE_KEY, Trinity.create(engine, engineInfo, file2));
        }
        ConsoleViewImpl consoleView = (ConsoleViewImpl)descriptor2.getExecutionConsole();
        RunIdeConsoleAction.prepareEngine(project2, engine, descriptor2);
        try {
            long ts = System.currentTimeMillis();
            consoleView.print("> " + command2, ConsoleViewContentType.USER_INPUT);
            consoleView.print("\n", ConsoleViewContentType.USER_INPUT);
            String script = profile == null ? command2 : profile + "\n" + command2;
            Object o = engine.eval(script);
            String prefix = "[" + StringUtil.formatDuration(System.currentTimeMillis() - ts) + "]";
            consoleView.print(prefix + "=> " + o, ConsoleViewContentType.NORMAL_OUTPUT);
            consoleView.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
        }
        catch (Throwable e) {
            Throwable ex = ExceptionUtil.getRootCause(e);
            String message = StringUtil.notNullize(StringUtil.nullize(ex.getMessage()), ex.toString());
            consoleView.print(ex.getClass().getSimpleName() + ": " + message, ConsoleViewContentType.ERROR_OUTPUT);
            consoleView.print("\n", ConsoleViewContentType.ERROR_OUTPUT);
        }
        RunIdeConsoleAction.selectContent(descriptor2);
    }

    private static void prepareEngine(@NotNull Project project2, @NotNull IdeScriptEngine engine, @NotNull RunContentDescriptor descriptor2) {
        if (project2 == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(14);
        }
        if (engine == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(15);
        }
        if (descriptor2 == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(16);
        }
        IdeConsoleScriptBindings.ensureIdeIsBound(project2, engine);
        RunIdeConsoleAction.ensureOutputIsRedirected(engine, descriptor2);
    }

    @Nullable
    private static String getProfileText(@NotNull VirtualFile file2) {
        if (file2 == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(17);
        }
        try {
            VirtualFile folder = file2.getParent();
            VirtualFile profileChild = folder == null ? null : folder.findChild(".profile." + file2.getExtension());
            return profileChild == null ? null : StringUtil.nullize(VfsUtilCore.loadText(profileChild));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @NotNull
    private static String getCommandText(@NotNull Project project2, @NotNull Editor editor2) {
        if (project2 == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(18);
        }
        if (editor2 == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(19);
        }
        TextRange selectedRange = EditorUtil.getSelectionInAnyMode((Editor)editor2);
        Document document = editor2.getDocument();
        if (!selectedRange.isEmpty()) {
            String string2 = document.getText(selectedRange);
            if (string2 == null) {
                RunIdeConsoleAction.$$$reportNull$$$0(20);
            }
            return string2;
        }
        int line = document.getLineNumber(selectedRange.getStartOffset());
        int lineStart = document.getLineStartOffset(line);
        int lineEnd = document.getLineEndOffset(line);
        String lineText = document.getText(TextRange.create(lineStart, lineEnd));
        PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument());
        if (file2 != null && !StringUtil.isEmptyOrSpaces(lineText)) {
            PsiElement parent2;
            int start;
            int end = lineEnd;
            for (start = lineStart; start < end && Character.isWhitespace(lineText.charAt(start - lineStart)); ++start) {
            }
            while (end > start && Character.isWhitespace(lineText.charAt(end - 1 - lineStart))) {
                --end;
            }
            PsiElement e1 = file2.findElementAt(start);
            PsiElement e2 = file2.findElementAt(end > start ? end - 1 : end);
            PsiElement psiElement = parent2 = e1 != null && e2 != null ? PsiTreeUtil.findCommonParent(e1, e2) : ObjectUtils.chooseNotNull(e1, e2);
            if (parent2 != null && parent2 != file2) {
                TextRange combined = parent2.getTextRange().union(TextRange.create(lineStart, lineEnd));
                editor2.getSelectionModel().setSelection(combined.getStartOffset(), combined.getEndOffset());
                String string3 = document.getText(combined);
                if (string3 == null) {
                    RunIdeConsoleAction.$$$reportNull$$$0(21);
                }
                return string3;
            }
        }
        String string4 = lineText;
        if (string4 == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(22);
        }
        return string4;
    }

    private static void selectContent(RunContentDescriptor descriptor2) {
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        ConsoleViewImpl consoleView = Objects.requireNonNull((ConsoleViewImpl)descriptor2.getExecutionConsole());
        RunContentManager.getInstance((Project)consoleView.getProject()).toFrontRunContent(executor, descriptor2);
    }

    @NotNull
    private static RunContentDescriptor getConsoleView(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull IdeScriptEngineManager.EngineInfo engineInfo) {
        if (project2 == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(23);
        }
        if (file2 == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(24);
        }
        if (engineInfo == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(25);
        }
        for (RunContentDescriptor existing : RunContentManager.getInstance((Project)project2).getAllDescriptors()) {
            Trinity data2;
            Content content2 = existing.getAttachedContent();
            if (content2 == null || (data2 = (Trinity)content2.getUserData(SCRIPT_ENGINE_KEY)) == null || !Comparing.equal(file2, (VirtualFile)data2.third) || !Comparing.equal(engineInfo, (IdeScriptEngineManager.EngineInfo)data2.second)) continue;
            RunContentDescriptor runContentDescriptor = existing;
            if (runContentDescriptor == null) {
                RunIdeConsoleAction.$$$reportNull$$$0(26);
            }
            return runContentDescriptor;
        }
        ConsoleView consoleView = TextConsoleBuilderFactory.getInstance().createBuilder(project2).getConsole();
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)consoleView.getComponent(), "Center");
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("RunIdeConsole", (ActionGroup)toolbarActions, false);
        toolbar.setTargetComponent(consoleView.getComponent());
        panel2.add((Component)toolbar.getComponent(), "West");
        RunContentDescriptor descriptor2 = new RunContentDescriptor((ExecutionConsole)consoleView, null, panel2, file2.getName()){

            public boolean isContentReuseProhibited() {
                return true;
            }
        };
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        toolbarActions.addAll(consoleView.createConsoleActions());
        toolbarActions.add((AnAction)new CloseAction(executor, descriptor2, project2));
        RunContentManager.getInstance((Project)project2).showRunContent(executor, descriptor2);
        RunContentDescriptor runContentDescriptor = descriptor2;
        if (runContentDescriptor == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(27);
        }
        return runContentDescriptor;
    }

    private static void ensureOutputIsRedirected(@NotNull IdeScriptEngine engine, @NotNull RunContentDescriptor descriptor2) {
        if (engine == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(28);
        }
        if (descriptor2 == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(29);
        }
        ConsoleWriter stdOutWriter = ObjectUtils.tryCast(engine.getStdOut(), ConsoleWriter.class);
        ConsoleWriter stdErrWriter = ObjectUtils.tryCast(engine.getStdErr(), ConsoleWriter.class);
        if (stdOutWriter != null && stdOutWriter.getDescriptor() == descriptor2 && stdErrWriter != null && stdErrWriter.getDescriptor() == descriptor2) {
            return;
        }
        WeakReference<RunContentDescriptor> ref = new WeakReference<RunContentDescriptor>(descriptor2);
        engine.setStdOut((Writer)new ConsoleWriter(ref, ProcessOutputTypes.STDOUT));
        engine.setStdErr((Writer)new ConsoleWriter(ref, ProcessOutputTypes.STDERR));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 23, 24, 25, 28, 29 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/script/RunIdeConsoleAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onChosen";
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 8: 
            case 11: 
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 13: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engineInfo";
                break;
            }
            case 15: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
            case 16: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/script/RunIdeConsoleAction";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandText";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleView";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "chooseScriptEngineAndRun";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runConsole";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "configureConsole";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "executeQuery";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "prepareEngine";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getProfileText";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getCommandText";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleView";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "ensureOutputIsRedirected";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 23, 24, 25, 28, 29 -> new IllegalArgumentException(string2);
        };
    }

    private static class MyRunAction
    extends DumbAwareAction {
        private IdeScriptEngineManager.EngineInfo engineInfo;

        private MyRunAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyRunAction.$$$reportNull$$$0(0);
            }
            Project project2 = e.getProject();
            Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
            VirtualFile virtualFile2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            e.getPresentation().setEnabledAndVisible(project2 != null && editor2 != null && virtualFile2 != null && (this.engineInfo != null || virtualFile2.getUserData(SELECTED_ENGINE_INFO_KEY) != null || virtualFile2.getExtension() != null));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MyRunAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyRunAction.$$$reportNull$$$0(2);
            }
            Project project2 = e.getProject();
            Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
            VirtualFile virtualFile2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            if (project2 == null || editor2 == null || virtualFile2 == null) {
                return;
            }
            String extension2 = virtualFile2.getExtension();
            IdeScriptEngineManager.EngineInfo engineInfo0 = virtualFile2.getUserData(SELECTED_ENGINE_INFO_KEY);
            if (this.engineInfo == null && engineInfo0 == null && extension2 == null) {
                return;
            }
            PsiDocumentManager.getInstance(project2).commitAllDocuments();
            if (this.engineInfo == null || engineInfo0 != null && !Comparing.equal(engineInfo0, this.engineInfo) || extension2 != null && !this.engineInfo.fileExtensions.contains(extension2)) {
                virtualFile2.putUserData(SELECTED_ENGINE_INFO_KEY, null);
                List<IdeScriptEngineManager.EngineInfo> infos = engineInfo0 != null ? Collections.singletonList(engineInfo0) : JBIterable.from(IdeScriptEngineManager.getInstance().getEngineInfos()).filter(o -> o.fileExtensions.contains(extension2)).toList();
                RunIdeConsoleAction.chooseScriptEngineAndRun(e, infos, selectedInfo -> {
                    this.engineInfo = selectedInfo;
                    RunIdeConsoleAction.executeQuery(project2, virtualFile2, editor2, this.engineInfo);
                });
            } else {
                RunIdeConsoleAction.executeQuery(project2, virtualFile2, editor2, this.engineInfo);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/script/RunIdeConsoleAction$MyRunAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/script/RunIdeConsoleAction$MyRunAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }

    private static final class ConsoleWriter
    extends Writer {
        @NotNull
        private final Reference<? extends RunContentDescriptor> myDescriptor;
        private final Key<?> myOutputType;
        private final AnsiEscapeDecoder myAnsiEscapeDecoder;

        private ConsoleWriter(@NotNull Reference<? extends RunContentDescriptor> descriptor2, Key<?> outputType) {
            if (descriptor2 == null) {
                ConsoleWriter.$$$reportNull$$$0(0);
            }
            this.myDescriptor = descriptor2;
            this.myOutputType = outputType;
            this.myAnsiEscapeDecoder = new AnsiEscapeDecoder();
        }

        @Nullable
        public RunContentDescriptor getDescriptor() {
            return this.myDescriptor.get();
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
            RunContentDescriptor descriptor2 = this.myDescriptor.get();
            ConsoleViewImpl console = ObjectUtils.tryCast(descriptor2 != null ? descriptor2.getExecutionConsole() : null, ConsoleViewImpl.class);
            String text2 = new String(cbuf, off, len);
            if (console == null) {
                LOG.info(this.myOutputType + ": " + text2);
            } else {
                this.myAnsiEscapeDecoder.escapeText(text2, this.myOutputType, (s, attr) -> console.print(s, ConsoleViewContentType.getConsoleViewType((Key)attr)));
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/script/RunIdeConsoleAction$ConsoleWriter", "<init>"));
        }
    }
}

