/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.newStructureView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.structureView.FileEditorPositionListener;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBundle;
import com.intellij.ide.structureView.StructureViewFactory;
import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.customRegions.CustomRegionTreeElement;
import com.intellij.ide.structureView.impl.StructureViewFactoryImpl;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.structureView.newStructureView.TreeActionWrapper;
import com.intellij.ide.structureView.newStructureView.TreeActionsOwner;
import com.intellij.ide.structureView.newStructureView.TreeModelWrapper;
import com.intellij.ide.structureView.symbol.DelegatingPsiElementWithSymbolPointer;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.ide.util.FileStructurePopup;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptorProvidingKey;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.ide.util.treeView.ValidateableNode;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.GroupWrapper;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.ProvidingTreeModel;
import com.intellij.ide.util.treeView.smartTree.SmartTreeStructure;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeAction;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElementWrapper;
import com.intellij.ide.util.treeView.smartTree.TreeModel;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CompositeDataProvider;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.AutoScrollFromSourceHandler;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.PlaceProvider;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.filtered.FilteringTreeStructure;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SingleAlarm;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class StructureViewComponent
extends SimpleToolWindowPanel
implements TreeActionsOwner,
DataProvider,
StructureView {
    private static final Logger LOG = Logger.getInstance(StructureViewComponent.class);
    private static final Key<TreeState> STRUCTURE_VIEW_STATE_KEY = Key.create("STRUCTURE_VIEW_STATE");
    private static final Key<Boolean> STRUCTURE_VIEW_STATE_RESTORED_KEY = Key.create("STRUCTURE_VIEW_STATE_RESTORED_KEY");
    private static final AtomicInteger ourSettingsModificationCount = new AtomicInteger();
    private FileEditor myFileEditor;
    private final TreeModelWrapper myTreeModelWrapper;
    private final Project myProject;
    private final StructureViewModel myTreeModel;
    private final Tree myTree;
    private final SmartTreeStructure myTreeStructure;
    private final StructureTreeModel<SmartTreeStructure> myStructureTreeModel;
    private final AsyncTreeModel myAsyncTreeModel;
    private final SingleAlarm myUpdateAlarm;
    private volatile AsyncPromise<TreePath> myCurrentFocusPromise;
    private boolean myAutoscrollFeedback;
    private volatile boolean myDisposed;
    private boolean myStoreStateDisabled;
    private final Alarm myAutoscrollAlarm;
    private final CopyPasteDelegator myCopyPasteDelegator;
    private final MyAutoScrollToSourceHandler myAutoScrollToSourceHandler;
    private final AutoScrollFromSourceHandler myAutoScrollFromSourceHandler;
    @Nullable
    private volatile CancellablePromise<?> myLastAutoscrollPromise;

    public StructureViewComponent(@Nullable FileEditor editor2, @NotNull StructureViewModel structureViewModel, @NotNull Project project2, boolean showRootNode) {
        if (structureViewModel == null) {
            StructureViewComponent.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            StructureViewComponent.$$$reportNull$$$0(1);
        }
        super(true, true);
        this.myAutoscrollAlarm = new Alarm((Disposable)((Object)this));
        this.myProject = project2;
        this.myFileEditor = editor2;
        this.myTreeModel = structureViewModel;
        this.myTreeModelWrapper = new TreeModelWrapper(this.myTreeModel, this);
        this.myTreeStructure = new SmartTreeStructure(project2, (TreeModel)this.myTreeModelWrapper){

            public void rebuildTree() {
                if (StructureViewComponent.this.isDisposed()) {
                    return;
                }
                super.rebuildTree();
            }

            public boolean isToBuildChildrenInBackground(@NotNull Object element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                return Registry.is("ide.structureView.StructureViewTreeStructure.BuildChildrenInBackground") || this.getRootElement() == element;
            }

            @NotNull
            protected TreeElementWrapper createTree() {
                return new MyNodeWrapper(this.myProject, this.myModel.getRoot(), this.myModel);
            }

            public String toString() {
                return "structure view tree structure(model=" + StructureViewComponent.this.myTreeModel + ")";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/structureView/newStructureView/StructureViewComponent$1", "isToBuildChildrenInBackground"));
            }
        };
        this.myStructureTreeModel = new StructureTreeModel((AbstractTreeStructure)this.myTreeStructure, (Disposable)((Object)this));
        this.myAsyncTreeModel = new AsyncTreeModel(this.myStructureTreeModel, (Disposable)((Object)this));
        this.myTree = new MyTree((javax.swing.tree.TreeModel)this.myAsyncTreeModel);
        Disposer.register((Disposable)((Object)this), (Disposable)((Object)this.myTreeModelWrapper));
        StructureViewComponent.registerAutoExpandListener((JTree)this.myTree, this.myTreeModel);
        this.myUpdateAlarm = new SingleAlarm(this::rebuild, 200, (Disposable)((Object)this));
        this.myTree.setRootVisible(showRootNode);
        this.myTree.getEmptyText().setText(LangBundle.message("status.text.structure.empty", new Object[0]));
        ModelListener modelListener2 = () -> this.queueUpdate();
        this.myTreeModelWrapper.addModelListener(modelListener2);
        Disposer.register((Disposable)((Object)this), () -> {
            this.storeState();
            this.myTreeModelWrapper.removeModelListener(modelListener2);
        });
        this.setContent(ScrollPaneFactory.createScrollPane((Component)this.myTree));
        this.myAutoScrollToSourceHandler = new MyAutoScrollToSourceHandler();
        this.myAutoScrollFromSourceHandler = new MyAutoScrollFromSourceHandler(this.myProject, (Disposable)((Object)this));
        this.myCopyPasteDelegator = new CopyPasteDelegator(this.myProject, (JComponent)this.myTree);
        if (!ExperimentalUI.isNewUI()) {
            this.showToolbar();
        }
        this.setupTree();
    }

    public static void registerAutoExpandListener(@NotNull JTree tree, @NotNull StructureViewModel structureViewModel) {
        if (tree == null) {
            StructureViewComponent.$$$reportNull$$$0(2);
        }
        if (structureViewModel == null) {
            StructureViewComponent.$$$reportNull$$$0(3);
        }
        tree.getModel().addTreeModelListener(new MyExpandListener(tree, ObjectUtils.tryCast(structureViewModel, StructureViewModel.ExpandInfoProvider.class)));
    }

    protected boolean showScrollToFromSourceActions() {
        return true;
    }

    public FileEditor getFileEditor() {
        return this.myFileEditor;
    }

    private StructureViewFactoryImpl.State getSettings() {
        return ((StructureViewFactoryImpl)StructureViewFactory.getInstance((Project)this.myProject)).getState();
    }

    protected final void showToolbar() {
        this.setToolbar(this.createToolbar());
    }

    @NotNull
    private JComponent createToolbar() {
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("StructureViewToolbar", this.createActionGroup(), true);
        toolbar.setTargetComponent((JComponent)this.myTree);
        JComponent jComponent = toolbar.getComponent();
        if (jComponent == null) {
            StructureViewComponent.$$$reportNull$$$0(4);
        }
        return jComponent;
    }

    private void setupTree() {
        this.myTree.setCellRenderer((TreeCellRenderer)new NodeRenderer());
        this.myTree.getSelectionModel().setSelectionMode(4);
        this.myTree.setShowsRootHandles(true);
        StructureViewComponent.registerPsiListener(this.myProject, (Disposable)((Object)this), this::queueUpdate);
        this.myProject.getMessageBus().connect((Disposable)((Object)this)).subscribe(UISettingsListener.TOPIC, o -> this.rebuild());
        if (this.showScrollToFromSourceActions()) {
            this.myAutoScrollToSourceHandler.install((JTree)this.myTree);
            this.myAutoScrollFromSourceHandler.install();
        }
        TreeUtil.installActions((JTree)this.getTree());
        new TreeSpeedSearch(this.getTree(), false, treePath -> {
            Object userObject = TreeUtil.getLastUserObject((TreePath)treePath);
            return userObject != null ? FileStructurePopup.getSpeedSearchText(userObject) : null;
        });
        this.addTreeKeyListener();
        this.addTreeMouseListeners();
        this.restoreState();
    }

    public static void registerPsiListener(@NotNull Project project2, @NotNull Disposable disposable, @NotNull Runnable onChange) {
        if (project2 == null) {
            StructureViewComponent.$$$reportNull$$$0(5);
        }
        if (disposable == null) {
            StructureViewComponent.$$$reportNull$$$0(6);
        }
        if (onChange == null) {
            StructureViewComponent.$$$reportNull$$$0(7);
        }
        MyPsiTreeChangeListener psiListener = new MyPsiTreeChangeListener(PsiManager.getInstance(project2).getModificationTracker(), onChange);
        PsiManager.getInstance(project2).addPsiTreeChangeListener(psiListener, disposable);
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            StructureViewComponent.$$$reportNull$$$0(8);
        }
        return project2;
    }

    @NotNull
    public JTree getTree() {
        Tree tree = this.myTree;
        if (tree == null) {
            StructureViewComponent.$$$reportNull$$$0(9);
        }
        return tree;
    }

    public void queueUpdate() {
        this.myUpdateAlarm.cancelAndRequest();
    }

    public void rebuild() {
        this.myStructureTreeModel.getInvoker().invoke(() -> {
            ComponentUtil.putClientProperty((JComponent)this.myTree, STRUCTURE_VIEW_STATE_RESTORED_KEY, null);
            this.myTreeStructure.rebuildTree();
            this.myStructureTreeModel.invalidateAsync();
        });
    }

    @NotNull
    private static JBTreeTraverser<Object> traverser() {
        JBTreeTraverser<Object> jBTreeTraverser = JBTreeTraverser.from(o -> o instanceof Group ? ((Group)o).getChildren() : null);
        if (jBTreeTraverser == null) {
            StructureViewComponent.$$$reportNull$$$0(10);
        }
        return jBTreeTraverser;
    }

    @NotNull
    public static JBIterable<Object> getSelectedValues(@NotNull JBIterable<Object> selection) {
        if (selection == null) {
            StructureViewComponent.$$$reportNull$$$0(11);
        }
        JBIterable<Object> jBIterable = ((JBTreeTraverser)StructureViewComponent.traverser().withRoots((Iterable<Object>)selection.filterMap(StructureViewComponent::unwrapValue))).traverse();
        if (jBIterable == null) {
            StructureViewComponent.$$$reportNull$$$0(12);
        }
        return jBIterable;
    }

    private void addTreeMouseListeners() {
        EditSourceOnDoubleClickHandler.install((JTree)this.getTree());
        this.installTreePopupHandlers();
    }

    protected void installTreePopupHandlers() {
        CustomizationUtil.installPopupHandler((JComponent)this.getTree(), (String)"StructureViewPopupMenu", (String)"StructureViewPopup");
    }

    private void addTreeKeyListener() {
        EditSourceOnEnterKeyHandler.install((JTree)this.getTree());
        this.getTree().addKeyListener(new PsiCopyPasteManager.EscapeHandler());
    }

    public void storeState() {
        if (this.isDisposed() || !this.myProject.isOpen() || this.myStoreStateDisabled) {
            return;
        }
        Object root = this.myTree.getModel().getRoot();
        if (root == null) {
            return;
        }
        TreeState state = TreeState.createOn((JTree)this.myTree, (TreePath)new TreePath(root));
        if (this.myFileEditor != null) {
            this.myFileEditor.putUserData(STRUCTURE_VIEW_STATE_KEY, (Object)state);
        }
        ComponentUtil.putClientProperty((JComponent)this.myTree, STRUCTURE_VIEW_STATE_RESTORED_KEY, null);
    }

    public void disableStoreState() {
        this.myStoreStateDisabled = true;
    }

    public void restoreState() {
        TreeState state;
        FileEditor editor2 = this.myFileEditor;
        TreeState treeState = state = editor2 == null ? null : (TreeState)editor2.getUserData(STRUCTURE_VIEW_STATE_KEY);
        if (state == null) {
            if (!Boolean.TRUE.equals(ComponentUtil.getClientProperty((JComponent)this.myTree, STRUCTURE_VIEW_STATE_RESTORED_KEY))) {
                TreeUtil.expand((JTree)this.getTree(), (int)StructureViewComponent.getMinimumExpandDepth(this.myTreeModel));
            }
        } else {
            ComponentUtil.putClientProperty((JComponent)this.myTree, STRUCTURE_VIEW_STATE_RESTORED_KEY, true);
            state.applyTo((JTree)this.myTree);
            editor2.putUserData(STRUCTURE_VIEW_STATE_KEY, null);
        }
    }

    @NotNull
    protected ActionGroup createActionGroup() {
        DefaultActionGroup result2 = new DefaultActionGroup();
        List<AnAction> sorters = this.getSortActions();
        if (!sorters.isEmpty()) {
            result2.addAll(sorters);
            result2.addSeparator();
        }
        this.addGroupByActions(result2);
        result2.addAll(this.getFilterActions());
        if (this.showScrollToFromSourceActions()) {
            result2.addSeparator();
            result2.addAll(this.addNavigationActions());
        }
        DefaultActionGroup defaultActionGroup = result2;
        if (defaultActionGroup == null) {
            StructureViewComponent.$$$reportNull$$$0(13);
        }
        return defaultActionGroup;
    }

    @ApiStatus.Internal
    public final DefaultActionGroup getDotsActions() {
        DefaultActionGroup result2 = new DefaultActionGroup();
        result2.addAll(this.addExpandCollapseActions());
        List<AnAction> navigationActions = this.addNavigationActions();
        if (!navigationActions.isEmpty()) {
            result2.addSeparator();
            result2.addAll(navigationActions);
        }
        return result2;
    }

    @ApiStatus.Internal
    public final DefaultActionGroup getViewActions() {
        DefaultActionGroup result2 = new DefaultActionGroup(IdeBundle.message((String)"group.view.options", (Object[])new Object[0]), null, AllIcons.Actions.GroupBy);
        result2.setPopup(true);
        result2.addSeparator(StructureViewBundle.message((String)"structureview.subgroup.sort", (Object[])new Object[0]));
        result2.addAll(StructureViewComponent.sortActionsByName(this.getSortActions()));
        result2.addSeparator(StructureViewBundle.message((String)"structureview.subgroup.filter", (Object[])new Object[0]));
        result2.addAll(StructureViewComponent.sortActionsByName(this.getFilterActions()));
        result2.addSeparator(StructureViewBundle.message((String)"structureview.subgroup.group", (Object[])new Object[0]));
        this.addGroupByActions(result2);
        return result2;
    }

    @NotNull
    private List<AnAction> getSortActions() {
        Sorter[] sorters;
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        for (Sorter sorter : sorters = this.myTreeModel.getSorters()) {
            if (!sorter.isVisible()) continue;
            result2.add((AnAction)new TreeActionWrapper((TreeAction)sorter, this));
        }
        ArrayList<AnAction> arrayList = result2;
        if (arrayList == null) {
            StructureViewComponent.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    private List<AnAction> getFilterActions() {
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        for (Filter filter2 : this.myTreeModel.getFilters()) {
            result2.add((AnAction)new TreeActionWrapper((TreeAction)filter2, this));
        }
        if (this.myTreeModel instanceof ProvidingTreeModel) {
            for (NodeProvider provider2 : ((ProvidingTreeModel)this.myTreeModel).getNodeProviders()) {
                result2.add((AnAction)new TreeActionWrapper((TreeAction)provider2, this));
            }
        }
        ArrayList<AnAction> arrayList = result2;
        if (arrayList == null) {
            StructureViewComponent.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    private List<AnAction> addNavigationActions() {
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        if (this.showScrollToFromSourceActions()) {
            result2.add((AnAction)this.myAutoScrollToSourceHandler.createToggleAction());
            result2.add((AnAction)this.myAutoScrollFromSourceHandler.createToggleAction());
        }
        ArrayList<AnAction> arrayList = result2;
        if (arrayList == null) {
            StructureViewComponent.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @ApiStatus.Internal
    @NotNull
    public final List<AnAction> addExpandCollapseActions() {
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        CommonActionsManager commonActionManager = CommonActionsManager.getInstance();
        result2.add(commonActionManager.createExpandAllHeaderAction(this.getTree()));
        result2.add(commonActionManager.createCollapseAllHeaderAction(this.getTree()));
        ArrayList<AnAction> arrayList = result2;
        if (arrayList == null) {
            StructureViewComponent.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    protected void addGroupByActions(@NotNull DefaultActionGroup result2) {
        if (result2 == null) {
            StructureViewComponent.$$$reportNull$$$0(18);
        }
        Grouper[] groupers = this.myTreeModel.getGroupers();
        ArrayList<AnAction> groupActions = new ArrayList<AnAction>();
        for (Grouper grouper : groupers) {
            groupActions.add((AnAction)new TreeActionWrapper((TreeAction)grouper, this));
        }
        result2.addAll(StructureViewComponent.sortActionsByName(groupActions));
    }

    @NotNull
    public Promise<TreePath> select(Object element, boolean requestFocus) {
        return this.expandSelectFocusInner(element, true, requestFocus);
    }

    @NotNull
    private Promise<TreePath> expandSelectFocusInner(Object element, boolean select2, boolean requestFocus) {
        final AsyncPromise result2 = this.myCurrentFocusPromise = new AsyncPromise();
        final int[] stage = new int[]{1, 0};
        final TreePath[] deepestPath = new TreePath[]{null};
        final TreeVisitor visitor2 = path2 -> {
            if (this.myCurrentFocusPromise != result2) {
                result2.setError("rejected");
                return TreeVisitor.Action.INTERRUPT;
            }
            Object last2 = path2.getLastPathComponent();
            Object userObject = StructureViewComponent.unwrapNavigatable(last2);
            Object value = StructureViewComponent.unwrapValue(last2);
            if (Comparing.equal(value, element) || userObject instanceof AbstractTreeNode && ((AbstractTreeNode)userObject).canRepresent(element)) {
                return TreeVisitor.Action.INTERRUPT;
            }
            if (value instanceof PsiElement && element instanceof PsiElement) {
                if (PsiTreeUtil.isAncestor((PsiElement)value, (PsiElement)element, true)) {
                    int count2 = path2.getPathCount();
                    if (stage[1] == 0 || stage[1] < count2) {
                        stage[1] = count2;
                        deepestPath[0] = path2;
                    }
                } else if (stage[0] != 3) {
                    stage[0] = 2;
                    return TreeVisitor.Action.SKIP_CHILDREN;
                }
            }
            return TreeVisitor.Action.CONTINUE;
        };
        final Function<TreePath, Promise> action2 = path2 -> {
            if (select2) {
                TreeUtil.selectPath((JTree)this.myTree, (TreePath)path2);
            } else {
                this.myTree.expandPath(path2);
            }
            if (requestFocus) {
                IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myTree, false);
            }
            return Promises.resolvedPromise((Object)path2);
        };
        Function<TreePath, Promise<TreePath>> fallback = new Function<TreePath, Promise<TreePath>>(){

            @Override
            public Promise<TreePath> fun(TreePath path2) {
                if (StructureViewComponent.this.myCurrentFocusPromise != result2) {
                    result2.setError("rejected");
                    return Promises.rejectedPromise();
                }
                if (path2 == null && stage[0] == 2) {
                    stage[0] = 3;
                    return StructureViewComponent.this.myAsyncTreeModel.accept(visitor2).thenAsync(this);
                }
                TreePath adjusted = path2 == null ? deepestPath[0] : path2;
                return adjusted == null ? Promises.rejectedPromise() : (Promise)action2.fun(adjusted);
            }
        };
        this.myAsyncTreeModel.accept(visitor2).thenAsync(fallback).processed((Promise<TreePath>)result2);
        AsyncPromise<TreePath> asyncPromise = this.myCurrentFocusPromise;
        if (asyncPromise == null) {
            StructureViewComponent.$$$reportNull$$$0(19);
        }
        return asyncPromise;
    }

    private void scrollToSelectedElement() {
        if (this.myAutoscrollFeedback) {
            this.myAutoscrollFeedback = false;
            return;
        }
        if (!this.getSettings().AUTOSCROLL_FROM_SOURCE) {
            return;
        }
        this.cancelScrollToSelectedElement();
        this.myAutoscrollAlarm.cancelAllRequests();
        this.myAutoscrollAlarm.addRequest(this::scrollToSelectedElementLater, 1000);
    }

    private void cancelScrollToSelectedElement() {
        CancellablePromise<?> lastPromise = this.myLastAutoscrollPromise;
        if (lastPromise != null && !lastPromise.isCancelled()) {
            lastPromise.cancel();
        }
    }

    private void scrollToSelectedElementLater() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.cancelScrollToSelectedElement();
        if (this.isDisposed()) {
            return;
        }
        this.myLastAutoscrollPromise = ReadAction.nonBlocking(this::doFindSelectedElement).withDocumentsCommitted(this.myProject).expireWith((Disposable)((Object)this)).finishOnUiThread(ModalityState.current(), this::doScrollToSelectedElement).submit(AppExecutorUtil.getAppExecutorService());
    }

    @Nullable
    private Object doFindSelectedElement() {
        try {
            return this.myTreeModel.getCurrentEditorElement();
        }
        catch (IndexNotReadyException indexNotReadyException) {
            return null;
        }
    }

    private void doScrollToSelectedElement(@Nullable Object currentEditorElement) {
        if (currentEditorElement == null) {
            return;
        }
        if (UIUtil.isFocusAncestor((Component)((Object)this))) {
            return;
        }
        this.select(currentEditorElement, false);
    }

    public void dispose() {
        LOG.assertTrue(EventQueue.isDispatchThread(), Thread.currentThread().getName());
        this.myDisposed = true;
        this.myFileEditor = null;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public void centerSelectedRow() {
        TreePath path2 = this.getTree().getSelectionPath();
        if (path2 == null) {
            return;
        }
        this.myAutoScrollToSourceHandler.setShouldAutoScroll(false);
        TreeUtil.showRowCentered((JTree)this.getTree(), (int)this.getTree().getRowForPath(path2), (boolean)false);
        this.myAutoScrollToSourceHandler.setShouldAutoScroll(true);
    }

    @Override
    public void setActionActive(String name, boolean state) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.storeState();
        StructureViewFactoryEx.getInstanceEx((Project)this.myProject).setActiveAction(name, state);
        ourSettingsModificationCount.incrementAndGet();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.waitForRebuildAndExpand();
        } else {
            this.rebuild();
            TreeUtil.expand((JTree)this.getTree(), (int)StructureViewComponent.getMinimumExpandDepth(this.myTreeModel));
        }
    }

    private void waitForRebuildAndExpand() {
        StructureViewComponent.wait(this.rebuildAndUpdate());
        UIUtil.dispatchAllInvocationEvents();
        StructureViewComponent.wait(TreeUtil.promiseExpand((JTree)this.getTree(), (int)StructureViewComponent.getMinimumExpandDepth(this.myTreeModel)));
    }

    private static void wait(Promise<?> originPromise) {
        AtomicBoolean complete = new AtomicBoolean(false);
        Promise<Object> promise = originPromise.onProcessed(ignore -> complete.set(true));
        while (!complete.get()) {
            UIUtil.dispatchAllInvocationEvents();
            try {
                promise.blockingGet(10, TimeUnit.MILLISECONDS);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean isActionActive(String name) {
        return !this.myProject.isDisposed() && StructureViewFactoryEx.getInstanceEx((Project)this.myProject).isActionActive(name);
    }

    public static void clearStructureViewState(Project project2) {
        for (FileEditor editor2 : FileEditorManager.getInstance(project2).getAllEditors()) {
            editor2.putUserData(STRUCTURE_VIEW_STATE_KEY, null);
        }
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            StructureViewComponent.$$$reportNull$$$0(20);
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (PlatformCoreDataKeys.FILE_EDITOR.is(dataId)) {
            return this.myFileEditor;
        }
        if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getCutProvider();
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getCopyProvider();
        }
        if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getPasteProvider();
        }
        if (PlatformCoreDataKeys.BGT_DATA_PROVIDER.is(dataId)) {
            DataProvider superProvider = (DataProvider)super.getData(dataId);
            JBIterable<Object> selection = JBIterable.of(this.getTree().getSelectionPaths()).map(TreePath::getLastPathComponent);
            return CompositeDataProvider.compose(slowId -> StructureViewComponent.getSlowData(slowId, selection), (DataProvider)superProvider);
        }
        if (PlatformCoreDataKeys.HELP_ID.is(dataId)) {
            return this.getHelpID();
        }
        return super.getData(dataId);
    }

    private static Object getSlowData(String dataId, JBIterable<Object> selection) {
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            PsiElement element = StructureViewComponent.getSelectedValues(selection).filter(PsiElement.class).single();
            return element != null && element.isValid() ? element : null;
        }
        if (PlatformCoreDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            return PsiUtilCore.toPsiElementArray(StructureViewComponent.getSelectedValues(selection).filter(PsiElement.class).toList());
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            Object[] selectedElements;
            List<Object> list2 = selection.map(StructureViewComponent::unwrapNavigatable).toList();
            Object[] objectArray = selectedElements = list2.isEmpty() ? null : ArrayUtil.toObjectArray(list2);
            if (selectedElements == null || selectedElements.length == 0) {
                return null;
            }
            if (selectedElements[0] instanceof Navigatable) {
                return selectedElements[0];
            }
        }
        if (CommonDataKeys.SYMBOLS.is(dataId)) {
            return StructureViewComponent.getSelectedValues(selection).filter(DelegatingPsiElementWithSymbolPointer.class).filterMap(it -> it.getSymbolPointer().dereference()).toList();
        }
        return null;
    }

    @NotNull
    public StructureViewModel getTreeModel() {
        StructureViewModel structureViewModel = this.myTreeModel;
        if (structureViewModel == null) {
            StructureViewComponent.$$$reportNull$$$0(21);
        }
        return structureViewModel;
    }

    public boolean navigateToSelectedElement(boolean requestFocus) {
        this.select(this.myTreeModel.getCurrentEditorElement(), requestFocus);
        return true;
    }

    @TestOnly
    public AsyncPromise<Void> rebuildAndUpdate() {
        AsyncPromise result2 = new AsyncPromise();
        this.rebuild();
        TreeVisitor visitor2 = path2 -> {
            AbstractTreeNode node2 = (AbstractTreeNode)TreeUtil.getLastUserObject(AbstractTreeNode.class, (TreePath)path2);
            if (node2 != null) {
                node2.update();
            }
            return TreeVisitor.Action.CONTINUE;
        };
        this.myAsyncTreeModel.accept(visitor2).onProcessed(ignore -> result2.setResult(null));
        return result2;
    }

    public String getHelpID() {
        return "viewingStructure.fileStructureView";
    }

    private static int getMinimumExpandDepth(@NotNull StructureViewModel structureViewModel) {
        StructureViewModel.ExpandInfoProvider provider2;
        if (structureViewModel == null) {
            StructureViewComponent.$$$reportNull$$$0(22);
        }
        return (provider2 = ObjectUtils.tryCast(structureViewModel, StructureViewModel.ExpandInfoProvider.class)) == null ? 2 : provider2.getMinimumAutoExpandDepth();
    }

    public static Object unwrapValue(Object o) {
        return StructureViewComponent.unwrapElement(StructureViewComponent.unwrapWrapper(o));
    }

    @Nullable
    public static Object unwrapNavigatable(Object o) {
        Object p = TreeUtil.getUserObject((Object)o);
        return p instanceof FilteringTreeStructure.FilteringNode ? ((FilteringTreeStructure.FilteringNode)p).getDelegate() : p;
    }

    public static Object unwrapWrapper(Object o) {
        Object object;
        Object p = StructureViewComponent.unwrapNavigatable(o);
        if (p instanceof MyNodeWrapper) {
            MyNodeWrapper nodeWrapper = (MyNodeWrapper)((Object)p);
            object = nodeWrapper.getValue();
        } else if (p instanceof MyGroupWrapper) {
            MyGroupWrapper groupWrapper = (MyGroupWrapper)((Object)p);
            object = groupWrapper.getValue();
        } else {
            object = p;
        }
        return object;
    }

    private static Object unwrapElement(Object o) {
        return o instanceof StructureViewTreeElement ? ((StructureViewTreeElement)o).getValue() : o;
    }

    @NotNull
    public static TreeElementWrapper createWrapper(@NotNull Project project2, @NotNull TreeElement value, TreeModel treeModel) {
        if (project2 == null) {
            StructureViewComponent.$$$reportNull$$$0(23);
        }
        if (value == null) {
            StructureViewComponent.$$$reportNull$$$0(24);
        }
        return new MyNodeWrapper(project2, value, treeModel);
    }

    @NotNull
    private static List<AnAction> sortActionsByName(@NotNull List<AnAction> actions) {
        if (actions == null) {
            StructureViewComponent.$$$reportNull$$$0(25);
        }
        actions.sort(Comparator.comparing(action2 -> action2.getTemplateText()));
        List<AnAction> list2 = actions;
        if (list2 == null) {
            StructureViewComponent.$$$reportNull$$$0(26);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 8, 9, 10, 12, 13, 14, 15, 16, 17, 19, 21, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structureViewModel";
                break;
            }
            case 1: 
            case 5: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/structureView/newStructureView/StructureViewComponent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onChange";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/structureView/newStructureView/StructureViewComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "traverser";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedValues";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionGroup";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortActions";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterActions";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "addNavigationActions";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "addExpandCollapseActions";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "expandSelectFocusInner";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeModel";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "sortActionsByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerAutoExpandListener";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 26: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerPsiListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedValues";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addGroupByActions";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getMinimumExpandDepth";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createWrapper";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "sortActionsByName";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 8, 9, 10, 12, 13, 14, 15, 16, 17, 19, 21, 26 -> new IllegalStateException(string2);
        };
    }

    private static class MyTree
    extends DnDAwareTree
    implements PlaceProvider {
        MyTree(javax.swing.tree.TreeModel model2) {
            super(model2);
            HintUpdateSupply.installDataContextHintUpdateSupply((JComponent)((Object)this));
        }

        public String getPlace() {
            return "StructureViewToolbar";
        }

        public void processMouseEvent(MouseEvent event) {
            if (event.getID() == 501) {
                this.requestFocus();
            }
            super.processMouseEvent(event);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = super.getAccessibleContext();
                this.accessibleContext.setAccessibleName(IdeBundle.message((String)"structure.view.tree.accessible.name", (Object[])new Object[0]));
            }
            return this.accessibleContext;
        }
    }

    private final class MyAutoScrollToSourceHandler
    extends AutoScrollToSourceHandler {
        private boolean myShouldAutoScroll = true;

        private MyAutoScrollToSourceHandler() {
        }

        void setShouldAutoScroll(boolean shouldAutoScroll) {
            this.myShouldAutoScroll = shouldAutoScroll;
        }

        protected boolean isAutoScrollMode() {
            return this.myShouldAutoScroll && !StructureViewComponent.this.myProject.isDisposed() && StructureViewComponent.this.getSettings().AUTOSCROLL_MODE;
        }

        protected void setAutoScrollMode(boolean state) {
            StructureViewComponent.this.getSettings().AUTOSCROLL_MODE = state;
        }

        @RequiresEdt
        protected void scrollToSource(@NotNull Component tree) {
            if (tree == null) {
                MyAutoScrollToSourceHandler.$$$reportNull$$$0(0);
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (StructureViewComponent.this.isDisposed()) {
                return;
            }
            StructureViewComponent.this.myAutoscrollFeedback = true;
            Navigatable navigatable = (Navigatable)CommonDataKeys.NAVIGATABLE.getData(DataManager.getInstance().getDataContext((Component)StructureViewComponent.this.getTree()));
            if (StructureViewComponent.this.myFileEditor != null && navigatable != null && navigatable.canNavigateToSource()) {
                navigatable.navigate(false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ide/structureView/newStructureView/StructureViewComponent$MyAutoScrollToSourceHandler", "scrollToSource"));
        }
    }

    private final class MyAutoScrollFromSourceHandler
    extends AutoScrollFromSourceHandler
    implements Disposable {
        private FileEditorPositionListener myFileEditorPositionListener;

        private MyAutoScrollFromSourceHandler(@NotNull Project project2, Disposable parentDisposable) {
            if (parentDisposable == null) {
                MyAutoScrollFromSourceHandler.$$$reportNull$$$0(0);
            }
            super(project2, (JComponent)StructureViewComponent.this.getTree(), parentDisposable);
            Disposer.register(parentDisposable, this);
        }

        protected void selectElementFromEditor(@NotNull FileEditor editor2) {
            if (editor2 == null) {
                MyAutoScrollFromSourceHandler.$$$reportNull$$$0(1);
            }
        }

        public void install() {
            this.addEditorCaretListener();
        }

        @Override
        public void dispose() {
            if (this.myFileEditorPositionListener != null) {
                StructureViewComponent.this.myTreeModel.removeEditorPositionListener(this.myFileEditorPositionListener);
            }
        }

        private void addEditorCaretListener() {
            this.myFileEditorPositionListener = () -> StructureViewComponent.this.scrollToSelectedElement();
            StructureViewComponent.this.myTreeModel.addEditorPositionListener(this.myFileEditorPositionListener);
            if (this.isAutoScrollEnabled()) {
                StructureViewComponent.this.scrollToSelectedElement();
            }
        }

        protected boolean isAutoScrollEnabled() {
            return StructureViewComponent.this.getSettings().AUTOSCROLL_FROM_SOURCE;
        }

        protected void setAutoScrollEnabled(boolean state) {
            StructureViewComponent.this.getSettings().AUTOSCROLL_FROM_SOURCE = state;
            FileEditor[] selectedEditors = FileEditorManager.getInstance(this.myProject).getSelectedEditors();
            if (selectedEditors.length > 0 && state) {
                StructureViewComponent.this.scrollToSelectedElementLater();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/structureView/newStructureView/StructureViewComponent$MyAutoScrollFromSourceHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectElementFromEditor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyExpandListener
    extends TreeModelAdapter {
        private static final RegistryValue autoExpandDepth = Registry.get("ide.tree.autoExpandMaxDepth");
        private final JTree tree;
        final StructureViewModel.ExpandInfoProvider provider;
        final boolean smartExpand;

        MyExpandListener(@NotNull JTree tree, @Nullable StructureViewModel.ExpandInfoProvider provider2) {
            if (tree == null) {
                MyExpandListener.$$$reportNull$$$0(0);
            }
            this.tree = tree;
            this.provider = provider2;
            this.smartExpand = provider2 != null && provider2.isSmartExpand();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            TreePath parentPath = e.getTreePath();
            if (Boolean.TRUE.equals(ComponentUtil.getClientProperty(this.tree, STRUCTURE_VIEW_STATE_RESTORED_KEY))) {
                return;
            }
            if (parentPath == null || parentPath.getPathCount() > autoExpandDepth.asInteger() - 1) {
                return;
            }
            Object[] children2 = e.getChildren();
            if (this.smartExpand && children2.length == 1) {
                this.expandLater(parentPath, children2[0]);
            } else {
                for (Object o : children2) {
                    NodeDescriptor descriptor2 = (NodeDescriptor)TreeUtil.getUserObject(NodeDescriptor.class, (Object)o);
                    if (descriptor2 == null || !this.isAutoExpandNode(descriptor2)) continue;
                    this.expandLater(parentPath, o);
                }
            }
        }

        void expandLater(@NotNull TreePath parentPath, @NotNull Object o) {
            if (parentPath == null) {
                MyExpandListener.$$$reportNull$$$0(1);
            }
            if (o == null) {
                MyExpandListener.$$$reportNull$$$0(2);
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!this.tree.isVisible(parentPath) || !this.tree.isExpanded(parentPath)) {
                    return;
                }
                this.tree.expandPath(parentPath.pathByAddingChild(o));
            });
        }

        boolean isAutoExpandNode(NodeDescriptor<?> nodeDescriptor) {
            NodeDescriptor parent2;
            if (this.provider != null) {
                Object value = StructureViewComponent.unwrapWrapper(nodeDescriptor.getElement());
                if (value instanceof CustomRegionTreeElement) {
                    return true;
                }
                if (value instanceof StructureViewTreeElement) {
                    return this.provider.isAutoExpand((StructureViewTreeElement)value);
                }
                if (value instanceof GroupWrapper) {
                    Group group2 = Objects.requireNonNull((Group)((GroupWrapper)value).getValue());
                    for (TreeElement treeElement : group2.getChildren()) {
                        if (!(treeElement instanceof StructureViewTreeElement) || this.provider.isAutoExpand((StructureViewTreeElement)treeElement)) continue;
                        return false;
                    }
                }
            }
            return (parent2 = nodeDescriptor.getParentDescriptor()) == null || parent2.getParentDescriptor() == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentPath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/structureView/newStructureView/StructureViewComponent$MyExpandListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "expandLater";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyPsiTreeChangeListener
    extends PsiTreeChangeAdapter {
        final PsiModificationTracker modTracker;
        long prevModCount;
        final Runnable onChange;

        private MyPsiTreeChangeListener(PsiModificationTracker modTracker, Runnable onChange) {
            this.modTracker = modTracker;
            this.onChange = onChange;
            this.prevModCount = modTracker.getModificationCount();
        }

        @Override
        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            PsiElement child;
            if (event == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(0);
            }
            if ((child = event.getOldChild()) instanceof PsiWhiteSpace) {
                return;
            }
            this.childrenChanged();
        }

        @Override
        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            PsiElement child;
            if (event == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(1);
            }
            if ((child = event.getNewChild()) instanceof PsiWhiteSpace) {
                return;
            }
            this.childrenChanged();
        }

        @Override
        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(2);
            }
            PsiElement oldChild = event.getOldChild();
            PsiElement newChild = event.getNewChild();
            if (oldChild instanceof PsiWhiteSpace && newChild instanceof PsiWhiteSpace) {
                return;
            }
            this.childrenChanged();
        }

        @Override
        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(3);
            }
            this.childrenChanged();
        }

        @Override
        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(4);
            }
            this.childrenChanged();
        }

        private void childrenChanged() {
            long newModificationCount = this.modTracker.getModificationCount();
            if (newModificationCount == this.prevModCount) {
                return;
            }
            this.prevModCount = newModificationCount;
            this.onChange.run();
        }

        @Override
        public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(5);
            }
            this.childrenChanged();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/ide/structureView/newStructureView/StructureViewComponent$MyPsiTreeChangeListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childRemoved";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childAdded";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childReplaced";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childMoved";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childrenChanged";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyNodeWrapper
    extends TreeElementWrapper
    implements NodeDescriptorProvidingKey,
    ValidateableNode {
        private long childrenStamp;
        private int modificationCountForChildren;

        MyNodeWrapper(Project project2, @NotNull TreeElement value, @NotNull TreeModel treeModel) {
            if (value == null) {
                MyNodeWrapper.$$$reportNull$$$0(0);
            }
            if (treeModel == null) {
                MyNodeWrapper.$$$reportNull$$$0(1);
            }
            super(project2, value, treeModel);
            this.childrenStamp = -1L;
            this.modificationCountForChildren = ourSettingsModificationCount.get();
        }

        public FileStatus getFileStatus() {
            Object object = this.myTreeModel;
            if (object instanceof StructureViewModel) {
                StructureViewModel model2 = (StructureViewModel)object;
                object = this.getValue();
                if (object instanceof StructureViewTreeElement) {
                    StructureViewTreeElement value = (StructureViewTreeElement)object;
                    return model2.getElementStatus(value.getValue());
                }
            }
            return FileStatus.NOT_CHANGED;
        }

        @NotNull
        public Object getKey() {
            StructureViewTreeElement element = (StructureViewTreeElement)this.getValue();
            if (element instanceof NodeDescriptorProvidingKey) {
                Object object = ((NodeDescriptorProvidingKey)element).getKey();
                if (object == null) {
                    MyNodeWrapper.$$$reportNull$$$0(2);
                }
                return object;
            }
            Object value = element == null ? null : element.getValue();
            Object object = value == null ? this : value;
            if (object == null) {
                MyNodeWrapper.$$$reportNull$$$0(3);
            }
            return object;
        }

        @NotNull
        public Collection<AbstractTreeNode<?>> getChildren() {
            if (ourSettingsModificationCount.get() != this.modificationCountForChildren) {
                this.resetChildren();
                this.modificationCountForChildren = ourSettingsModificationCount.get();
            }
            Object o = StructureViewComponent.unwrapElement(this.getValue());
            long currentStamp = -1L;
            if (o instanceof PsiElement) {
                if (!((PsiElement)o).isValid()) {
                    List<AbstractTreeNode<?>> list2 = Collections.emptyList();
                    if (list2 == null) {
                        MyNodeWrapper.$$$reportNull$$$0(4);
                    }
                    return list2;
                }
                PsiFile file2 = ((PsiElement)o).getContainingFile();
                if (file2 != null) {
                    currentStamp = file2.getModificationStamp();
                }
            } else if (o instanceof ModificationTracker) {
                currentStamp = ((ModificationTracker)o).getModificationCount();
            }
            if (this.childrenStamp != currentStamp) {
                this.resetChildren();
                this.childrenStamp = currentStamp;
            }
            Collection collection = super.getChildren();
            if (collection == null) {
                MyNodeWrapper.$$$reportNull$$$0(5);
            }
            return collection;
        }

        public boolean isAlwaysShowPlus() {
            StructureViewModel.ElementInfoProvider elementInfoProvider = this.getElementInfoProvider();
            return elementInfoProvider == null || elementInfoProvider.isAlwaysShowsPlus((StructureViewTreeElement)this.getValue());
        }

        public boolean isAlwaysLeaf() {
            StructureViewModel.ElementInfoProvider elementInfoProvider = this.getElementInfoProvider();
            return elementInfoProvider != null && elementInfoProvider.isAlwaysLeaf((StructureViewTreeElement)this.getValue());
        }

        @Nullable
        private StructureViewModel.ElementInfoProvider getElementInfoProvider() {
            StructureViewModel model2;
            if (this.myTreeModel instanceof StructureViewModel.ElementInfoProvider) {
                return (StructureViewModel.ElementInfoProvider)this.myTreeModel;
            }
            if (this.myTreeModel instanceof TreeModelWrapper && (model2 = ((TreeModelWrapper)this.myTreeModel).getModel()) instanceof StructureViewModel.ElementInfoProvider) {
                return (StructureViewModel.ElementInfoProvider)model2;
            }
            return null;
        }

        @NotNull
        protected TreeElementWrapper createChildNode(@NotNull TreeElement child) {
            if (child == null) {
                MyNodeWrapper.$$$reportNull$$$0(6);
            }
            return new MyNodeWrapper(this.myProject, child, this.myTreeModel);
        }

        @NotNull
        protected GroupWrapper createGroupWrapper(Project project2, @NotNull Group group2, @NotNull TreeModel treeModel) {
            if (group2 == null) {
                MyNodeWrapper.$$$reportNull$$$0(7);
            }
            if (treeModel == null) {
                MyNodeWrapper.$$$reportNull$$$0(8);
            }
            return new MyGroupWrapper(project2, group2, treeModel);
        }

        public boolean equals(Object o) {
            if (o instanceof MyNodeWrapper) {
                return Comparing.equal(StructureViewComponent.unwrapElement(this.getValue()), StructureViewComponent.unwrapElement(((MyNodeWrapper)((Object)o)).getValue()));
            }
            if (o instanceof StructureViewTreeElement) {
                return Comparing.equal(StructureViewComponent.unwrapElement(this.getValue()), ((StructureViewTreeElement)o).getValue());
            }
            return false;
        }

        public boolean isValid() {
            PsiTreeElementBase treeElementBase;
            TreeElement value = (TreeElement)this.getValue();
            return !(value instanceof PsiTreeElementBase) || (treeElementBase = (PsiTreeElementBase)value).isValid();
        }

        public int hashCode() {
            Object o = StructureViewComponent.unwrapElement(this.getValue());
            return o != null ? o.hashCode() : 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treeModel";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/structureView/newStructureView/StructureViewComponent$MyNodeWrapper";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/structureView/newStructureView/StructureViewComponent$MyNodeWrapper";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKey";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createChildNode";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createGroupWrapper";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 3, 4, 5 -> new IllegalStateException(string2);
            };
        }
    }

    private static class MyGroupWrapper
    extends GroupWrapper {
        MyGroupWrapper(Project project2, @NotNull Group group2, @NotNull TreeModel treeModel) {
            if (group2 == null) {
                MyGroupWrapper.$$$reportNull$$$0(0);
            }
            if (treeModel == null) {
                MyGroupWrapper.$$$reportNull$$$0(1);
            }
            super(project2, group2, treeModel);
        }

        @NotNull
        protected TreeElementWrapper createChildNode(@NotNull TreeElement child) {
            if (child == null) {
                MyGroupWrapper.$$$reportNull$$$0(2);
            }
            return new MyNodeWrapper(this.getProject(), child, this.myTreeModel);
        }

        @NotNull
        protected GroupWrapper createGroupWrapper(Project project2, @NotNull Group group2, @NotNull TreeModel treeModel) {
            if (group2 == null) {
                MyGroupWrapper.$$$reportNull$$$0(3);
            }
            if (treeModel == null) {
                MyGroupWrapper.$$$reportNull$$$0(4);
            }
            return new MyGroupWrapper(project2, group2, treeModel);
        }

        public boolean isAlwaysShowPlus() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treeModel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/structureView/newStructureView/StructureViewComponent$MyGroupWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createChildNode";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createGroupWrapper";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

