/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.tags;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ColoredText;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class TagManager {
    @NotNull
    public static TagManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            TagManager.$$$reportNull$$$0(0);
        }
        TagManager tagManager = project2.getService(TagManager.class);
        if (tagManager == null) {
            TagManager.$$$reportNull$$$0(1);
        }
        return tagManager;
    }

    public static boolean isEnabled() {
        return Registry.is("ide.element.tags.enabled");
    }

    public static Pair<@Nullable Icon, @NotNull ColoredText> getTagIconAndText(@Nullable PsiElement element) {
        Collection<Tag> tags = TagManager.getElementTags(element);
        ColoredText.Builder ct = ColoredText.builder();
        Icon tagIcon = null;
        for (Tag tag : tags) {
            if (tagIcon == null) {
                tagIcon = tag.icon;
            }
            if (tag.text.isEmpty()) continue;
            ct.append(tag.text + " ", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES.derive(1, tag.color, null, null));
        }
        return Pair.create(tagIcon, ct.build());
    }

    @NotNull
    public static Collection<Tag> getElementTags(@Nullable PsiElement element) {
        if (!TagManager.isEnabled()) {
            Set<Tag> set2 = Collections.emptySet();
            if (set2 == null) {
                TagManager.$$$reportNull$$$0(2);
            }
            return set2;
        }
        if (element == null || !element.isValid()) {
            Set<Tag> set3 = Collections.emptySet();
            if (set3 == null) {
                TagManager.$$$reportNull$$$0(3);
            }
            return set3;
        }
        Collection<Tag> collection = TagManager.getInstance(element.getProject()).getTags(element);
        if (collection == null) {
            TagManager.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public abstract Collection<Tag> getTags(@NotNull PsiElement var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/tags/TagManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/tags/TagManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementTags";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 3, 4 -> new IllegalStateException(string2);
        };
    }

    @ApiStatus.Experimental
    public static final class Tag {
        @Nls
        public final String text;
        public final Color color;
        public final Icon icon;

        public Tag(@NotNull @Nls String text2, @Nullable Color color, @Nullable Icon icon2) {
            if (text2 == null) {
                Tag.$$$reportNull$$$0(0);
            }
            this.text = text2;
            this.color = color;
            this.icon = icon2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof Tag && this.text.equals(((Tag)o).text);
        }

        public int hashCode() {
            return this.text.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ide/tags/TagManager$Tag", "<init>"));
        }
    }
}

