/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.tags;

import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.tags.TagManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.JBColor;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class TagManagerImpl
extends TagManager {
    private final Project myProject;

    public TagManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            TagManagerImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
    }

    @Override
    @NotNull
    public Collection<TagManager.Tag> getTags(@NotNull PsiElement element) {
        Bookmark bookmark;
        if (element == null) {
            TagManagerImpl.$$$reportNull$$$0(1);
        }
        if ((bookmark = BookmarkManager.getInstance(this.myProject).findElementBookmark(element)) == null) {
            Set<TagManager.Tag> set2 = Collections.emptySet();
            if (set2 == null) {
                TagManagerImpl.$$$reportNull$$$0(2);
            }
            return set2;
        }
        String desc = bookmark.getDescription();
        if (desc.indexOf(35) == -1 || desc.indexOf(32) == -1) {
            String text2 = StringUtil.isNotEmpty(desc) && desc.indexOf(32) == -1 ? (desc.indexOf(35) == -1 ? "#" + desc : desc) : "";
            Set<TagManager.Tag> set3 = Collections.singleton(new TagManager.Tag(text2, JBColor.RED, bookmark.getIcon()));
            if (set3 == null) {
                TagManagerImpl.$$$reportNull$$$0(3);
            }
            return set3;
        }
        Matcher matcher = Pattern.compile("#\\w[\\w_\\-#]*").matcher(desc);
        TreeSet<TagManager.Tag> result2 = new TreeSet<TagManager.Tag>(Comparator.comparing(o -> o.text));
        int offset2 = 0;
        while (matcher.find(offset2)) {
            String text3 = desc.substring(matcher.start(), matcher.end());
            result2.add(new TagManager.Tag(text3, JBColor.RED, bookmark.getIcon()));
            offset2 = matcher.end();
        }
        TreeSet<TagManager.Tag> treeSet = result2;
        if (treeSet == null) {
            TagManagerImpl.$$$reportNull$$$0(4);
        }
        return treeSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/tags/TagManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/tags/TagManagerImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTags";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTags";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 4 -> new IllegalStateException(string2);
        };
    }
}

