/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.todo.TodoTreeStructure;
import com.intellij.ide.todo.nodes.SingleFileToDoNode;
import com.intellij.ide.todo.nodes.ToDoRootNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CurrentFileTodosTreeStructure
extends TodoTreeStructure {
    private PsiFile myFile;

    public CurrentFileTodosTreeStructure(Project project2) {
        super(project2);
    }

    @Override
    protected void validateCache() {
        super.validateCache();
        if (this.myFile != null && !this.myFile.isValid()) {
            VirtualFile vFile = this.myFile.getVirtualFile();
            this.myFile = vFile.isValid() ? PsiManager.getInstance(this.myProject).findFile(vFile) : null;
        }
    }

    @Nullable
    PsiFile getFile() {
        return this.myFile;
    }

    public void setFile(@Nullable PsiFile file2) {
        this.myFile = file2;
        this.myRootElement = this.createRootElement();
    }

    @Override
    public boolean accept(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            CurrentFileTodosTreeStructure.$$$reportNull$$$0(0);
        }
        if (this.myFile == null || !this.myFile.equals(psiFile) || !this.myFile.isValid()) {
            return false;
        }
        return this.acceptTodoFilter(psiFile);
    }

    @Override
    boolean isAutoExpandNode(NodeDescriptor descriptor2) {
        Object element = descriptor2.getElement();
        if (element instanceof AbstractTreeNode) {
            element = ((AbstractTreeNode)element).getValue();
        }
        if (element == this.myFile) {
            return true;
        }
        return element == this.getRootElement() || element == this.mySummaryElement;
    }

    @Override
    Object getFirstSelectableElement() {
        if (this.myRootElement instanceof SingleFileToDoNode) {
            return ((SingleFileToDoNode)this.myRootElement).getFileNode();
        }
        return null;
    }

    protected AbstractTreeNode createRootElement() {
        if (this.myFile == null) {
            return new ToDoRootNode(this.myProject, new Object(), this.myBuilder, this.mySummaryElement);
        }
        return new SingleFileToDoNode(this.myProject, this.myFile, this.myBuilder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/ide/todo/CurrentFileTodosTreeStructure", "accept"));
    }
}

