/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.search.TodoItem;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class SmartTodoItemPointer {
    @NotNull
    private final TodoItem myTodoItem;
    @NotNull
    private final Document myDocument;
    @NotNull
    private final RangeMarker myRangeMarker;
    @NotNull
    private final List<RangeMarker> myAdditionalRangeMarkers;

    public SmartTodoItemPointer(@NotNull TodoItem todoItem, @NotNull Document document) {
        if (todoItem == null) {
            SmartTodoItemPointer.$$$reportNull$$$0(0);
        }
        if (document == null) {
            SmartTodoItemPointer.$$$reportNull$$$0(1);
        }
        this.myTodoItem = todoItem;
        this.myDocument = document;
        TextRange textRange = this.myTodoItem.getTextRange();
        this.myRangeMarker = document.createRangeMarker(textRange);
        this.myAdditionalRangeMarkers = ContainerUtil.map(todoItem.getAdditionalTextRanges(), document::createRangeMarker);
    }

    @NotNull
    public TodoItem getTodoItem() {
        TodoItem todoItem = this.myTodoItem;
        if (todoItem == null) {
            SmartTodoItemPointer.$$$reportNull$$$0(2);
        }
        return todoItem;
    }

    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            SmartTodoItemPointer.$$$reportNull$$$0(3);
        }
        return document;
    }

    @NotNull
    public RangeMarker getRangeMarker() {
        RangeMarker rangeMarker = this.myRangeMarker;
        if (rangeMarker == null) {
            SmartTodoItemPointer.$$$reportNull$$$0(4);
        }
        return rangeMarker;
    }

    @NotNull
    public List<RangeMarker> getAdditionalRangeMarkers() {
        List<RangeMarker> list2 = this.myAdditionalRangeMarkers;
        if (list2 == null) {
            SmartTodoItemPointer.$$$reportNull$$$0(5);
        }
        return list2;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SmartTodoItemPointer)) {
            return false;
        }
        SmartTodoItemPointer pointer = (SmartTodoItemPointer)obj;
        if (!this.myTodoItem.getFile().equals(pointer.myTodoItem.getFile()) || this.myRangeMarker.getStartOffset() != pointer.myRangeMarker.getStartOffset() || this.myRangeMarker.getEndOffset() != pointer.myRangeMarker.getEndOffset() || !this.myTodoItem.getPattern().equals((Object)pointer.myTodoItem.getPattern()) || this.myAdditionalRangeMarkers.size() != pointer.myAdditionalRangeMarkers.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.myAdditionalRangeMarkers.size(); ++i2) {
            RangeMarker m1 = this.myAdditionalRangeMarkers.get(i2);
            RangeMarker m2 = pointer.myAdditionalRangeMarkers.get(i2);
            if (m1.getStartOffset() == m2.getStartOffset() && m1.getEndOffset() == m2.getEndOffset()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.myTodoItem.getFile().hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "todoItem";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/todo/SmartTodoItemPointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/todo/SmartTodoItemPointer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTodoItem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeMarker";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalRangeMarkers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 4, 5 -> new IllegalStateException(string2);
        };
    }
}

