/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0003\u001a\f\u0010\u0006\u001a\u00020\u0004*\u00020\u0005H\u0003\u001a\f\u0010\u0007\u001a\u00020\u0004*\u00020\u0005H\u0003\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"ASYNC_BATCH_SIZE", "Lcom/intellij/openapi/util/registry/RegistryValue;", "Lorg/jetbrains/annotations/NotNull;", "collectFiles", "", "Lcom/intellij/ide/todo/TodoTreeBuilder;", "updateVisibleTree", "validateCacheAndUpdateTree", "intellij.platform.lang.impl"})
public final class TodoTreeBuilderCoroutineHelperKt {
    @NotNull
    private static final RegistryValue ASYNC_BATCH_SIZE;

    @RequiresBackgroundThread
    @RequiresReadLock
    private static final void collectFiles(TodoTreeBuilder $this$collectFiles) {
        ProgressManager.checkCanceled();
        $this$collectFiles.clearCache();
        $this$collectFiles.collectFiles(arg_0 -> TodoTreeBuilderCoroutineHelperKt.collectFiles$lambda$0((Function1)new Function1<PsiFile, Unit>($this$collectFiles){
            final /* synthetic */ TodoTreeBuilder $this_collectFiles;
            {
                this.$this_collectFiles = $receiver;
                super(1);
            }

            public final void invoke(@NotNull PsiFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$this_collectFiles.myFileTree.add(it.getVirtualFile());
                if (this.$this_collectFiles.myFileTree.size() % TodoTreeBuilderCoroutineHelperKt.access$getASYNC_BATCH_SIZE$p().asInteger() == 0) {
                    TodoTreeBuilderCoroutineHelperKt.access$validateCacheAndUpdateTree(this.$this_collectFiles);
                }
            }
        }, arg_0));
        TodoTreeBuilderCoroutineHelperKt.validateCacheAndUpdateTree($this$collectFiles);
    }

    @RequiresBackgroundThread
    @RequiresReadLock
    private static final void validateCacheAndUpdateTree(TodoTreeBuilder $this$validateCacheAndUpdateTree) {
        ProgressManager.checkCanceled();
        $this$validateCacheAndUpdateTree.getTodoTreeStructure().validateCache();
        TodoTreeBuilderCoroutineHelperKt.updateVisibleTree($this$validateCacheAndUpdateTree);
    }

    @RequiresBackgroundThread
    @RequiresReadLock
    private static final void updateVisibleTree(TodoTreeBuilder $this$updateVisibleTree) {
        if ($this$updateVisibleTree.isUpdatable()) {
            if ($this$updateVisibleTree.hasDirtyFiles()) {
                $this$updateVisibleTree.getTodoTreeStructure().validateCache();
            }
            $this$updateVisibleTree.getModel().invalidateAsync();
        }
    }

    private static final void collectFiles$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$collectFiles(TodoTreeBuilder $receiver) {
        TodoTreeBuilderCoroutineHelperKt.collectFiles($receiver);
    }

    public static final /* synthetic */ void access$validateCacheAndUpdateTree(TodoTreeBuilder $receiver) {
        TodoTreeBuilderCoroutineHelperKt.validateCacheAndUpdateTree($receiver);
    }

    public static final /* synthetic */ void access$updateVisibleTree(TodoTreeBuilder $receiver) {
        TodoTreeBuilderCoroutineHelperKt.updateVisibleTree($receiver);
    }

    public static final /* synthetic */ RegistryValue access$getASYNC_BATCH_SIZE$p() {
        return ASYNC_BATCH_SIZE;
    }

    static {
        RegistryValue registryValue = RegistryManager.getInstance().get("ide.tree.ui.async.batch.size");
        Intrinsics.checkNotNullExpressionValue((Object)registryValue, (String)"getInstance().get(\"ide.tree.ui.async.batch.size\")");
        ASYNC_BATCH_SIZE = registryValue;
    }
}

