/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.todo.AllTodosTreeBuilder;
import com.intellij.ide.todo.CurrentFileTodosPanel;
import com.intellij.ide.todo.CurrentFileTodosTreeBuilder;
import com.intellij.ide.todo.ScopeBasedTodosPanel;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.ide.todo.TodoPanel;
import com.intellij.ide.todo.TodoPanelSettings;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.TodoTreeBuilderFactory;
import com.intellij.ide.todo.TodoViewChangesSupport;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ReadConstraint;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.JComponent;
import javax.swing.JTree;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@com.intellij.openapi.components.State(name="TodoView", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")})
public class TodoView
implements PersistentStateComponent<State>,
Disposable {
    @NotNull
    private final Project myProject;
    private ContentManager myContentManager;
    private TodoPanel myAllTodos;
    @Nullable
    private TodoPanel myChangeListTodosPanel;
    private CurrentFileTodosPanel myCurrentFileTodosPanel;
    private ScopeBasedTodosPanel myScopeBasedTodosPanel;
    private final List<TodoPanel> myPanels;
    private final List<Content> myNotAddedContent;
    private State state;
    private final TodoViewChangesSupport myChangesSupport;
    private final TodoViewChangesSupport.Listener myChangesListener;
    private Content myChangeListTodosContent;

    public TodoView(@NotNull Project project2) {
        if (project2 == null) {
            TodoView.$$$reportNull$$$0(0);
        }
        this.myPanels = new ArrayList<TodoPanel>();
        this.myNotAddedContent = new ArrayList<Content>();
        this.state = new State();
        this.myProject = project2;
        this.state.all.arePackagesShown = true;
        this.state.all.isAutoScrollToSource = true;
        this.state.current.isAutoScrollToSource = true;
        MessageBusConnection connection = project2.getMessageBus().connect(this);
        connection.subscribe(TodoConfiguration.PROPERTY_CHANGE, new MyPropertyChangeListener());
        connection.subscribe(FileTypeManager.TOPIC, new MyFileTypeListener());
        this.myChangesSupport = project2.getService(TodoViewChangesSupport.class);
        this.myChangesListener = this.myChangesSupport.installListener(project2, connection, (Function0<? extends ContentManager>)((Function0)() -> this.myContentManager), (Function0<? extends Content>)((Function0)() -> this.myChangeListTodosContent));
    }

    @Override
    public void loadState(@NotNull State state) {
        if (state == null) {
            TodoView.$$$reportNull$$$0(1);
        }
        this.state = state;
    }

    @Override
    public State getState() {
        if (this.myContentManager != null) {
            Content content2 = this.myContentManager.getSelectedContent();
            this.state.selectedIndex = content2 == null ? -1 : this.myContentManager.getIndexOfContent(content2);
        }
        return this.state;
    }

    @Override
    public void dispose() {
    }

    public void initToolWindow(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            TodoView.$$$reportNull$$$0(2);
        }
        ContentFactory contentFactory = ContentFactory.getInstance();
        Content allTodosContent = contentFactory.createContent(null, IdeUICustomization.getInstance().projectMessage("tab.title.project", new Object[0]), false);
        toolWindow.setHelpId("find.todoList");
        this.myAllTodos = new TodoPanel(this.myProject, this.state.all, false, allTodosContent){

            @Override
            protected TodoTreeBuilder createTreeBuilder(@NotNull JTree tree, @NotNull Project project2) {
                if (tree == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (project2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                AllTodosTreeBuilder builder2 = TodoView.this.createAllTodoBuilder(tree, project2);
                builder2.init();
                return builder2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "tree";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/todo/TodoView$1";
                objectArray[2] = "createTreeBuilder";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        allTodosContent.setComponent((JComponent)((Object)this.myAllTodos));
        allTodosContent.setPreferredFocusableComponent((JComponent)this.myAllTodos.getTree());
        Disposer.register(this, this.myAllTodos);
        if (toolWindow instanceof ToolWindowEx) {
            DefaultActionGroup group2 = new DefaultActionGroup(){
                {
                    this.getTemplatePresentation().setText(IdeBundle.messagePointer((String)"group.view.options", (Object[])new Object[0]));
                    this.setPopup(true);
                    this.add(TodoView.this.myAllTodos.createAutoScrollToSourceAction());
                    this.addSeparator();
                    this.addAll((ActionGroup)TodoView.this.myAllTodos.createGroupByActionGroup());
                }
            };
            toolWindow.setAdditionalGearActions((ActionGroup)group2);
        }
        Content currentFileTodosContent = contentFactory.createContent(null, IdeBundle.message((String)"title.todo.current.file", (Object[])new Object[0]), false);
        this.myCurrentFileTodosPanel = new CurrentFileTodosPanel(this.myProject, this.state.current, currentFileTodosContent){

            @Override
            protected TodoTreeBuilder createTreeBuilder(@NotNull JTree tree, @NotNull Project project2) {
                if (tree == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (project2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                CurrentFileTodosTreeBuilder builder2 = new CurrentFileTodosTreeBuilder(tree, project2);
                builder2.init();
                return builder2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "tree";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/todo/TodoView$3";
                objectArray[2] = "createTreeBuilder";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        Disposer.register(this, this.myCurrentFileTodosPanel);
        currentFileTodosContent.setComponent((JComponent)((Object)this.myCurrentFileTodosPanel));
        currentFileTodosContent.setPreferredFocusableComponent((JComponent)this.myCurrentFileTodosPanel.getTree());
        String tabName = this.myChangesSupport.getTabName(this.myProject);
        this.myChangeListTodosContent = contentFactory.createContent(null, tabName, false);
        this.myChangeListTodosPanel = this.myChangesSupport.createPanel(this.myProject, this.state.current, this.myChangeListTodosContent);
        if (this.myChangeListTodosPanel != null) {
            Disposer.register(this, this.myChangeListTodosPanel);
            this.myChangeListTodosContent.setComponent((JComponent)((Object)this.myChangeListTodosPanel));
            this.myChangeListTodosContent.setPreferredFocusableComponent((JComponent)this.myChangeListTodosPanel.getTree());
        }
        Content scopeBasedTodoContent = contentFactory.createContent(null, LangBundle.message("tab.title.scope.based", new Object[0]), false);
        this.myScopeBasedTodosPanel = new ScopeBasedTodosPanel(this.myProject, this.state.current, scopeBasedTodoContent);
        Disposer.register(this, this.myScopeBasedTodosPanel);
        scopeBasedTodoContent.setComponent((JComponent)((Object)this.myScopeBasedTodosPanel));
        this.myContentManager = toolWindow.getContentManager();
        this.myContentManager.addContent(allTodosContent);
        this.myContentManager.addContent(currentFileTodosContent);
        this.myContentManager.addContent(scopeBasedTodoContent);
        if (this.myChangesSupport.isContentVisible(this.myProject)) {
            this.myChangesListener.setVisible(true);
            this.myContentManager.addContent(this.myChangeListTodosContent);
        }
        for (Content content2 : this.myNotAddedContent) {
            this.myContentManager.addContent(content2);
        }
        this.myChangeListTodosContent.setCloseable(false);
        allTodosContent.setCloseable(false);
        currentFileTodosContent.setCloseable(false);
        scopeBasedTodoContent.setCloseable(false);
        Content content3 = this.myContentManager.getContent(this.state.selectedIndex);
        this.myContentManager.setSelectedContent(content3 == null ? allTodosContent : content3);
        this.myPanels.add(this.myAllTodos);
        if (this.myChangeListTodosPanel != null) {
            this.myPanels.add(this.myChangeListTodosPanel);
        }
        this.myPanels.add(this.myCurrentFileTodosPanel);
        this.myPanels.add(this.myScopeBasedTodosPanel);
    }

    @NotNull
    protected AllTodosTreeBuilder createAllTodoBuilder(@NotNull JTree tree, @NotNull Project project2) {
        if (tree == null) {
            TodoView.$$$reportNull$$$0(3);
        }
        if (project2 == null) {
            TodoView.$$$reportNull$$$0(4);
        }
        return new AllTodosTreeBuilder(tree, project2);
    }

    @VisibleForTesting
    @NotNull
    public final CompletableFuture<Void> refresh() {
        if (this.myAllTodos == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                TodoView.$$$reportNull$$$0(5);
            }
            return completableFuture;
        }
        ReadConstraint inSmartMode = ReadConstraint.Companion.inSmartMode(this.myProject);
        CompletableFuture[] futures = (CompletableFuture[])this.myPanels.stream().map(TodoPanel::getTreeBuilder).map(TodoTreeBuilder::getCoroutineHelper).map(helper -> helper.scheduleCacheAndTreeUpdate(inSmartMode)).toArray(CompletableFuture[]::new);
        CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures);
        if (completableFuture == null) {
            TodoView.$$$reportNull$$$0(6);
        }
        return completableFuture;
    }

    @Nullable
    public Content addCustomTodoView(@NotNull TodoTreeBuilderFactory factory2, @NlsContexts.TabTitle String title, @NotNull TodoPanelSettings settings) {
        Content content2;
        TodoPanel panel2;
        if (factory2 == null) {
            TodoView.$$$reportNull$$$0(7);
        }
        if (settings == null) {
            TodoView.$$$reportNull$$$0(8);
        }
        if ((panel2 = this.myChangesSupport.createPanel(this.myProject, settings, content2 = ContentFactory.getInstance().createContent(null, title, true), factory2)) == null) {
            return null;
        }
        content2.setComponent((JComponent)((Object)panel2));
        Disposer.register(this, panel2);
        if (this.myContentManager == null) {
            this.myNotAddedContent.add(content2);
        } else {
            this.myContentManager.addContent(content2);
        }
        this.myPanels.add(panel2);
        content2.setCloseable(true);
        content2.setDisposer(new Disposable(){

            @Override
            public void dispose() {
                TodoView.this.myPanels.remove(panel2);
            }
        });
        return content2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/todo/TodoView";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/todo/TodoView";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "refresh";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initToolWindow";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createAllTodoBuilder";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addCustomTodoView";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 6 -> new IllegalStateException(string2);
        };
    }

    static class State {
        @Attribute(value="selected-index")
        public int selectedIndex;
        @OptionTag(value="selected-file", nameAttribute="id", tag="todo-panel", valueAttribute="")
        public TodoPanelSettings current = new TodoPanelSettings();
        @OptionTag(value="all", nameAttribute="id", tag="todo-panel", valueAttribute="")
        public TodoPanelSettings all = new TodoPanelSettings();
        @OptionTag(value="default-changelist", nameAttribute="id", tag="todo-panel", valueAttribute="")
        public TodoPanelSettings changeList = new TodoPanelSettings();

        State() {
        }
    }

    private final class MyPropertyChangeListener
    implements PropertyChangeListener {
        private MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("todoPatterns".equals(e.getPropertyName()) || "todoFilters".equals(e.getPropertyName())) {
                this.updateFilters();
            }
        }

        private void updateFilters() {
            try {
                for (TodoPanel panel2 : TodoView.this.myPanels) {
                    panel2.updateTodoFilter();
                }
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
        }
    }

    private final class MyFileTypeListener
    implements FileTypeListener {
        private MyFileTypeListener() {
        }

        public void fileTypesChanged(@NotNull FileTypeEvent e) {
            if (e == null) {
                MyFileTypeListener.$$$reportNull$$$0(0);
            }
            TodoView.this.refresh();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/todo/TodoView$MyFileTypeListener", "fileTypesChanged"));
        }
    }

    @TestOnly
    public static enum Scope {
        AllTodos,
        ChangeList,
        CurrentFile,
        ScopeBased;

    }
}

