/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.configurable;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.psi.search.TodoPattern;
import com.intellij.util.ui.ItemRemovable;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import one.util.streamex.StreamEx;

final class FiltersTableModel
extends AbstractTableModel
implements ItemRemovable {
    private final String[] ourColumnNames = new String[]{IdeBundle.message((String)"column.todo.filters.name", (Object[])new Object[0]), IdeBundle.message((String)"column.todo.filter.patterns", (Object[])new Object[0])};
    private final Class<?>[] ourColumnClasses = new Class[]{String.class, String.class};
    private final List<TodoFilter> myFilters;

    FiltersTableModel(List<TodoFilter> filters) {
        this.myFilters = filters;
    }

    @Override
    public String getColumnName(int column) {
        return this.ourColumnNames[column];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return this.ourColumnClasses[column];
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.myFilters.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        TodoFilter filter2 = this.myFilters.get(row);
        return switch (column) {
            case 0 -> filter2.getName();
            case 1 -> StreamEx.of((Iterator)filter2.iterator()).map(TodoPattern::getPatternString).joining((CharSequence)" | ");
            default -> throw new IllegalArgumentException();
        };
    }

    @Override
    public void removeRow(int index2) {
        this.myFilters.remove(index2);
        this.fireTableRowsDeleted(index2, index2);
    }
}

