/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.configurable;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.ide.todo.configurable.FilterDialog;
import com.intellij.ide.todo.configurable.FiltersTableModel;
import com.intellij.ide.todo.configurable.PatternDialog;
import com.intellij.ide.todo.configurable.PatternsTableModel;
import com.intellij.ide.todo.configurable.TodoPatternTableCellRenderer;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.psi.search.TodoAttributesUtil;
import com.intellij.psi.search.TodoPattern;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.IconTableCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class TodoConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private static final int HEADER_GAP = JBUIScale.scale(20);
    private JPanel myPanel;
    private JCheckBox myMultiLineCheckBox;
    private JBTable myPatternsTable;
    private JBTable myFiltersTable;
    protected final List<TodoPattern> myPatterns = new ArrayList<TodoPattern>();
    private final PatternsTableModel myPatternsModel;
    protected final List<TodoFilter> myFilters = new ArrayList<TodoFilter>();
    private final FiltersTableModel myFiltersModel = new FiltersTableModel(this.myFilters);

    public TodoConfigurable() {
        this.myPatternsModel = new PatternsTableModel(this.myPatterns);
    }

    protected boolean arePatternsModified() {
        TodoConfiguration todoConfiguration = TodoConfiguration.getInstance();
        TodoPattern[] initialPatterns = this.getTodoPatternsToDisplay(todoConfiguration);
        if (initialPatterns.length != this.myPatterns.size()) {
            return true;
        }
        for (TodoPattern initialPattern : initialPatterns) {
            if (this.myPatterns.contains(initialPattern)) continue;
            return true;
        }
        return false;
    }

    protected boolean areFiltersModified() {
        TodoConfiguration todoConfiguration = TodoConfiguration.getInstance();
        TodoFilter[] initialFilters = todoConfiguration.getTodoFilters();
        if (initialFilters.length != this.myFilters.size()) {
            return true;
        }
        for (TodoFilter initialFilter : initialFilters) {
            if (this.myFilters.contains(initialFilter)) continue;
            return true;
        }
        return false;
    }

    public boolean isModified() {
        this.stopEditing();
        return TodoConfiguration.getInstance().isMultiLine() != this.myMultiLineCheckBox.isSelected() || this.arePatternsModified() || this.areFiltersModified();
    }

    public void apply() {
        this.stopEditing();
        TodoConfiguration.getInstance().setMultiLine(this.myMultiLineCheckBox.isSelected());
        if (this.arePatternsModified()) {
            TodoPattern[] patterns = this.myPatterns.toArray(new TodoPattern[0]);
            TodoConfiguration.getInstance().setTodoPatterns(patterns);
        }
        if (this.areFiltersModified()) {
            TodoFilter[] filters = this.myFilters.toArray(new TodoFilter[0]);
            TodoConfiguration.getInstance().setTodoFilters(filters);
        }
    }

    public void disposeUIResources() {
        this.myPanel = null;
        this.myPatternsModel.removeTableModelListener((TableModelListener)this.myPatternsTable);
        this.myPatternsTable = null;
        this.myFiltersModel.removeTableModelListener((TableModelListener)this.myFiltersTable);
        this.myFiltersTable = null;
    }

    public JComponent createComponent() {
        this.myMultiLineCheckBox = new JCheckBox(IdeBundle.message((String)"label.todo.multiline", (Object[])new Object[0]));
        this.myPatternsTable = new JBTable((TableModel)this.myPatternsModel);
        this.myPatternsTable.setShowGrid(false);
        this.myPatternsTable.getEmptyText().setText(IdeBundle.message((String)"text.todo.no.patterns", (Object[])new Object[0]));
        TableColumn typeColumn = this.myPatternsTable.getColumnModel().getColumn(0);
        JTableHeader tableHeader = this.myPatternsTable.getTableHeader();
        FontMetrics headerFontMetrics = tableHeader.getFontMetrics(tableHeader.getFont());
        int typeColumnWidth = headerFontMetrics.stringWidth(this.myPatternsTable.getColumnName(0) + HEADER_GAP);
        typeColumn.setPreferredWidth(typeColumnWidth);
        typeColumn.setMinWidth(typeColumnWidth);
        typeColumn.setCellRenderer((TableCellRenderer)new IconTableCellRenderer<Icon>(){

            @NotNull
            protected Icon getIcon(@NotNull Icon value, JTable table, int row) {
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                Icon icon2 = value;
                if (icon2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return icon2;
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focus, int row, int column) {
                super.getTableCellRendererComponent(table, value, selected, focus, row, column);
                this.setText("");
                return this;
            }

            protected boolean isCenterAlignment() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/todo/configurable/TodoConfigurable$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/todo/configurable/TodoConfigurable$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIcon";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getIcon";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 1 -> new IllegalStateException(string2);
                };
            }
        });
        TableColumn todoCaseSensitiveColumn = this.myPatternsTable.getColumnModel().getColumn(1);
        int caseSensitiveColumnWidth = headerFontMetrics.stringWidth(this.myPatternsTable.getColumnName(1)) + HEADER_GAP;
        todoCaseSensitiveColumn.setPreferredWidth(caseSensitiveColumnWidth);
        todoCaseSensitiveColumn.setMinWidth(caseSensitiveColumnWidth);
        todoCaseSensitiveColumn.setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        todoCaseSensitiveColumn.setCellEditor(new BooleanTableCellEditor());
        TodoPatternTableCellRenderer todoPatternRenderer = new TodoPatternTableCellRenderer(this.myPatterns);
        TableColumn patternColumn = this.myPatternsTable.getColumnModel().getColumn(2);
        patternColumn.setCellRenderer(todoPatternRenderer);
        patternColumn.setPreferredWidth(patternColumn.getMaxWidth());
        JPanel patternsPanel = new JPanel(new BorderLayout());
        patternsPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)IdeBundle.message((String)"label.todo.patterns", (Object[])new Object[0]), (boolean)false, (Insets)JBUI.insetsTop(8)).setShowLine(false));
        patternsPanel.add((Component)ToolbarDecorator.createDecorator((JTable)this.myPatternsTable).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                TodoConfigurable.this.stopEditing();
                TodoPattern pattern = new TodoPattern(TodoAttributesUtil.createDefault());
                PatternDialog dialog = new PatternDialog(TodoConfigurable.this.myPanel, pattern, -1, TodoConfigurable.this.myPatterns);
                if (!dialog.showAndGet()) {
                    return;
                }
                TodoConfigurable.this.myPatterns.add(pattern);
                int index2 = TodoConfigurable.this.myPatterns.size() - 1;
                TodoConfigurable.this.myPatternsModel.fireTableRowsInserted(index2, index2);
                TodoConfigurable.this.myPatternsTable.getSelectionModel().setSelectionInterval(index2, index2);
                TodoConfigurable.this.myPatternsTable.scrollRectToVisible(TodoConfigurable.this.myPatternsTable.getCellRect(index2, 0, true));
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                TodoConfigurable.this.editSelectedPattern();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                TodoConfigurable.this.stopEditing();
                int selectedIndex = TodoConfigurable.this.myPatternsTable.getSelectedRow();
                if (selectedIndex < 0 || selectedIndex >= TodoConfigurable.this.myPatternsModel.getRowCount()) {
                    return;
                }
                TodoPattern patternToBeRemoved = TodoConfigurable.this.myPatterns.get(selectedIndex);
                TableUtil.removeSelectedItems((JTable)TodoConfigurable.this.myPatternsTable);
                for (int i2 = 0; i2 < TodoConfigurable.this.myFilters.size(); ++i2) {
                    TodoFilter filter2 = TodoConfigurable.this.myFilters.get(i2);
                    if (!filter2.contains(patternToBeRemoved)) continue;
                    filter2.removeTodoPattern(patternToBeRemoved);
                    TodoConfigurable.this.myFiltersModel.fireTableRowsUpdated(i2, i2);
                }
            }
        }).disableUpDownActions().createPanel(), "Center");
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                TodoConfigurable.this.editSelectedPattern();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/todo/configurable/TodoConfigurable$5", "onDoubleClick"));
            }
        }.installOn((Component)this.myPatternsTable);
        this.myFiltersTable = new JBTable((TableModel)this.myFiltersModel);
        this.myFiltersTable.setShowGrid(false);
        this.myFiltersTable.getEmptyText().setText(IdeBundle.message((String)"text.todo.no.filters", (Object[])new Object[0]));
        TableColumn nameColumn = this.myFiltersTable.getColumnModel().getColumn(0);
        int nameColumnWidth = caseSensitiveColumnWidth + typeColumnWidth;
        nameColumn.setPreferredWidth(nameColumnWidth);
        nameColumn.setMinWidth(nameColumnWidth);
        nameColumn.setCellRenderer(new MyFilterNameTableCellRenderer());
        TableColumn patternsColumn = this.myFiltersTable.getColumnModel().getColumn(1);
        patternsColumn.setPreferredWidth(patternsColumn.getMaxWidth());
        JPanel filtersPanel = new JPanel(new BorderLayout());
        filtersPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)IdeBundle.message((String)"label.todo.filters", (Object[])new Object[0]), (boolean)false, (Insets)JBUI.insetsTop(13)).setShowLine(false));
        filtersPanel.add(ToolbarDecorator.createDecorator((JTable)this.myFiltersTable).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                TodoConfigurable.this.stopEditing();
                TodoFilter filter2 = new TodoFilter();
                FilterDialog dialog = new FilterDialog(TodoConfigurable.this.myPanel, filter2, -1, TodoConfigurable.this.myFilters, TodoConfigurable.this.myPatterns);
                if (dialog.showAndGet()) {
                    TodoConfigurable.this.myFilters.add(filter2);
                    int index2 = TodoConfigurable.this.myFilters.size() - 1;
                    TodoConfigurable.this.myFiltersModel.fireTableRowsInserted(index2, index2);
                    TodoConfigurable.this.myFiltersTable.getSelectionModel().setSelectionInterval(index2, index2);
                    TodoConfigurable.this.myFiltersTable.scrollRectToVisible(TodoConfigurable.this.myFiltersTable.getCellRect(index2, 0, true));
                }
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                TodoConfigurable.this.editSelectedFilter();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                TodoConfigurable.this.stopEditing();
                TableUtil.removeSelectedItems((JTable)TodoConfigurable.this.myFiltersTable);
            }
        }).disableUpDownActions().createPanel());
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                TodoConfigurable.this.editSelectedFilter();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/todo/configurable/TodoConfigurable$9", "onDoubleClick"));
            }
        }.installOn((Component)this.myFiltersTable);
        this.myPanel = FormBuilder.createFormBuilder().addComponent((JComponent)this.myMultiLineCheckBox).addComponentFillVertically((JComponent)patternsPanel, 0).addComponentFillVertically((JComponent)filtersPanel, 0).getPanel();
        return this.myPanel;
    }

    private void editSelectedPattern() {
        this.stopEditing();
        int selectedIndex = this.myPatternsTable.getSelectedRow();
        if (selectedIndex < 0 || selectedIndex >= this.myPatternsModel.getRowCount()) {
            return;
        }
        TodoPattern sourcePattern = this.myPatterns.get(selectedIndex);
        TodoPattern pattern = sourcePattern.clone();
        PatternDialog dialog = new PatternDialog(this.myPanel, pattern, selectedIndex, this.myPatterns);
        dialog.setTitle(IdeBundle.message((String)"title.edit.todo.pattern", (Object[])new Object[0]));
        if (!dialog.showAndGet()) {
            return;
        }
        this.myPatterns.set(selectedIndex, pattern);
        this.myPatternsModel.fireTableRowsUpdated(selectedIndex, selectedIndex);
        this.myPatternsTable.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
        for (int i2 = 0; i2 < this.myFilters.size(); ++i2) {
            TodoFilter filter2 = this.myFilters.get(i2);
            if (!filter2.contains(sourcePattern)) continue;
            filter2.removeTodoPattern(sourcePattern);
            filter2.addTodoPattern(pattern);
            this.myFiltersModel.fireTableRowsUpdated(i2, i2);
        }
    }

    private void editSelectedFilter() {
        this.stopEditing();
        int selectedIndex = this.myFiltersTable.getSelectedRow();
        if (selectedIndex < 0 || selectedIndex >= this.myFiltersModel.getRowCount()) {
            return;
        }
        TodoFilter sourceFilter = this.myFilters.get(selectedIndex);
        TodoFilter filter2 = sourceFilter.clone();
        FilterDialog dialog = new FilterDialog(this.myPanel, filter2, selectedIndex, this.myFilters, this.myPatterns);
        dialog.setTitle(IdeBundle.message((String)"title.edit.todo.filter", (Object[])new Object[0]));
        dialog.show();
        int exitCode = dialog.getExitCode();
        if (0 == exitCode) {
            this.myFilters.set(selectedIndex, filter2);
            this.myFiltersModel.fireTableRowsUpdated(selectedIndex, selectedIndex);
            this.myFiltersTable.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
        }
    }

    protected void stopEditing() {
        TableCellEditor editor2;
        if (this.myPatternsTable.isEditing() && (editor2 = this.myPatternsTable.getCellEditor()) != null) {
            editor2.stopCellEditing();
        }
        if (this.myFiltersTable.isEditing() && (editor2 = this.myFiltersTable.getCellEditor()) != null) {
            editor2.stopCellEditing();
        }
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"title.todo", (Object[])new Object[0]);
    }

    @NotNull
    public String getHelpTopic() {
        return "preferences.toDoOptions";
    }

    public void reset() {
        TodoFilter[] filters;
        TodoPattern[] patterns;
        this.myMultiLineCheckBox.setSelected(TodoConfiguration.getInstance().isMultiLine());
        this.myPatterns.clear();
        TodoConfiguration todoConfiguration = TodoConfiguration.getInstance();
        for (TodoPattern pattern : patterns = this.getTodoPatternsToDisplay(todoConfiguration)) {
            this.myPatterns.add(pattern.clone());
        }
        this.myPatternsModel.fireTableDataChanged();
        this.myFilters.clear();
        for (TodoFilter filter2 : filters = todoConfiguration.getTodoFilters()) {
            this.myFilters.add(filter2.clone());
        }
        this.myFiltersModel.fireTableDataChanged();
    }

    protected TodoPattern @NotNull [] getTodoPatternsToDisplay(TodoConfiguration todoConfiguration) {
        TodoPattern[] todoPatternArray = todoConfiguration.getTodoPatterns();
        if (todoPatternArray == null) {
            TodoConfigurable.$$$reportNull$$$0(0);
        }
        return todoPatternArray;
    }

    @NotNull
    public String getId() {
        String string2 = this.getHelpTopic();
        if (string2 == null) {
            TodoConfigurable.$$$reportNull$$$0(1);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/todo/configurable/TodoConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTodoPatternsToDisplay";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private final class MyFilterNameTableCellRenderer
    extends DefaultTableCellRenderer {
        private MyFilterNameTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            TodoFilter filter2 = TodoConfigurable.this.myFilters.get(row);
            if (isSelected) {
                this.setForeground(UIUtil.getTableSelectionForeground(true));
            } else if (filter2.isEmpty()) {
                this.setForeground(JBColor.RED);
            } else {
                this.setForeground(UIUtil.getTableForeground());
            }
            return this;
        }
    }
}

