/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.nodes;

import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.todo.TodoFileDirAndModuleComparator;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.nodes.TodoDirNode;
import com.intellij.ide.todo.nodes.TodoFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TodoTreeHelper {
    private final Project myProject;

    public static TodoTreeHelper getInstance(Project project2) {
        return project2.getService(TodoTreeHelper.class);
    }

    public TodoTreeHelper(Project project2) {
        this.myProject = project2;
    }

    public void addPackagesToChildren(@NotNull ArrayList<? super AbstractTreeNode<?>> children2, @Nullable Module module2, @NotNull TodoTreeBuilder builder2) {
        if (children2 == null) {
            TodoTreeHelper.$$$reportNull$$$0(0);
        }
        if (builder2 == null) {
            TodoTreeHelper.$$$reportNull$$$0(1);
        }
        this.addDirsToChildren(this.collectContentRoots(module2), children2, builder2);
    }

    @NotNull
    protected List<? extends VirtualFile> collectContentRoots(@Nullable Module module2) {
        ArrayList roots2 = new ArrayList();
        ContainerUtil.addAll(roots2, module2 != null ? ModuleRootManager.getInstance(module2).getContentRoots() : ProjectRootManager.getInstance(this.myProject).getContentRoots());
        ArrayList arrayList = roots2;
        if (arrayList == null) {
            TodoTreeHelper.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    protected void addDirsToChildren(@NotNull List<? extends VirtualFile> roots2, @NotNull ArrayList<? super AbstractTreeNode<?>> children2, @NotNull TodoTreeBuilder builder2) {
        if (roots2 == null) {
            TodoTreeHelper.$$$reportNull$$$0(3);
        }
        if (children2 == null) {
            TodoTreeHelper.$$$reportNull$$$0(4);
        }
        if (builder2 == null) {
            TodoTreeHelper.$$$reportNull$$$0(5);
        }
        PsiManager psiManager = PsiManager.getInstance(this.myProject);
        for (VirtualFile virtualFile2 : roots2) {
            TodoDirNode dirNode;
            Iterator<PsiFile> files2;
            PsiDirectory directory = psiManager.findDirectory(virtualFile2);
            if (directory == null || !(files2 = builder2.getFiles(directory)).hasNext() || children2.contains(dirNode = new TodoDirNode(this.myProject, directory, builder2))) continue;
            children2.add(dirNode);
        }
    }

    public Collection<AbstractTreeNode<?>> getDirectoryChildren(PsiDirectory psiDirectory, TodoTreeBuilder builder2, boolean isFlatten) {
        ArrayList children2 = new ArrayList();
        if (!isFlatten || !this.skipDirectory(psiDirectory)) {
            Iterator<PsiFile> iterator2 = builder2.getFiles(psiDirectory);
            block0: while (iterator2.hasNext()) {
                PsiFile psiFile = iterator2.next();
                PsiDirectory containingDirectory = psiFile.getContainingDirectory();
                TodoFileNode todoFileNode = new TodoFileNode(this.getProject(), psiFile, builder2, false);
                if (psiDirectory.equals(containingDirectory) && !children2.contains(todoFileNode)) {
                    children2.add(todoFileNode);
                    continue;
                }
                PsiDirectory _dir = psiFile.getContainingDirectory();
                while (_dir != null && !this.skipDirectory(_dir)) {
                    PsiDirectory parentDirectory = _dir.getParentDirectory();
                    TodoDirNode todoDirNode = new TodoDirNode(this.getProject(), _dir, builder2);
                    if (parentDirectory != null && psiDirectory.equals(parentDirectory) && !children2.contains(todoDirNode)) {
                        children2.add(todoDirNode);
                        continue block0;
                    }
                    _dir = parentDirectory;
                }
            }
        } else {
            PsiDirectory parentDirectory = psiDirectory.getParentDirectory();
            if (parentDirectory == null || !this.skipDirectory(parentDirectory) || !ProjectRootManager.getInstance(this.getProject()).getFileIndex().isInContent(parentDirectory.getVirtualFile())) {
                Iterator<PsiFile> iterator3 = builder2.getFiles(psiDirectory);
                while (iterator3.hasNext()) {
                    PsiFile psiFile = iterator3.next();
                    TodoFileNode todoFileNode = new TodoFileNode(this.getProject(), psiFile, builder2, false);
                    if (psiDirectory.equals(psiFile.getContainingDirectory()) && !children2.contains(todoFileNode)) {
                        children2.add(todoFileNode);
                        continue;
                    }
                    PsiDirectory _dir = psiFile.getContainingDirectory();
                    if (_dir == null || this.skipDirectory(_dir)) continue;
                    TodoDirNode todoDirNode = new TodoDirNode(this.getProject(), _dir, builder2);
                    if (!PsiTreeUtil.isAncestor(psiDirectory, _dir, true) || children2.contains(todoDirNode) || builder2.isDirectoryEmpty(_dir)) continue;
                    children2.add(todoDirNode);
                }
            } else {
                Iterator<PsiFile> iterator4 = builder2.getFiles(psiDirectory);
                while (iterator4.hasNext()) {
                    PsiFile psiFile = iterator4.next();
                    PsiDirectory containingDirectory = psiFile.getContainingDirectory();
                    TodoFileNode todoFileNode = new TodoFileNode(this.getProject(), psiFile, builder2, false);
                    if (!psiDirectory.equals(containingDirectory) || children2.contains(todoFileNode)) continue;
                    children2.add(todoFileNode);
                }
            }
        }
        children2.sort(TodoFileDirAndModuleComparator.INSTANCE);
        return children2;
    }

    public boolean skipDirectory(PsiDirectory directory) {
        return false;
    }

    @Nullable
    public PsiElement getSelectedElement(Object userObject) {
        if (userObject instanceof TodoDirNode) {
            TodoDirNode descriptor2 = (TodoDirNode)userObject;
            return (PsiElement)descriptor2.getValue();
        }
        if (userObject instanceof TodoFileNode) {
            TodoFileNode descriptor3 = (TodoFileNode)userObject;
            return (PsiElement)descriptor3.getValue();
        }
        return null;
    }

    public boolean contains(ProjectViewNode node2, Object element) {
        return false;
    }

    public Project getProject() {
        return this.myProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/todo/nodes/TodoTreeHelper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/todo/nodes/TodoTreeHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectContentRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addPackagesToChildren";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addDirsToChildren";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }
}

