/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.application.options.OptionsContainingConfigurable;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.impl.AllFileTemplatesConfigurable;
import com.intellij.ide.fileTemplates.impl.BundledFileTemplate;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.ide.ui.search.TraverseUIHelper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.EdtInvocationManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TraverseUIStarter
implements ApplicationStarter {
    @NonNls
    private static final String OPTIONS = "options";
    @NonNls
    private static final String CONFIGURABLE = "configurable";
    @NonNls
    private static final String ID = "id";
    @NonNls
    private static final String CONFIGURABLE_NAME = "configurable_name";
    @NonNls
    private static final String OPTION = "option";
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String PATH = "path";
    @NonNls
    private static final String HIT = "hit";
    private static final String ROOT_ACTION_MODULE = "intellij.platform.ide";
    private String OUTPUT_PATH;
    private boolean SPLIT_BY_RESOURCE_PATH;
    private boolean I18N_OPTION;

    public String getCommandName() {
        return "traverseUI";
    }

    public int getRequiredModality() {
        return 3;
    }

    public void premain(@NotNull List<String> args2) {
        if (args2 == null) {
            TraverseUIStarter.$$$reportNull$$$0(0);
        }
        this.OUTPUT_PATH = args2.get(1);
        this.SPLIT_BY_RESOURCE_PATH = args2.size() > 2 && Boolean.parseBoolean(args2.get(2));
        this.I18N_OPTION = Boolean.getBoolean("intellij.searchableOptions.i18n.enabled");
    }

    public void main(@NotNull List<String> args2) {
        if (args2 == null) {
            TraverseUIStarter.$$$reportNull$$$0(1);
        }
        try {
            TraverseUIStarter.startup(Path.of(this.OUTPUT_PATH, new String[0]), this.SPLIT_BY_RESOURCE_PATH, this.I18N_OPTION);
            ApplicationManagerEx.getApplicationEx().exit(3);
            System.out.println("Searchable options index builder completed");
        }
        catch (Throwable e) {
            try {
                Logger.getInstance(this.getClass()).error("Searchable options index builder failed", e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.exit(-1);
        }
    }

    public static void startup(@NotNull Path outputPath, boolean splitByResourcePath) throws IOException {
        if (outputPath == null) {
            TraverseUIStarter.$$$reportNull$$$0(2);
        }
        TraverseUIStarter.startup(outputPath, splitByResourcePath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startup(@NotNull Path outputPath, boolean splitByResourcePath, boolean i18n) throws IOException {
        if (outputPath == null) {
            TraverseUIStarter.$$$reportNull$$$0(3);
        }
        LinkedHashMap options2 = new LinkedHashMap();
        HashMap<String, Element> roots2 = new HashMap<String, Element>();
        try {
            EdtInvocationManager.invokeAndWaitIfNeeded(() -> {
                for (TraverseUIHelper extension2 : TraverseUIHelper.helperExtensionPoint.getExtensionList()) {
                    extension2.beforeStart();
                }
                SearchUtil.processConfigurables((List)ShowSettingsUtilImpl.getConfigurables((Project)ProjectManager.getInstance().getDefaultProject(), (boolean)true, (boolean)false), (Map)options2, (boolean)i18n);
                for (TraverseUIHelper extension2 : TraverseUIHelper.helperExtensionPoint.getExtensionList()) {
                    extension2.afterTraversal(options2);
                }
            });
            System.out.println("Found " + options2.size() + " configurables");
            for (SearchableConfigurable configurable2 : options2.keySet()) {
                Object wrapped;
                Element configurableElement = TraverseUIStarter.createConfigurableElement(configurable2);
                TraverseUIStarter.writeOptions(configurableElement, (Set)options2.get(configurable2));
                if (configurable2 instanceof ConfigurableWrapper && (wrapped = ((ConfigurableWrapper)configurable2).getConfigurable()) instanceof SearchableConfigurable) {
                    configurable2 = (SearchableConfigurable)wrapped;
                }
                if (configurable2 instanceof KeymapPanel) {
                    wrapped = TraverseUIStarter.processKeymap(splitByResourcePath).entrySet().iterator();
                    while (wrapped.hasNext()) {
                        Map.Entry entry = (Map.Entry)wrapped.next();
                        entryElement = TraverseUIStarter.createConfigurableElement(configurable2);
                        TraverseUIStarter.writeOptions(entryElement, (Set)entry.getValue());
                        TraverseUIStarter.addElement(roots2, entryElement, (String)entry.getKey());
                    }
                } else if (configurable2 instanceof OptionsContainingConfigurable) {
                    TraverseUIStarter.processOptionsContainingConfigurable((OptionsContainingConfigurable)configurable2, configurableElement);
                } else if (configurable2 instanceof PluginManagerConfigurable) {
                    TreeSet optionDescriptions = new TreeSet();
                    TraverseUIStarter.wordsToOptionDescriptors(Collections.singleton(IdeBundle.message((String)"plugin.manager.repositories", (Object[])new Object[0])), null, optionDescriptions);
                    Iterator iterator2 = optionDescriptions.iterator();
                    while (iterator2.hasNext()) {
                        OptionDescription description = (OptionDescription)iterator2.next();
                        configurableElement.addContent(TraverseUIStarter.createOptionElement(null, IdeBundle.message((String)"plugin.manager.repositories", (Object[])new Object[0]), description.getOption()));
                    }
                } else if (configurable2 instanceof AllFileTemplatesConfigurable) {
                    for (Map.Entry entry : TraverseUIStarter.processFileTemplates(splitByResourcePath).entrySet()) {
                        entryElement = TraverseUIStarter.createConfigurableElement(configurable2);
                        TraverseUIStarter.writeOptions(entryElement, (Set)entry.getValue());
                        TraverseUIStarter.addElement(roots2, entryElement, (String)entry.getKey());
                    }
                }
                String module2 = splitByResourcePath ? TraverseUIStarter.getModuleByClass(configurable2.getOriginalClass()) : "";
                TraverseUIStarter.addElement(roots2, configurableElement, module2);
            }
        }
        finally {
            EdtInvocationManager.invokeAndWaitIfNeeded(() -> {
                for (SearchableConfigurable configurable2 : options2.keySet()) {
                    configurable2.disposeUIResources();
                }
            });
        }
        TraverseUIStarter.saveResults(outputPath, roots2);
    }

    private static void saveResults(@NotNull Path outputPath, Map<String, Element> roots2) throws IOException {
        if (outputPath == null) {
            TraverseUIStarter.$$$reportNull$$$0(4);
        }
        for (Map.Entry<String, Element> entry : roots2.entrySet()) {
            Path output;
            String module2 = entry.getKey();
            if (module2.isEmpty()) {
                output = outputPath.resolve(SearchableOptionsRegistrar.getSearchableOptionsXmlName());
            } else {
                Path moduleDir = outputPath.resolve(module2);
                Files.deleteIfExists(moduleDir.resolve("classpath.index"));
                output = moduleDir.resolve("search/" + module2 + "." + SearchableOptionsRegistrar.getSearchableOptionsXmlName());
            }
            JDOMUtil.write(entry.getValue(), output);
            System.out.println("Output written to " + output);
        }
        for (TraverseUIHelper extension2 : TraverseUIHelper.helperExtensionPoint.getExtensionList()) {
            extension2.afterResultsAreSaved();
        }
    }

    @NotNull
    private static Element createConfigurableElement(@NotNull SearchableConfigurable configurable2) {
        if (configurable2 == null) {
            TraverseUIStarter.$$$reportNull$$$0(5);
        }
        Element configurableElement = new Element(CONFIGURABLE);
        configurableElement.setAttribute(ID, configurable2.getId());
        configurableElement.setAttribute(CONFIGURABLE_NAME, configurable2.getDisplayName());
        Element element = configurableElement;
        if (element == null) {
            TraverseUIStarter.$$$reportNull$$$0(6);
        }
        return element;
    }

    private static void addElement(@NotNull Map<String, Element> roots2, @NotNull Element element, @NotNull String module2) {
        if (roots2 == null) {
            TraverseUIStarter.$$$reportNull$$$0(7);
        }
        if (element == null) {
            TraverseUIStarter.$$$reportNull$$$0(8);
        }
        if (module2 == null) {
            TraverseUIStarter.$$$reportNull$$$0(9);
        }
        roots2.computeIfAbsent(module2, __ -> new Element(OPTIONS)).addContent(element);
    }

    @NotNull
    private static Map<String, Set<OptionDescription>> processFileTemplates(boolean splitByResourcePath) {
        SearchableOptionsRegistrar optionsRegistrar = SearchableOptionsRegistrar.getInstance();
        HashMap<String, Set<OptionDescription>> options2 = new HashMap<String, Set<OptionDescription>>();
        FileTemplateManager fileTemplateManager = FileTemplateManager.getDefaultInstance();
        TraverseUIStarter.processTemplates(optionsRegistrar, options2, fileTemplateManager.getAllTemplates(), splitByResourcePath);
        TraverseUIStarter.processTemplates(optionsRegistrar, options2, fileTemplateManager.getAllPatterns(), splitByResourcePath);
        TraverseUIStarter.processTemplates(optionsRegistrar, options2, fileTemplateManager.getAllCodeTemplates(), splitByResourcePath);
        TraverseUIStarter.processTemplates(optionsRegistrar, options2, fileTemplateManager.getAllJ2eeTemplates(), splitByResourcePath);
        HashMap<String, Set<OptionDescription>> hashMap = options2;
        if (hashMap == null) {
            TraverseUIStarter.$$$reportNull$$$0(10);
        }
        return hashMap;
    }

    private static void processTemplates(SearchableOptionsRegistrar registrar, Map<String, Set<OptionDescription>> options2, FileTemplate[] templates, boolean splitByResourcePath) {
        for (FileTemplate template : templates) {
            String module2 = splitByResourcePath && template instanceof BundledFileTemplate ? TraverseUIStarter.getModuleByTemplate((BundledFileTemplate)template) : "";
            TraverseUIStarter.collectOptions(registrar, options2.computeIfAbsent(module2, __ -> new TreeSet()), template.getName(), null);
        }
    }

    @NotNull
    private static String getModuleByTemplate(@NotNull BundledFileTemplate template) {
        if (template == null) {
            TraverseUIStarter.$$$reportNull$$$0(11);
        }
        String url = template.toString();
        String path2 = StringUtil.substringBefore(url, "fileTemplates");
        assert (path2 != null) : "Template URL doesn't contain 'fileTemplates' directory.";
        if (path2.startsWith("jar")) {
            path2 = StringUtil.trimEnd(path2, "!/");
        }
        String string2 = PathUtil.getFileName(path2);
        if (string2 == null) {
            TraverseUIStarter.$$$reportNull$$$0(12);
        }
        return string2;
    }

    private static void collectOptions(SearchableOptionsRegistrar registrar, Set<? super OptionDescription> options2, @NotNull String text2, String path2) {
        if (text2 == null) {
            TraverseUIStarter.$$$reportNull$$$0(13);
        }
        for (String word2 : registrar.getProcessedWordsWithoutStemming(text2)) {
            options2.add((OptionDescription)new OptionDescription(word2, text2, path2));
        }
    }

    private static void processOptionsContainingConfigurable(OptionsContainingConfigurable configurable2, Element configurableElement) {
        Set optionsPath = configurable2.processListOptions();
        TreeSet result2 = new TreeSet();
        TraverseUIStarter.wordsToOptionDescriptors(optionsPath, null, result2);
        Map optionsWithPaths = configurable2.processListOptionsWithPaths();
        for (String path2 : optionsWithPaths.keySet()) {
            TraverseUIStarter.wordsToOptionDescriptors((Set)optionsWithPaths.get(path2), path2, result2);
        }
        TraverseUIStarter.writeOptions(configurableElement, result2);
    }

    private static void wordsToOptionDescriptors(@NotNull Set<String> optionsPath, @Nullable String path2, @NotNull Set<? super OptionDescription> result2) {
        if (optionsPath == null) {
            TraverseUIStarter.$$$reportNull$$$0(14);
        }
        if (result2 == null) {
            TraverseUIStarter.$$$reportNull$$$0(15);
        }
        SearchableOptionsRegistrar registrar = SearchableOptionsRegistrar.getInstance();
        for (String opt : optionsPath) {
            for (String word2 : registrar.getProcessedWordsWithoutStemming(opt)) {
                if (word2 == null) continue;
                result2.add((OptionDescription)new OptionDescription(word2, opt, path2));
            }
        }
    }

    @NotNull
    private static Map<String, Set<OptionDescription>> processKeymap(boolean splitByResourcePath) {
        HashMap<String, Set<OptionDescription>> map2 = new HashMap<String, Set<OptionDescription>>();
        ActionManagerImpl actionManager = (ActionManagerImpl)ActionManager.getInstance();
        Map<String, PluginId> actionToPluginId = splitByResourcePath ? TraverseUIStarter.getActionToPluginId() : Collections.emptyMap();
        String componentName = "ActionManager";
        SearchableOptionsRegistrar searchableOptionsRegistrar = SearchableOptionsRegistrar.getInstance();
        for (String id : actionManager.getActionIds()) {
            String description;
            AnAction action2 = actionManager.getAction(id);
            if (action2 == null) {
                throw new IllegalStateException("Cannot find action by id " + id);
            }
            String module2 = splitByResourcePath ? TraverseUIStarter.getModuleByAction(action2, actionToPluginId) : "";
            Set options2 = map2.computeIfAbsent(module2, __ -> new TreeSet());
            String text2 = action2.getTemplatePresentation().getText();
            if (text2 != null) {
                TraverseUIStarter.collectOptions(searchableOptionsRegistrar, options2, text2, componentName);
            }
            if ((description = action2.getTemplatePresentation().getDescription()) == null) continue;
            TraverseUIStarter.collectOptions(searchableOptionsRegistrar, options2, description, componentName);
        }
        HashMap<String, Set<OptionDescription>> hashMap = map2;
        if (hashMap == null) {
            TraverseUIStarter.$$$reportNull$$$0(16);
        }
        return hashMap;
    }

    @NotNull
    private static Map<String, PluginId> getActionToPluginId() {
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        HashMap<String, PluginId> actionToPluginId = new HashMap<String, PluginId>();
        for (PluginId id : PluginId.getRegisteredIds()) {
            for (String action2 : actionManager.getPluginActions(id)) {
                actionToPluginId.put(action2, id);
            }
        }
        HashMap<String, PluginId> hashMap = actionToPluginId;
        if (hashMap == null) {
            TraverseUIStarter.$$$reportNull$$$0(17);
        }
        return hashMap;
    }

    @NotNull
    private static String getModuleByAction(@NotNull AnAction rootAction, @NotNull Map<String, PluginId> actionToPluginId) {
        IdeaPluginDescriptor plugin;
        if (rootAction == null) {
            TraverseUIStarter.$$$reportNull$$$0(18);
        }
        if (actionToPluginId == null) {
            TraverseUIStarter.$$$reportNull$$$0(19);
        }
        ArrayDeque<AnAction> actions = new ArrayDeque<AnAction>();
        actions.add(rootAction);
        while (!actions.isEmpty()) {
            AnAction action2 = (AnAction)actions.remove();
            String module2 = TraverseUIStarter.getModuleByClass(action2.getClass());
            if (!ROOT_ACTION_MODULE.equals(module2)) {
                String string2 = module2;
                if (string2 == null) {
                    TraverseUIStarter.$$$reportNull$$$0(20);
                }
                return string2;
            }
            if (!(action2 instanceof ActionGroup)) continue;
            Collections.addAll(actions, ((ActionGroup)action2).getChildren(null));
        }
        ActionManager actionManager = ActionManager.getInstance();
        PluginId id = actionToPluginId.get(actionManager.getId(rootAction));
        if (id != null && (plugin = PluginManagerCore.getPlugin(id)) != null && !plugin.getName().equals(PluginManagerCore.SPECIAL_IDEA_PLUGIN_ID.getIdString())) {
            String string3 = PathUtil.getFileName(plugin.getPluginPath().toString());
            if (string3 == null) {
                TraverseUIStarter.$$$reportNull$$$0(21);
            }
            return string3;
        }
        return ROOT_ACTION_MODULE;
    }

    @NotNull
    private static String getModuleByClass(@NotNull Class<?> aClass) {
        if (aClass == null) {
            TraverseUIStarter.$$$reportNull$$$0(22);
        }
        String string2 = PathUtil.getFileName(PathUtil.getJarPathForClass(aClass));
        if (string2 == null) {
            TraverseUIStarter.$$$reportNull$$$0(23);
        }
        return string2;
    }

    private static void writeOptions(@NotNull Element configurableElement, @NotNull Set<? extends OptionDescription> options2) {
        if (configurableElement == null) {
            TraverseUIStarter.$$$reportNull$$$0(24);
        }
        if (options2 == null) {
            TraverseUIStarter.$$$reportNull$$$0(25);
        }
        for (OptionDescription optionDescription : options2) {
            configurableElement.addContent(TraverseUIStarter.createOptionElement(optionDescription.getPath(), optionDescription.getHit(), optionDescription.getOption()));
        }
    }

    @NotNull
    private static Element createOptionElement(String path2, String hit, String word2) {
        Element optionElement = new Element(OPTION);
        optionElement.setAttribute(NAME, word2);
        if (path2 != null) {
            optionElement.setAttribute(PATH, path2);
        }
        optionElement.setAttribute(HIT, hit);
        Element element = optionElement;
        if (element == null) {
            TraverseUIStarter.$$$reportNull$$$0(26);
        }
        return element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 10, 12, 16, 17, 20, 21, 23, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = CONFIGURABLE;
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/search/TraverseUIStarter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionsPath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootAction";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionToPluginId";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurableElement";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = OPTIONS;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/search/TraverseUIStarter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurableElement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "processFileTemplates";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleByTemplate";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "processKeymap";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionToPluginId";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleByAction";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleByClass";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "premain";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "main";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "startup";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveResults";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurableElement";
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 26: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getModuleByTemplate";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectOptions";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "wordsToOptionDescriptors";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getModuleByAction";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getModuleByClass";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "writeOptions";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6, 10, 12, 16, 17, 20, 21, 23, 26 -> new IllegalStateException(string2);
        };
    }
}

