/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.CommonBundle;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.DataManager;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.util.DeleteUtil;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.safeDelete.SafeDeleteDialog;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import com.intellij.util.ui.IoErrorText;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class DeleteHandler {
    private static Boolean ourOverrideNeedsConfirmation;

    private DeleteHandler() {
    }

    public static void deletePsiElement(PsiElement[] elementsToDelete, Project project2) {
        DeleteHandler.deletePsiElement(elementsToDelete, project2, true);
    }

    public static void deletePsiElement(PsiElement[] elementsToDelete, final Project project2, boolean needConfirmation) {
        if (elementsToDelete == null || elementsToDelete.length == 0) {
            return;
        }
        needConfirmation = ourOverrideNeedsConfirmation != null ? ourOverrideNeedsConfirmation : needConfirmation;
        final PsiElement[] elements = PsiTreeUtil.filterAncestors(elementsToDelete);
        boolean safeDeleteApplicable = ContainerUtil.and(elements, SafeDeleteProcessor::validElement);
        boolean dumb = DumbService.getInstance(project2).isDumb();
        if (safeDeleteApplicable && !dumb) {
            final Ref<Boolean> exit = Ref.create(false);
            SafeDeleteDialog dialog = new SafeDeleteDialog(project2, elements, new SafeDeleteDialog.Callback(){

                @Override
                public void run(SafeDeleteDialog dialog) {
                    if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project2, Arrays.asList(elements), (boolean)true)) {
                        return;
                    }
                    SafeDeleteProcessor processor = SafeDeleteProcessor.createInstance(project2, () -> {
                        exit.set(true);
                        dialog.close(0);
                    }, elements, dialog.isSearchInComments(), dialog.isSearchForTextOccurences(), true);
                    processor.run();
                }
            }){

                @Override
                protected boolean isDelete() {
                    return true;
                }
            };
            if (needConfirmation) {
                dialog.setTitle(RefactoringBundle.message((String)"delete.title"));
                if (!dialog.showAndGet() || exit.get().booleanValue()) {
                    return;
                }
            }
        } else {
            int result2;
            Object warningMessage = DeleteUtil.generateWarningMessage("prompt.delete.elements", elements);
            boolean anyDirectories = false;
            String directoryName = null;
            for (PsiElement psiElement : elementsToDelete) {
                if (!(psiElement instanceof PsiDirectory) || PsiUtilBase.isSymLink((PsiDirectory)psiElement)) continue;
                anyDirectories = true;
                directoryName = ((PsiDirectory)psiElement).getName();
                break;
            }
            if (anyDirectories) {
                warningMessage = elements.length == 1 ? (String)warningMessage + IdeBundle.message((String)"warning.delete.all.files.and.subdirectories", (Object[])new Object[]{directoryName}) : (String)warningMessage + IdeBundle.message((String)"warning.delete.all.files.and.subdirectories.in.the.selected.directory", (Object[])new Object[0]);
            }
            if (safeDeleteApplicable) {
                warningMessage = (String)warningMessage + LangBundle.message("dialog.message.warning.safe.delete.not.available.while.updates.indices.no.usages.will.be.checked", ApplicationNamesInfo.getInstance().getFullProductName());
            }
            if (needConfirmation && (result2 = Messages.showOkCancelDialog((Project)project2, (String)warningMessage, (String)IdeBundle.message((String)"title.delete", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"button.delete", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon())) != 0) {
                return;
            }
        }
        DeleteHandler.deleteInCommand(project2, elements);
    }

    private static boolean makeWritable(Project project2, PsiElement[] elements) {
        SmartList<PsiElement> directories = new SmartList<PsiElement>();
        for (PsiElement e : elements) {
            if (!(e instanceof PsiFileSystemItem) || e.getParent() == null) continue;
            directories.add(e.getParent());
        }
        return CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, Arrays.asList(elements), directories, (boolean)false);
    }

    private static void deleteInCommand(Project project2, PsiElement[] elements) {
        CommandProcessor.getInstance().executeCommand(project2, () -> NonProjectFileWritingAccessProvider.disableChecksDuring(() -> {
            SmartPointerManager smartPointerManager = SmartPointerManager.getInstance(project2);
            List<SmartPsiElementPointer> pointers2 = ContainerUtil.map(elements, smartPointerManager::createSmartPsiElementPointer);
            if (!DeleteHandler.makeWritable(project2, elements)) {
                return;
            }
            DataContext context2 = DataManager.getInstance().getDataContext();
            if (CommonDataKeys.EDITOR.getData(context2) == null) {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(project2);
            }
            if (ContainerUtil.and(elements, DeleteHandler::isLocalFile)) {
                DeleteHandler.doDeleteFiles(project2, elements);
            } else {
                for (SmartPsiElementPointer pointer : pointers2) {
                    Object elementToDelete = pointer.getElement();
                    if (elementToDelete == null) continue;
                    DeleteHandler.doDelete(project2, elementToDelete);
                }
            }
        }), RefactoringBundle.message((String)"safe.delete.command", (Object[])new Object[]{RefactoringUIUtil.calculatePsiElementDescriptionList(elements)}), null);
    }

    private static boolean isLocalFile(PsiElement e) {
        VirtualFile file2;
        return e instanceof PsiFileSystemItem && (file2 = ((PsiFileSystemItem)e).getVirtualFile()) != null && file2.isInLocalFileSystem();
    }

    private static boolean clearFileReadOnlyFlags(Project project2, PsiElement elementToDelete) {
        VirtualFile virtualFile2;
        PsiFile file2;
        if (elementToDelete instanceof PsiDirectory) {
            VirtualFile virtualFile3 = ((PsiDirectory)elementToDelete).getVirtualFile();
            if (virtualFile3.isInLocalFileSystem() && !virtualFile3.is(VFileProperty.SYMLINK)) {
                ArrayList readOnlyFiles = new ArrayList();
                CommonRefactoringUtil.collectReadOnlyFiles((VirtualFile)virtualFile3, readOnlyFiles);
                if (!readOnlyFiles.isEmpty()) {
                    VirtualFile file3;
                    String message = IdeBundle.message((String)"prompt.directory.contains.read.only.files", (Object[])new Object[]{virtualFile3.getPresentableUrl()});
                    int _result = Messages.showYesNoDialog((Project)project2, (String)message, (String)IdeBundle.message((String)"title.delete", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
                    if (_result != 0) {
                        return false;
                    }
                    boolean success = true;
                    Iterator iterator2 = readOnlyFiles.iterator();
                    while (iterator2.hasNext() && (success = DeleteHandler.clearReadOnlyFlag(file3 = (VirtualFile)iterator2.next(), project2))) {
                    }
                    if (!success) {
                        return false;
                    }
                }
            }
        } else if (!(elementToDelete.isWritable() || elementToDelete instanceof PsiFileSystemItem && PsiUtilBase.isSymLink((PsiFileSystemItem)elementToDelete) || (file2 = elementToDelete.getContainingFile()) == null || !(virtualFile2 = file2.getVirtualFile()).isInLocalFileSystem())) {
            int _result = ((MessagesEx.MessageInfo)((MessagesEx.MessageInfo)MessagesEx.fileIsReadOnly((Project)project2, (VirtualFile)virtualFile2).setTitle(IdeBundle.message((String)"title.delete", (Object[])new Object[0]))).appendMessage(" " + IdeBundle.message((String)"prompt.delete.it.anyway", (Object[])new Object[0]))).askYesNo();
            if (_result != 0) {
                return false;
            }
            boolean success = DeleteHandler.clearReadOnlyFlag(virtualFile2, project2);
            if (!success) {
                return false;
            }
        }
        return true;
    }

    private static void doDelete(Project project2, PsiElement element) {
        if (!DeleteHandler.clearFileReadOnlyFlags(project2, element)) {
            return;
        }
        try {
            element.checkDelete();
        }
        catch (IncorrectOperationException e) {
            Messages.showMessageDialog((Project)project2, (String)e.getMessage(), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                element.delete();
            }
            catch (IncorrectOperationException e) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((Project)project2, (String)e.getMessage(), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon()));
            }
        });
    }

    private static void doDeleteFiles(Project project2, PsiElement[] fileElements) {
        for (PsiElement file2 : fileElements) {
            if (DeleteHandler.clearFileReadOnlyFlags(project2, file2)) continue;
            return;
        }
        LocalFilesDeleteTask task2 = new LocalFilesDeleteTask(project2, fileElements);
        ProgressManager.getInstance().run(task2);
        if (task2.error != null) {
            String file3;
            String string2 = file3 = task2.error instanceof FileSystemException ? ((FileSystemException)task2.error).getFile() : null;
            if (file3 != null) {
                String message = IoErrorText.message((Throwable)task2.error);
                String yes = RevealFileAction.getActionName();
                String no = CommonBundle.getCloseButtonText();
                if (Messages.showYesNoDialog((Project)project2, (String)message, (String)CommonBundle.getErrorTitle(), (String)yes, (String)no, (Icon)Messages.getErrorIcon()) == 0) {
                    RevealFileAction.openFile((Path)Paths.get(file3, new String[0]));
                }
            } else {
                Messages.showMessageDialog((Project)project2, (String)IoErrorText.message((Throwable)task2.error), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            }
        }
        if (task2.aborted != null) {
            VfsUtil.markDirtyAndRefresh(true, true, false, task2.aborted);
        }
        if (!task2.processed.isEmpty()) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                for (PsiElement fileElement : task2.processed) {
                    try {
                        fileElement.delete();
                    }
                    catch (IncorrectOperationException e) {
                        ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((Project)project2, (String)e.getMessage(), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon()));
                    }
                }
            });
        }
    }

    private static boolean clearReadOnlyFlag(VirtualFile virtualFile2, Project project2) {
        boolean[] success = new boolean[1];
        CommandProcessor.getInstance().executeCommand(project2, () -> {
            Runnable action2 = () -> {
                try {
                    ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)virtualFile2, (boolean)false);
                    success[0] = true;
                }
                catch (IOException e1) {
                    Messages.showMessageDialog((Project)project2, (String)e1.getMessage(), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                }
            };
            ApplicationManager.getApplication().runWriteAction(action2);
        }, "", null);
        return success[0];
    }

    public static boolean shouldEnableDeleteAction(PsiElement[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        for (PsiElement element : elements) {
            VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile(element);
            if (virtualFile2 == null || virtualFile2 instanceof LightVirtualFile) {
                return false;
            }
            if (WritingAccessProvider.isPotentiallyWritable(virtualFile2, element.getProject())) continue;
            return false;
        }
        return true;
    }

    @TestOnly
    public static void overrideNeedsConfirmationInTests(boolean needsConfirmation, @NotNull Disposable disposable) {
        if (disposable == null) {
            DeleteHandler.$$$reportNull$$$0(0);
        }
        ourOverrideNeedsConfirmation = needsConfirmation;
        Disposer.register(disposable, () -> {
            ourOverrideNeedsConfirmation = null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/ide/util/DeleteHandler", "overrideNeedsConfirmationInTests"));
    }

    private static class LocalFilesDeleteTask
    extends Task.Modal {
        private final PsiElement[] myFileElements;
        List<PsiElement> processed = new ArrayList<PsiElement>();
        VirtualFile aborted = null;
        Throwable error = null;

        LocalFilesDeleteTask(Project project2, PsiElement[] fileElements) {
            super(project2, IdeBundle.message((String)"progress.deleting", (Object[])new Object[0]), true);
            this.myFileElements = fileElements;
        }

        @Override
        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                LocalFilesDeleteTask.$$$reportNull$$$0(0);
            }
            indicator.setIndeterminate(true);
            try {
                for (PsiElement element : this.myFileElements) {
                    if (!indicator.isCanceled()) {
                        VirtualFile file2;
                        this.aborted = file2 = ((PsiFileSystemItem)element).getVirtualFile();
                        Path path2 = file2.toNioPath();
                        indicator.setText(path2.toString());
                        try {
                            NioFiles.deleteRecursively(path2, p -> {
                                indicator.checkCanceled();
                                indicator.setText2(path2.relativize((Path)p).toString());
                            });
                            this.processed.add(element);
                            this.aborted = null;
                        }
                        catch (ProcessCanceledException processCanceledException) {
                            // empty catch block
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                Logger.getInstance(this.getClass()).info(t);
                this.error = t;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/util/DeleteHandler$LocalFilesDeleteTask", "run"));
        }
    }

    public static class DefaultDeleteProvider
    implements DeleteProvider {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                DefaultDeleteProvider.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext2) {
            if (dataContext2 == null) {
                DefaultDeleteProvider.$$$reportNull$$$0(1);
            }
            if (CommonDataKeys.PROJECT.getData(dataContext2) == null) {
                return false;
            }
            PsiElement[] elements = DefaultDeleteProvider.getPsiElements(dataContext2);
            return DeleteHandler.shouldEnableDeleteAction(elements);
        }

        private static PsiElement @Nullable [] getPsiElements(DataContext dataContext2) {
            PsiElement[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext2);
            if (elements == null) {
                PsiElement data2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext2);
                if (data2 != null) {
                    elements = new PsiElement[]{data2};
                } else {
                    PsiFile data1 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext2);
                    if (data1 != null) {
                        elements = new PsiElement[]{data1};
                    }
                }
            }
            return elements;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteElement(@NotNull DataContext dataContext2) {
            PsiElement[] elements;
            if (dataContext2 == null) {
                DefaultDeleteProvider.$$$reportNull$$$0(2);
            }
            if ((elements = DefaultDeleteProvider.getPsiElements(dataContext2)) == null) {
                return;
            }
            Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
            if (project2 == null) {
                return;
            }
            LocalHistoryAction a = LocalHistory.getInstance().startAction(IdeBundle.message((String)"progress.deleting", (Object[])new Object[0]));
            try {
                DeleteHandler.deletePsiElement(elements, project2);
            }
            finally {
                a.finish();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/DeleteHandler$DefaultDeleteProvider";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/DeleteHandler$DefaultDeleteProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "canDeleteElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteElement";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 1, 2 -> new IllegalArgumentException(string2);
            };
        }
    }
}

