/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.actions.GotoClassPresentationUpdater;
import com.intellij.ide.util.DirectoryChooserModuleTreeView;
import com.intellij.ide.util.DirectoryChooserView;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.gotoByName.ChooseByNamePanel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectoryChooser
extends DialogWrapper {
    private static final String FILTER_NON_EXISTING = "filter_non_existing";
    private static final String DEFAULT_SELECTION = "last_directory_selection";
    private final DirectoryChooserView myView;
    private boolean myShowExisting;
    private PsiDirectory myDefaultSelection;
    private final List<ItemWrapper> myItems;
    private PsiElement mySelection;
    private final TabbedPaneWrapper myTabbedPaneWrapper;
    private final ChooseByNamePanel myByClassPanel;
    private final ChooseByNamePanel myByFilePanel;
    private final JLabel myDescription;

    public DirectoryChooser(@NotNull Project project2) {
        if (project2 == null) {
            DirectoryChooser.$$$reportNull$$$0(0);
        }
        this(project2, new DirectoryChooserModuleTreeView(project2));
    }

    public DirectoryChooser(@NotNull Project project2, @NotNull DirectoryChooserView view) {
        if (project2 == null) {
            DirectoryChooser.$$$reportNull$$$0(1);
        }
        if (view == null) {
            DirectoryChooser.$$$reportNull$$$0(2);
        }
        super(project2, true);
        this.myItems = new ArrayList<ItemWrapper>();
        this.myDescription = new JLabel();
        this.myView = view;
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        this.myShowExisting = !propertiesComponent.isTrueValue(FILTER_NON_EXISTING);
        this.myTabbedPaneWrapper = new TabbedPaneWrapper(this.getDisposable());
        String gotoClassText = GotoClassPresentationUpdater.getTabTitle();
        this.myByClassPanel = gotoClassText.startsWith("Class") ? this.createChooserPanel(project2, true) : null;
        this.myByFilePanel = this.createChooserPanel(project2, false);
        this.init();
    }

    public void setDescription(@NlsContexts.Label String description) {
        this.myDescription.setText(description);
    }

    private ChooseByNamePanel createChooserPanel(@NotNull Project project2, boolean useClass) {
        if (project2 == null) {
            DirectoryChooser.$$$reportNull$$$0(3);
        }
        FilteringGotoByModel model2 = useClass ? new GotoClassModel2(project2){

            @Override
            public boolean loadInitialCheckBoxState() {
                return true;
            }

            @Override
            public void saveInitialCheckBoxState(boolean state) {
            }

            @Override
            @Nullable
            public String getPromptText() {
                return null;
            }
        } : new GotoFileModel(project2){

            @Override
            public boolean loadInitialCheckBoxState() {
                return true;
            }

            @Override
            public void saveInitialCheckBoxState(boolean state) {
            }

            @Override
            public String getPromptText() {
                return null;
            }
        };
        ChooseByNamePanel panel2 = new ChooseByNamePanel(project2, model2, "", false, null){

            @Override
            protected void showTextFieldPanel() {
            }

            @Override
            protected void close(boolean isOk) {
                super.close(isOk);
                if (isOk) {
                    List<Object> elements = this.getChosenElements();
                    if (!elements.isEmpty()) {
                        this.myActionListener.elementChosen(elements.get(0));
                    }
                    DirectoryChooser.this.doOKAction();
                } else {
                    DirectoryChooser.this.doCancelAction();
                }
            }
        };
        UiNotifyConnector.doWhenFirstShown((JComponent)panel2.getPanel(), () -> panel2.invoke(new ChooseByNamePopupComponent.Callback(){

            @Override
            public void elementChosen(Object element) {
                DirectoryChooser.this.setSelection(element);
            }
        }, ModalityState.stateForComponent(this.getRootPane()), false));
        Disposer.register(this.myDisposable, panel2);
        return panel2;
    }

    protected void doOKAction() {
        PsiDirectory directory;
        ItemWrapper item;
        PropertiesComponent.getInstance().setValue(FILTER_NON_EXISTING, !this.myShowExisting);
        JComponent selectedTab = this.myTabbedPaneWrapper.getSelectedComponent();
        if (selectedTab == this.myByFilePanel.getPanel() || this.myByClassPanel != null && selectedTab == this.myByClassPanel.getPanel()) {
            this.setSelection(selectedTab == this.myByFilePanel.getPanel() ? this.myByFilePanel.getChosenElement() : this.myByClassPanel.getChosenElement());
        }
        if ((item = this.myView.getSelectedItem()) != null && (directory = item.getDirectory()) != null) {
            PropertiesComponent.getInstance(directory.getProject()).setValue(DEFAULT_SELECTION, directory.getVirtualFile().getPath());
        }
        super.doOKAction();
    }

    @Nullable
    protected JComponent createNorthPanel() {
        return this.myDescription;
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        DefaultActionGroup actionGroup2 = new DefaultActionGroup();
        actionGroup2.add((AnAction)new FilterExistentAction());
        ActionToolbar chooser2 = ActionManager.getInstance().createActionToolbar("DirectoryChooser", (ActionGroup)actionGroup2, true);
        chooser2.setTargetComponent(this.myView.getComponent());
        JComponent chooserComponent = chooser2.getComponent();
        chooserComponent.setBorder(JBUI.Borders.empty(6, 0));
        panel2.add((Component)chooserComponent, "North");
        Runnable runnable = () -> this.enableButtons();
        this.myView.onSelectionChange(runnable);
        JComponent component2 = this.myView.getComponent();
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)component2);
        int prototypeWidth = component2.getFontMetrics(component2.getFont()).stringWidth("X:\\1234567890\\1234567890\\com\\company\\system\\subsystem");
        jScrollPane.setPreferredSize(new Dimension(Math.max(300, prototypeWidth), 300));
        jScrollPane.putClientProperty(UIUtil.KEEP_BORDER_SIDES, 15);
        this.installEnterAction(component2);
        panel2.add((Component)jScrollPane, "Center");
        this.myTabbedPaneWrapper.addTab(LangBundle.message("tab.title.directory.structure", new Object[0]), (JComponent)panel2);
        if (this.myByClassPanel != null) {
            this.myTabbedPaneWrapper.addTab(LangBundle.message("tab.title.by.class", new Object[0]), (JComponent)this.myByClassPanel.getPanel());
        }
        this.myTabbedPaneWrapper.addTab(LangBundle.message("tab.title.by.file", new Object[0]), (JComponent)this.myByFilePanel.getPanel());
        this.myTabbedPaneWrapper.addChangeListener(e -> this.enableButtons());
        return this.myTabbedPaneWrapper.getComponent();
    }

    private void setSelection(Object element) {
        if (element instanceof PsiElement) {
            this.mySelection = (PsiElement)element;
        }
    }

    private void installEnterAction(JComponent component2) {
        KeyStroke enterKeyStroke = KeyStroke.getKeyStroke(10, 0);
        InputMap inputMap = component2.getInputMap();
        ActionMap actionMap = component2.getActionMap();
        Object oldActionKey = inputMap.get(enterKeyStroke);
        final Action oldAction = oldActionKey != null ? actionMap.get(oldActionKey) : null;
        inputMap.put(enterKeyStroke, "clickButton");
        actionMap.put("clickButton", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DirectoryChooser.this.isOKActionEnabled()) {
                    DirectoryChooser.this.doOKAction();
                } else if (oldAction != null) {
                    oldAction.actionPerformed(e);
                }
            }
        });
    }

    protected String getDimensionServiceKey() {
        return "chooseDestDirectoryDialog";
    }

    private void buildFragments() {
        ArrayList<String[]> paths2 = new ArrayList<String[]>();
        for (int i2 = 0; i2 < this.myView.getItemsSize(); ++i2) {
            ItemWrapper item = this.myView.getItemByIndex(i2);
            paths2.add(ArrayUtilRt.toStringArray(FileUtil.splitPath(item.getPresentableUrl())));
        }
        FragmentBuilder headBuilder = new FragmentBuilder(paths2){

            @Override
            protected void append(String fragment, StringBuffer buffer) {
                buffer.append(this.mySeparator);
                buffer.append(fragment);
            }

            @Override
            protected int getFragmentIndex(String[] path2, int index2) {
                return path2.length > index2 ? index2 : -1;
            }
        };
        String commonHead = headBuilder.execute();
        final int headLimit = headBuilder.getIndex();
        FragmentBuilder tailBuilder = new FragmentBuilder(paths2){

            @Override
            protected void append(String fragment, StringBuffer buffer) {
                buffer.insert(0, fragment + this.mySeparator);
            }

            @Override
            protected int getFragmentIndex(String[] path2, int index2) {
                int result2 = path2.length - 1 - index2;
                return result2 > headLimit ? result2 : -1;
            }
        };
        String commonTail = tailBuilder.execute();
        int tailLimit = tailBuilder.getIndex();
        for (int i3 = 0; i3 < this.myView.getItemsSize(); ++i3) {
            ItemWrapper item = this.myView.getItemByIndex(i3);
            String special = DirectoryChooser.concat((String[])paths2.get(i3), headLimit, tailLimit);
            item.setFragments(DirectoryChooser.createFragments(commonHead, special, commonTail));
        }
    }

    @Nullable
    private static String concat(String[] strings2, int headLimit, int tailLimit) {
        if (strings2.length <= headLimit + tailLimit) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        String separator = "";
        for (int i2 = headLimit; i2 < strings2.length - tailLimit; ++i2) {
            buffer.append(separator);
            buffer.append(strings2[i2]);
            separator = File.separator;
        }
        return buffer.toString();
    }

    private static PathFragment[] createFragments(String head, String special, String tail) {
        ArrayList<PathFragment> list2 = new ArrayList<PathFragment>(3);
        if (head != null) {
            if (special != null || tail != null) {
                list2.add(new PathFragment(head + File.separatorChar, true));
            } else {
                return new PathFragment[]{new PathFragment(head, true)};
            }
        }
        if (special != null) {
            if (tail != null) {
                list2.add(new PathFragment(special + File.separatorChar, false));
            } else {
                list2.add(new PathFragment(special, false));
            }
        }
        if (tail != null) {
            list2.add(new PathFragment(tail, true));
        }
        return list2.toArray(new PathFragment[0]);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myView.getComponent();
    }

    public void fillList(PsiDirectory[] directories, @Nullable PsiDirectory defaultSelection, Project project2, String postfixToShow) {
        this.fillList(directories, defaultSelection, project2, postfixToShow, null);
    }

    public void fillList(PsiDirectory[] directories, @Nullable PsiDirectory defaultSelection, Project project2, Map<PsiDirectory, String> postfixes) {
        this.fillList(directories, defaultSelection, project2, null, postfixes);
    }

    private void fillList(PsiDirectory[] directories, @Nullable PsiDirectory defaultSelection, Project project2, String postfixToShow, Map<PsiDirectory, String> postfixes) {
        int selectionIndex;
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReadAction.run(() -> this.fillItems(directories, postfixToShow, postfixes)), LangBundle.message("progress.title.validating", new Object[0]), true, project2);
        if (defaultSelection == null && (defaultSelection = DirectoryChooser.getDefaultSelection(directories, project2)) == null && directories.length > 0) {
            defaultSelection = directories[0];
        }
        if ((selectionIndex = ArrayUtil.indexOf(directories, defaultSelection)) < 0 && directories.length == 1) {
            selectionIndex = 0;
        }
        if (selectionIndex < 0) {
            VirtualFile[] sourceRoots;
            PsiManager manager = PsiManager.getInstance(project2);
            for (VirtualFile sourceRoot : sourceRoots = ProjectRootManager.getInstance(project2).getContentSourceRoots()) {
                PsiDirectory directory;
                if (!sourceRoot.isDirectory() || (directory = manager.findDirectory(sourceRoot)) == null || !DirectoryChooser.isParent(defaultSelection, directory)) continue;
                defaultSelection = directory;
                break;
            }
        }
        this.updateView(defaultSelection, selectionIndex);
    }

    private void updateView(@Nullable PsiDirectory defaultSelection, int selectionIndex) {
        if (this.myView.getItemsSize() > 0) {
            this.myView.clearItems();
        }
        int existingIdx = 0;
        for (int i2 = 0; i2 < this.myItems.size(); ++i2) {
            ItemWrapper itemWrapper = this.myItems.get(i2);
            PsiDirectory directory = itemWrapper.getDirectory();
            String postfixForDirectory = itemWrapper.myPostfix;
            if (this.myShowExisting) {
                if (selectionIndex == i2) {
                    selectionIndex = -1;
                }
                if (postfixForDirectory != null && directory.getVirtualFile().findFileByRelativePath(StringUtil.trimStart(postfixForDirectory, File.separator)) == null) {
                    if (!DirectoryChooser.isParent(directory, defaultSelection)) continue;
                    this.myDefaultSelection = directory;
                    continue;
                }
            }
            this.myView.addItem(itemWrapper);
            if (selectionIndex < 0 && DirectoryChooser.isParent(directory, defaultSelection)) {
                selectionIndex = existingIdx;
            }
            ++existingIdx;
        }
        this.buildFragments();
        this.myView.listFilled();
        if (this.myView.getItemsSize() > 0) {
            if (selectionIndex != -1) {
                this.myView.selectItemByIndex(selectionIndex);
            } else {
                this.myView.selectItemByIndex(0);
            }
        } else {
            this.myView.clearSelection();
        }
        this.enableButtons();
        this.myView.getComponent().repaint();
    }

    private void fillItems(PsiDirectory[] directories, String postfixToShow, Map<PsiDirectory, String> postfixes) {
        for (PsiDirectory directory : directories) {
            ProgressManager.checkCanceled();
            String postfixForDirectory = postfixes == null ? postfixToShow : postfixes.get(directory);
            this.myItems.add(new ItemWrapper(directory, postfixForDirectory));
        }
    }

    @Nullable
    private static PsiDirectory getDefaultSelection(PsiDirectory[] directories, Project project2) {
        VirtualFile directoryByDefault;
        String defaultSelectionPath = PropertiesComponent.getInstance(project2).getValue(DEFAULT_SELECTION);
        if (defaultSelectionPath != null && (directoryByDefault = LocalFileSystem.getInstance().findFileByPath(defaultSelectionPath)) != null) {
            PsiDirectory directory = PsiManager.getInstance(project2).findDirectory(directoryByDefault);
            return directory != null && ArrayUtil.find(directories, directory) > -1 ? directory : null;
        }
        return null;
    }

    private static boolean isParent(PsiDirectory directory, PsiDirectory parentCandidate) {
        while (directory != null) {
            if (directory.equals(parentCandidate)) {
                return true;
            }
            directory = directory.getParentDirectory();
        }
        return false;
    }

    private void enableButtons() {
        JComponent selectedTab = this.myTabbedPaneWrapper.getSelectedComponent();
        this.setOKActionEnabled(selectedTab != null && (selectedTab == this.myByFilePanel.getPanel() || this.myByClassPanel != null && selectedTab == this.myByClassPanel.getPanel() || this.myView.getSelectedItem() != null));
    }

    @Nullable
    public PsiDirectory getSelectedDirectory() {
        PsiFile file2;
        if (this.mySelection != null && (file2 = this.mySelection.getContainingFile()) != null) {
            return file2.getContainingDirectory();
        }
        ItemWrapper wrapper2 = this.myView.getSelectedItem();
        if (wrapper2 == null) {
            return null;
        }
        return wrapper2.myDirectory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/util/DirectoryChooser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createChooserPanel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ItemWrapper {
        private final PsiDirectory myDirectory;
        private PathFragment[] myFragments;
        private final String myPostfix;
        private final Icon myIcon;
        private String myRelativeToProjectPath = null;

        public ItemWrapper(PsiDirectory directory, String postfix) {
            this.myDirectory = directory;
            this.myPostfix = postfix != null && postfix.length() > 0 ? postfix : null;
            this.myIcon = directory != null ? this.getIconInternal(directory) : PlatformIcons.FOLDER_ICON;
        }

        public PathFragment[] getFragments() {
            return this.myFragments;
        }

        public void setFragments(PathFragment[] fragments) {
            this.myFragments = fragments;
        }

        @Deprecated
        public Icon getIcon(FileIndex fileIndex) {
            return this.getIcon();
        }

        public Icon getIcon() {
            return this.myIcon;
        }

        private Icon getIconInternal(@NotNull PsiDirectory directory) {
            VirtualFile virtualFile2;
            ProjectFileIndex fileIndex;
            if (directory == null) {
                ItemWrapper.$$$reportNull$$$0(0);
            }
            if ((fileIndex = ProjectRootManager.getInstance(directory.getProject()).getFileIndex()).isInTestSourceContent(virtualFile2 = this.myDirectory.getVirtualFile())) {
                return PlatformIcons.MODULES_TEST_SOURCE_FOLDER;
            }
            if (fileIndex.isInSourceContent(virtualFile2)) {
                return PlatformIcons.MODULES_SOURCE_FOLDERS_ICON;
            }
            return PlatformIcons.FOLDER_ICON;
        }

        public String getPresentableUrl() {
            Object directoryUrl;
            if (this.myDirectory != null) {
                String projectHomeUrl;
                directoryUrl = this.myDirectory.getVirtualFile().getPresentableUrl();
                VirtualFile baseDir = this.myDirectory.getProject().getBaseDir();
                if (baseDir != null && ((String)directoryUrl).startsWith(projectHomeUrl = baseDir.getPresentableUrl())) {
                    directoryUrl = "..." + ((String)directoryUrl).substring(projectHomeUrl.length());
                }
            } else {
                directoryUrl = "";
            }
            return this.myPostfix != null ? (String)directoryUrl + this.myPostfix : directoryUrl;
        }

        public PsiDirectory getDirectory() {
            return this.myDirectory;
        }

        @NlsSafe
        public String getRelativeToProjectPath() {
            if (this.myRelativeToProjectPath == null) {
                PsiDirectory directory = this.getDirectory();
                VirtualFile virtualFile2 = directory != null ? directory.getVirtualFile() : null;
                this.myRelativeToProjectPath = virtualFile2 != null ? ProjectUtil.calcRelativeToProjectPath((VirtualFile)virtualFile2, (Project)directory.getProject(), (boolean)true, (boolean)false, (boolean)true) + ObjectUtils.notNull(this.myPostfix, "") : this.getPresentableUrl();
            }
            return this.myRelativeToProjectPath;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/ide/util/DirectoryChooser$ItemWrapper", "getIconInternal"));
        }
    }

    private class FilterExistentAction
    extends CheckboxAction {
        FilterExistentAction() {
            super(RefactoringBundle.messagePointer((String)"directory.chooser.hide.non.existing.checkBox.text", (Object[])new Object[0]), () -> UIUtil.removeMnemonic(RefactoringBundle.message((String)"directory.chooser.hide.non.existing.checkBox.text")), null);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                FilterExistentAction.$$$reportNull$$$0(0);
            }
            return DirectoryChooser.this.myShowExisting;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                FilterExistentAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            PsiDirectory directory;
            if (e == null) {
                FilterExistentAction.$$$reportNull$$$0(2);
            }
            DirectoryChooser.this.myShowExisting = state;
            ItemWrapper selectedItem = DirectoryChooser.this.myView.getSelectedItem();
            PsiDirectory psiDirectory = directory = selectedItem != null ? selectedItem.getDirectory() : null;
            if (directory == null && DirectoryChooser.this.myDefaultSelection != null) {
                directory = DirectoryChooser.this.myDefaultSelection;
            }
            DirectoryChooser.this.updateView(directory, -1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/DirectoryChooser$FilterExistentAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/DirectoryChooser$FilterExistentAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }

    private static abstract class FragmentBuilder {
        private final ArrayList<String[]> myPaths;
        private final StringBuffer myBuffer = new StringBuffer();
        private int myIndex;
        protected String mySeparator = "";

        FragmentBuilder(ArrayList<String[]> pathes) {
            this.myPaths = pathes;
            this.myIndex = 0;
        }

        public int getIndex() {
            return this.myIndex;
        }

        @Nullable
        public String execute() {
            String commonHead;
            while ((commonHead = this.getCommonFragment(this.myIndex)) != null) {
                this.append(commonHead, this.myBuffer);
                this.mySeparator = File.separator;
                ++this.myIndex;
            }
            return this.myIndex > 0 ? this.myBuffer.toString() : null;
        }

        protected abstract void append(String var1, StringBuffer var2);

        @Nullable
        private String getCommonFragment(int count2) {
            String commonFragment = null;
            for (String[] path2 : this.myPaths) {
                int index2 = this.getFragmentIndex(path2, count2);
                if (index2 == -1) {
                    return null;
                }
                if (commonFragment == null) {
                    commonFragment = path2[index2];
                    continue;
                }
                if (Comparing.strEqual(commonFragment, path2[index2], SystemInfo.isFileSystemCaseSensitive)) continue;
                return null;
            }
            return commonFragment;
        }

        protected abstract int getFragmentIndex(String[] var1, int var2);
    }

    public static class PathFragment {
        private final String myText;
        private final boolean myCommon;

        public PathFragment(String text2, boolean isCommon) {
            this.myText = text2;
            this.myCommon = isCommon;
        }

        @NlsSafe
        public String getText() {
            return this.myText;
        }

        public boolean isCommon() {
            return this.myCommon;
        }
    }
}

