/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DirectoryUtil {
    private DirectoryUtil() {
    }

    public static PsiDirectory mkdirs(PsiManager manager, String path2) throws IncorrectOperationException {
        if (File.separatorChar != '/' && path2.indexOf(File.separatorChar) != -1) {
            throw new IllegalArgumentException("separators must be '/'; path is " + path2);
        }
        @Nullable Pair<PsiDirectory, String> pair = DirectoryUtil.findLongestExistingDirectoryAndItsPath(manager, path2);
        if (pair == null) {
            return null;
        }
        PsiDirectory directory = (PsiDirectory)pair.first;
        String existingPath = (String)pair.second;
        if (path2.equals(existingPath)) {
            return directory;
        }
        String postfix = path2.substring(existingPath.length() + 1);
        StringTokenizer tokenizer = new StringTokenizer(postfix, "/");
        while (tokenizer.hasMoreTokens()) {
            directory = directory.createSubdirectory(tokenizer.nextToken());
        }
        return directory;
    }

    @Nullable
    public static PsiDirectory findLongestExistingDirectory(@NotNull PsiManager manager, @NotNull String path2) {
        Pair<PsiDirectory, String> pair;
        if (manager == null) {
            DirectoryUtil.$$$reportNull$$$0(0);
        }
        if (path2 == null) {
            DirectoryUtil.$$$reportNull$$$0(1);
        }
        return (pair = DirectoryUtil.findLongestExistingDirectoryAndItsPath(manager, path2)) != null ? (PsiDirectory)pair.first : null;
    }

    @Nullable
    private static Pair<PsiDirectory, String> findLongestExistingDirectoryAndItsPath(@NotNull PsiManager manager, @NotNull String path2) {
        if (manager == null) {
            DirectoryUtil.$$$reportNull$$$0(2);
        }
        if (path2 == null) {
            DirectoryUtil.$$$reportNull$$$0(3);
        }
        PsiDirectory directory = null;
        while (path2.length() > 0) {
            int index2;
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(path2);
            if (file2 != null) {
                directory = manager.findDirectory(file2);
                if (directory != null) break;
                return null;
            }
            if (StringUtil.endsWithChar(path2, '/')) {
                path2 = path2.substring(0, path2.length() - 1);
                if (SystemInfo.isWindows && path2.length() == 2 && OSAgnosticPathUtil.startsWithWindowsDrive(path2)) {
                    return null;
                }
            }
            if ((index2 = path2.lastIndexOf(47)) == -1) {
                return null;
            }
            path2 = path2.substring(0, index2);
        }
        return Pair.create(directory, path2);
    }

    public static PsiDirectory createSubdirectories(String subDirName, PsiDirectory baseDirectory, String delim) throws IncorrectOperationException {
        StringTokenizer tokenizer = new StringTokenizer(subDirName, delim);
        PsiDirectory dir = baseDirectory;
        boolean firstToken = true;
        while (tokenizer.hasMoreTokens()) {
            String dirName = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                if (firstToken && "~".equals(dirName)) {
                    VirtualFile userHomeDir = VfsUtil.getUserHomeDir();
                    if (userHomeDir == null) {
                        throw new IncorrectOperationException("User home directory not found");
                    }
                    PsiDirectory directory1 = baseDirectory.getManager().findDirectory(userHomeDir);
                    if (directory1 == null) {
                        throw new IncorrectOperationException("User home directory not found");
                    }
                    dir = directory1;
                    continue;
                }
                if ("..".equals(dirName)) {
                    if ((dir = dir.getParentDirectory()) != null) continue;
                    throw new IncorrectOperationException("Not a valid directory");
                }
                if (".".equals(dirName)) continue;
                PsiDirectory existingDir = dir.findSubdirectory(dirName);
                if (existingDir != null) {
                    dir = existingDir;
                    continue;
                }
            }
            dir = dir.createSubdirectory(dirName);
            firstToken = false;
        }
        return dir;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/util/DirectoryUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findLongestExistingDirectory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findLongestExistingDirectoryAndItsPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

