/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.ui.configuration.CommonContentEntriesEditor;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.FilteredQuery;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlatformPackageUtil {
    private static final Logger LOG = Logger.getInstance(PlatformPackageUtil.class);

    @ApiStatus.Internal
    public static String getPackageName(@NotNull VirtualFile directory, @NotNull Project project2) {
        if (directory == null) {
            PlatformPackageUtil.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            PlatformPackageUtil.$$$reportNull$$$0(1);
        }
        return DirectoryIndex.getInstance(project2).getPackageName(directory);
    }

    @ApiStatus.Internal
    @NotNull
    public static Query<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName, boolean includeLibrarySources, @NotNull Project project2) {
        if (packageName == null) {
            PlatformPackageUtil.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            PlatformPackageUtil.$$$reportNull$$$0(3);
        }
        Query<VirtualFile> query2 = DirectoryIndex.getInstance(project2).getDirectoriesByPackageName(packageName, includeLibrarySources);
        if (query2 == null) {
            PlatformPackageUtil.$$$reportNull$$$0(4);
        }
        return query2;
    }

    @ApiStatus.Internal
    public static Query<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName, @NotNull GlobalSearchScope scope, @NotNull Project project2) {
        if (packageName == null) {
            PlatformPackageUtil.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            PlatformPackageUtil.$$$reportNull$$$0(6);
        }
        if (project2 == null) {
            PlatformPackageUtil.$$$reportNull$$$0(7);
        }
        return DirectoryIndex.getInstance(project2).getDirectoriesByPackageName(packageName, true).filtering(scope::contains);
    }

    @Nullable
    private static String findLongestExistingPackage(Project project2, String packageName, GlobalSearchScope scope) {
        PsiManager manager = PsiManager.getInstance(project2);
        String nameToMatch = packageName;
        while (true) {
            Query<VirtualFile> vFiles;
            PsiDirectory directory;
            if ((directory = PlatformPackageUtil.getWritableModuleDirectory(vFiles = PlatformPackageUtil.getDirectoriesByPackageName(nameToMatch, false, project2), scope, manager)) != null) {
                return PlatformPackageUtil.getPackageName(directory.getVirtualFile(), project2);
            }
            int lastDotIndex = nameToMatch.lastIndexOf(46);
            if (lastDotIndex < 0) break;
            nameToMatch = nameToMatch.substring(0, lastDotIndex);
        }
        return null;
    }

    @Nullable
    private static PsiDirectory getWritableModuleDirectory(@NotNull Query<? extends VirtualFile> vFiles, GlobalSearchScope scope, PsiManager manager) {
        if (vFiles == null) {
            PlatformPackageUtil.$$$reportNull$$$0(8);
        }
        for (VirtualFile virtualFile2 : vFiles) {
            PsiDirectory directory;
            if (!scope.contains(virtualFile2) || (directory = manager.findDirectory(virtualFile2)) == null || !directory.isValid() || !directory.isWritable()) continue;
            return directory;
        }
        return null;
    }

    @Nullable
    public static PsiDirectory findOrCreateDirectoryForPackage(@NotNull Project project2, @Nullable Module module2, GlobalSearchScope scope, String packageName, PsiDirectory baseDir, boolean askUserToCreate, ThreeState chooseFlag) throws IncorrectOperationException {
        String rootPackage;
        if (project2 == null) {
            PlatformPackageUtil.$$$reportNull$$$0(9);
        }
        PsiDirectory psiDirectory = null;
        if (chooseFlag == ThreeState.UNSURE && StringUtil.isNotEmpty(packageName) && (rootPackage = PlatformPackageUtil.findLongestExistingPackage(project2, packageName, scope)) != null) {
            int beginIndex = rootPackage.length() + 1;
            packageName = beginIndex < packageName.length() ? packageName.substring(beginIndex) : "";
            Object postfixToShow = packageName.replace('.', File.separatorChar);
            if (packageName.length() > 0) {
                postfixToShow = File.separatorChar + (String)postfixToShow;
            }
            if ((psiDirectory = DirectoryChooserUtil.selectDirectory(project2, PlatformPackageUtil.getPackageDirectories(project2, rootPackage, scope), baseDir, (String)postfixToShow)) == null) {
                return null;
            }
        }
        if (psiDirectory == null) {
            if (chooseFlag == ThreeState.NO && baseDir != null) {
                VirtualFile sourceRoot = ProjectRootManager.getInstance(project2).getFileIndex().getSourceRootForFile(baseDir.getVirtualFile());
                psiDirectory = sourceRoot != null ? PsiManager.getInstance(project2).findDirectory(sourceRoot) : null;
            } else {
                if (module2 != null && !PlatformPackageUtil.checkSourceRootsConfigured(module2)) {
                    return null;
                }
                GlobalSearchScope scope_ = scope;
                List<PsiDirectory> dirs = ContainerUtil.mapNotNull(ProjectRootManager.getInstance(project2).getContentSourceRoots(), virtualFile2 -> scope_.contains((VirtualFile)virtualFile2) ? PsiManager.getInstance(project2).findDirectory((VirtualFile)virtualFile2) : null);
                psiDirectory = DirectoryChooserUtil.selectDirectory(project2, dirs.toArray(PsiDirectory.EMPTY_ARRAY), baseDir, File.separatorChar + packageName.replace('.', File.separatorChar));
                if (psiDirectory == null) {
                    return null;
                }
                VirtualFile sourceRoot = ProjectRootManager.getInstance(project2).getFileIndex().getSourceRootForFile(psiDirectory.getVirtualFile());
                psiDirectory = sourceRoot != null ? PsiManager.getInstance(project2).findDirectory(sourceRoot) : null;
            }
        }
        String restOfName = packageName;
        boolean askedToCreate = false;
        while (restOfName.length() > 0) {
            PsiDirectory foundExistingDirectory;
            String name = PlatformPackageUtil.getLeftPart(restOfName);
            PsiDirectory psiDirectory2 = foundExistingDirectory = psiDirectory != null ? psiDirectory.findSubdirectory(name) : null;
            if (foundExistingDirectory == null) {
                if (!askedToCreate && askUserToCreate) {
                    int toCreate;
                    if (!ApplicationManager.getApplication().isUnitTestMode() && (toCreate = Messages.showYesNoDialog((Project)project2, (String)IdeBundle.message((String)"prompt.create.non.existing.package", (Object[])new Object[]{packageName}), (String)IdeBundle.message((String)"title.package.not.found", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) != 0) {
                        return null;
                    }
                    askedToCreate = true;
                }
                PsiDirectory psiDirectory_ = psiDirectory;
                try {
                    psiDirectory = WriteAction.compute(() -> psiDirectory_ != null ? psiDirectory_.createSubdirectory(name) : null);
                }
                catch (IncorrectOperationException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error(e);
                }
            } else {
                psiDirectory = foundExistingDirectory;
            }
            restOfName = PlatformPackageUtil.cutLeftPart(restOfName);
        }
        return psiDirectory;
    }

    public static GlobalSearchScope adjustScope(PsiDirectory baseDir, GlobalSearchScope scope, boolean skipSourceDirsForBaseTestDirectory, boolean skipTestDirsForBaseSourceDirectory) {
        if (baseDir != null) {
            if (TestSourcesFilter.isTestSources(baseDir.getVirtualFile(), baseDir.getProject())) {
                if (skipSourceDirsForBaseTestDirectory) {
                    return scope.intersectWith(GlobalSearchScopesCore.projectTestScope(baseDir.getProject()));
                }
            } else if (skipTestDirsForBaseSourceDirectory) {
                return scope.intersectWith(GlobalSearchScopesCore.projectProductionScope(baseDir.getProject()));
            }
        }
        return scope;
    }

    private static PsiDirectory[] getPackageDirectories(Project project2, String rootPackage, GlobalSearchScope scope) {
        PsiManager manager = PsiManager.getInstance(project2);
        Query<VirtualFile> query2 = PlatformPackageUtil.getDirectoriesByPackageName(rootPackage, true, project2);
        query2 = new FilteredQuery<VirtualFile>(query2, scope::contains);
        List<PsiDirectory> directories = ContainerUtil.mapNotNull(query2.findAll(), manager::findDirectory);
        return directories.toArray(PsiDirectory.EMPTY_ARRAY);
    }

    private static boolean checkSourceRootsConfigured(Module module2) {
        VirtualFile[] sourceRoots = ModuleRootManager.getInstance(module2).getSourceRoots();
        if (sourceRoots.length == 0) {
            Messages.showErrorDialog((Project)module2.getProject(), (String)ProjectBundle.message((String)"module.source.roots.not.configured.error", (Object[])new Object[]{module2.getName()}), (String)ProjectBundle.message((String)"module.source.roots.not.configured.title", (Object[])new Object[0]));
            ProjectSettingsService.getInstance(module2.getProject()).showModuleConfigurationDialog(module2.getName(), CommonContentEntriesEditor.getName());
            sourceRoots = ModuleRootManager.getInstance(module2).getSourceRoots();
            if (sourceRoots.length == 0) {
                return false;
            }
        }
        return true;
    }

    private static String getLeftPart(String packageName) {
        int index2 = packageName.indexOf(46);
        return index2 > -1 ? packageName.substring(0, index2) : packageName;
    }

    private static String cutLeftPart(String packageName) {
        int index2 = packageName.indexOf(46);
        return index2 > -1 ? packageName.substring(index2 + 1) : "";
    }

    @Nullable
    public static PsiDirectory getDirectory(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile file2 = FileContextUtil.getContextFile(element);
        return file2 == null ? null : file2.getContainingDirectory();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/PlatformPackageUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/PlatformPackageUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoriesByPackageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoriesByPackageName";
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getWritableModuleDirectory";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateDirectoryForPackage";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4 -> new IllegalStateException(string2);
        };
    }
}

