/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PsiElementBackgroundPresentationComputerKt;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.util.PsiElementListCellRendererComponent;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.list.SelectablePanel;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005J8\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00142\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ide/util/PsiElementBackgroundListCellRenderer;", "Ljavax/swing/ListCellRenderer;", "Lcom/intellij/psi/PsiElement;", "renderer", "Lcom/intellij/ide/util/PsiElementListCellRenderer;", "(Lcom/intellij/ide/util/PsiElementListCellRenderer;)V", "myComponent", "Lcom/intellij/ide/util/PsiElementListCellRendererComponent;", "myLoadingComponentRenderer", "", "value", "", "usedInPopup", "getUsedInPopup", "()Z", "setUsedInPopup", "(Z)V", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "index", "", "isSelected", "cellHasFocus", "intellij.platform.lang.impl"})
public final class PsiElementBackgroundListCellRenderer
implements ListCellRenderer<PsiElement> {
    @NotNull
    private final PsiElementListCellRenderer<?> renderer;
    @NotNull
    private final ListCellRenderer<Object> myLoadingComponentRenderer;
    @NotNull
    private final PsiElementListCellRendererComponent myComponent;
    private boolean usedInPopup;

    public PsiElementBackgroundListCellRenderer(@NotNull PsiElementListCellRenderer<?> renderer) {
        Intrinsics.checkNotNullParameter(renderer, (String)"renderer");
        this.renderer = renderer;
        this.myLoadingComponentRenderer = (ListCellRenderer)new ColoredListCellRenderer<Object>(){

            protected void customizeCellRenderer(@NotNull JList<? extends Object> list2, @Nullable Object value, int index2, boolean selected, boolean hasFocus) {
                Intrinsics.checkNotNullParameter(list2, (String)"list");
                this.setBackground(UIUtil.getListBackground(selected, hasFocus));
                this.setIcon((Icon)AnimatedIcon.Default.INSTANCE);
                this.append(IdeBundle.message((String)"progress.text.loading", (Object[])new Object[0]));
            }
        };
        this.myComponent = new PsiElementListCellRendererComponent();
    }

    public final boolean getUsedInPopup() {
        return this.usedInPopup;
    }

    public final void setUsedInPopup(boolean value) {
        if (ExperimentalUI.isNewUI()) {
            PopupUtil.configListRendererFixedHeight((SelectablePanel)this.myComponent);
        }
        this.usedInPopup = value;
    }

    @Override
    @NotNull
    public Component getListCellRendererComponent(@NotNull JList<? extends PsiElement> list2, @NotNull PsiElement value, int index2, boolean isSelected, boolean cellHasFocus) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Deferred<TargetPresentation> future = PsiElementBackgroundPresentationComputerKt.getComputer(list2).computePresentationAsync(this.renderer, value);
        if (!future.isCompleted()) {
            Component component2 = this.myLoadingComponentRenderer.getListCellRendererComponent(list2, value, index2, isSelected, cellHasFocus);
            Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"myLoadingComponentRender\u2026isSelected, cellHasFocus)");
            return component2;
        }
        this.myComponent.removeAll();
        TargetPresentation presentation2 = future.getCompleted();
        Color defaultBg = this.usedInPopup && ExperimentalUI.isNewUI() ? JBUI.CurrentTheme.Popup.BACKGROUND : UIUtil.getListBackground();
        Color color = presentation2.getBackgroundColor();
        if (color == null) {
            color = defaultBg;
        }
        this.myComponent.setBackground(color);
        Color bg = isSelected ? UIUtil.getListSelectionBackground(cellHasFocus) : this.myComponent.getBackground();
        this.myComponent.setSelectionColor(bg);
        String locationText = presentation2.getLocationText();
        if (locationText != null) {
            JPanel spacer = new JPanel();
            spacer.setOpaque(false);
            spacer.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            this.myComponent.add(spacer, "Center");
            ListCellRenderer rightRenderer2 = new DefaultListCellRenderer(presentation2, locationText, this){
                final /* synthetic */ TargetPresentation $presentation;
                final /* synthetic */ String $locationText;
                final /* synthetic */ PsiElementBackgroundListCellRenderer this$0;
                {
                    this.$presentation = $presentation;
                    this.$locationText = $locationText;
                    this.this$0 = $receiver;
                }

                @NotNull
                public Component getListCellRendererComponent(@NotNull JList<?> list2, @Nullable Object value, int index2, boolean isSelected, boolean cellHasFocus) {
                    Intrinsics.checkNotNullParameter(list2, (String)"list");
                    Component component2 = super.getListCellRendererComponent(list2, value, index2, isSelected, cellHasFocus);
                    this.setForeground(isSelected ? NamedColorUtil.getListSelectionForeground(cellHasFocus) : NamedColorUtil.getInactiveTextColor());
                    this.setOpaque(false);
                    this.setIcon(this.$presentation.getLocationIcon());
                    this.setText(this.$locationText);
                    if (!this.this$0.getUsedInPopup() || !ExperimentalUI.isNewUI()) {
                        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, UIUtil.getListCellHPadding()));
                    }
                    this.setHorizontalTextPosition(2);
                    this.setHorizontalAlignment(4);
                    Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"component");
                    return component2;
                }
            };
            Component rightRendererComponent = rightRenderer2.getListCellRendererComponent(list2, value, index2, isSelected, cellHasFocus);
            this.myComponent.add(rightRendererComponent, "East");
        }
        ListCellRenderer leftRenderer2 = (ListCellRenderer)new ColoredListCellRenderer<PsiElement>(this, list2, value, presentation2, bg){
            @NotNull
            private final PsiElementListCellRenderer.ItemMatchers itemMatchers;
            final /* synthetic */ PsiElementBackgroundListCellRenderer this$0;
            final /* synthetic */ TargetPresentation $presentation;
            final /* synthetic */ Color $bg;
            {
                this.this$0 = $receiver;
                this.$presentation = $presentation;
                this.$bg = $bg;
                PsiElementListCellRenderer.ItemMatchers itemMatchers = PsiElementBackgroundListCellRenderer.access$getRenderer$p($receiver).getItemMatchers($list, $value);
                Intrinsics.checkNotNullExpressionValue((Object)itemMatchers, (String)"renderer.getItemMatchers(list, value)");
                this.itemMatchers = itemMatchers;
            }

            @NotNull
            public final PsiElementListCellRenderer.ItemMatchers getItemMatchers() {
                return this.itemMatchers;
            }

            protected void customizeCellRenderer(@NotNull JList<? extends PsiElement> list2, @NotNull PsiElement value, int index2, boolean selected, boolean hasFocus) {
                block9: {
                    TextAttributes textAttributes;
                    String containerText;
                    block11: {
                        block10: {
                            TextAttributes textAttributes2;
                            block8: {
                                block7: {
                                    Intrinsics.checkNotNullParameter(list2, (String)"list");
                                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                                    this.setOpaque(false);
                                    this.setIcon(this.$presentation.getIcon());
                                    if (this.this$0.getUsedInPopup() && ExperimentalUI.isNewUI()) {
                                        this.getIpad().left = 0;
                                        this.getIpad().right = 0;
                                    }
                                    if ((textAttributes2 = this.$presentation.getPresentableTextAttributes()) == null) break block7;
                                    TextAttributes p0 = textAttributes2;
                                    boolean bl = false;
                                    SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)p0);
                                    textAttributes2 = simpleTextAttributes;
                                    if (simpleTextAttributes != null) break block8;
                                }
                                textAttributes2 = new SimpleTextAttributes(0, UIUtil.getListForeground(selected, hasFocus));
                            }
                            TextAttributes nameAttributes = textAttributes2;
                            SpeedSearchUtil.appendColoredFragmentForMatcher((String)this.$presentation.getPresentableText(), (SimpleColoredComponent)((SimpleColoredComponent)this), (SimpleTextAttributes)nameAttributes, (Matcher)this.itemMatchers.nameMatcher, (Color)this.$bg, (boolean)selected);
                            containerText = this.$presentation.getContainerText();
                            if (containerText == null) break block9;
                            textAttributes = this.$presentation.getContainerTextAttributes();
                            if (textAttributes == null) break block10;
                            TextAttributes it = textAttributes;
                            boolean bl = false;
                            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.merge((SimpleTextAttributes)SimpleTextAttributes.fromTextAttributes((TextAttributes)it), (SimpleTextAttributes)SimpleTextAttributes.GRAYED_ATTRIBUTES);
                            textAttributes = simpleTextAttributes;
                            if (simpleTextAttributes != null) break block11;
                        }
                        textAttributes = SimpleTextAttributes.GRAYED_ATTRIBUTES;
                    }
                    TextAttributes containerTextAttributes = textAttributes;
                    this.append(" (", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    SpeedSearchUtil.appendColoredFragmentForMatcher((String)containerText, (SimpleColoredComponent)((SimpleColoredComponent)this), (SimpleTextAttributes)containerTextAttributes, (Matcher)this.itemMatchers.locationMatcher, (Color)this.$bg, (boolean)selected);
                    this.append(")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
            }
        };
        Component leftRendererComponent = leftRenderer2.getListCellRendererComponent(list2, value, index2, isSelected, cellHasFocus);
        this.myComponent.add(leftRendererComponent, "West");
        return (Component)((Object)this.myComponent);
    }

    public static final /* synthetic */ PsiElementListCellRenderer access$getRenderer$p(PsiElementBackgroundListCellRenderer $this) {
        return $this.renderer;
    }
}

