/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.PsiElementBackgroundPresentationComputer;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Key;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelIterator;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u00022\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0000\u001a\u0014\u0010\b\u001a\u00020\t2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002\u001a\u0014\u0010\n\u001a\u00020\t2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002\u001a\u0014\u0010\u000b\u001a\u00020\t2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002\u001a\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r*\u00020\u000e2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002\"!\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000*,\b\u0002\u0010\u000f\"\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u00a8\u0006\u0013"}, d2={"computerKey", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ide/util/PsiElementBackgroundPresentationComputer;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getComputer", "list", "Ljavax/swing/JList;", "notifyModelChanged", "", "redrawListAndContainer", "resizePopup", "repaintQueue", "Lkotlinx/coroutines/channels/SendChannel;", "Lkotlinx/coroutines/CoroutineScope;", "RendererAndElement", "Lkotlin/Pair;", "Lcom/intellij/ide/util/PsiElementListCellRenderer;", "Lcom/intellij/psi/PsiElement;", "intellij.platform.lang.impl"})
public final class PsiElementBackgroundPresentationComputerKt {
    @NotNull
    private static final Key<PsiElementBackgroundPresentationComputer> computerKey;

    @NotNull
    public static final PsiElementBackgroundPresentationComputer getComputer(@NotNull JList<?> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        PsiElementBackgroundPresentationComputer existing = UIUtil.getClientProperty(list2, computerKey);
        if (existing != null) {
            return existing;
        }
        PsiElementBackgroundPresentationComputer computer = new PsiElementBackgroundPresentationComputer(list2);
        UIUtil.putClientProperty(list2, computerKey, computer);
        UIUtil.putClientProperty(list2, AnimatedIcon.ANIMATION_IN_RENDERER_ALLOWED, true);
        UIUtil.runWhenHidden(list2, () -> PsiElementBackgroundPresentationComputerKt.getComputer$cleanUp(list2, computer));
        UIUtil.runWhenChanged(list2, "cellRenderer", () -> PsiElementBackgroundPresentationComputerKt.getComputer$cleanUp(list2, computer));
        return computer;
    }

    private static final SendChannel<Unit> repaintQueue(CoroutineScope $this$repaintQueue, JList<?> list2) {
        Channel repaintQueue2 = ChannelKt.Channel$default(-1, null, null, 6, null);
        BuildersKt.launch$default($this$repaintQueue, CoroutinesKt.getEDT(Dispatchers.INSTANCE), null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Channel<Unit>)repaintQueue2, list2, null){
            Object L$0;
            int label;
            final /* synthetic */ Channel<Unit> $repaintQueue;
            final /* synthetic */ JList<?> $list;
            {
                this.$repaintQueue = $repaintQueue;
                this.$list = $list;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var2_3 = this.$repaintQueue.iterator();
lbl6:
                        // 2 sources

                        while (true) {
                            this.L$0 = var2_3;
                            this.label = 1;
                            v0 = var2_3.hasNext((Continuation<Boolean>)((Continuation)this));
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl17
                            break;
                        }
                    }
                    case 1: {
                        var2_3 = (ChannelIterator<E>)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        if (!((Boolean)v0).booleanValue()) break;
                        var2_3.next();
                        PsiElementBackgroundPresentationComputerKt.access$notifyModelChanged(this.$list);
                        PsiElementBackgroundPresentationComputerKt.access$redrawListAndContainer(this.$list);
                        this.L$0 = var2_3;
                        this.label = 2;
                        v1 = DelayKt.delay(100L, (Continuation<? super Unit>)((Continuation)this));
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl32
                    }
                    case 2: {
                        var2_3 = (ChannelIterator)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl32:
                        // 2 sources

                        ** continue;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
        return repaintQueue2;
    }

    private static final void notifyModelChanged(JList<?> list2) {
        ListModel<?> model2 = list2.getModel();
        if (!(model2 instanceof AbstractListModel)) {
            throw new IllegalStateException(("Unsupported list model: " + model2.getClass().getName()).toString());
        }
        int size = ((AbstractListModel)model2).getSize();
        if (size == 0) {
            return;
        }
        ListDataListener[] listeners = ((AbstractListModel)model2).getListDataListeners();
        Intrinsics.checkNotNullExpressionValue((Object)listeners, (String)"listeners");
        if (listeners.length == 0) {
            return;
        }
        ListDataEvent e = new ListDataEvent(list2, 0, 0, size - 1);
        for (ListDataListener listener2 : listeners) {
            listener2.contentsChanged(e);
        }
    }

    private static final void redrawListAndContainer(JList<?> list2) {
        if (!list2.isShowing()) {
            return;
        }
        PsiElementBackgroundPresentationComputerKt.resizePopup(list2);
        list2.repaint();
    }

    private static final void resizePopup(JList<?> list2) {
        JBPopup jBPopup = PopupUtil.getPopupContainerFor((Component)list2);
        if (jBPopup == null) {
            return;
        }
        JBPopup popup2 = jBPopup;
        if (popup2 instanceof AbstractPopup && ((AbstractPopup)popup2).getDimensionServiceKey() != null) {
            return;
        }
        Point point = popup2.getLocationOnScreen();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"popup.locationOnScreen");
        Point popupLocation = point;
        Rectangle rectangle = new Rectangle(popupLocation, list2.getParent().getPreferredSize());
        ScreenUtil.fitToScreen(rectangle);
        if (rectangle.width > popup2.getSize().width) {
            popup2.setLocation(new Point(rectangle.x, popupLocation.y));
            popup2.setSize(new Dimension(rectangle.width, popup2.getSize().height));
        }
    }

    private static final void getComputer$cleanUp(JList<?> $list, PsiElementBackgroundPresentationComputer computer) {
        UIUtil.putClientProperty($list, computerKey, null);
        UIUtil.putClientProperty($list, AnimatedIcon.ANIMATION_IN_RENDERER_ALLOWED, null);
        computer.dispose();
    }

    public static final /* synthetic */ SendChannel access$repaintQueue(CoroutineScope $receiver, JList list2) {
        return PsiElementBackgroundPresentationComputerKt.repaintQueue($receiver, list2);
    }

    public static final /* synthetic */ void access$notifyModelChanged(JList list2) {
        PsiElementBackgroundPresentationComputerKt.notifyModelChanged(list2);
    }

    public static final /* synthetic */ void access$redrawListAndContainer(JList list2) {
        PsiElementBackgroundPresentationComputerKt.redrawListAndContainer(list2);
    }

    static {
        Key key = Key.create("PsiElementBackgroundPresentationComputer");
        Intrinsics.checkNotNullExpressionValue(key, (String)"create<PsiElementBackgro\u2026undPresentationComputer\")");
        computerKey = key;
    }
}

