/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.ModuleRendererFactory;
import com.intellij.ide.util.NavigationItemListCellRenderer;
import com.intellij.ide.util.PlatformModuleRendererFactory;
import com.intellij.ide.util.PsiElementBackgroundListCellRenderer;
import com.intellij.ide.util.PsiElementRenderingInfo;
import com.intellij.lang.LangBundle;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.platform.backend.presentation.TargetPresentationBuilder;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SlowOperations;
import com.intellij.util.TextWithIcon;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.text.MatcherHolder;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DirtyUI
@ApiStatus.Obsolete
public abstract class PsiElementListCellRenderer<T extends PsiElement>
extends JPanel
implements ListCellRenderer<Object> {
    public static final Key<TargetPresentation> TARGET_PRESENTATION_KEY = Key.create("cell.target.presentation");
    private static final Logger LOG = Logger.getInstance(PsiElementListCellRenderer.class);
    private static final String LEFT = "West";
    private static final Pattern CONTAINER_PATTERN = Pattern.compile("(\\(in |\\()?([^)]*)(\\))?");
    private static final SimpleTextAttributes DEFAULT_ERROR_ATTRIBUTES = new SimpleTextAttributes(8, NamedColorUtil.getInactiveTextColor(), (Color)JBColor.RED);
    protected int myRightComponentWidth;
    private final ListCellRenderer<PsiElement> myBackgroundRenderer;
    private final boolean isGetRightCellRendererOverridden = ReflectionUtil.getMethodDeclaringClass(this.getClass(), "getRightCellRenderer", Object.class) != PsiElementListCellRenderer.class;
    private final PsiElementRenderingInfo<T> myRenderingInfo = new PsiElementRenderingInfo<T>(){

        @Override
        @Nullable
        public Icon getIcon(@NotNull T element) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            return PsiElementListCellRenderer.this.getIcon((PsiElement)element);
        }

        @Override
        @NotNull
        public String getPresentableText(@NotNull T element) {
            String elementText;
            if (element == null) {
                1.$$$reportNull$$$0(1);
            }
            if ((elementText = PsiElementListCellRenderer.this.getElementText(element)) == null) {
                LOG.error("Null name for PSI element " + element.getClass() + " (by " + PsiElementListCellRenderer.this + ")");
                String string2 = LangBundle.message("label.unknown", new Object[0]);
                if (string2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string2;
            }
            String string3 = elementText;
            if (string3 == null) {
                1.$$$reportNull$$$0(3);
            }
            return string3;
        }

        @Override
        @Nullable
        public String getContainerText(@NotNull T element) {
            if (element == null) {
                1.$$$reportNull$$$0(4);
            }
            return PsiElementListCellRenderer.this.getContainerText(element, this.getPresentableText(element));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/PsiElementListCellRenderer$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/PsiElementListCellRenderer$1";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getIcon";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentableText";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getContainerText";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 3 -> new IllegalStateException(string2);
            };
        }
    };

    protected PsiElementListCellRenderer() {
        super(new BorderLayout());
        this.myBackgroundRenderer = Registry.is("psi.element.list.cell.renderer.background") ? new PsiElementBackgroundListCellRenderer(this) : null;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new MyAccessibleContext();
        }
        return this.accessibleContext;
    }

    public void setUsedInPopup(boolean value) {
        ListCellRenderer<PsiElement> listCellRenderer = this.myBackgroundRenderer;
        if (listCellRenderer instanceof PsiElementBackgroundListCellRenderer) {
            PsiElementBackgroundListCellRenderer psiElementRenderer = (PsiElementBackgroundListCellRenderer)listCellRenderer;
            psiElementRenderer.setUsedInPopup(value);
        }
    }

    @Nullable
    protected TextAttributes getNavigationItemAttributes(Object value) {
        return PsiElementListCellRenderer.getNavigationItemAttributesStatic(value);
    }

    @Nullable
    private static TextAttributes getNavigationItemAttributesStatic(Object value) {
        TextAttributes attributes = null;
        if (value instanceof NavigationItem) {
            TextAttributesKey attributesKey = null;
            ItemPresentation presentation2 = ((NavigationItem)value).getPresentation();
            if (presentation2 instanceof ColoredItemPresentation) {
                attributesKey = ((ColoredItemPresentation)presentation2).getTextAttributesKey();
            }
            if (attributesKey != null) {
                attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(attributesKey);
            }
        }
        return attributes;
    }

    @Override
    public Component getListCellRendererComponent(JList list2, Object value, int index2, boolean isSelected, boolean cellHasFocus) {
        Component result2;
        JPanel spacer;
        JLabel locationComponent;
        TextWithIcon itemLocation;
        if (ApplicationManager.getApplication().isHeadlessEnvironment() && value instanceof PsiElement) {
            this.putClientProperty(TARGET_PRESENTATION_KEY, this.computePresentation((PsiElement)value));
            return this;
        }
        if (this.myBackgroundRenderer != null && value instanceof PsiElement) {
            return this.myBackgroundRenderer.getListCellRendererComponent(list2, (PsiElement)value, index2, isSelected, cellHasFocus);
        }
        this.removeAll();
        this.myRightComponentWidth = 0;
        try (AccessToken ignore = SlowOperations.startSection("rendering");){
            itemLocation = this.getItemLocation(value);
        }
        if (itemLocation == null) {
            locationComponent = null;
            spacer = null;
        } else {
            locationComponent = new JLabel(itemLocation.getText(), itemLocation.getIcon(), 4);
            locationComponent.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, UIUtil.getListCellHPadding()));
            locationComponent.setHorizontalTextPosition(2);
            locationComponent.setForeground(isSelected ? NamedColorUtil.getListSelectionForeground(true) : NamedColorUtil.getInactiveTextColor());
            this.add((Component)locationComponent, "East");
            spacer = new JPanel();
            spacer.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            this.add((Component)spacer, "Center");
            this.myRightComponentWidth = locationComponent.getPreferredSize().width;
            this.myRightComponentWidth += spacer.getPreferredSize().width;
        }
        ColoredListCellRenderer<Object> leftRenderer2 = this.createLeftRenderer(list2, value);
        try (AccessToken ignore = SlowOperations.startSection("rendering");){
            result2 = leftRenderer2.getListCellRendererComponent(list2, value, index2, isSelected, cellHasFocus);
        }
        Component leftCellRendererComponent = result2;
        this.add(leftCellRendererComponent, LEFT);
        Color bg = isSelected ? UIUtil.getListSelectionBackground(true) : leftCellRendererComponent.getBackground();
        this.setBackground(bg);
        if (itemLocation != null) {
            locationComponent.setBackground(bg);
            spacer.setBackground(bg);
        }
        return this;
    }

    @NotNull
    protected ColoredListCellRenderer<Object> createLeftRenderer(JList<?> list2, Object value) {
        return new LeftRenderer(value == null ? new ItemMatchers(null, null) : this.getItemMatchers(list2, value));
    }

    @NotNull
    protected SimpleTextAttributes getErrorAttributes() {
        SimpleTextAttributes simpleTextAttributes = DEFAULT_ERROR_ATTRIBUTES;
        if (simpleTextAttributes == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(0);
        }
        return simpleTextAttributes;
    }

    @NotNull
    public ItemMatchers getItemMatchers(@NotNull JList list2, @NotNull Object value) {
        if (list2 == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(1);
        }
        if (value == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(2);
        }
        return new ItemMatchers(MatcherHolder.getAssociatedMatcher(list2), null);
    }

    protected boolean customizeNonPsiElementLeftRenderer(ColoredListCellRenderer renderer, JList list2, Object value, int index2, boolean selected, boolean hasFocus) {
        return false;
    }

    @Nullable
    protected TextWithIcon getItemLocation(Object value) {
        if (this.isGetRightCellRendererOverridden) {
            return ModuleRendererFactory.getTextWithIcon(this.getRightCellRenderer(value), value);
        }
        if (UISettings.getInstance().getShowIconInQuickNavigation()) {
            return PsiElementListCellRenderer.getModuleTextWithIcon(value);
        }
        return null;
    }

    @Deprecated
    @Nullable
    protected DefaultListCellRenderer getRightCellRenderer(Object value) {
        if (!UISettings.getInstance().getShowIconInQuickNavigation()) {
            return null;
        }
        DefaultListCellRenderer renderer = ModuleRendererFactory.findInstance(value).getModuleRenderer();
        if (renderer instanceof PlatformModuleRendererFactory.PlatformModuleRenderer) {
            return null;
        }
        return renderer;
    }

    @ApiStatus.Internal
    @Nullable
    public static TextWithIcon getModuleTextWithIcon(Object value) {
        ModuleRendererFactory factory2 = ModuleRendererFactory.findInstance(value);
        if (factory2 instanceof PlatformModuleRendererFactory) {
            return null;
        }
        return factory2.getModuleTextWithIcon(value);
    }

    @NlsSafe
    public abstract String getElementText(T var1);

    @Nullable
    @NlsSafe
    protected abstract String getContainerText(T var1, String var2);

    @Nullable
    @NlsSafe
    protected String getContainerTextForLeftComponent(T element, String name, int maxWidth, FontMetrics fm) {
        return this.getContainerText(element, name);
    }

    @Iconable.IconFlags
    protected int getIconFlags() {
        return 0;
    }

    protected Icon getIcon(PsiElement element) {
        return element.getIcon(this.getIconFlags());
    }

    public Comparator<T> getComparator() {
        return Comparator.comparing(this::getComparingObject);
    }

    @NotNull
    public Comparable getComparingObject(T element) {
        Comparable comparable = (Comparable)((Object)ReadAction.compute(() -> {
            String elementText = this.getElementText(element);
            String containerText = this.getContainerText(element, elementText);
            TextWithIcon moduleTextWithIcon = PsiElementListCellRenderer.getModuleTextWithIcon(element);
            return (String)(containerText == null ? elementText : elementText + " " + containerText) + (String)(moduleTextWithIcon != null ? " " + moduleTextWithIcon.getText() : "");
        }));
        if (comparable == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(3);
        }
        return comparable;
    }

    @Deprecated
    public void installSpeedSearch(PopupChooserBuilder<?> builder2) {
        this.installSpeedSearch((IPopupChooserBuilder)builder2);
    }

    public void installSpeedSearch(IPopupChooserBuilder builder2) {
        this.installSpeedSearch(builder2, false);
    }

    public void installSpeedSearch(@NotNull IPopupChooserBuilder builder2, boolean includeContainerText) {
        if (builder2 == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(4);
        }
        builder2.setNamerForFiltering(o -> {
            if (o instanceof PsiElement) {
                String elementText = this.getElementText((PsiElement)o);
                if (includeContainerText) {
                    return elementText + " " + this.getContainerText((PsiElement)o, elementText);
                }
                return elementText;
            }
            return o.toString();
        });
    }

    @ApiStatus.Internal
    @RequiresReadLock
    @NotNull
    public final TargetPresentation computePresentation(@NotNull PsiElement element) {
        if (element == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return PsiElementListCellRenderer.targetPresentation(element, this.myRenderingInfo, this::getNavigationItemAttributes, this::getItemLocation, this::getErrorAttributes);
    }

    @NotNull
    static <T extends PsiElement> TargetPresentation targetPresentation(@NotNull T element, @NotNull PsiElementRenderingInfo<? super T> renderingInfo) {
        if (element == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(6);
        }
        if (renderingInfo == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(7);
        }
        return PsiElementListCellRenderer.targetPresentation(element, renderingInfo, PsiElementListCellRenderer::getNavigationItemAttributesStatic, PsiElementListCellRenderer::getModuleTextWithIcon, () -> DEFAULT_ERROR_ATTRIBUTES);
    }

    @NotNull
    private static <T extends PsiElement> TargetPresentation targetPresentation(@NotNull T element, @NotNull PsiElementRenderingInfo<? super T> renderingInfo, @NotNull @NotNull Function<? super @NotNull T, ? extends @Nullable TextAttributes> presentableAttributesProvider, @NotNull @NotNull Function<? super @NotNull T, ? extends @Nullable TextWithIcon> locationProvider, @NotNull @NotNull Supplier<? extends @NotNull SimpleTextAttributes> errorAttributesSupplier) {
        TextWithIcon itemLocation;
        if (element == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(8);
        }
        if (renderingInfo == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(9);
        }
        if (presentableAttributesProvider == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(10);
        }
        if (locationProvider == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(11);
        }
        if (errorAttributesSupplier == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(12);
        }
        TargetPresentationBuilder builder2 = TargetPresentation.builder(renderingInfo.getPresentableText(element));
        builder2 = builder2.icon(renderingInfo.getIcon(element));
        TextAttributes elementAttributes = presentableAttributesProvider.apply(element);
        VirtualFile vFile = PsiUtilCore.getVirtualFile(element);
        if (vFile == null) {
            builder2 = builder2.presentableTextAttributes(elementAttributes);
        } else {
            Color color;
            Project project2 = element.getProject();
            TextAttributes presentableAttributes = elementAttributes;
            if (presentableAttributes == null && (color = FileStatusManager.getInstance((Project)project2).getStatus(vFile).getColor()) != null) {
                presentableAttributes = new SimpleTextAttributes(0, color).toTextAttributes();
            }
            if (WolfTheProblemSolver.getInstance(project2).isProblemFile(vFile)) {
                presentableAttributes = TextAttributes.merge(errorAttributesSupplier.get().toTextAttributes(), presentableAttributes);
            }
            builder2 = builder2.presentableTextAttributes(presentableAttributes);
            builder2 = builder2.backgroundColor(VfsPresentationUtil.getFileBackgroundColor((Project)project2, (VirtualFile)vFile));
        }
        String containerText = renderingInfo.getContainerText(element);
        if (containerText != null) {
            Matcher matcher = CONTAINER_PATTERN.matcher(containerText);
            builder2 = builder2.containerText(matcher.matches() ? matcher.group(2) : containerText);
        }
        if ((itemLocation = locationProvider.apply(element)) != null) {
            builder2 = builder2.locationText(itemLocation.getText(), itemLocation.getIcon());
        }
        TargetPresentation targetPresentation2 = builder2.presentation();
        if (targetPresentation2 == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(13);
        }
        return targetPresentation2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/PsiElementListCellRenderer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderingInfo";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableAttributesProvider";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationProvider";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorAttributesSupplier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorAttributes";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/PsiElementListCellRenderer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComparingObject";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "targetPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getItemMatchers";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "installSpeedSearch";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computePresentation";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "targetPresentation";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> new IllegalArgumentException(string2);
        };
    }

    private class MyAccessibleContext
    extends JPanel.AccessibleJPanel {
        private MyAccessibleContext() {
            super(PsiElementListCellRenderer.this);
        }

        @Override
        public String getAccessibleName() {
            LayoutManager lm = PsiElementListCellRenderer.this.getLayout();
            assert (lm instanceof BorderLayout);
            Component leftCellRendererComp = ((BorderLayout)lm).getLayoutComponent(PsiElementListCellRenderer.LEFT);
            return leftCellRendererComp instanceof Accessible ? leftCellRendererComp.getAccessibleContext().getAccessibleName() : super.getAccessibleName();
        }
    }

    private final class LeftRenderer
    extends ColoredListCellRenderer<Object> {
        private final ItemMatchers myMatchers;

        LeftRenderer(ItemMatchers matchers) {
            if (matchers == null) {
                LeftRenderer.$$$reportNull$$$0(0);
            }
            this.myMatchers = matchers;
        }

        protected void customizeCellRenderer(@NotNull JList<?> list2, Object value, int index2, boolean selected, boolean hasFocus) {
            if (list2 == null) {
                LeftRenderer.$$$reportNull$$$0(1);
            }
            Color bgColor = UIUtil.getListBackground();
            Color color = list2.getForeground();
            PsiElement target2 = NavigationItemListCellRenderer.getPsiElement(value);
            VirtualFile vFile = PsiUtilCore.getVirtualFile(target2);
            boolean isProblemFile = false;
            if (vFile != null) {
                Project project2 = target2.getProject();
                isProblemFile = WolfTheProblemSolver.getInstance(project2).isProblemFile(vFile);
                FileStatus status = FileStatusManager.getInstance((Project)project2).getStatus(vFile);
                color = status.getColor();
                Color fileBgColor = VfsPresentationUtil.getFileBackgroundColor((Project)project2, (VirtualFile)vFile);
                Color color2 = bgColor = fileBgColor == null ? bgColor : fileBgColor;
            }
            if (value instanceof PsiElement) {
                SimpleTextAttributes nameAttributes;
                PsiElement element = (PsiElement)value;
                @NlsContexts.Label String name = ((PsiElement)value).isValid() ? PsiElementListCellRenderer.this.getElementText(element) : "INVALID";
                TextAttributes attributes = element.isValid() ? PsiElementListCellRenderer.this.getNavigationItemAttributes(value) : null;
                SimpleTextAttributes simpleTextAttributes = nameAttributes = attributes != null ? SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes) : null;
                if (nameAttributes == null) {
                    nameAttributes = new SimpleTextAttributes(0, color);
                }
                if (name == null) {
                    LOG.error("Null name for PSI element " + element.getClass() + " (by " + PsiElementListCellRenderer.this + ")");
                    name = LangBundle.message("label.unknown", new Object[0]);
                }
                SpeedSearchUtil.appendColoredFragmentForMatcher((String)name, (SimpleColoredComponent)this, (SimpleTextAttributes)nameAttributes, (com.intellij.util.text.Matcher)this.myMatchers.nameMatcher, (Color)bgColor, (boolean)selected);
                if (!element.isValid()) {
                    this.append(" " + LangBundle.message("label.invalid", new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
                    return;
                }
                this.setIcon(PsiElementListCellRenderer.this.getIcon(element));
                FontMetrics fm = list2.getFontMetrics(list2.getFont());
                int maxWidth = list2.getWidth() - fm.stringWidth(name) - 16 - PsiElementListCellRenderer.this.myRightComponentWidth - 20;
                String containerText = PsiElementListCellRenderer.this.getContainerTextForLeftComponent(element, name, maxWidth, fm);
                if (containerText != null) {
                    this.appendLocationText(selected, bgColor, isProblemFile, containerText);
                }
            } else if (!PsiElementListCellRenderer.this.customizeNonPsiElementLeftRenderer(this, list2, value, index2, selected, hasFocus)) {
                this.setIcon(IconUtil.getEmptyIcon((boolean)false));
                @NlsSafe String text2 = value == null ? "" : value.toString();
                this.append(text2, new SimpleTextAttributes(0, list2.getForeground()));
            }
            this.setBackground(selected ? UIUtil.getListSelectionBackground(true) : bgColor);
        }

        private void appendLocationText(boolean selected, Color bgColor, boolean isProblemFile, @Nls String containerText) {
            SimpleTextAttributes locationAttrs = SimpleTextAttributes.GRAYED_ATTRIBUTES;
            if (isProblemFile) {
                SimpleTextAttributes wavedAttributes = SimpleTextAttributes.merge((SimpleTextAttributes)PsiElementListCellRenderer.this.getErrorAttributes(), (SimpleTextAttributes)locationAttrs);
                Matcher matcher = CONTAINER_PATTERN.matcher(containerText);
                if (matcher.matches()) {
                    String prefix = matcher.group(1);
                    SpeedSearchUtil.appendColoredFragmentForMatcher((String)(" " + ObjectUtils.notNull(prefix, "")), (SimpleColoredComponent)this, (SimpleTextAttributes)locationAttrs, (com.intellij.util.text.Matcher)this.myMatchers.locationMatcher, (Color)bgColor, (boolean)selected);
                    String strippedContainerText = matcher.group(2);
                    SpeedSearchUtil.appendColoredFragmentForMatcher((String)ObjectUtils.notNull(strippedContainerText, ""), (SimpleColoredComponent)this, (SimpleTextAttributes)wavedAttributes, (com.intellij.util.text.Matcher)this.myMatchers.locationMatcher, (Color)bgColor, (boolean)selected);
                    String suffix = matcher.group(3);
                    if (suffix != null) {
                        SpeedSearchUtil.appendColoredFragmentForMatcher((String)suffix, (SimpleColoredComponent)this, (SimpleTextAttributes)locationAttrs, (com.intellij.util.text.Matcher)this.myMatchers.locationMatcher, (Color)bgColor, (boolean)selected);
                    }
                    return;
                }
                locationAttrs = wavedAttributes;
            }
            SpeedSearchUtil.appendColoredFragmentForMatcher((String)(" " + containerText), (SimpleColoredComponent)this, (SimpleTextAttributes)locationAttrs, (com.intellij.util.text.Matcher)this.myMatchers.locationMatcher, (Color)bgColor, (boolean)selected);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matchers";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/util/PsiElementListCellRenderer$LeftRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeCellRenderer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ItemMatchers {
        @Nullable
        public final com.intellij.util.text.Matcher nameMatcher;
        @Nullable
        public final com.intellij.util.text.Matcher locationMatcher;

        public ItemMatchers(@Nullable com.intellij.util.text.Matcher nameMatcher, @Nullable com.intellij.util.text.Matcher locationMatcher) {
            this.nameMatcher = nameMatcher;
            this.locationMatcher = locationMatcher;
        }
    }
}

