/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.StructureViewComposite;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.ProvidingTreeModel;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StructureViewCompositeModel
extends StructureViewModelBase
implements Disposable,
StructureViewModel.ElementInfoProvider,
StructureViewModel.ExpandInfoProvider {
    private final List<? extends StructureViewComposite.StructureViewDescriptor> myViews;

    public StructureViewCompositeModel(@NotNull PsiFile file2, @Nullable Editor editor2, @NotNull List<? extends StructureViewComposite.StructureViewDescriptor> views) {
        if (file2 == null) {
            StructureViewCompositeModel.$$$reportNull$$$0(0);
        }
        if (views == null) {
            StructureViewCompositeModel.$$$reportNull$$$0(1);
        }
        super(file2, editor2, StructureViewCompositeModel.createRootNode(file2, views));
        this.myViews = views;
    }

    @NotNull
    private JBIterable<StructureViewModel> getModels() {
        JBIterable<StructureViewModel> jBIterable = JBIterable.from(this.myViews).map(o -> o.structureModel);
        if (jBIterable == null) {
            StructureViewCompositeModel.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    public Object getCurrentEditorElement() {
        return this.getModels().filterMap(o -> o.getCurrentEditorElement()).first();
    }

    @NotNull
    private static StructureViewTreeElement createRootNode(final @NotNull PsiFile file2, @NotNull List<? extends StructureViewComposite.StructureViewDescriptor> views) {
        if (file2 == null) {
            StructureViewCompositeModel.$$$reportNull$$$0(3);
        }
        if (views == null) {
            StructureViewCompositeModel.$$$reportNull$$$0(4);
        }
        final JBIterable<TreeElement> children2 = JBIterable.from(views).map(o -> StructureViewCompositeModel.createTreeElementFromView(file2, o));
        return new StructureViewTreeElement(){

            public Object getValue() {
                return file2;
            }

            public void navigate(boolean requestFocus) {
                file2.navigate(requestFocus);
            }

            public boolean canNavigate() {
                return file2.canNavigate();
            }

            public boolean canNavigateToSource() {
                return file2.canNavigateToSource();
            }

            @NotNull
            public ItemPresentation getPresentation() {
                ItemPresentation itemPresentation = file2.getPresentation();
                if (itemPresentation == null) {
                    1.$$$reportNull$$$0(0);
                }
                return itemPresentation;
            }

            public TreeElement @NotNull [] getChildren() {
                List elements = children2.toList();
                TreeElement[] treeElementArray = elements.toArray(TreeElement.EMPTY_ARRAY);
                if (treeElementArray == null) {
                    1.$$$reportNull$$$0(1);
                }
                return treeElementArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/ide/util/StructureViewCompositeModel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentation";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getChildren";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    public Collection<NodeProvider<?>> getNodeProviders() {
        Set<NodeProvider<?>> set2 = this.getModels().filter(ProvidingTreeModel.class).flatMap(ProvidingTreeModel::getNodeProviders).toSet();
        if (set2 == null) {
            StructureViewCompositeModel.$$$reportNull$$$0(5);
        }
        return set2;
    }

    public Filter @NotNull [] getFilters() {
        Set<Filter> filters = this.getModels().flatMap(o -> JBIterable.of(o.getFilters())).toSet();
        Filter[] filterArray = filters.toArray(Filter.EMPTY_ARRAY);
        if (filterArray == null) {
            StructureViewCompositeModel.$$$reportNull$$$0(6);
        }
        return filterArray;
    }

    public boolean isAlwaysShowsPlus(StructureViewTreeElement element) {
        for (StructureViewModel.ElementInfoProvider p : this.getModels().filter(StructureViewModel.ElementInfoProvider.class)) {
            if (!p.isAlwaysShowsPlus(element)) continue;
            return true;
        }
        return false;
    }

    public boolean isAlwaysLeaf(StructureViewTreeElement element) {
        for (StructureViewModel.ElementInfoProvider p : this.getModels().filter(StructureViewModel.ElementInfoProvider.class)) {
            if (!p.isAlwaysLeaf(element)) continue;
            return true;
        }
        return false;
    }

    public boolean isAutoExpand(@NotNull StructureViewTreeElement element) {
        if (element == null) {
            StructureViewCompositeModel.$$$reportNull$$$0(7);
        }
        if (element.getValue() instanceof StructureViewComposite.StructureViewDescriptor) {
            return true;
        }
        for (StructureViewModel.ExpandInfoProvider p : this.getModels().filter(StructureViewModel.ExpandInfoProvider.class)) {
            if (!p.isAutoExpand(element)) continue;
            return true;
        }
        return false;
    }

    public boolean isSmartExpand() {
        boolean result2 = false;
        for (StructureViewModel.ExpandInfoProvider p : this.getModels().filter(StructureViewModel.ExpandInfoProvider.class)) {
            if (!p.isSmartExpand()) {
                return false;
            }
            result2 = true;
        }
        return result2;
    }

    @NotNull
    private static TreeElement createTreeElementFromView(final PsiFile file2, final StructureViewComposite.StructureViewDescriptor view) {
        return new StructureViewTreeElement(){

            public Object getValue() {
                return view;
            }

            public void navigate(boolean requestFocus) {
                file2.navigate(requestFocus);
            }

            public boolean canNavigate() {
                return file2.canNavigate();
            }

            public boolean canNavigateToSource() {
                return file2.canNavigateToSource();
            }

            @NotNull
            public ItemPresentation getPresentation() {
                return new ItemPresentation(){

                    @Override
                    @Nullable
                    public String getPresentableText() {
                        return view.title;
                    }

                    @Override
                    @Nullable
                    public Icon getIcon(boolean unused) {
                        return view.icon;
                    }
                };
            }

            public TreeElement @NotNull [] getChildren() {
                TreeElement[] treeElementArray = view.structureModel.getRoot().getChildren();
                if (treeElementArray == null) {
                    2.$$$reportNull$$$0(0);
                }
                return treeElementArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/StructureViewCompositeModel$2", "getChildren"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "views";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/StructureViewCompositeModel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/StructureViewCompositeModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModels";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeProviders";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createRootNode";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAutoExpand";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 5, 6 -> new IllegalStateException(string2);
        };
    }
}

