/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.concurrency.JobLauncher;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.util.NavigationItemListCellRenderer;
import com.intellij.ide.util.gotoByName.ChooseByNameModelEx;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.ChooseByNameContributorEx2;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FindSymbolParameters;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public abstract class ContributorsBasedGotoByModel
implements ChooseByNameModelEx,
PossiblyDumbAware {
    public static final Logger LOG = Logger.getInstance(ContributorsBasedGotoByModel.class);
    protected final Project myProject;
    private final List<ChooseByNameContributor> myContributors;
    private final ConcurrentMap<ChooseByNameContributor, IntSet> myContributorToItsSymbolsMap;

    protected ContributorsBasedGotoByModel(@NotNull Project project2, ChooseByNameContributor @NotNull [] contributors) {
        if (project2 == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(0);
        }
        if (contributors == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(1);
        }
        this(project2, Arrays.asList(contributors));
    }

    protected ContributorsBasedGotoByModel(@NotNull Project project2, @NotNull List<ChooseByNameContributor> contributors) {
        if (project2 == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(2);
        }
        if (contributors == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(3);
        }
        this.myContributorToItsSymbolsMap = CollectionFactory.createConcurrentWeakMap();
        this.myProject = project2;
        this.myContributors = contributors;
        assert (!contributors.contains(null));
    }

    @Override
    public boolean isDumbAware() {
        return ContainerUtil.find(this.getContributorList(), o -> DumbService.isDumbAware(o)) != null;
    }

    @Override
    @NotNull
    public ListCellRenderer<?> getListCellRenderer() {
        return new NavigationItemListCellRenderer();
    }

    public boolean sameNamesForProjectAndLibraries() {
        return false;
    }

    @Override
    public void processNames(final @NotNull Processor<? super String> nameProcessor, final @NotNull FindSymbolParameters parameters2) {
        if (nameProcessor == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(4);
        }
        if (parameters2 == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(5);
        }
        long start = System.currentTimeMillis();
        List<ChooseByNameContributor> contributors = this.filterDumb(this.getContributorList());
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        ReadActionProcessor<ChooseByNameContributor> processor = new ReadActionProcessor<ChooseByNameContributor>(){

            @Override
            public boolean processInReadAction(@NotNull ChooseByNameContributor contributor) {
                if (contributor == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    if (!ContributorsBasedGotoByModel.this.myProject.isDisposed()) {
                        long contributorStarted = System.currentTimeMillis();
                        ContributorsBasedGotoByModel.this.processContributorNames(contributor, parameters2, nameProcessor);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(contributor + " for " + (System.currentTimeMillis() - contributorStarted));
                        }
                    }
                }
                catch (ProcessCanceledException | IndexNotReadyException contributorStarted) {
                }
                catch (Exception ex) {
                    LOG.error(ex);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contributor", "com/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel$1", "processInReadAction"));
            }
        };
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(contributors, indicator, processor)) {
            throw new ProcessCanceledException();
        }
        if (indicator != null) {
            indicator.checkCanceled();
        }
        long finish = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug("processNames(): " + (finish - start) + "ms;");
        }
    }

    public void processContributorNames(@NotNull ChooseByNameContributor contributor, @NotNull FindSymbolParameters parameters2, @NotNull Processor<? super String> nameProcessor) {
        if (contributor == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(6);
        }
        if (parameters2 == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(7);
        }
        if (nameProcessor == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(8);
        }
        IntOpenHashSet filter2 = new IntOpenHashSet(1000);
        if (contributor instanceof ChooseByNameContributorEx2) {
            ((ChooseByNameContributorEx2)contributor).processNames(s -> {
                if (nameProcessor.process((String)s)) {
                    filter2.add(s.hashCode());
                }
                return true;
            }, parameters2);
        } else if (contributor instanceof ChooseByNameContributorEx) {
            ((ChooseByNameContributorEx)contributor).processNames(s -> {
                if (nameProcessor.process((String)s)) {
                    filter2.add(s.hashCode());
                }
                return true;
            }, parameters2.getSearchScope(), parameters2.getIdFilter());
        } else {
            String[] names;
            for (String element : names = contributor.getNames(this.myProject, parameters2.isSearchInLibraries())) {
                if (!nameProcessor.process(element)) continue;
                filter2.add(element.hashCode());
            }
        }
        this.myContributorToItsSymbolsMap.put(contributor, filter2);
    }

    @Override
    public String @NotNull [] getNames(boolean checkBoxState) {
        HashSet<String> allNames = new HashSet<String>();
        Collection result2 = Collections.synchronizedCollection(allNames);
        this.processNames(Processors.cancelableCollectProcessor(result2), FindSymbolParameters.simple(this.myProject, checkBoxState));
        if (LOG.isDebugEnabled()) {
            LOG.debug("getNames(): (got " + allNames.size() + " elements)");
        }
        String[] stringArray = ArrayUtilRt.toStringArray(allNames);
        if (stringArray == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(9);
        }
        return stringArray;
    }

    private List<ChooseByNameContributor> filterDumb(List<ChooseByNameContributor> contributors) {
        if (!DumbService.getInstance(this.myProject).isDumb()) {
            return contributors;
        }
        ArrayList<ChooseByNameContributor> answer = new ArrayList<ChooseByNameContributor>(contributors.size());
        for (ChooseByNameContributor contributor : contributors) {
            if (!DumbService.isDumbAware(contributor)) continue;
            answer.add(contributor);
        }
        return answer;
    }

    public Object @NotNull [] getElementsByName(@NotNull String name, @NotNull FindSymbolParameters parameters2, @NotNull ProgressIndicator canceled) {
        if (name == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(10);
        }
        if (parameters2 == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(11);
        }
        if (canceled == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(12);
        }
        HashMap<ChooseByNameContributor, String> applicable = new HashMap<ChooseByNameContributor, String>();
        for (ChooseByNameContributor contributor2 : this.filterDumb(this.getContributorList())) {
            IntSet filter2 = (IntSet)this.myContributorToItsSymbolsMap.get(contributor2);
            if (filter2 != null && !filter2.contains(name.hashCode())) continue;
            applicable.put(contributor2, name);
        }
        if (applicable.isEmpty()) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                ContributorsBasedGotoByModel.$$$reportNull$$$0(13);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        long start = System.nanoTime();
        List items2 = Collections.synchronizedList(new ArrayList());
        Processor<ChooseByNameContributor> processor = contributor -> this.processContributorForName((ChooseByNameContributor)contributor, (String)applicable.get(contributor), parameters2, canceled, items2);
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList(applicable.keySet()), canceled, processor)) {
            canceled.cancel();
        }
        canceled.checkCanceled();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieving " + name + ":" + items2.size() + " for " + TimeoutUtil.getDurationMillis(start));
        }
        Object[] objectArray = ArrayUtil.toObjectArray(items2);
        if (objectArray == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(14);
        }
        return objectArray;
    }

    private boolean processContributorForName(@NotNull ChooseByNameContributor contributor, @NotNull String name, @NotNull FindSymbolParameters parameters2, @NotNull ProgressIndicator canceled, @NotNull List<? super NavigationItem> items2) {
        if (contributor == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(15);
        }
        if (name == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(16);
        }
        if (parameters2 == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(17);
        }
        if (canceled == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(18);
        }
        if (items2 == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(19);
        }
        if (this.myProject.isDisposed()) {
            return true;
        }
        try {
            boolean searchInLibraries = parameters2.isSearchInLibraries();
            long start = System.nanoTime();
            int[] count2 = new int[]{0};
            if (contributor instanceof ChooseByNameContributorEx) {
                ((ChooseByNameContributorEx)contributor).processElementsWithName(name, item -> {
                    canceled.checkCanceled();
                    count2[0] = count2[0] + 1;
                    if (this.acceptItem((NavigationItem)item)) {
                        items2.add((NavigationItem)item);
                    }
                    return true;
                }, parameters2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(TimeoutUtil.getDurationMillis(start) + "," + contributor + "," + count2[0]);
                }
            } else {
                NavigationItem[] itemsByName = contributor.getItemsByName(name, parameters2.getLocalPatternName(), this.myProject, searchInLibraries);
                count2[0] = count2[0] + itemsByName.length;
                for (NavigationItem item2 : itemsByName) {
                    VirtualFile file2;
                    canceled.checkCanceled();
                    if (item2 == null) {
                        PluginException.logPluginError(LOG, "null item from contributor " + contributor + " for name " + name, null, contributor.getClass());
                        continue;
                    }
                    VirtualFile virtualFile2 = file2 = item2 instanceof PsiElement && !(item2 instanceof PomTargetPsiElement) ? PsiUtilCore.getVirtualFile((PsiElement)((Object)item2)) : null;
                    if (file2 != null && !parameters2.getSearchScope().contains(file2) || !this.acceptItem(item2)) continue;
                    items2.add(item2);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(TimeoutUtil.getDurationMillis(start) + "," + contributor + "," + count2[0]);
            }
        }
        catch (ProcessCanceledException searchInLibraries) {
        }
        catch (Exception ex) {
            LOG.error(ex);
        }
        return true;
    }

    @Override
    public Object @NotNull [] getElementsByName(@NotNull String name, boolean checkBoxState, @NotNull String pattern) {
        if (name == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(20);
        }
        if (pattern == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(21);
        }
        Object[] objectArray = this.getElementsByName(name, FindSymbolParameters.wrap(pattern, this.myProject, checkBoxState), new ProgressIndicatorBase());
        if (objectArray == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(22);
        }
        return objectArray;
    }

    @Override
    public String getElementName(@NotNull Object element) {
        if (element == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(23);
        }
        if (!(element instanceof NavigationItem)) {
            throw new AssertionError((Object)(element + " of " + element.getClass() + " in " + this + " of " + this.getClass()));
        }
        return ((NavigationItem)element).getName();
    }

    @Override
    public String getHelpId() {
        return null;
    }

    protected List<ChooseByNameContributor> getContributorList() {
        return this.myContributors;
    }

    protected ChooseByNameContributor[] getContributors() {
        return this.getContributorList().toArray(new ChooseByNameContributor[0]);
    }

    protected boolean acceptItem(NavigationItem item) {
        return true;
    }

    @Override
    public boolean useMiddleMatching() {
        return true;
    }

    @NotNull
    public String removeModelSpecificMarkup(@NotNull String pattern) {
        if (pattern == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(24);
        }
        String string2 = pattern;
        if (string2 == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(25);
        }
        return string2;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(26);
        }
        return project2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 13, 14, 22, 25, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributors";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameProcessor";
                break;
            }
            case 5: 
            case 7: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributor";
                break;
            }
            case 9: 
            case 13: 
            case 14: 
            case 22: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel";
                break;
            }
            case 10: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canceled";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNames";
                break;
            }
            case 13: 
            case 14: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsByName";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "removeModelSpecificMarkup";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processNames";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processContributorNames";
                break;
            }
            case 9: 
            case 13: 
            case 14: 
            case 22: 
            case 25: 
            case 26: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getElementsByName";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processContributorForName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getElementName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "removeModelSpecificMarkup";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 9, 13, 14, 22, 25, 26 -> new IllegalStateException(string2);
        };
    }
}

