/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoFileItemProvider;
import com.intellij.ide.actions.NonProjectScopeDisablerEP;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.FileTypeRef;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.ide.util.gotoByName.GotoFileCustomizer;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.DirectoryFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.IdeUICustomization;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.Matcher;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.JList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoFileModel
extends FilteringGotoByModel<FileTypeRef>
implements DumbAware,
Comparator<Object> {
    private final int myMaxSize;
    public static final FileTypeRef DIRECTORY_FILE_TYPE_REF = FileTypeRef.forFileType(new DirectoryFileType(){

        @Override
        @NonNls
        @NotNull
        public String getName() {
            String string2 = IdeBundle.message((String)"search.everywhere.directory.file.type.name", (Object[])new Object[0]);
            if (string2 == null) {
                2.$$$reportNull$$$0(0);
            }
            return string2;
        }

        @Override
        @NlsContexts.Label
        @NotNull
        public String getDescription() {
            String string2 = IdeBundle.message((String)"filetype.search.everywhere.directory.description", (Object[])new Object[0]);
            if (string2 == null) {
                2.$$$reportNull$$$0(1);
            }
            return string2;
        }

        @Override
        @NlsSafe
        @NotNull
        public String getDefaultExtension() {
            return "";
        }

        @Override
        public Icon getIcon() {
            return PlatformIcons.FOLDER_ICON;
        }

        @Override
        public boolean isBinary() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/ide/util/gotoByName/GotoFileModel$2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    });

    public GotoFileModel(@NotNull Project project2) {
        if (project2 == null) {
            GotoFileModel.$$$reportNull$$$0(0);
        }
        super(project2, ChooseByNameContributor.FILE_EP_NAME.getExtensionList());
        Application application = ApplicationManager.getApplication();
        this.myMaxSize = application.isUnitTestMode() || application.isHeadlessEnvironment() ? Integer.MAX_VALUE : WindowManagerEx.getInstanceEx().getFrame((Project)project2).getSize().width;
    }

    public boolean isSlashlessMatchingEnabled() {
        return true;
    }

    @Override
    @NotNull
    public ChooseByNameItemProvider getItemProvider(@Nullable PsiElement context2) {
        for (GotoFileCustomizer customizer : GotoFileCustomizer.EP_NAME.getExtensionList()) {
            GotoFileItemProvider provider2 = customizer.createItemProvider(this.myProject, context2, this);
            if (provider2 == null) continue;
            GotoFileItemProvider gotoFileItemProvider = provider2;
            if (gotoFileItemProvider == null) {
                GotoFileModel.$$$reportNull$$$0(1);
            }
            return gotoFileItemProvider;
        }
        return new GotoFileItemProvider(this.myProject, context2, this);
    }

    @Override
    protected boolean acceptItem(NavigationItem item) {
        if (item instanceof PsiFile) {
            PsiFile file2 = (PsiFile)item;
            Collection types = this.getFilterItems();
            if (types != null) {
                if (types.contains(FileTypeRef.forFileType(file2.getFileType()))) {
                    return true;
                }
                VirtualFile vFile = file2.getVirtualFile();
                return vFile != null && types.contains(FileTypeRef.forFileType(vFile.getFileType()));
            }
            return true;
        }
        if (item instanceof PsiDirectory) {
            Collection types = this.getFilterItems();
            if (types != null) {
                return types.contains(DIRECTORY_FILE_TYPE_REF);
            }
            return true;
        }
        return super.acceptItem(item);
    }

    @Override
    @Nullable
    protected FileTypeRef filterValueFor(NavigationItem item) {
        return item instanceof PsiFile ? FileTypeRef.forFileType(((PsiFile)item).getFileType()) : null;
    }

    @Override
    public String getPromptText() {
        return IdeBundle.message((String)"prompt.gotofile.enter.file.name", (Object[])new Object[0]);
    }

    @Override
    public String getCheckBoxName() {
        if (NonProjectScopeDisablerEP.EP_NAME.getExtensionList().stream().anyMatch(ep -> ep.disable)) {
            return null;
        }
        return IdeUICustomization.getInstance().projectMessage("checkbox.include.non.project.files", new Object[0]);
    }

    @Override
    @NotNull
    public String getNotInMessage() {
        return "";
    }

    @Override
    @NotNull
    public String getNotFoundMessage() {
        String string2 = IdeBundle.message((String)"label.no.files.found", (Object[])new Object[0]);
        if (string2 == null) {
            GotoFileModel.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Override
    public boolean loadInitialCheckBoxState() {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance(this.myProject);
        return propertiesComponent.isTrueValue("GoToClass.toSaveIncludeLibraries") && propertiesComponent.isTrueValue("GoToFile.includeJavaFiles");
    }

    @Override
    public void saveInitialCheckBoxState(boolean state) {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance(this.myProject);
        if (propertiesComponent.isTrueValue("GoToClass.toSaveIncludeLibraries")) {
            propertiesComponent.setValue("GoToFile.includeJavaFiles", Boolean.toString(state));
        }
    }

    @Override
    @NotNull
    public PsiElementListCellRenderer getListCellRenderer() {
        return new GotoFileCellRenderer(this.myMaxSize){

            @Override
            @NotNull
            public PsiElementListCellRenderer.ItemMatchers getItemMatchers(@NotNull JList list2, @NotNull Object value) {
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value == null) {
                    1.$$$reportNull$$$0(1);
                }
                PsiElementListCellRenderer.ItemMatchers defaultMatchers = super.getItemMatchers(list2, value);
                if (!(value instanceof PsiFileSystemItem)) {
                    PsiElementListCellRenderer.ItemMatchers itemMatchers = defaultMatchers;
                    if (itemMatchers == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return itemMatchers;
                }
                PsiElementListCellRenderer.ItemMatchers itemMatchers = GotoFileModel.convertToFileItemMatchers(defaultMatchers, (PsiFileSystemItem)value, GotoFileModel.this);
                if (itemMatchers == null) {
                    1.$$$reportNull$$$0(3);
                }
                return itemMatchers;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "list";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/util/gotoByName/GotoFileModel$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/util/gotoByName/GotoFileModel$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getItemMatchers";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getItemMatchers";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 2, 3 -> new IllegalStateException(string2);
                };
            }
        };
    }

    @Override
    @Nullable
    public String getFullName(@NotNull Object element) {
        if (element == null) {
            GotoFileModel.$$$reportNull$$$0(3);
        }
        return element instanceof PsiFileSystemItem ? this.getFullName(((PsiFileSystemItem)element).getVirtualFile()) : this.getElementName(element);
    }

    @Nullable
    public String getFullName(@NotNull VirtualFile file2) {
        VirtualFile root;
        if (file2 == null) {
            GotoFileModel.$$$reportNull$$$0(4);
        }
        return (root = this.getTopLevelRoot(file2)) != null ? GotoFileCellRenderer.getRelativePathFromRoot(file2, root) : GotoFileCellRenderer.getRelativePath(file2, this.myProject);
    }

    @Nullable
    public VirtualFile getTopLevelRoot(@NotNull VirtualFile file2) {
        VirtualFile root;
        if (file2 == null) {
            GotoFileModel.$$$reportNull$$$0(5);
        }
        return (root = this.getContentRoot(file2)) == null ? null : JBIterable.generate(root, r -> this.getContentRoot(r.getParent())).last();
    }

    private VirtualFile getContentRoot(@Nullable VirtualFile file2) {
        return file2 == null ? null : GotoFileCellRenderer.getAnyRoot(file2, this.myProject);
    }

    @Override
    public String @NotNull [] getSeparators() {
        String[] stringArray = new String[]{"/", "\\"};
        if (stringArray == null) {
            GotoFileModel.$$$reportNull$$$0(6);
        }
        return stringArray;
    }

    @Override
    public String getHelpId() {
        return "procedures.navigating.goto.class";
    }

    @Override
    public boolean willOpenEditor() {
        return true;
    }

    @Override
    @NotNull
    public String removeModelSpecificMarkup(@NotNull String pattern) {
        if (pattern == null) {
            GotoFileModel.$$$reportNull$$$0(7);
        }
        if (pattern.endsWith("/") || pattern.endsWith("\\")) {
            String string2 = pattern.substring(0, pattern.length() - 1);
            if (string2 == null) {
                GotoFileModel.$$$reportNull$$$0(8);
            }
            return string2;
        }
        String string3 = pattern;
        if (string3 == null) {
            GotoFileModel.$$$reportNull$$$0(9);
        }
        return string3;
    }

    @Override
    public int compare(Object o1, Object o2) {
        return 0;
    }

    @NotNull
    public static PsiElementListCellRenderer.ItemMatchers convertToFileItemMatchers(@NotNull PsiElementListCellRenderer.ItemMatchers defaultMatchers, @NotNull PsiFileSystemItem value, @NotNull GotoFileModel model2) {
        String shortName;
        if (defaultMatchers == null) {
            GotoFileModel.$$$reportNull$$$0(10);
        }
        if (value == null) {
            GotoFileModel.$$$reportNull$$$0(11);
        }
        if (model2 == null) {
            GotoFileModel.$$$reportNull$$$0(12);
        }
        if ((shortName = model2.getElementName(value)) != null && defaultMatchers.nameMatcher instanceof MinusculeMatcher) {
            String sanitized = GotoFileItemProvider.getSanitizedPattern(((MinusculeMatcher)defaultMatchers.nameMatcher).getPattern(), model2);
            for (int i2 = sanitized.lastIndexOf(47) + 1; i2 < sanitized.length() - 1; ++i2) {
                MinusculeMatcher nameMatcher = NameUtil.buildMatcher((String)("*" + sanitized.substring(i2)), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
                if (!nameMatcher.matches(shortName)) continue;
                String locationPattern = FileUtil.toSystemDependentName(StringUtil.trimEnd(sanitized.substring(0, i2), "/"));
                return new PsiElementListCellRenderer.ItemMatchers((Matcher)nameMatcher, (Matcher)GotoFileItemProvider.getQualifiedNameMatcher(locationPattern));
            }
        }
        PsiElementListCellRenderer.ItemMatchers itemMatchers = defaultMatchers;
        if (itemMatchers == null) {
            GotoFileModel.$$$reportNull$$$0(13);
        }
        return itemMatchers;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 6, 8, 9, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/gotoByName/GotoFileModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultMatchers";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/gotoByName/GotoFileModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotFoundMessage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparators";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "removeModelSpecificMarkup";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToFileItemMatchers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 13: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFullName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelRoot";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeModelSpecificMarkup";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "convertToFileItemMatchers";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 6, 8, 9, 13 -> new IllegalStateException(string2);
        };
    }
}

