/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModelDiff {
    @Nullable
    public static <T> List<Cmd> createDiffCmds(@NotNull Model<T> listModel, T @NotNull [] oldElements, T @NotNull [] newElements) {
        if (listModel == null) {
            ModelDiff.$$$reportNull$$$0(0);
        }
        if (oldElements == null) {
            ModelDiff.$$$reportNull$$$0(1);
        }
        if (newElements == null) {
            ModelDiff.$$$reportNull$$$0(2);
        }
        Diff.Change change2 = null;
        try {
            change2 = Diff.buildChanges((Object[])oldElements, (Object[])newElements);
        }
        catch (FilesTooBigForDiffException filesTooBigForDiffException) {
            // empty catch block
        }
        if (change2 == null) {
            return null;
        }
        ArrayList<Cmd> commands = new ArrayList<Cmd>();
        int inserted = 0;
        int deleted = 0;
        while (change2 != null) {
            if (change2.deleted > 0) {
                int start = change2.line0 + inserted - deleted;
                commands.add(new RemoveCmd<T>(listModel, start, start + change2.deleted - 1));
            }
            if (change2.inserted > 0) {
                ArrayList<T> elements = new ArrayList<T>(Arrays.asList(newElements).subList(change2.line1, change2.line1 + change2.inserted));
                commands.add(new InsertCmd<T>(listModel, change2.line0 + inserted - deleted, elements));
            }
            deleted += change2.deleted;
            inserted += change2.inserted;
            change2 = change2.link;
        }
        return commands;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "listModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "oldElements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "newElements";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/util/gotoByName/ModelDiff";
        objectArray[2] = "createDiffCmds";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class RemoveCmd<T>
    implements Cmd {
        private final Model<T> myListModel;
        private final int start;
        private final int end;

        private RemoveCmd(@NotNull Model<T> model2, int start, int end) {
            if (model2 == null) {
                RemoveCmd.$$$reportNull$$$0(0);
            }
            this.myListModel = model2;
            this.start = start;
            this.end = end;
        }

        @Override
        public void apply() {
            this.myListModel.removeRangeFromModel(this.start, this.end);
        }

        @Override
        public int translateSelection(int row) {
            if (row < this.start) {
                return row;
            }
            if (row >= this.end) {
                return row - (this.end - this.start);
            }
            return this.start - 1;
        }

        public String toString() {
            return "-[" + this.start + ", " + this.end + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ide/util/gotoByName/ModelDiff$RemoveCmd", "<init>"));
        }
    }

    public static interface Model<T> {
        public void addToModel(int var1, T var2);

        default public void addAllToModel(int index2, List<? extends T> elements) {
            for (int i2 = 0; i2 < elements.size(); ++i2) {
                this.addToModel(index2 + i2, elements.get(i2));
            }
        }

        public void removeRangeFromModel(int var1, int var2);
    }

    private static final class InsertCmd<T>
    implements Cmd {
        private final Model<T> myListModel;
        private final int idx;
        private final List<? extends T> elements;

        private InsertCmd(@NotNull Model<T> model2, int idx, @NotNull List<? extends T> elements) {
            if (model2 == null) {
                InsertCmd.$$$reportNull$$$0(0);
            }
            if (elements == null) {
                InsertCmd.$$$reportNull$$$0(1);
            }
            this.myListModel = model2;
            this.idx = idx;
            this.elements = elements;
        }

        @Override
        public void apply() {
            this.myListModel.addAllToModel(this.idx, this.elements);
        }

        @Override
        public int translateSelection(int row) {
            return this.idx > row ? row : row + this.elements.size();
        }

        public String toString() {
            return "+[" + this.idx + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "model";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "elements";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/util/gotoByName/ModelDiff$InsertCmd";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Cmd {
        public void apply();

        public int translateSelection(int var1);
    }
}

