/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.OpenProjectTaskKt;
import com.intellij.ide.impl.TrustedPaths;
import com.intellij.ide.util.projectWizard.CustomStepProjectGenerator;
import com.intellij.ide.util.projectWizard.ProjectSettingsStepBase;
import com.intellij.ide.util.projectWizard.actions.ProjectSpecificAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.ActionsWithPanelProvider;
import com.intellij.openapi.wm.impl.welcomeScreen.NewWelcomeScreen;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.platform.HideableProjectGenerator;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.platform.ProjectGeneratorPeer;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.templates.ArchivedTemplatesFactory;
import com.intellij.platform.templates.LocalArchivedTemplate;
import com.intellij.platform.templates.TemplateProjectDirectoryGenerator;
import com.intellij.util.PairConsumer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Icon;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractNewProjectStep<T>
extends DefaultActionGroup
implements DumbAware,
ActionsWithPanelProvider {
    public static final ExtensionPointName<DirectoryProjectGenerator<?>> EP_NAME = new ExtensionPointName("com.intellij.directoryProjectGenerator");
    private static final Logger LOG = Logger.getInstance(AbstractNewProjectStep.class);
    private static final Key<Boolean> CREATED_KEY = new Key("abstract.new.project.step.created");
    private final Customization<T> myCustomization;

    protected AbstractNewProjectStep(@NotNull Customization<T> customization) {
        if (customization == null) {
            AbstractNewProjectStep.$$$reportNull$$$0(0);
        }
        super(Presentation.NULL_STRING, true);
        this.myCustomization = customization;
        this.updateActions();
        EP_NAME.addChangeListener(this::updateActions, null);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractNewProjectStep.$$$reportNull$$$0(1);
        }
        super.update(e);
        NewWelcomeScreen.updateNewProjectIconIfWelcomeScreen((AnActionEvent)e);
        this.updateActions();
    }

    protected void updateActions() {
        List projectGenerators;
        this.removeAll();
        AbstractCallback<T> callback = this.myCustomization.createCallback();
        ProjectSpecificAction projectSpecificAction = this.myCustomization.createProjectSpecificAction(callback);
        this.addProjectSpecificAction(projectSpecificAction);
        List<DirectoryProjectGenerator<?>> generators = this.myCustomization.getProjectGenerators();
        this.addAll(this.myCustomization.getActions(generators, callback));
        if (!this.myCustomization.showUserDefinedProjects()) {
            return;
        }
        ProjectTemplate[] templates = new ArchivedTemplatesFactory().createTemplates("User-defined");
        if (templates.length == 0) {
            projectGenerators = Collections.emptyList();
        } else {
            projectGenerators = new ArrayList(templates.length);
            for (ProjectTemplate template : templates) {
                projectGenerators.add(new TemplateProjectDirectoryGenerator((LocalArchivedTemplate)template));
            }
        }
        this.addAll(this.myCustomization.getActions(projectGenerators, callback));
    }

    protected void addProjectSpecificAction(@NotNull ProjectSpecificAction projectSpecificAction) {
        if (projectSpecificAction == null) {
            AbstractNewProjectStep.$$$reportNull$$$0(2);
        }
        this.addAll(projectSpecificAction.getChildren(null));
    }

    public static <T> Project doGenerateProject(@Nullable Project projectToClose, @NotNull String locationString, @Nullable DirectoryProjectGenerator<T> generator, @NotNull T settings) {
        if (locationString == null) {
            AbstractNewProjectStep.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            AbstractNewProjectStep.$$$reportNull$$$0(4);
        }
        OpenProjectTask options2 = AbstractNewProjectStep.createOpenProjectOptions(projectToClose, null);
        return AbstractNewProjectStep.doGenerateProject(locationString, generator, settings, options2);
    }

    @NotNull
    protected static OpenProjectTask createOpenProjectOptions(@Nullable Project projectToClose, @Nullable Consumer<? super UserDataHolder> extraUserData) {
        OpenProjectTask openProjectTask = OpenProjectTaskKt.OpenProjectTask(builder2 -> {
            builder2.setProjectToClose(projectToClose);
            builder2.setNewProject(true);
            builder2.setRunConfigurators(true);
            builder2.setProjectCreatedWithWizard(true);
            builder2.setRefreshVfsNeeded(false);
            builder2.withBeforeOpenCallback(project2 -> {
                if (extraUserData != null) {
                    extraUserData.accept((UserDataHolder)project2);
                }
                project2.putUserData(CREATED_KEY, true);
                return true;
            });
            return Unit.INSTANCE;
        });
        if (openProjectTask == null) {
            AbstractNewProjectStep.$$$reportNull$$$0(5);
        }
        return openProjectTask;
    }

    public static <T> Project doGenerateProject(@NotNull String locationString, @Nullable DirectoryProjectGenerator<T> generator, @NotNull T settings, @NotNull OpenProjectTask options2) {
        if (locationString == null) {
            AbstractNewProjectStep.$$$reportNull$$$0(6);
        }
        if (settings == null) {
            AbstractNewProjectStep.$$$reportNull$$$0(7);
        }
        if (options2 == null) {
            AbstractNewProjectStep.$$$reportNull$$$0(8);
        }
        Path location2 = Paths.get(locationString, new String[0]);
        try {
            Files.createDirectories(location2, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOG.warn(e);
            String message = ActionsBundle.message((String)"action.NewDirectoryProject.cannot.create.dir", (Object[])new Object[]{location2.toString()});
            Messages.showErrorDialog((Project)options2.getProjectToClose(), (String)message, (String)ActionsBundle.message((String)"action.NewDirectoryProject.title", (Object[])new Object[0]));
            return null;
        }
        VirtualFile baseDir = WriteAction.compute(() -> LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName(location2.toString())));
        if (baseDir == null) {
            LOG.error("Couldn't find '" + location2 + "' in VFS");
            return null;
        }
        VfsUtil.markDirtyAndRefresh(false, true, true, baseDir);
        if (baseDir.getChildren().length > 0) {
            String title = ActionsBundle.message((String)"action.NewDirectoryProject.not.empty.dialog.title", (Object[])new Object[0]);
            String message = ActionsBundle.message((String)"action.NewDirectoryProject.not.empty.dialog.text", (Object[])new Object[]{location2.toString()});
            String yesText = ActionsBundle.message((String)"action.NewDirectoryProject.not.empty.dialog.create.new", (Object[])new Object[0]);
            String noText = ActionsBundle.message((String)"action.NewDirectoryProject.not.empty.dialog.open.existing", (Object[])new Object[0]);
            int result2 = Messages.showYesNoDialog((Project)options2.getProjectToClose(), (String)message, (String)title, (String)yesText, (String)noText, (Icon)Messages.getQuestionIcon());
            if (result2 == 1) {
                return PlatformProjectOpenProcessor.Companion.doOpenProject(location2, OpenProjectTask.build());
            }
        }
        RecentProjectsManager.getInstance().setLastProjectCreationLocation(location2.getParent());
        if (generator instanceof TemplateProjectDirectoryGenerator) {
            ((TemplateProjectDirectoryGenerator)generator).generateProject(baseDir.getName(), locationString);
        }
        TrustedPaths.getInstance().setProjectPathTrusted(location2, true);
        Project project2 = ProjectManagerEx.getInstanceEx().openProject(location2, options2);
        if (project2 != null && generator != null && !(generator instanceof TemplateProjectDirectoryGenerator)) {
            generator.generateProject(project2, baseDir, settings, ModuleManager.getInstance(project2).getModules()[0]);
        }
        AbstractNewProjectStep.logProjectGeneratedEvent(generator, project2);
        return project2;
    }

    private static void logProjectGeneratedEvent(@Nullable DirectoryProjectGenerator<?> generator, @Nullable Project project2) {
        FeatureUsageData data2 = new FeatureUsageData();
        if (generator != null) {
            data2.addData("generator_id", generator.getClass().getName());
            data2.addPluginInfo(PluginInfoDetectorKt.getPluginInfo(generator.getClass()));
        }
        FUCounterUsageLogger.getInstance().logEvent(project2, "new.project.wizard", "project.generated", data2);
    }

    public static boolean created(@NotNull Project project2) {
        if (project2 == null) {
            AbstractNewProjectStep.$$$reportNull$$$0(9);
        }
        return Boolean.TRUE.equals(project2.getUserData(CREATED_KEY));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AbstractNewProjectStep.$$$reportNull$$$0(10);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customization";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSpecificAction";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationString";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/projectWizard/AbstractNewProjectStep";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/projectWizard/AbstractNewProjectStep";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createOpenProjectOptions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addProjectSpecificAction";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doGenerateProject";
                break;
            }
            case 5: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "created";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 10 -> new IllegalStateException(string2);
        };
    }

    protected static abstract class Customization<T> {
        protected Customization() {
        }

        @NotNull
        protected ProjectSpecificAction createProjectSpecificAction(@NotNull AbstractCallback<T> callback) {
            if (callback == null) {
                Customization.$$$reportNull$$$0(0);
            }
            DirectoryProjectGenerator<T> emptyProjectGenerator = this.createEmptyProjectGenerator();
            return new ProjectSpecificAction(emptyProjectGenerator, this.createProjectSpecificSettingsStep(emptyProjectGenerator, callback));
        }

        @NotNull
        protected abstract AbstractCallback<T> createCallback();

        @NotNull
        protected abstract DirectoryProjectGenerator<T> createEmptyProjectGenerator();

        @NotNull
        protected abstract ProjectSettingsStepBase<T> createProjectSpecificSettingsStep(@NotNull DirectoryProjectGenerator<T> var1, @NotNull AbstractCallback<T> var2);

        @NotNull
        protected List<DirectoryProjectGenerator<?>> getProjectGenerators() {
            List<DirectoryProjectGenerator<?>> list2 = EP_NAME.getExtensionList();
            if (list2 == null) {
                Customization.$$$reportNull$$$0(1);
            }
            return list2;
        }

        public AnAction[] getActions(@NotNull List<? extends DirectoryProjectGenerator<?>> generators, @NotNull AbstractCallback<T> callback) {
            if (generators == null) {
                Customization.$$$reportNull$$$0(2);
            }
            if (callback == null) {
                Customization.$$$reportNull$$$0(3);
            }
            ArrayList<AnAction> actions = new ArrayList<AnAction>();
            for (DirectoryProjectGenerator<?> projectGenerator : generators) {
                try {
                    actions.addAll(Arrays.asList(this.getActions(projectGenerator, callback)));
                }
                catch (Throwable throwable) {
                    LOG.error("Broken project generator " + projectGenerator, throwable);
                }
            }
            return actions.toArray(AnAction.EMPTY_ARRAY);
        }

        public AnAction @NotNull [] getActions(@NotNull DirectoryProjectGenerator<T> generator, @NotNull AbstractCallback<T> callback) {
            if (generator == null) {
                Customization.$$$reportNull$$$0(4);
            }
            if (callback == null) {
                Customization.$$$reportNull$$$0(5);
            }
            if (this.shouldIgnore(generator)) {
                if (AnAction.EMPTY_ARRAY == null) {
                    Customization.$$$reportNull$$$0(6);
                }
                return AnAction.EMPTY_ARRAY;
            }
            ProjectSettingsStepBase step2 = generator instanceof CustomStepProjectGenerator ? (ProjectSettingsStepBase)((CustomStepProjectGenerator)generator).createStep(generator, callback) : this.createProjectSpecificSettingsStep(generator, callback);
            ProjectSpecificAction projectSpecificAction = new ProjectSpecificAction(generator, step2);
            AnAction[] anActionArray = projectSpecificAction.getChildren(null);
            if (anActionArray == null) {
                Customization.$$$reportNull$$$0(7);
            }
            return anActionArray;
        }

        protected boolean shouldIgnore(@NotNull DirectoryProjectGenerator<?> generator) {
            if (generator == null) {
                Customization.$$$reportNull$$$0(8);
            }
            return generator instanceof HideableProjectGenerator && ((HideableProjectGenerator)generator).isHidden();
        }

        public boolean showUserDefinedProjects() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
                case 1: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$Customization";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "generators";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "generator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$Customization";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProjectGenerators";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createProjectSpecificAction";
                    break;
                }
                case 1: 
                case 6: 
                case 7: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getActions";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "shouldIgnore";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1, 6, 7 -> new IllegalStateException(string2);
            };
        }
    }

    public static class AbstractCallback<T>
    implements PairConsumer<ProjectSettingsStepBase<T>, ProjectGeneratorPeer<T>> {
        @Override
        public void consume(@Nullable ProjectSettingsStepBase<T> settings, @NotNull ProjectGeneratorPeer<T> projectGeneratorPeer) {
            if (projectGeneratorPeer == null) {
                AbstractCallback.$$$reportNull$$$0(0);
            }
            if (settings == null) {
                return;
            }
            IdeFrame frame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
            Project projectToClose = frame != null ? frame.getProject() : null;
            DirectoryProjectGenerator<T> generator = settings.getProjectGenerator();
            Object actualSettings = projectGeneratorPeer.getSettings();
            AbstractNewProjectStep.doGenerateProject(projectToClose, settings.getProjectLocation(), generator, actualSettings);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectGeneratorPeer", "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$AbstractCallback", "consume"));
        }
    }
}

