/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.BundleBase;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.projectWizard.AbstractNewProjectStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WebProjectSettingsStepWrapper;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.welcomeScreen.AbstractActionWithPanel;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.platform.ProjectGeneratorPeer;
import com.intellij.platform.templates.TemplateProjectDirectoryGenerator;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.SlowOperations;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSettingsStepBase<T>
extends AbstractActionWithPanel
implements DumbAware,
Disposable {
    protected DirectoryProjectGenerator<T> myProjectGenerator;
    protected AbstractNewProjectStep.AbstractCallback<T> myCallback;
    protected TextFieldWithBrowseButton myLocationField;
    protected NotNullLazyValue<File> myProjectDirectory;
    protected JButton myCreateButton;
    protected JLabel myErrorLabel;
    protected NotNullLazyValue<ProjectGeneratorPeer<T>> myLazyGeneratorPeer;

    public ProjectSettingsStepBase(DirectoryProjectGenerator<T> projectGenerator, AbstractNewProjectStep.AbstractCallback<T> callback) {
        this.getTemplatePresentation().setIcon(projectGenerator.getLogo());
        this.getTemplatePresentation().setText(projectGenerator.getName());
        this.myProjectGenerator = projectGenerator;
        this.myCallback = callback;
        this.myProjectDirectory = NotNullLazyValue.lazy(() -> this.findSequentNonExistingUntitled());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ProjectSettingsStepBase.$$$reportNull$$$0(0);
        }
    }

    public void onPanelSelected() {
        this.checkWebProjectValid();
    }

    @NotNull
    public JButton getActionButton() {
        JButton jButton = this.myCreateButton;
        if (jButton == null) {
            ProjectSettingsStepBase.$$$reportNull$$$0(1);
        }
        return jButton;
    }

    @NotNull
    protected NotNullLazyValue<ProjectGeneratorPeer<T>> createLazyPeer() {
        NotNullLazyValue notNullLazyValue = this.myProjectGenerator.createLazyPeer();
        if (notNullLazyValue == null) {
            ProjectSettingsStepBase.$$$reportNull$$$0(2);
        }
        return notNullLazyValue;
    }

    public JPanel createPanel() {
        this.myLazyGeneratorPeer = this.createLazyPeer();
        JPanel mainPanel = new JPanel(new BorderLayout());
        JLabel label2 = this.createErrorLabel();
        JButton button2 = this.createActionButton();
        button2.addActionListener(this.createCloseActionListener());
        Disposer.register(this, () -> UIUtil.dispose(button2));
        JPanel scrollPanel = this.createAndFillContentPanel();
        this.initGeneratorListeners();
        this.registerValidators();
        JBScrollPane scrollPane = new JBScrollPane((Component)scrollPanel, 20, 31);
        scrollPane.setBorder((Border)JBUI.Borders.empty());
        mainPanel.add((Component)scrollPane, "Center");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.setName("BOTTOM_PANEL");
        bottomPanel.add((Component)label2, "North");
        bottomPanel.add((Component)button2, "East");
        mainPanel.add((Component)bottomPanel, "South");
        return mainPanel;
    }

    protected final JLabel createErrorLabel() {
        JLabel errorLabel = new JLabel("");
        errorLabel.setForeground(JBColor.RED);
        this.myErrorLabel = errorLabel;
        return errorLabel;
    }

    protected final JButton createActionButton() {
        JButton button2 = new JButton(IdeBundle.message((String)"new.dir.project.create", (Object[])new Object[0]));
        button2.putClientProperty("DefaultAction", Boolean.TRUE);
        this.myCreateButton = button2;
        return button2;
    }

    @NotNull
    protected final ActionListener createCloseActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isValid = ProjectSettingsStepBase.this.checkValid();
                if (isValid && ProjectSettingsStepBase.this.myCallback != null) {
                    DialogWrapper dialog = DialogWrapper.findInstance((Component)ProjectSettingsStepBase.this.myCreateButton);
                    if (dialog != null) {
                        dialog.close(0);
                    }
                    try (AccessToken ignore = SlowOperations.allowSlowOperations("action.perform");){
                        ProjectSettingsStepBase.this.myCallback.consume(ProjectSettingsStepBase.this, ProjectSettingsStepBase.this.getPeer());
                    }
                }
            }
        };
    }

    protected ProjectGeneratorPeer<T> getPeer() {
        return this.myLazyGeneratorPeer.getValue();
    }

    protected final JPanel createContentPanelWithAdvancedSettingsPanel() {
        JPanel basePanel = this.createBasePanel();
        JPanel scrollPanel = new JPanel(new BorderLayout());
        scrollPanel.add((Component)basePanel, "North");
        JPanel advancedSettings = this.createAdvancedSettings();
        if (advancedSettings != null) {
            scrollPanel.add((Component)advancedSettings, "Center");
        }
        return scrollPanel;
    }

    protected void initGeneratorListeners() {
        if (this.myProjectGenerator instanceof WebProjectTemplate) {
            this.getPeer().addSettingsListener(new ProjectGeneratorPeer.SettingsListener(){

                public void stateChanged(boolean validSettings) {
                    ProjectSettingsStepBase.this.checkValid();
                }
            });
        }
    }

    protected final Icon getIcon() {
        return this.myProjectGenerator.getLogo();
    }

    protected JPanel createBasePanel() {
        JPanel panel2 = new JPanel(new VerticalFlowLayout(0, 2));
        LabeledComponent<TextFieldWithBrowseButton> component2 = this.createLocationComponent();
        panel2.add((Component)component2);
        return panel2;
    }

    protected void registerValidators() {
        DocumentAdapter documentAdapter = new DocumentAdapter(){

            @Override
            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                ProjectSettingsStepBase.this.checkValid();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/projectWizard/ProjectSettingsStepBase$3", "textChanged"));
            }
        };
        this.myLocationField.getTextField().getDocument().addDocumentListener(documentAdapter);
        Disposer.register(this, () -> this.myLocationField.getTextField().getDocument().removeDocumentListener(documentAdapter));
        this.checkWebProjectValid();
    }

    private void checkWebProjectValid() {
        if (this.myProjectGenerator instanceof WebProjectTemplate && !((WebProjectTemplate)this.myProjectGenerator).postponeValidation()) {
            this.checkValid();
        }
    }

    public boolean checkValid() {
        if (this.myLocationField == null) {
            return true;
        }
        String projectPath = this.myLocationField.getText().trim();
        if (projectPath.isEmpty()) {
            this.setErrorText(IdeBundle.message((String)"new.dir.project.error.empty", (Object[])new Object[0]));
            return false;
        }
        try {
            Paths.get(projectPath, new String[0]);
        }
        catch (InvalidPathException e) {
            this.setErrorText(IdeBundle.message((String)"new.dir.project.error.invalid", (Object[])new Object[0]));
            return false;
        }
        if (this.myProjectGenerator != null) {
            ValidationResult validationResult = this.myProjectGenerator.validate(projectPath);
            if (!validationResult.isOk()) {
                this.setErrorText(validationResult.getErrorMessage());
                return false;
            }
            ValidationInfo peerValidationResult = this.getPeer().validate();
            if (peerValidationResult != null) {
                this.setErrorText(peerValidationResult.message);
                return false;
            }
        }
        this.setErrorText(null);
        return true;
    }

    protected JPanel createAndFillContentPanel() {
        WebProjectSettingsStepWrapper settingsStep = new WebProjectSettingsStepWrapper(this);
        if (this.myProjectGenerator instanceof WebProjectTemplate) {
            this.getPeer().buildUI((SettingsStep)settingsStep);
        } else if (this.myProjectGenerator instanceof TemplateProjectDirectoryGenerator) {
            ((TemplateProjectDirectoryGenerator)this.myProjectGenerator).buildUI(settingsStep);
        } else {
            return this.createContentPanelWithAdvancedSettingsPanel();
        }
        if (settingsStep.isEmpty()) {
            return this.createContentPanelWithAdvancedSettingsPanel();
        }
        JPanel jPanel = new JPanel(new VerticalFlowLayout(0, 5));
        ArrayList<Object> labeledComponentList = new ArrayList<Object>();
        labeledComponentList.add(this.createLocationComponent());
        labeledComponentList.addAll(settingsStep.getFields());
        JPanel scrollPanel = new JPanel(new BorderLayout());
        scrollPanel.add((Component)jPanel, "North");
        for (LabeledComponent labeledComponent : labeledComponentList) {
            labeledComponent.setLabelLocation("West");
            jPanel.add((Component)labeledComponent);
        }
        for (JComponent jComponent : settingsStep.getComponents()) {
            jPanel.add(jComponent);
        }
        UIUtil.mergeComponentsWithAnchor(labeledComponentList);
        return scrollPanel;
    }

    public void setErrorText(@Nullable @Nls String text2) {
        this.myErrorLabel.setText(text2);
        this.myErrorLabel.setForeground(MessageType.ERROR.getTitleForeground());
        this.myErrorLabel.setIcon(StringUtil.isEmpty(text2) ? null : AllIcons.Actions.Lightning);
        this.myCreateButton.setEnabled(text2 == null);
    }

    public void setWarningText(@Nullable @Nls String text2) {
        this.myErrorLabel.setText(HtmlChunk.html().children(HtmlChunk.text(LangBundle.message("warning.prefix.note", new Object[0])).bold(), HtmlChunk.raw(" " + text2 + "  ")).toString());
        this.myErrorLabel.setForeground(MessageType.WARNING.getTitleForeground());
        this.myErrorLabel.setIcon(StringUtil.isEmpty(text2) ? null : AllIcons.Actions.Lightning);
    }

    @Nullable
    protected JPanel createAdvancedSettings() {
        JPanel jPanel = new JPanel(new VerticalFlowLayout(0, 5));
        jPanel.add(this.getPeer().getComponent(this.myLocationField, () -> this.checkValid()));
        return jPanel;
    }

    public DirectoryProjectGenerator<T> getProjectGenerator() {
        return this.myProjectGenerator;
    }

    public String getProjectLocation() {
        return FileUtil.expandUserHome(FileUtil.toSystemIndependentName(this.myLocationField.getText()));
    }

    public final void setLocation(@NotNull String location2) {
        if (location2 == null) {
            ProjectSettingsStepBase.$$$reportNull$$$0(3);
        }
        this.myLocationField.setText(UiUtils.getPresentablePath((String)location2));
    }

    protected LabeledComponent<TextFieldWithBrowseButton> createLocationComponent() {
        this.myLocationField = new TextFieldWithBrowseButton();
        String projectLocation = this.myProjectDirectory.get().toString();
        this.myLocationField.setText(projectLocation);
        int index2 = projectLocation.lastIndexOf(File.separator);
        if (index2 > 0) {
            JTextField textField = this.myLocationField.getTextField();
            textField.select(index2 + 1, projectLocation.length());
            textField.putClientProperty(DialogWrapperPeer.HAVE_INITIAL_SELECTION, true);
        }
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.myLocationField.addBrowseFolderListener(IdeBundle.message((String)"directory.project.location.title", (Object[])new Object[0]), IdeBundle.message((String)"directory.project.location.description", (Object[])new Object[0]), null, descriptor2);
        return LabeledComponent.create((JComponent)this.myLocationField, (String)BundleBase.replaceMnemonicAmpersand(IdeBundle.message((String)"directory.project.location.label", (Object[])new Object[0])), (String)"West");
    }

    @NotNull
    protected File findSequentNonExistingUntitled() {
        File file2 = FileUtil.findSequentNonexistentFile(new File(ProjectUtil.getBaseDir()), "untitled", "");
        if (file2 == null) {
            ProjectSettingsStepBase.$$$reportNull$$$0(4);
        }
        return file2;
    }

    @Override
    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/projectWizard/ProjectSettingsStepBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/projectWizard/ProjectSettingsStepBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionButton";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createLazyPeer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findSequentNonExistingUntitled";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setLocation";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 4 -> new IllegalStateException(string2);
        };
    }
}

