/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.ide.util.scopeChooser.EditScopesDialog;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.ide.util.scopeChooser.ScopeIdMapper;
import com.intellij.ide.util.scopeChooser.ScopeModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Condition;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.PredefinedSearchScopeProvider;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.EnumSet;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class ScopeChooserCombo
extends ComboboxWithBrowseButton
implements Disposable {
    private Project myProject;
    @Nullable
    private Condition<? super ScopeDescriptor> myScopeFilter;
    private BrowseListener myBrowseListener;
    private final ScopeModel scopeModel = new ScopeModel(EnumSet.of(ScopeModel.Option.FROM_SELECTION, ScopeModel.Option.USAGE_VIEW));
    @Nullable
    private SearchScope preselectedScope;

    public ScopeChooserCombo() {
        super((JComboBox)((Object)new MyComboBox()));
    }

    public ScopeChooserCombo(Project project2, boolean suggestSearchInLibs, boolean prevSearchWholeFiles, @Nls String preselect) {
        this();
        this.init(project2, suggestSearchInLibs, prevSearchWholeFiles, preselect, null);
    }

    public void init(Project project2, @Nls String preselect) {
        this.init(project2, false, true, preselect, null);
    }

    public void init(Project project2, boolean suggestSearchInLibs, boolean prevSearchWholeFiles, Object selection, @Nullable Condition<? super ScopeDescriptor> scopeFilter) {
        this.initialize(project2, suggestSearchInLibs, prevSearchWholeFiles, selection, scopeFilter);
    }

    @NotNull
    public Promise<?> initialize(@NotNull Project project2, boolean suggestSearchInLibs, boolean prevSearchWholeFiles, @Nullable Object selection, @Nullable Condition<? super ScopeDescriptor> scopeFilter) {
        if (project2 == null) {
            ScopeChooserCombo.$$$reportNull$$$0(0);
        }
        if (this.myProject != null) {
            throw new IllegalStateException("scope chooser combo already initialized");
        }
        this.scopeModel.init(project2);
        this.scopeModel.setOption(ScopeModel.Option.LIBRARIES, suggestSearchInLibs);
        this.scopeModel.setOption(ScopeModel.Option.SEARCH_RESULTS, prevSearchWholeFiles);
        this.myProject = project2;
        NamedScopesHolder.ScopeListener scopeListener = () -> {
            SearchScope selectedScope = this.getSelectedScope();
            this.rebuildModelAndSelectScopeOnSuccess(selectedScope);
        };
        this.myScopeFilter = scopeFilter;
        NamedScopeManager.getInstance(project2).addScopeListener(scopeListener, this);
        DependencyValidationManager.getInstance(project2).addScopeListener(scopeListener, this);
        this.addActionListener(this::handleScopeChooserAction);
        ComboBox<ScopeDescriptor> combo = this.getComboBox();
        combo.setMinimumAndPreferredWidth(JBUIScale.scale(300));
        combo.setRenderer(ScopeChooserCombo.createDefaultRenderer());
        combo.setSwingPopup(false);
        if (selection != null) {
            PredefinedSearchScopeProvider provider2 = PredefinedSearchScopeProvider.getInstance();
            List<? extends SearchScope> scopes = provider2.getPredefinedScopes(project2, null, suggestSearchInLibs, prevSearchWholeFiles, false, false, false);
            for (SearchScope searchScope2 : scopes) {
                if (!selection.equals(searchScope2.getDisplayName())) continue;
                this.preselectedScope = searchScope2;
                break;
            }
        }
        return this.rebuildModelAndSelectScopeOnSuccess(selection);
    }

    @NotNull
    public static ListCellRenderer<ScopeDescriptor> createDefaultRenderer() {
        return new MyRenderer();
    }

    public ComboBox<ScopeDescriptor> getComboBox() {
        return (ComboBox)super.getComboBox();
    }

    public void setBrowseListener(BrowseListener browseListener) {
        this.myBrowseListener = browseListener;
    }

    public void setCurrentSelection(boolean currentSelection) {
        this.scopeModel.setOption(ScopeModel.Option.FROM_SELECTION, currentSelection);
    }

    public void setUsageView(boolean usageView) {
        this.scopeModel.setOption(ScopeModel.Option.USAGE_VIEW, usageView);
    }

    public void selectItem(@Nullable Object selection) {
        if (selection == null) {
            return;
        }
        ComboBox<ScopeDescriptor> combo = this.getComboBox();
        DefaultComboBoxModel model2 = (DefaultComboBoxModel)combo.getModel();
        for (int i2 = 0; i2 < model2.getSize(); ++i2) {
            ScopeDescriptor descriptor2 = (ScopeDescriptor)model2.getElementAt(i2);
            if ((!(selection instanceof String) || !selection.equals(descriptor2.getDisplayName())) && (!(selection instanceof SearchScope) || !descriptor2.scopeEquals((SearchScope)selection))) continue;
            combo.setSelectedIndex(i2);
            break;
        }
    }

    private void handleScopeChooserAction(ActionEvent ignore) {
        EditScopesDialog dlg;
        String selection = this.getSelectedScopeName();
        if (this.myBrowseListener != null) {
            this.myBrowseListener.onBeforeBrowseStarted();
        }
        if ((dlg = EditScopesDialog.showDialog(this.myProject, selection)).isOK()) {
            NamedScope namedScope = dlg.getSelectedScope();
            this.rebuildModelAndSelectScopeOnSuccess(namedScope == null ? null : namedScope.getScopeId());
        }
        if (this.myBrowseListener != null) {
            this.myBrowseListener.onAfterBrowseFinished();
        }
    }

    @NotNull
    private Promise<?> rebuildModelAndSelectScopeOnSuccess(@Nullable Object selection) {
        Promise<List> promise = this.scopeModel.getScopeDescriptors(descriptor2 -> this.myScopeFilter == null || this.myScopeFilter.value((ScopeDescriptor)descriptor2)).onSuccess(descriptors -> {
            DefaultComboBoxModel<ScopeDescriptor> model2 = new DefaultComboBoxModel<ScopeDescriptor>();
            this.updateModel(model2, (List<? extends ScopeDescriptor>)descriptors);
            this.getComboBox().setModel(model2);
            this.selectItem(selection);
            this.preselectedScope = null;
        });
        if (promise == null) {
            ScopeChooserCombo.$$$reportNull$$$0(1);
        }
        return promise;
    }

    @RequiresEdt
    protected void updateModel(@NotNull DefaultComboBoxModel<ScopeDescriptor> model2, @NotNull List<? extends ScopeDescriptor> descriptors) {
        if (model2 == null) {
            ScopeChooserCombo.$$$reportNull$$$0(2);
        }
        if (descriptors == null) {
            ScopeChooserCombo.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        for (ScopeDescriptor scopeDescriptor : descriptors) {
            model2.addElement(scopeDescriptor);
        }
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension preferredSize = super.getPreferredSize();
        return new Dimension(Math.min(400, preferredSize.width), preferredSize.height);
    }

    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        Dimension minimumSize = super.getMinimumSize();
        return new Dimension(Math.min(200, minimumSize.width), minimumSize.height);
    }

    public void setShowEmptyScopes(boolean showEmptyScopes) {
        this.scopeModel.setOption(ScopeModel.Option.EMPTY_SCOPES, showEmptyScopes);
    }

    @Nullable
    public SearchScope getSelectedScope() {
        ScopeDescriptor item = (ScopeDescriptor)this.getComboBox().getSelectedItem();
        return item == null ? this.preselectedScope : item.getScope();
    }

    @Nullable
    @Nls
    public String getSelectedScopeName() {
        ScopeDescriptor item = (ScopeDescriptor)this.getComboBox().getSelectedItem();
        if (item == null) {
            return this.preselectedScope == null ? null : this.preselectedScope.getDisplayName();
        }
        return item.getDisplayName();
    }

    @Nullable
    @NonNls
    public String getSelectedScopeId() {
        ScopeDescriptor item = (ScopeDescriptor)this.getComboBox().getSelectedItem();
        String scopeName = item != null ? item.getDisplayName() : (this.preselectedScope != null ? this.preselectedScope.getDisplayName() : null);
        return scopeName != null ? ScopeIdMapper.getInstance().getScopeSerializationId(scopeName) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/scopeChooser/ScopeChooserCombo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/scopeChooser/ScopeChooserCombo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "rebuildModelAndSelectScopeOnSuccess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateModel";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }

    private static class MyComboBox
    extends ComboBox {
        private MyComboBox() {
        }

        public void setSelectedItem(Object item) {
            if (!(item instanceof ScopeModel.ScopeSeparator)) {
                super.setSelectedItem(item);
            }
        }

        public void setSelectedIndex(int anIndex) {
            Object item = this.getItemAt(anIndex);
            if (!(item instanceof ScopeModel.ScopeSeparator)) {
                super.setSelectedIndex(anIndex);
            }
        }
    }

    private static class MyRenderer
    extends SimpleListCellRenderer<ScopeDescriptor> {
        final TitledSeparator separator = new TitledSeparator();

        private MyRenderer() {
        }

        public void customize(@NotNull JList<? extends ScopeDescriptor> list2, ScopeDescriptor value, int index2, boolean selected, boolean hasFocus) {
            if (list2 == null) {
                MyRenderer.$$$reportNull$$$0(0);
            }
            if (value == null) {
                return;
            }
            this.setIcon(value.getIcon());
            this.setText(value.getDisplayName());
        }

        public Component getListCellRendererComponent(JList<? extends ScopeDescriptor> list2, ScopeDescriptor value, int index2, boolean selected, boolean hasFocus) {
            if (value instanceof ScopeModel.ScopeSeparator) {
                this.separator.setText(value.getDisplayName());
                this.separator.setBorder((Border)(index2 == -1 ? null : new JBEmptyBorder(4, 2, 4, 0)));
                return this.separator;
            }
            return super.getListCellRendererComponent(list2, (Object)value, index2, selected, hasFocus);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/util/scopeChooser/ScopeChooserCombo$MyRenderer", "customize"));
        }
    }

    public static interface BrowseListener {
        public void onBeforeBrowseStarted();

        public void onAfterBrowseFinished();
    }
}

