/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.find.impl.FindInProjectExtension;
import com.intellij.ide.scratch.ScratchesSearchScope;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.OpenFilesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.PredefinedSearchScopeProvider;
import com.intellij.psi.search.PredefinedSearchScopeProviderImpl;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScopeChooserUtils {
    private ScopeChooserUtils() {
    }

    @NotNull
    public static GlobalSearchScope findScopeByName(@NotNull Project project2, @Nullable String scopePresentableName) {
        if (project2 == null) {
            ScopeChooserUtils.$$$reportNull$$$0(0);
        }
        if (scopePresentableName == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                ScopeChooserUtils.$$$reportNull$$$0(1);
            }
            return globalSearchScope;
        }
        if (OpenFilesScope.getNameText().equals(scopePresentableName)) {
            return ScopeChooserUtils.intersectWithContentScope(project2, GlobalSearchScopes.openFilesScope(project2));
        }
        if (PredefinedSearchScopeProviderImpl.getCurrentFileScopeName().equals(scopePresentableName)) {
            VirtualFile[] array = FileEditorManager.getInstance(project2).getSelectedFiles();
            List<VirtualFile> files2 = ContainerUtil.createMaybeSingletonList(ArrayUtil.getFirstElement(array));
            GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope(project2, files2, PredefinedSearchScopeProviderImpl.getCurrentFileScopeName());
            return ScopeChooserUtils.intersectWithContentScope(project2, globalSearchScope);
        }
        PredefinedSearchScopeProvider scopeProvider = PredefinedSearchScopeProvider.getInstance();
        for (SearchScope searchScope2 : scopeProvider.getPredefinedScopes(project2, null, false, false, false, false, true)) {
            if (!(searchScope2 instanceof GlobalSearchScope) || !searchScope2.getDisplayName().equals(scopePresentableName)) continue;
            if (searchScope2 instanceof ScratchesSearchScope) {
                ScratchesSearchScope scratchesSearchScope = (ScratchesSearchScope)searchScope2;
                if (scratchesSearchScope == null) {
                    ScopeChooserUtils.$$$reportNull$$$0(2);
                }
                return scratchesSearchScope;
            }
            return ScopeChooserUtils.intersectWithContentScope(project2, (GlobalSearchScope)searchScope2);
        }
        for (FindInProjectExtension findInProjectExtension : FindInProjectExtension.EP_NAME.getExtensionList()) {
            for (NamedScope namedScope : findInProjectExtension.getFilteredNamedScopes(project2)) {
                if (!namedScope.getPresentableName().equals(scopePresentableName)) continue;
                return ScopeChooserUtils.intersectWithContentScope(project2, GlobalSearchScopesCore.filterScope(project2, namedScope));
            }
        }
        for (Iterator<Object> iterator2 : NamedScopesHolder.getAllNamedScopeHolders(project2)) {
            NamedScope[] scopes;
            for (NamedScope scope : scopes = ((NamedScopesHolder)((Object)iterator2)).getEditableScopes()) {
                if (!scope.getScopeId().equals(scopePresentableName)) continue;
                return ScopeChooserUtils.intersectWithContentScope(project2, GlobalSearchScopesCore.filterScope(project2, scope));
            }
        }
        if (scopePresentableName.startsWith("Module '") && scopePresentableName.endsWith("'")) {
            GlobalSearchScope globalSearchScope = ProjectScope.getContentScope(project2);
            if (globalSearchScope == null) {
                ScopeChooserUtils.$$$reportNull$$$0(3);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
        if (globalSearchScope == null) {
            ScopeChooserUtils.$$$reportNull$$$0(4);
        }
        return globalSearchScope;
    }

    @NotNull
    private static GlobalSearchScope intersectWithContentScope(@NotNull Project project2, @NotNull GlobalSearchScope scope) {
        if (project2 == null) {
            ScopeChooserUtils.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            ScopeChooserUtils.$$$reportNull$$$0(6);
        }
        GlobalSearchScope globalSearchScope = scope.intersectWith(ProjectScope.getContentScope(project2));
        if (globalSearchScope == null) {
            ScopeChooserUtils.$$$reportNull$$$0(7);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/scopeChooser/ScopeChooserUtils";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/scopeChooser/ScopeChooserUtils";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findScopeByName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectWithContentScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findScopeByName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "intersectWithContentScope";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 3, 4, 7 -> new IllegalStateException(string2);
        };
    }
}

