/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.Block;
import com.intellij.formatting.CoreFormatterUtil;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.FormattingModelDumper;
import com.intellij.idea.ActionsBundle;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class DumpFormattingModelAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(DumpFormattingModelAction.class);

    DumpFormattingModelAction() {
        super(ActionsBundle.messagePointer((String)"action.DumpFormattingModelAction.text", (Object[])new Object[0]));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            DumpFormattingModelAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DumpFormattingModelAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabledAndVisible(e.getProject() != null && e.getData(CommonDataKeys.PSI_FILE) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile file2;
        if (e == null) {
            DumpFormattingModelAction.$$$reportNull$$$0(2);
        }
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        Project project2 = e.getProject();
        if (project2 == null || psiFile == null) {
            return;
        }
        StringBuilder output = new StringBuilder();
        DumpFormattingModelAction.dumpModelForFile(psiFile, output, psiFile.getTextRange());
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance(project2);
        List<PsiFile> injectedFiles = injectedLanguageManager.getCachedInjectedDocumentsInRange(psiFile, psiFile.getTextRange()).stream().map(documentWindow -> PsiDocumentManager.getInstance(project2).getPsiFile((Document)documentWindow)).filter(psi -> psi != null).sorted(Comparator.comparingInt(psi -> injectedLanguageManager.injectedToHost((PsiElement)psi, psi.getTextRange()).getStartOffset())).toList();
        for (PsiFile injectedFile : injectedFiles) {
            DumpFormattingModelAction.dumpModelForFile(injectedFile, output, injectedLanguageManager.injectedToHost((PsiElement)injectedFile, injectedFile.getTextRange()));
        }
        try {
            File tempFile = FileUtil.createTempFile("formattingModel-" + psiFile.getName() + "-", ".txt");
            FileUtil.writeToFile(tempFile, output.toString());
            file2 = LocalFileSystem.getInstance().findFileByIoFile(tempFile);
            if (file2 == null) {
                return;
            }
        }
        catch (Exception exception) {
            LOG.error(exception);
            return;
        }
        OpenFileDescriptor fileDescriptor = new OpenFileDescriptor(project2, file2);
        FileEditorManager.getInstance(project2).openEditor(fileDescriptor, true);
    }

    private static void dumpModelForFile(@NotNull PsiFile psiFile, @NotNull StringBuilder output, @NotNull TextRange hostTextRange) {
        FormattingModelBuilder builder2;
        if (psiFile == null) {
            DumpFormattingModelAction.$$$reportNull$$$0(3);
        }
        if (output == null) {
            DumpFormattingModelAction.$$$reportNull$$$0(4);
        }
        if (hostTextRange == null) {
            DumpFormattingModelAction.$$$reportNull$$$0(5);
        }
        if ((builder2 = LanguageFormatting.INSTANCE.forContext((PsiElement)psiFile)) == null) {
            LOG.warn("no formatting model found for file: " + psiFile.getName());
            return;
        }
        output.append("> ");
        output.append(hostTextRange);
        output.append("\n");
        FormattingModel model2 = CoreFormatterUtil.buildModel((FormattingModelBuilder)builder2, (PsiElement)psiFile, (CodeStyleSettings)CodeStyle.getSettings((PsiFile)psiFile), (FormattingMode)FormattingMode.REFORMAT);
        FormattingModelDumper.dumpFormattingModel((Block)model2.getRootBlock(), (int)0, (StringBuilder)output);
        output.append("\n\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/DumpFormattingModelAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostTextRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/DumpFormattingModelAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "dumpModelForFile";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string2);
        };
    }
}

