/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class DumpLookupElementWeights
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(DumpLookupElementWeights.class);

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            DumpLookupElementWeights.$$$reportNull$$$0(0);
        }
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        DumpLookupElementWeights.dumpLookupElementWeights((LookupImpl)LookupManager.getActiveLookup(editor2));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            DumpLookupElementWeights.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DumpLookupElementWeights.$$$reportNull$$$0(2);
        }
        Presentation presentation2 = e.getPresentation();
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        presentation2.setEnabled(editor2 != null && LookupManager.getActiveLookup(editor2) != null);
    }

    public static void dumpLookupElementWeights(LookupImpl lookup2) {
        LookupElement selected = lookup2.getCurrentItem();
        String sb = "selected: " + selected;
        if (selected != null) {
            sb = sb + "\nprefix: " + lookup2.itemPattern(selected);
        }
        sb = sb + "\nweights:\n" + StringUtil.join(DumpLookupElementWeights.getLookupElementWeights(lookup2, true), "\n");
        System.out.println(sb);
        LOG.info(sb);
        try {
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(sb));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static List<String> getLookupElementWeights(LookupImpl lookup2, boolean hideSingleValued) {
        Map<LookupElement, List<Pair<String, Object>>> weights = lookup2.getRelevanceObjects(lookup2.getItems(), hideSingleValued);
        return ContainerUtil.map(weights.entrySet(), entry -> ((LookupElement)entry.getKey()).getLookupString() + "\t" + StringUtil.join((Collection)entry.getValue(), pair -> (String)pair.first + "=" + pair.second, ", "));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/DumpLookupElementWeights";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/DumpLookupElementWeights";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

