/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

final class DumpVfsInfoForExcludedFilesAction
extends DumbAwareAction {
    DumpVfsInfoForExcludedFilesAction() {
        super(ActionsBundle.messagePointer((String)"action.DumpVfsInfoForExcludedFilesAction.text", (Object[])new Object[0]));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            DumpVfsInfoForExcludedFilesAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DumpVfsInfoForExcludedFilesAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabledAndVisible(e.getProject() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            DumpVfsInfoForExcludedFilesAction.$$$reportNull$$$0(2);
        }
        if ((project2 = e.getProject()) == null) {
            return;
        }
        HashSet excludeRoots = new HashSet();
        for (Module module2 : ModuleManager.getInstance(project2).getModules()) {
            Collections.addAll(excludeRoots, ModuleRootManager.getInstance(module2).getExcludeRootUrls());
        }
        for (DirectoryIndexExcludePolicy policy : DirectoryIndexExcludePolicy.EP_NAME.getExtensions(project2)) {
            ContainerUtil.addAll(excludeRoots, policy.getExcludeUrlsForProject());
        }
        if (excludeRoots.isEmpty()) {
            System.out.println("No excluded roots found in project.");
        }
        for (String root : excludeRoots) {
            VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(root);
            if (file2 == null) {
                System.out.println(root + " not in VFS");
                continue;
            }
            DumpVfsInfoForExcludedFilesAction.dumpChildrenInDbRecursively(file2, 0);
        }
    }

    private static void dumpChildrenInDbRecursively(VirtualFile dir, int depth) {
        if (!(dir instanceof NewVirtualFile)) {
            System.out.println(dir.getPresentableUrl() + ": not in db (" + dir.getClass().getName() + ")");
            return;
        }
        ArrayList<NewVirtualFile> dirs = new ArrayList<NewVirtualFile>();
        int inDb = 0;
        int contentInDb = 0;
        int nullChildren = 0;
        PersistentFS persistentFS = PersistentFS.getInstance();
        if (persistentFS.wereChildrenAccessed(dir)) {
            for (String name : persistentFS.listPersisted(dir)) {
                ++inDb;
                NewVirtualFile child = ((NewVirtualFile)dir).refreshAndFindChild(name);
                if (child == null) {
                    ++nullChildren;
                    continue;
                }
                if (child.isDirectory()) {
                    dirs.add(child);
                    continue;
                }
                if (PersistentFS.getInstance().getCurrentContentId((VirtualFile)child) == 0) continue;
                ++contentInDb;
            }
        }
        System.out.print(dir.getPresentableUrl() + ": " + inDb + " children in db");
        if (contentInDb > 0) {
            System.out.print(", content of " + contentInDb + " files in db");
        }
        if (nullChildren > 0) {
            System.out.print(", " + nullChildren + " invalid files in db");
        }
        System.out.println();
        if (depth > 10) {
            System.out.println("too deep, skipping children");
        } else {
            for (VirtualFile virtualFile2 : dirs) {
                DumpVfsInfoForExcludedFilesAction.dumpChildrenInDbRecursively(virtualFile2, depth + 1);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/DumpVfsInfoForExcludedFilesAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/DumpVfsInfoForExcludedFilesAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2 -> new IllegalArgumentException(string2);
        };
    }
}

