/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.internal.InternalActionsBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

final class LoadAllVfsStoredContentsAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(LoadAllVfsStoredContentsAction.class);
    private final AtomicInteger count = new AtomicInteger();
    private final AtomicLong totalSize = new AtomicLong();

    LoadAllVfsStoredContentsAction() {
        super(InternalActionsBundle.messagePointer((String)"action.AnAction.text.load.all.virtual.files.content", (Object[])new Object[0]), InternalActionsBundle.messagePointer((String)"action.AnAction.description.load.all.virtual.files.content", (Object[])new Object[0]), null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            LoadAllVfsStoredContentsAction.$$$reportNull$$$0(0);
        }
        ApplicationEx application = ApplicationManagerEx.getApplicationEx();
        String m = "Started loading content";
        LOG.info(m);
        System.out.println(m);
        long start = System.currentTimeMillis();
        this.count.set(0);
        this.totalSize.set(0L);
        application.runProcessWithProgressSynchronously(() -> {
            VirtualFile[] roots2;
            PersistentFS vfs = (PersistentFS)application.getComponent(ManagingFS.class);
            for (VirtualFile root : roots2 = vfs.getRoots()) {
                this.iterateCached(root);
            }
        }, "Loading", false, null);
        long end = System.currentTimeMillis();
        String message = "Finished loading content of " + this.count + " files. Total size=" + StringUtil.formatFileSize(this.totalSize.get()) + ". Elapsed=" + (end - start) / 1000L + "sec.";
        LOG.info(message);
        System.out.println(message);
    }

    private void iterateCached(VirtualFile root) {
        this.processFile((NewVirtualFile)root);
        Collection<VirtualFile> children2 = ((NewVirtualFile)root).getCachedChildren();
        for (VirtualFile child : children2) {
            this.iterateCached(child);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean processFile(NewVirtualFile file2) {
        if (file2.isDirectory()) return true;
        if (file2.is(VFileProperty.SPECIAL)) {
            return true;
        }
        try (InputStream stream = PersistentFS.getInstance().getInputStream((VirtualFile)file2);){
            if (!(stream instanceof DataInputStream)) {
                boolean bl = true;
                return bl;
            }
            byte[] bytes = FileUtil.loadBytes(stream);
            this.totalSize.addAndGet(bytes.length);
            this.count.incrementAndGet();
            ProgressManager.getInstance().getProgressIndicator().setText(file2.getPresentableUrl());
            return true;
        }
        catch (IOException e) {
            LOG.error(e);
        }
        return true;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            LoadAllVfsStoredContentsAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            LoadAllVfsStoredContentsAction.$$$reportNull$$$0(2);
        }
        e.getPresentation().setEnabledAndVisible(e.getProject() != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/LoadAllVfsStoredContentsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/LoadAllVfsStoredContentsAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

