/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;

final class ShowNonRetinaImagesActions
extends DumbAwareAction {
    ShowNonRetinaImagesActions() {
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShowNonRetinaImagesActions.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowNonRetinaImagesActions.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabledAndVisible(e.getProject() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            ShowNonRetinaImagesActions.$$$reportNull$$$0(2);
        }
        if ((project2 = e.getProject()) == null) {
            return;
        }
        class ImageInfo {
            boolean retina;
            boolean normal;
            boolean dark;
            boolean retina_dark;

            ImageInfo() {
            }
        }
        HashMap<String, ImageInfo> info2 = new HashMap<String, ImageInfo>();
        Collection images = FilenameIndex.getAllFilesByExt((Project)project2, (String)"png", (GlobalSearchScope)GlobalSearchScope.projectScope(project2));
        for (VirtualFile image : images) {
            String path2 = image.getPath();
            String key = ShowNonRetinaImagesActions.toKey(path2);
            ImageInfo imageInfo = (ImageInfo)info2.get(key);
            if (imageInfo == null) {
                imageInfo = new ImageInfo();
                info2.put(key, imageInfo);
            }
            if (path2.endsWith("@2x_dark.png")) {
                imageInfo.retina_dark = true;
                continue;
            }
            if (path2.endsWith("_dark.png")) {
                imageInfo.dark = true;
                continue;
            }
            if (path2.endsWith("@2x.png")) {
                imageInfo.retina = true;
                continue;
            }
            imageInfo.normal = true;
        }
        final ArrayList<String> retinaMissed = new ArrayList<String>();
        for (String key : info2.keySet()) {
            if (((ImageInfo)info2.get((Object)key)).retina || !((ImageInfo)info2.get((Object)key)).normal) continue;
            retinaMissed.add(key);
        }
        retinaMissed.sort(String.CASE_INSENSITIVE_ORDER);
        new DialogWrapper(project2){
            {
                super(arg0);
                this.init();
            }

            @NotNull
            protected JComponent createCenterPanel() {
                return new JBScrollPane((Component)new JTextArea(StringUtil.join(retinaMissed, "\n")));
            }
        }.show();
    }

    private static String toKey(String path2) {
        if (path2.endsWith("@2x_dark.png")) {
            return path2.substring(0, path2.lastIndexOf("@2x_dark.png")) + ".png";
        }
        if (path2.endsWith("_dark.png")) {
            return path2.substring(0, path2.lastIndexOf("_dark.png")) + ".png";
        }
        if (path2.endsWith("@2x.png")) {
            return path2.substring(0, path2.lastIndexOf("@2x.png")) + ".png";
        }
        return path2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/ShowNonRetinaImagesActions";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/ShowNonRetinaImagesActions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2 -> new IllegalArgumentException(string2);
        };
    }
}

