/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.ui.IconMapLoader;
import com.intellij.internal.TestIconMappingsAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.IconLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/internal/TestIconMappingsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nTestIconMappingsAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestIconMappingsAction.kt\ncom/intellij/internal/TestIconMappingsAction\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,37:1\n39#2,3:38\n1855#3,2:41\n*S KotlinDebug\n*F\n+ 1 TestIconMappingsAction.kt\ncom/intellij/internal/TestIconMappingsAction\n*L\n17#1:38,3\n20#1:41,2\n*E\n"})
final class TestIconMappingsAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        List errors = new ArrayList();
        boolean $i$f$service = false;
        Class<IconMapLoader> serviceClass$iv = IconMapLoader.class;
        IconMapLoader iconMapLoader = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (iconMapLoader == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        Map mappings = iconMapLoader.loadIconMapping();
        for (Map.Entry entry : mappings.entrySet()) {
            ClassLoader classLoader = (ClassLoader)entry.getKey();
            Map map2 = (Map)entry.getValue();
            for (Map.Entry entry2 : map2.entrySet()) {
                String expUI = (String)entry2.getKey();
                String oldUI = (String)entry2.getValue();
                Object[] objectArray = new String[]{expUI, oldUI};
                Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.endsWith$default((String)it, (String)".svg", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)it, (String)".png", (boolean)false, (int)2, null)) {
                        errors.add("Path should end with .svg or .png '" + it + "'");
                    }
                    Icon icon2 = IconLoader.findIcon(it, classLoader);
                    Intrinsics.checkNotNull((Object)icon2);
                    if (icon2.getIconHeight() != 1) continue;
                    errors.add(it + " is not found");
                }
            }
        }
        if (!((Collection)errors).isEmpty()) {
            Messages.showErrorDialog((String)CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)"\n", null, null, (int)0, null, (Function1)actionPerformed.2.INSTANCE, (int)30, null), (String)"Errors Found");
        } else {
            Messages.showInfoMessage((String)"Everything is correct!", (String)"Information");
        }
    }
}

